/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\b\u0010\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u00022\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011J\u001f\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0002H\u0086\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ClassOneToManyMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Ljava/io/File;)V", "add", "", "key", "Lorg/jetbrains/kotlin/name/FqName;", "value", "dumpValue", "get", "remove", "removeValues", "removed", "", "set", "values", "kotlin-build-common"})
public class ClassOneToManyMap
extends BasicStringMap<Collection<? extends String>> {
    public ClassOneToManyMap(@NotNull File storageFile) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        super(storageFile, StringCollectionExternalizer.INSTANCE);
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value2);
    }

    public final synchronized void add(@NotNull FqName key, @NotNull FqName value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        LazyStorage<String, List> lazyStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key.asString()");
        lazyStorage.append(string2, CollectionsKt.listOf((Object)value2.asString()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Collection<FqName> get(@NotNull FqName key) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        LazyStorage lazyStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key.asString()");
        Collection collection2 = (Collection)lazyStorage.get(string2);
        if (collection2 == null) {
            collection = SetsKt.emptySet();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string3 = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                FqName fqName2 = new FqName((String)p0);
                collection3.add(fqName2);
            }
            collection = (List)destination$iv$iv;
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void set(@NotNull FqName key, @NotNull Collection<FqName> values2) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        if (values2.isEmpty()) {
            this.remove(key);
            return;
        }
        LazyStorage<String, List> lazyStorage = this.getStorage();
        Object object = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key.asString()");
        String string2 = object;
        object = values2;
        String string3 = string2;
        LazyStorage<String, List> lazyStorage2 = lazyStorage;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            FqName fqName2 = (FqName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string4 = p0.asString();
            collection.add(string4);
        }
        collection = (List)destination$iv$iv;
        lazyStorage2.set(string3, (List)collection);
    }

    public final synchronized void remove(@NotNull FqName key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        LazyStorage lazyStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key.asString()");
        lazyStorage.remove(string2);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void removeValues(@NotNull FqName key, @NotNull Set<FqName> removed2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(removed2, (String)"removed");
        Iterable $this$filter$iv = this.get(key);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!(!removed2.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notRemoved = (List)destination$iv$iv;
        this.set(key, notRemoved);
    }
}

