/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnexpectedTypeArgumentsError;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.FirQualifierResolver;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolver;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TreeResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeOuterClassArgumentsRequired;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedQualifierError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnsupportedDynamicType;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeWrongNumberOfTypeArgumentsError;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeArgumentList;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003BCDB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JG\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J&\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J!\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001f\u001a\u00020\u00182\b\u0010(\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010)J\u001c\u0010*\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J,\u0010-\u001a\u0016\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010/\u0012\u0006\u0012\u0004\u0018\u0001000.2\u0006\u0010\u001f\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J(\u00104\u001a\u0002052\u0006\u0010\u001f\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0016JB\u0010:\u001a\u0002052\u0006\u0010\u001f\u001a\u00020\u00182\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u0010;\u001a\u0004\u0018\u0001002\u0006\u00108\u001a\u00020\u001b2\b\u0010<\u001a\u0004\u0018\u00010\u00122\u0006\u00109\u001a\u00020\u001bH\u0002J*\u0010=\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010>*\u00020@2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010A\u001a\u00020,H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirTypeResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "implicitBuiltinTypeSymbols", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ClassIdInSession;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "symbolProvider$delegate", "Lkotlin/Lazy;", "createDiagnosticsIfExists", "Lorg/jetbrains/kotlin/fir/types/ConeClassErrorType;", "parameterClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "qualifierPartIndex", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "userTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "qualifierPartArgumentsCount", "ignoreOuterClassCheck", "", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;ILorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;Ljava/lang/Integer;Z)Lorg/jetbrains/kotlin/fir/types/ConeClassErrorType;", "createFunctionalType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "getClassesAlignedToQualifierParts", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ParametersMapAndOuterClasses;", "qualifier", "", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "getTypeArgumentsOrNameSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "qualifierIndex", "(Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/fir/FirSourceElement;", "resolveBuiltInQualified", "id", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveToSymbol", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "resolveType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "scopeClassDeclaration", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "areBareTypesAllowed", "isOperandOfIsOperator", "resolveUserType", "substitutor", "topDeclaration", "resolveEnumEntrySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/resolve/FirQualifierResolver;", "classId", "ClassIdInSession", "ClassWithQualifierPartIndex", "ParametersMapAndOuterClasses", "resolve"})
public final class FirTypeResolverImpl
extends FirTypeResolver {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy symbolProvider$delegate;
    @NotNull
    private final Map<ClassIdInSession, FirClassLikeSymbol<?>> implicitBuiltinTypeSymbols;

    public FirTypeResolverImpl(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.symbolProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirSymbolProvider>(this){
            final /* synthetic */ FirTypeResolverImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FirSymbolProvider invoke() {
                return MainSessionComponentsKt.getSymbolProvider(FirTypeResolverImpl.access$getSession$p(this.this$0));
            }
        }));
        this.implicitBuiltinTypeSymbols = new LinkedHashMap();
    }

    private final FirSymbolProvider getSymbolProvider() {
        Lazy lazy = this.symbolProvider$delegate;
        Object var2_2 = null;
        return (FirSymbolProvider)lazy.getValue();
    }

    private final FirClassLikeSymbol<?> resolveBuiltInQualified(ClassId id, FirSession session) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ClassIdInSession nameInSession = new ClassIdInSession(session, id);
        Map<ClassIdInSession, FirClassLikeSymbol<?>> $this$getOrPut$iv = this.implicitBuiltinTypeSymbols;
        boolean $i$f$getOrPut = false;
        FirClassLikeSymbol<?> value$iv = $this$getOrPut$iv.get(nameInSession);
        if (value$iv == null) {
            boolean bl = false;
            FirClassLikeSymbol<?> firClassLikeSymbol2 = this.getSymbolProvider().getClassLikeSymbolByFqName(id);
            Intrinsics.checkNotNull(firClassLikeSymbol2);
            FirClassLikeSymbol<?> answer$iv = firClassLikeSymbol2;
            $this$getOrPut$iv.put(nameInSession, answer$iv);
            firClassLikeSymbol = answer$iv;
        } else {
            firClassLikeSymbol = value$iv;
        }
        return firClassLikeSymbol;
    }

    private final Pair<FirBasedSymbol<?>, ConeSubstitutor> resolveToSymbol(FirTypeRef typeRef, FirScope scope2) {
        Pair pair;
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef instanceof FirResolvedTypeRef) {
            FirClassifierSymbol<?> firClassifierSymbol;
            ConeLookupTagBasedType coneLookupTagBasedType;
            Object $this$coneTypeSafe$iv = typeRef;
            boolean $i$f$coneTypeSafe2 = false;
            Object object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                coneKotlinType = null;
            }
            if ((coneLookupTagBasedType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType))) == null) {
                firClassifierSymbol = null;
            } else {
                Object $i$f$coneTypeSafe2 = $this$coneTypeSafe$iv = coneLookupTagBasedType.getLookupTag();
                object = this.getSymbolProvider();
                Object p0 = $i$f$coneTypeSafe2;
                boolean bl = false;
                firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag((FirSymbolProvider)object, (ConeClassifierLookupTag)p0);
            }
            FirClassifierSymbol<?> resultSymbol = firClassifierSymbol;
            pair = TuplesKt.to(resultSymbol, null);
        } else if (firTypeRef instanceof FirUserTypeRef) {
            FirQualifierResolver qualifierResolver = MainSessionComponentsKt.getQualifierResolver(this.session);
            Ref.ObjectRef resolvedSymbol = new Ref.ObjectRef();
            Ref.ObjectRef substitutor2 = new Ref.ObjectRef();
            scope2.processClassifiersByNameWithSubstitution(((FirQualifierPart)CollectionsKt.first(((FirUserTypeRef)typeRef).getQualifier())).getName(), (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(resolvedSymbol, typeRef, qualifierResolver, this, (Ref.ObjectRef<ConeSubstitutor>)substitutor2){
                final /* synthetic */ Ref.ObjectRef<FirBasedSymbol<?>> $resolvedSymbol;
                final /* synthetic */ FirTypeRef $typeRef;
                final /* synthetic */ FirQualifierResolver $qualifierResolver;
                final /* synthetic */ FirTypeResolverImpl this$0;
                final /* synthetic */ Ref.ObjectRef<ConeSubstitutor> $substitutor;
                {
                    this.$resolvedSymbol = $resolvedSymbol;
                    this.$typeRef = $typeRef;
                    this.$qualifierResolver = $qualifierResolver;
                    this.this$0 = $receiver;
                    this.$substitutor = $substitutor;
                    super(2);
                }

                public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor substitutorFromScope) {
                    FirBasedSymbol firBasedSymbol;
                    Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                    Intrinsics.checkNotNullParameter((Object)substitutorFromScope, (String)"substitutorFromScope");
                    if (this.$resolvedSymbol.element != null) {
                        return;
                    }
                    FirClassifierSymbol<?> firClassifierSymbol = symbol2;
                    if (firClassifierSymbol instanceof FirClassLikeSymbol) {
                        FirClassifierSymbol<?> firClassifierSymbol2;
                        firBasedSymbol = ((FirUserTypeRef)this.$typeRef).getQualifier().size() == 1 ? (FirBasedSymbol)symbol2 : ((firClassifierSymbol2 = this.$qualifierResolver.resolveSymbolWithPrefix(((FirUserTypeRef)this.$typeRef).getQualifier(), ((FirClassLikeSymbol)symbol2).getClassId())) == null ? (FirBasedSymbol)FirTypeResolverImpl.access$resolveEnumEntrySymbol(this.this$0, this.$qualifierResolver, ((FirUserTypeRef)this.$typeRef).getQualifier(), ((FirClassLikeSymbol)symbol2).getClassId()) : (FirBasedSymbol)firClassifierSymbol2);
                    } else if (firClassifierSymbol instanceof FirTypeParameterSymbol) {
                        boolean bl;
                        boolean bl2 = bl = ((FirUserTypeRef)this.$typeRef).getQualifier().size() == 1;
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        firBasedSymbol = symbol2;
                    } else {
                        throw new IllegalStateException("!".toString());
                    }
                    this.$resolvedSymbol.element = firBasedSymbol;
                    this.$substitutor.element = substitutorFromScope;
                }
            });
            FirBasedSymbol firBasedSymbol = (FirBasedSymbol)resolvedSymbol.element;
            FirBasedSymbol resultSymbol = firBasedSymbol == null ? (FirBasedSymbol)qualifierResolver.resolveSymbol(((FirUserTypeRef)typeRef).getQualifier()) : firBasedSymbol;
            pair = TuplesKt.to((Object)resultSymbol, (Object)substitutor2.element);
        } else {
            pair = firTypeRef instanceof FirImplicitBuiltinTypeRef ? TuplesKt.to(this.resolveBuiltInQualified(((FirImplicitBuiltinTypeRef)typeRef).getId(), this.session), null) : TuplesKt.to(null, null);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final FirVariableSymbol<FirEnumEntry> resolveEnumEntrySymbol(FirQualifierResolver $this$resolveEnumEntrySymbol, List<? extends FirQualifierPart> qualifier, ClassId classId) {
        FirEnumEntry enumEntryMatchingLastQualifier;
        FirEnumEntry firEnumEntry;
        block4: {
            void $this$firstOrNull$iv;
            FirRegularClass firRegularClass;
            FirClassifierSymbol<?> firClassifierSymbol = $this$resolveEnumEntrySymbol.resolveSymbolWithPrefix(CollectionsKt.dropLast(qualifier, (int)1), classId);
            if (firClassifierSymbol == null) {
                return null;
            }
            FirClassifierSymbol<?> enumClassSymbol = firClassifierSymbol;
            Object e = enumClassSymbol.getFir();
            FirRegularClass firRegularClass2 = firRegularClass = e instanceof FirRegularClass ? (FirRegularClass)e : null;
            if (firRegularClass == null) {
                return null;
            }
            FirRegularClass enumClassFir = firRegularClass;
            FirClass $this$isEnumClass$iv = enumClassFir;
            boolean $i$f$isEnumClass = false;
            Object $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
                return null;
            }
            $this$isEnumClass$iv$iv = enumClassFir.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirEnumEntry && Intrinsics.areEqual((Object)((FirEnumEntry)it).getName(), (Object)((FirQualifierPart)CollectionsKt.last(qualifier)).getName()))) continue;
                firEnumEntry = element$iv;
                break block4;
            }
            firEnumEntry = null;
        }
        FirEnumEntry firEnumEntry2 = firEnumEntry;
        firEnumEntry2 = enumEntryMatchingLastQualifier = firEnumEntry2 instanceof FirEnumEntry ? (FirEnumEntry)firEnumEntry2 : null;
        return firEnumEntry2 == null ? null : firEnumEntry2.getSymbol();
    }

    private final ConeKotlinType resolveUserType(FirUserTypeRef typeRef, FirBasedSymbol<?> symbol2, ConeSubstitutor substitutor2, boolean areBareTypesAllowed, FirRegularClass topDeclaration, boolean isOperandOfIsOperator) {
        ConeLookupTagBasedType coneLookupTagBasedType;
        Object object;
        Object qualifierTypeArguments;
        if (symbol2 == null || !(symbol2 instanceof FirClassifierSymbol)) {
            FirBasedSymbol<?> firBasedSymbol = symbol2;
            ConeDiagnostic diagnostic = (firBasedSymbol == null ? null : firBasedSymbol.getFir()) instanceof FirEnumEntry ? (ConeDiagnostic)(isOperandOfIsOperator ? new ConeSimpleDiagnostic("'is' operator can not be applied to an enum entry.", DiagnosticKind.IsEnumEntry) : new ConeSimpleDiagnostic("An enum entry should not be used as a type.", DiagnosticKind.EnumEntryAsType)) : (ConeDiagnostic)new ConeUnresolvedQualifierError(FirRendererKt.render$default(typeRef, null, 1, null));
            return new ConeClassErrorType(diagnostic, false, 2, null);
        }
        if (symbol2 instanceof FirTypeParameterSymbol) {
            for (FirQualifierPart part : typeRef.getQualifier()) {
                Collection collection = part.getTypeArgumentList().getTypeArguments();
                if (!(!collection.isEmpty())) continue;
                return new ConeClassErrorType(new ConeUnexpectedTypeArgumentsError("Type arguments not allowed", part.getTypeArgumentList().getSource()), false, 2, null);
            }
        }
        List allTypeArguments = new ArrayList();
        int typeArgumentsCount = 0;
        List<FirQualifierPart> qualifier = typeRef.getQualifier();
        int n = qualifier.size() - 1;
        if (0 <= n) {
            do {
                int qualifierIndex = n--;
                qualifierTypeArguments = qualifier.get(qualifierIndex).getTypeArgumentList().getTypeArguments();
                object = qualifierTypeArguments.iterator();
                while (object.hasNext()) {
                    FirTypeProjection qualifierTypeArgument = (FirTypeProjection)object.next();
                    allTypeArguments.add(FirTypeUtilsKt.toConeTypeProjection(qualifierTypeArgument));
                    int n2 = typeArgumentsCount;
                    typeArgumentsCount = n2 + 1;
                }
            } while (0 <= n);
        }
        if (symbol2 instanceof FirRegularClassSymbol) {
            boolean isPossibleBareType;
            boolean bl = isPossibleBareType = areBareTypesAllowed && allTypeArguments.isEmpty();
            if (!isPossibleBareType) {
                Object object2;
                Object object3;
                Object typeParameter;
                int index2;
                qualifierTypeArguments = substitutor2;
                Object actualSubstitutor = qualifierTypeArguments == null ? (ConeSubstitutor)ConeSubstitutor.Empty.INSTANCE : qualifierTypeArguments;
                List<FirTypeParameterRef> typeParameters2 = ((FirRegularClass)((FirRegularClassSymbol)symbol2).getFir()).getTypeParameters();
                object = this.getClassesAlignedToQualifierParts((FirRegularClassSymbol)symbol2, qualifier, this.session);
                Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> typeParametersAlignedToQualifierParts = ((ParametersMapAndOuterClasses)object).component1();
                List<FirRegularClass> outerClasses2 = ((ParametersMapAndOuterClasses)object).component2();
                Iterator<FirTypeParameterRef> iterator2 = typeParameters2.iterator();
                int n3 = 0;
                while (iterator2.hasNext()) {
                    ConeClassErrorType coneClassErrorType;
                    index2 = n3++;
                    typeParameter = iterator2.next();
                    object3 = typeParametersAlignedToQualifierParts.get(typeParameter.getSymbol());
                    if (object3 == null) continue;
                    object2 = object3;
                    FirRegularClass parameterClass = ((ClassWithQualifierPartIndex)object2).component1();
                    int qualifierPartIndex = ((ClassWithQualifierPartIndex)object2).component2();
                    if (index2 < typeArgumentsCount) {
                        int qualifierPartArgumentsCount = qualifier.get(qualifierPartIndex).getTypeArgumentList().getTypeArguments().size();
                        ConeClassErrorType coneClassErrorType2 = FirTypeResolverImpl.createDiagnosticsIfExists$default(this, parameterClass, qualifierPartIndex, (FirRegularClassSymbol)symbol2, typeRef, qualifierPartArgumentsCount, false, 32, null);
                        if (coneClassErrorType2 == null) continue;
                        ConeClassErrorType it = coneClassErrorType = coneClassErrorType2;
                        boolean bl2 = false;
                        return it;
                    }
                    if (!(typeParameter instanceof FirOuterClassTypeParameterRef) || ResolveUtilsKt.isValidTypeParameterFromOuterClass(typeParameter.getSymbol(), topDeclaration, this.session)) {
                        ConeTypeParameterTypeImpl type2 = new ConeTypeParameterTypeImpl(new ConeTypeParameterLookupTag(typeParameter.getSymbol()), false, null, 4, null);
                        ConeKotlinType substituted = ((ConeSubstitutor)actualSubstitutor).substituteOrNull(type2);
                        if (substituted == null) {
                            ConeClassErrorType coneClassErrorType3;
                            coneClassErrorType = FirTypeResolverImpl.createDiagnosticsIfExists$default(this, parameterClass, qualifierPartIndex, (FirRegularClassSymbol)symbol2, typeRef, null, false, 48, null);
                            if (coneClassErrorType == null) continue;
                            ConeClassErrorType it = coneClassErrorType3 = coneClassErrorType;
                            boolean bl3 = false;
                            return it;
                        }
                        allTypeArguments.add(substituted);
                        continue;
                    }
                    return new ConeClassErrorType(new ConeOuterClassArgumentsRequired(parameterClass.getSymbol()), false, 2, null);
                }
                if (typeArgumentsCount > typeParameters2.size()) {
                    int n4 = 0;
                    n3 = qualifier.size();
                    while (n4 < n3) {
                        if (!(!(typeParameter = (Collection)qualifier.get(index2 = n4++).getTypeArgumentList().getTypeArguments()).isEmpty())) continue;
                        object2 = outerClasses2;
                        FirRegularClass parameterClass = (FirRegularClass)CollectionsKt.getOrNull((List)object2, (int)index2);
                        if ((object2 = FirTypeResolverImpl.createDiagnosticsIfExists$default(this, parameterClass, index2, (FirRegularClassSymbol)symbol2, typeRef, null, true, 16, null)) == null) continue;
                        Object it = object3 = object2;
                        boolean bl4 = false;
                        return (ConeKotlinType)it;
                    }
                }
            }
        }
        Collection $this$toTypedArray$iv = allTypeArguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ConeLookupTagBasedType it = coneLookupTagBasedType = TreeResolveUtilsKt.constructType((FirClassifierSymbol)symbol2, (ConeTypeProjection[])object, typeRef.isMarkedNullable(), FirTypeUtilsKt.computeTypeAttributes$default(typeRef.getAnnotations(), null, 1, null));
        boolean bl = false;
        ConeClassifierLookupTag lookupTag = it.getLookupTag();
        if (lookupTag instanceof ConeClassLikeLookupTagImpl && symbol2 instanceof FirClassLikeSymbol) {
            LookupTagUtilsKt.bindSymbolToLookupTag((ConeClassLikeLookupTagImpl)lookupTag, this.session, (FirClassLikeSymbol)symbol2);
        }
        return coneLookupTagBasedType;
    }

    private final ParametersMapAndOuterClasses getClassesAlignedToQualifierParts(FirRegularClassSymbol symbol2, List<? extends FirQualifierPart> qualifier, FirSession session) {
        FirRegularClass currentClass = null;
        List outerClasses2 = new ArrayList();
        int qualifierPartIndex = 0;
        while (qualifierPartIndex < qualifier.size() || currentClass != null) {
            if (qualifierPartIndex == 0) {
                currentClass = (FirRegularClass)symbol2.getFir();
            } else if (currentClass != null) {
                currentClass = ResolveUtilsKt.getOuterClass(currentClass, session);
            }
            outerClasses2.add(currentClass);
            int n = qualifierPartIndex;
            qualifierPartIndex = n + 1;
        }
        int outerArgumentsCount = outerClasses2.size() - qualifier.size();
        List reversedOuterClasses = CollectionsKt.asReversedMutable((List)outerClasses2);
        Map result2 = new LinkedHashMap();
        int n = 0;
        int n2 = reversedOuterClasses.size();
        while (n < n2) {
            int index2;
            if ((currentClass = (FirRegularClass)reversedOuterClasses.get(index2 = n++)) == null) continue;
            for (FirTypeParameterRef typeParameter : currentClass.getTypeParameters()) {
                FirTypeParameterSymbol typeParameterSymbol = typeParameter.getSymbol();
                if (result2.containsKey(typeParameterSymbol)) continue;
                Map map = result2;
                ClassWithQualifierPartIndex classWithQualifierPartIndex = new ClassWithQualifierPartIndex(currentClass, index2 - outerArgumentsCount);
                map.put(typeParameterSymbol, classWithQualifierPartIndex);
            }
        }
        return new ParametersMapAndOuterClasses(result2, CollectionsKt.drop((Iterable)reversedOuterClasses, (int)outerArgumentsCount));
    }

    private final ConeClassErrorType createDiagnosticsIfExists(FirRegularClass parameterClass, int qualifierPartIndex, FirRegularClassSymbol symbol2, FirUserTypeRef userTypeRef, Integer qualifierPartArgumentsCount, boolean ignoreOuterClassCheck) {
        FirSourceElement source;
        FirRegularClass firRegularClass = parameterClass;
        Pair<FirRegularClass, Integer> pair = ResolveUtilsKt.getOuterClassAndActualTypeParametersCount(firRegularClass == null ? (FirRegularClass)symbol2.getFir() : firRegularClass, this.session);
        FirRegularClass outerClass = (FirRegularClass)pair.component1();
        int actualTypeParametersCount = ((Number)pair.component2()).intValue();
        if ((qualifierPartArgumentsCount == null || actualTypeParametersCount != qualifierPartArgumentsCount) && (ignoreOuterClassCheck || parameterClass != null && FirDeclarationUtilKt.getClassId(parameterClass).getRelativeClassName().parent().isRoot() || outerClass != null) && (source = this.getTypeArgumentsOrNameSource(userTypeRef, qualifierPartIndex)) != null) {
            FirRegularClass firRegularClass2 = parameterClass;
            return new ConeClassErrorType(new ConeWrongNumberOfTypeArgumentsError(actualTypeParametersCount, firRegularClass2 == null ? symbol2 : firRegularClass2.getSymbol(), source), false, 2, null);
        }
        return null;
    }

    static /* synthetic */ ConeClassErrorType createDiagnosticsIfExists$default(FirTypeResolverImpl firTypeResolverImpl, FirRegularClass firRegularClass, int n, FirRegularClassSymbol firRegularClassSymbol, FirUserTypeRef firUserTypeRef, Integer n2, boolean bl, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        return firTypeResolverImpl.createDiagnosticsIfExists(firRegularClass, n, firRegularClassSymbol, firUserTypeRef, n2, bl);
    }

    private final FirSourceElement getTypeArgumentsOrNameSource(FirUserTypeRef typeRef, Integer qualifierIndex) {
        FirTypeArgumentList typeArgumentsList;
        FirQualifierPart qualifierPart;
        FirQualifierPart firQualifierPart;
        if (qualifierIndex != null) {
            List<FirQualifierPart> list2 = typeRef.getQualifier();
            int n = qualifierIndex;
            firQualifierPart = (FirQualifierPart)CollectionsKt.getOrNull(list2, (int)n);
        } else {
            firQualifierPart = null;
        }
        FirQualifierPart firQualifierPart2 = qualifierPart = firQualifierPart;
        FirTypeArgumentList firTypeArgumentList = typeArgumentsList = firQualifierPart2 == null ? null : firQualifierPart2.getTypeArgumentList();
        return typeArgumentsList == null || typeArgumentsList.getTypeArguments().isEmpty() ? ((firQualifierPart2 = qualifierPart) == null ? typeRef.getSource() : firQualifierPart2.getSource()) : typeArgumentsList.getSource();
    }

    /*
     * WARNING - void declaration
     */
    private final ConeClassLikeType createFunctionalType(FirFunctionTypeRef typeRef) {
        ConeKotlinType coneKotlinType;
        Collection<ConeKotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = typeRef.getReceiverTypeRef();
        ConeKotlinType coneKotlinType2 = object == null ? null : FirTypeUtilsKt.getConeType((FirTypeRef)object);
        object = typeRef.getValueParameters();
        Collection collection2 = CollectionsKt.listOfNotNull((Object)coneKotlinType2);
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            coneKotlinType = FirTypeUtilsKt.getConeType(it.getReturnTypeRef());
            collection.add(coneKotlinType);
        }
        collection = (List)destination$iv$iv;
        List parameters2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (Iterable)CollectionsKt.listOf((Object)FirTypeUtilsKt.getConeType(typeRef.getReturnTypeRef())));
        ClassId classId = typeRef.isSuspend() ? StandardNames.getSuspendFunctionClassId(FirTypeUtilsKt.getParametersCount(typeRef)) : StandardNames.getFunctionClassId(FirTypeUtilsKt.getParametersCount(typeRef));
        ConeAttributes attributes2 = FirTypeUtilsKt.computeTypeAttributes$default(typeRef.getAnnotations(), null, 1, null);
        FirClassLikeSymbol<?> symbol2 = this.resolveBuiltInQualified(classId, this.session);
        Object it = destination$iv$iv = symbol2.toLookupTag();
        boolean bl = false;
        if (it instanceof ConeClassLikeLookupTagImpl) {
            LookupTagUtilsKt.bindSymbolToLookupTag((ConeClassLikeLookupTagImpl)it, this.session, symbol2);
        }
        coneKotlinType = Unit.INSTANCE;
        Collection $this$toTypedArray$iv = parameters2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeKotlinType[] coneKotlinTypeArray = thisCollection$iv.toArray(new ConeKotlinType[0]);
        if (coneKotlinTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ConeAttributes coneAttributes = attributes2;
        boolean bl2 = typeRef.isMarkedNullable();
        ConeTypeProjection[] coneTypeProjectionArray = coneKotlinTypeArray;
        Object object2 = destination$iv$iv;
        return new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)object2, coneTypeProjectionArray, bl2, coneAttributes);
    }

    @Override
    @NotNull
    public ConeKotlinType resolveType(@NotNull FirTypeRef typeRef, @NotNull ScopeClassDeclaration scopeClassDeclaration, boolean areBareTypesAllowed, boolean isOperandOfIsOperator) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)scopeClassDeclaration, (String)"scopeClassDeclaration");
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef instanceof FirResolvedTypeRef) {
            coneKotlinType = ((FirResolvedTypeRef)typeRef).getType();
        } else if (firTypeRef instanceof FirUserTypeRef) {
            Pair<FirBasedSymbol<?>, ConeSubstitutor> pair = this.resolveToSymbol(typeRef, scopeClassDeclaration.getScope());
            FirBasedSymbol symbol2 = (FirBasedSymbol)pair.component1();
            ConeSubstitutor substitutor2 = (ConeSubstitutor)pair.component2();
            coneKotlinType = this.resolveUserType((FirUserTypeRef)typeRef, symbol2, substitutor2, areBareTypesAllowed, scopeClassDeclaration.getTopDeclaration(), isOperandOfIsOperator);
        } else if (firTypeRef instanceof FirFunctionTypeRef) {
            coneKotlinType = this.createFunctionalType((FirFunctionTypeRef)typeRef);
        } else if (firTypeRef instanceof FirDynamicTypeRef) {
            coneKotlinType = new ConeClassErrorType(new ConeUnsupportedDynamicType(), false, 2, null);
        } else {
            throw new IllegalStateException(FirRendererKt.render$default(typeRef, null, 1, null).toString());
        }
        return coneKotlinType;
    }

    public static final /* synthetic */ FirVariableSymbol access$resolveEnumEntrySymbol(FirTypeResolverImpl $this, FirQualifierResolver $receiver, List qualifier, ClassId classId) {
        return $this.resolveEnumEntrySymbol($receiver, qualifier, classId);
    }

    public static final /* synthetic */ FirSession access$getSession$p(FirTypeResolverImpl $this) {
        return $this.session;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ClassIdInSession;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "id", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;)V", "getId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    private static final class ClassIdInSession {
        @NotNull
        private final FirSession session;
        @NotNull
        private final ClassId id;

        public ClassIdInSession(@NotNull FirSession session, @NotNull ClassId id) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.session = session;
            this.id = id;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final ClassId getId() {
            return this.id;
        }

        @NotNull
        public final FirSession component1() {
            return this.session;
        }

        @NotNull
        public final ClassId component2() {
            return this.id;
        }

        @NotNull
        public final ClassIdInSession copy(@NotNull FirSession session, @NotNull ClassId id) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new ClassIdInSession(session, id);
        }

        public static /* synthetic */ ClassIdInSession copy$default(ClassIdInSession classIdInSession, FirSession firSession, ClassId classId, int n, Object object) {
            if ((n & 1) != 0) {
                firSession = classIdInSession.session;
            }
            if ((n & 2) != 0) {
                classId = classIdInSession.id;
            }
            return classIdInSession.copy(firSession, classId);
        }

        @NotNull
        public String toString() {
            return "ClassIdInSession(session=" + this.session + ", id=" + this.id + ')';
        }

        public int hashCode() {
            int result2 = this.session.hashCode();
            result2 = result2 * 31 + this.id.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassIdInSession)) {
                return false;
            }
            ClassIdInSession classIdInSession = (ClassIdInSession)other;
            if (!Intrinsics.areEqual((Object)this.session, (Object)classIdInSession.session)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.id, (Object)classIdInSession.id);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0011\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0003J1\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ParametersMapAndOuterClasses;", "", "parameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ClassWithQualifierPartIndex;", "outerClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Ljava/util/Map;Ljava/util/List;)V", "getOuterClasses", "()Ljava/util/List;", "getParameters", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    private static final class ParametersMapAndOuterClasses {
        @NotNull
        private final Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> parameters;
        @NotNull
        private final List<FirRegularClass> outerClasses;

        public ParametersMapAndOuterClasses(@NotNull Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> parameters2, @NotNull List<? extends FirRegularClass> outerClasses2) {
            Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
            Intrinsics.checkNotNullParameter(outerClasses2, (String)"outerClasses");
            this.parameters = parameters2;
            this.outerClasses = outerClasses2;
        }

        @NotNull
        public final Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> getParameters() {
            return this.parameters;
        }

        @NotNull
        public final List<FirRegularClass> getOuterClasses() {
            return this.outerClasses;
        }

        @NotNull
        public final Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> component1() {
            return this.parameters;
        }

        @NotNull
        public final List<FirRegularClass> component2() {
            return this.outerClasses;
        }

        @NotNull
        public final ParametersMapAndOuterClasses copy(@NotNull Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> parameters2, @NotNull List<? extends FirRegularClass> outerClasses2) {
            Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
            Intrinsics.checkNotNullParameter(outerClasses2, (String)"outerClasses");
            return new ParametersMapAndOuterClasses(parameters2, outerClasses2);
        }

        public static /* synthetic */ ParametersMapAndOuterClasses copy$default(ParametersMapAndOuterClasses parametersMapAndOuterClasses, Map map, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                map = parametersMapAndOuterClasses.parameters;
            }
            if ((n & 2) != 0) {
                list2 = parametersMapAndOuterClasses.outerClasses;
            }
            return parametersMapAndOuterClasses.copy(map, list2);
        }

        @NotNull
        public String toString() {
            return "ParametersMapAndOuterClasses(parameters=" + this.parameters + ", outerClasses=" + this.outerClasses + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.parameters).hashCode();
            result2 = result2 * 31 + ((Object)this.outerClasses).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParametersMapAndOuterClasses)) {
                return false;
            }
            ParametersMapAndOuterClasses parametersMapAndOuterClasses = (ParametersMapAndOuterClasses)other;
            if (!Intrinsics.areEqual(this.parameters, parametersMapAndOuterClasses.parameters)) {
                return false;
            }
            return Intrinsics.areEqual(this.outerClasses, parametersMapAndOuterClasses.outerClasses);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ClassWithQualifierPartIndex;", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "index", "", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;I)V", "getIndex", "()I", "getKlass", "()Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "resolve"})
    private static final class ClassWithQualifierPartIndex {
        @NotNull
        private final FirRegularClass klass;
        private final int index;

        public ClassWithQualifierPartIndex(@NotNull FirRegularClass klass, int index2) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            this.klass = klass;
            this.index = index2;
        }

        @NotNull
        public final FirRegularClass getKlass() {
            return this.klass;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final FirRegularClass component1() {
            return this.klass;
        }

        public final int component2() {
            return this.index;
        }

        @NotNull
        public final ClassWithQualifierPartIndex copy(@NotNull FirRegularClass klass, int index2) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            return new ClassWithQualifierPartIndex(klass, index2);
        }

        public static /* synthetic */ ClassWithQualifierPartIndex copy$default(ClassWithQualifierPartIndex classWithQualifierPartIndex, FirRegularClass firRegularClass, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                firRegularClass = classWithQualifierPartIndex.klass;
            }
            if ((n2 & 2) != 0) {
                n = classWithQualifierPartIndex.index;
            }
            return classWithQualifierPartIndex.copy(firRegularClass, n);
        }

        @NotNull
        public String toString() {
            return "ClassWithQualifierPartIndex(klass=" + this.klass + ", index=" + this.index + ')';
        }

        public int hashCode() {
            int result2 = this.klass.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.index);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassWithQualifierPartIndex)) {
                return false;
            }
            ClassWithQualifierPartIndex classWithQualifierPartIndex = (ClassWithQualifierPartIndex)other;
            if (!Intrinsics.areEqual((Object)this.klass, (Object)classWithQualifierPartIndex.klass)) {
                return false;
            }
            return this.index == classWithQualifierPartIndex.index;
        }
    }
}

