/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.deserialization.AbstractAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.AbstractFirDeserializedSymbolsProvider;
import org.jetbrains.kotlin.fir.deserialization.ClassDeserializationKt;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.FirMemberDeserializer;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.fir.deserialization.PackagePartsCacheData;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0001AB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010!\u001a\u00020\u001aH$J\u001e\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u000b2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\rH$J>\u0010&\u001a$\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020)\u0018\u00010(j\u0004\u0018\u0001`*0'2\u0006\u0010$\u001a\u00020\u000b2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\f2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001f2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u001e\u0010-\u001a\u0004\u0018\u00010\f2\u0006\u0010$\u001a\u00020\u000b2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\rH\u0014J\u0016\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\u0006\u0010$\u001a\u00020\u000bH\u0016J\u0012\u00100\u001a\u0004\u0018\u00010\u001a2\u0006\u00101\u001a\u00020\u001aH\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b032\u0006\u0010!\u001a\u00020\u001aH\u0002J*\u00104\u001a\u00020)2\u0010\u00105\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u000307062\u0006\u0010!\u001a\u00020\u001a2\u0006\u00108\u001a\u000209H\u0017J&\u0010:\u001a\u00020)2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0013062\u0006\u0010!\u001a\u00020\u001a2\u0006\u00108\u001a\u000209H\u0017J&\u0010;\u001a\u00020)2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001d062\u0006\u0010!\u001a\u00020\u001a2\u0006\u00108\u001a\u000209H\u0017J\u0012\u0010<\u001a\u0004\u0018\u00010\u001f2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010>\u001a\u00020\u0011H\u0002J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00122\u0006\u0010>\u001a\u00020\u0011H\u0002J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010!\u001a\u00020\u001aH\u0002R*\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u001c\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u001c\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleDataProvider", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;)V", "classCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "getClassCache", "()Lorg/jetbrains/kotlin/fir/caches/FirCache;", "functionCache", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "getModuleDataProvider", "()Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "packagePartsCache", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/deserialization/PackagePartsCacheData;", "propertyCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "typeAliasCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "computePackagePartsInfos", "packageFqName", "extractClassMetadata", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult;", "classId", "parentContext", "findAndDeserializeClass", "Lkotlin/Pair;", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/deserialization/DeserializedClassPostProcessor;", "findAndDeserializeClassViaParent", "findAndDeserializeTypeAlias", "getClass", "getClassLikeSymbolByFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getPackage", "fqName", "getPackageParts", "", "getTopLevelCallableSymbolsTo", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "getTopLevelPropertySymbolsTo", "getTypeAlias", "loadFunctionsByCallableId", "callableId", "loadPropertiesByCallableId", "tryComputePackagePartInfos", "ClassMetadataFindResult", "fir-deserialization"})
public abstract class AbstractFirDeserializedSymbolsProvider
extends FirSymbolProvider {
    @NotNull
    private final ModuleDataProvider moduleDataProvider;
    @NotNull
    private final FirKotlinScopeProvider kotlinScopeProvider;
    @NotNull
    private final FirCache packagePartsCache;
    @NotNull
    private final FirCache typeAliasCache;
    @NotNull
    private final FirCache<ClassId, FirRegularClassSymbol, FirDeserializationContext> classCache;
    @NotNull
    private final FirCache functionCache;
    @NotNull
    private final FirCache propertyCache;

    public AbstractFirDeserializedSymbolsProvider(@NotNull FirSession session, @NotNull ModuleDataProvider moduleDataProvider, @NotNull FirKotlinScopeProvider kotlinScopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)moduleDataProvider, (String)"moduleDataProvider");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider2, (String)"kotlinScopeProvider");
        super(session);
        this.moduleDataProvider = moduleDataProvider;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session);
        boolean $i$f$createCache = false;
        this.packagePartsCache = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ AbstractFirDeserializedSymbolsProvider $receiver$inlined;
            {
                this.$receiver$inlined = abstractFirDeserializedSymbolsProvider;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void $noName_1) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                FqName p0 = (FqName)key;
                boolean bl = false;
                return AbstractFirDeserializedSymbolsProvider.access$tryComputePackagePartInfos(this.$receiver$inlined, p0);
            }
        });
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session);
        $i$f$createCache = false;
        this.typeAliasCache = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ AbstractFirDeserializedSymbolsProvider $receiver$inlined;
            {
                this.$receiver$inlined = abstractFirDeserializedSymbolsProvider;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void $noName_1) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                ClassId p0 = (ClassId)key;
                boolean bl = false;
                return AbstractFirDeserializedSymbolsProvider.access$findAndDeserializeTypeAlias(this.$receiver$inlined, p0);
            }
        });
        this.classCache = FirCachesFactoryKt.getFirCachesFactory(session).createCacheWithPostCompute((Function2)new Function2<ClassId, FirDeserializationContext, Pair<? extends FirRegularClassSymbol, ? extends Function1<? super FirRegularClassSymbol, ? extends Unit>>>(this){
            final /* synthetic */ AbstractFirDeserializedSymbolsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Pair<FirRegularClassSymbol, Function1<FirRegularClassSymbol, Unit>> invoke(@NotNull ClassId classId, @Nullable FirDeserializationContext context2) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                return AbstractFirDeserializedSymbolsProvider.access$findAndDeserializeClass(this.this$0, classId, context2);
            }
        }, classCache.2.INSTANCE);
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session);
        $i$f$createCache = false;
        this.functionCache = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ AbstractFirDeserializedSymbolsProvider $receiver$inlined;
            {
                this.$receiver$inlined = abstractFirDeserializedSymbolsProvider;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void $noName_1) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                CallableId p0 = (CallableId)key;
                boolean bl = false;
                return AbstractFirDeserializedSymbolsProvider.access$loadFunctionsByCallableId(this.$receiver$inlined, p0);
            }
        });
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(session);
        $i$f$createCache = false;
        this.propertyCache = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ AbstractFirDeserializedSymbolsProvider $receiver$inlined;
            {
                this.$receiver$inlined = abstractFirDeserializedSymbolsProvider;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void $noName_1) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                CallableId p0 = (CallableId)key;
                boolean bl = false;
                return AbstractFirDeserializedSymbolsProvider.access$loadPropertiesByCallableId(this.$receiver$inlined, p0);
            }
        });
    }

    @NotNull
    public final ModuleDataProvider getModuleDataProvider() {
        return this.moduleDataProvider;
    }

    @NotNull
    public final FirKotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    @NotNull
    protected final FirCache<ClassId, FirRegularClassSymbol, FirDeserializationContext> getClassCache() {
        return this.classCache;
    }

    @NotNull
    protected abstract List<PackagePartsCacheData> computePackagePartsInfos(@NotNull FqName var1);

    @Nullable
    protected abstract ClassMetadataFindResult extractClassMetadata(@NotNull ClassId var1, @Nullable FirDeserializationContext var2);

    public static /* synthetic */ ClassMetadataFindResult extractClassMetadata$default(AbstractFirDeserializedSymbolsProvider abstractFirDeserializedSymbolsProvider, ClassId classId, FirDeserializationContext firDeserializationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extractClassMetadata");
        }
        if ((n & 2) != 0) {
            firDeserializationContext = null;
        }
        return abstractFirDeserializedSymbolsProvider.extractClassMetadata(classId, firDeserializationContext);
    }

    private final List<PackagePartsCacheData> tryComputePackagePartInfos(FqName packageFqName) {
        List<PackagePartsCacheData> list2;
        try {
            list2 = this.computePackagePartsInfos(packageFqName);
        }
        catch (ProcessCanceledException e) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirTypeAliasSymbol findAndDeserializeTypeAlias(ClassId classId) {
        FirTypeAliasSymbol firTypeAliasSymbol;
        block4: {
            Object object = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classId.packageFqName");
            object = this.getPackageParts((FqName)object);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                FirTypeAliasSymbol firTypeAliasSymbol2;
                FirTypeAliasSymbol firTypeAliasSymbol3;
                Object t = iterator2.next();
                PackagePartsCacheData part = (PackagePartsCacheData)t;
                boolean bl = false;
                List<Integer> ids = part.getTypeAliasNameIndex().get(classId.getShortClassName());
                if (ids == null || ids.isEmpty()) {
                    firTypeAliasSymbol3 = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = ids;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        int n = ((Number)item$iv$iv).intValue();
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        ProtoBuf.TypeAlias typeAlias = part.getProto().getTypeAlias((int)it);
                        collection.add(typeAlias);
                    }
                    ProtoBuf.TypeAlias aliasProto = (ProtoBuf.TypeAlias)CollectionsKt.single((List)((List)destination$iv$iv));
                    FirMemberDeserializer firMemberDeserializer = part.getContext().getMemberDeserializer();
                    Intrinsics.checkNotNullExpressionValue((Object)aliasProto, (String)"aliasProto");
                    firTypeAliasSymbol3 = firMemberDeserializer.loadTypeAlias(aliasProto).getSymbol();
                }
                if ((firTypeAliasSymbol2 = firTypeAliasSymbol3) == null) continue;
                firTypeAliasSymbol = firTypeAliasSymbol2;
                break block4;
            }
            firTypeAliasSymbol = null;
        }
        return firTypeAliasSymbol;
    }

    private final Pair<FirRegularClassSymbol, Function1<FirRegularClassSymbol, Unit>> findAndDeserializeClass(ClassId classId, FirDeserializationContext parentContext) {
        Pair pair;
        ClassMetadataFindResult result2 = this.extractClassMetadata(classId, parentContext);
        if (result2 instanceof ClassMetadataFindResult.Metadata) {
            ClassMetadataFindResult classMetadataFindResult = result2;
            NameResolver nameResolver2 = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component1();
            ProtoBuf.Class classProto = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component2();
            AbstractAnnotationDeserializer annotationDeserializer = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component3();
            Path containingLibrary = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component4();
            DeserializedContainerSource sourceElement = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component5();
            Function1<FirRegularClassSymbol, Unit> postProcessor = ((ClassMetadataFindResult.Metadata)classMetadataFindResult).component6();
            FirModuleData firModuleData = this.moduleDataProvider.getModuleData(containingLibrary);
            if (firModuleData == null) {
                return TuplesKt.to(null, null);
            }
            FirModuleData moduleData = firModuleData;
            FirRegularClassSymbol symbol2 = new FirRegularClassSymbol(classId);
            ClassDeserializationKt.deserializeClassToSymbol$default(classId, classProto, symbol2, nameResolver2, this.getSession(), moduleData, annotationDeserializer, this.kotlinScopeProvider, parentContext, sourceElement, null, (Function2)new Function2<ClassId, FirDeserializationContext, FirRegularClassSymbol>((Object)this){

                @Nullable
                public final FirRegularClassSymbol invoke(@NotNull ClassId p0, @Nullable FirDeserializationContext p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AbstractFirDeserializedSymbolsProvider)this.receiver).getClass(p0, p1);
                }

                @NotNull
                public final String getSignature() {
                    return "getClass(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;";
                }

                @NotNull
                public final String getName() {
                    return "getClass";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(AbstractFirDeserializedSymbolsProvider.class);
                }
            }, 1024, null);
            pair = TuplesKt.to((Object)symbol2, postProcessor);
        } else if (result2 instanceof ClassMetadataFindResult.ClassWithoutMetadata) {
            pair = TuplesKt.to((Object)((ClassMetadataFindResult.ClassWithoutMetadata)result2).getSymbol(), null);
        } else if (Intrinsics.areEqual((Object)result2, (Object)ClassMetadataFindResult.ShouldDeserializeViaParent.INSTANCE)) {
            pair = TuplesKt.to((Object)this.findAndDeserializeClassViaParent(classId), null);
        } else if (result2 == null) {
            pair = TuplesKt.to(null, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    static /* synthetic */ Pair findAndDeserializeClass$default(AbstractFirDeserializedSymbolsProvider abstractFirDeserializedSymbolsProvider, ClassId classId, FirDeserializationContext firDeserializationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findAndDeserializeClass");
        }
        if ((n & 2) != 0) {
            firDeserializationContext = null;
        }
        return abstractFirDeserializedSymbolsProvider.findAndDeserializeClass(classId, firDeserializationContext);
    }

    private final FirRegularClassSymbol findAndDeserializeClassViaParent(ClassId classId) {
        ClassId classId2 = classId.getOuterClassId();
        if (classId2 == null) {
            return null;
        }
        Object object = classId2;
        Object outerClassId = object;
        if ((object = AbstractFirDeserializedSymbolsProvider.getClass$default(this, (ClassId)outerClassId, null, 2, null)) == null) {
            return null;
        }
        return this.classCache.getValueIfComputed(classId);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirNamedFunctionSymbol> loadFunctionsByCallableId(CallableId callableId) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getPackageParts(callableId.getPackageName());
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            PackagePartsCacheData part = (PackagePartsCacheData)element$iv$iv;
            boolean bl = false;
            List<Integer> list3 = part.getTopLevelFunctionNameIndex().get(callableId.getCallableName());
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                List<Integer> functionIds = list3;
                Iterable $this$map$iv = functionIds;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    int n = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    FirMemberDeserializer firMemberDeserializer = part.getContext().getMemberDeserializer();
                    ProtoBuf.Function function2 = part.getProto().getFunction((int)it);
                    Intrinsics.checkNotNullExpressionValue((Object)function2, (String)"part.proto.getFunction(it)");
                    FirNamedFunctionSymbol firNamedFunctionSymbol = FirMemberDeserializer.loadFunction$default(firMemberDeserializer, function2, null, null, 6, null).getSymbol();
                    collection.add(firNamedFunctionSymbol);
                }
                list2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirPropertySymbol> loadPropertiesByCallableId(CallableId callableId) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getPackageParts(callableId.getPackageName());
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            PackagePartsCacheData part = (PackagePartsCacheData)element$iv$iv;
            boolean bl = false;
            List<Integer> list3 = part.getTopLevelPropertyNameIndex().get(callableId.getCallableName());
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                List<Integer> propertyIds = list3;
                Iterable $this$map$iv = propertyIds;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    int n = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    FirMemberDeserializer firMemberDeserializer = part.getContext().getMemberDeserializer();
                    ProtoBuf.Property property2 = part.getProto().getProperty((int)it);
                    Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"part.proto.getProperty(it)");
                    FirPropertySymbol firPropertySymbol = FirMemberDeserializer.loadProperty$default(firMemberDeserializer, property2, null, null, 6, null).getSymbol();
                    collection.add(firPropertySymbol);
                }
                list2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Collection<PackagePartsCacheData> getPackageParts(FqName packageFqName) {
        FirCache $this$getValue$iv = this.packagePartsCache;
        boolean $i$f$getValue = false;
        return (Collection)$this$getValue$iv.getValue(packageFqName, null);
    }

    @Nullable
    protected FirRegularClassSymbol getClass(@NotNull ClassId classId, @Nullable FirDeserializationContext parentContext) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.classCache.getValue(classId, parentContext);
    }

    public static /* synthetic */ FirRegularClassSymbol getClass$default(AbstractFirDeserializedSymbolsProvider abstractFirDeserializedSymbolsProvider, ClassId classId, FirDeserializationContext firDeserializationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getClass");
        }
        if ((n & 2) != 0) {
            firDeserializationContext = null;
        }
        return abstractFirDeserializedSymbolsProvider.getClass(classId, firDeserializationContext);
    }

    private final FirTypeAliasSymbol getTypeAlias(ClassId classId) {
        FqName fqName2 = classId.getRelativeClassName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.relativeClassName");
        if (!FqNamesUtilKt.isOneSegmentFQN(fqName2)) {
            return null;
        }
        FirCache $this$getValue$iv = this.typeAliasCache;
        boolean $i$f$getValue = false;
        return (FirTypeAliasSymbol)$this$getValue$iv.getValue(classId, null);
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CallableId callableId = new CallableId(packageFqName, name);
        FirCache $this$getValue$iv = this.functionCache;
        boolean $i$f$getValue = false;
        CollectionsKt.addAll((Collection)destination, (Iterable)((Iterable)$this$getValue$iv.getValue(callableId, null)));
        $this$getValue$iv = this.propertyCache;
        $i$f$getValue = false;
        CollectionsKt.addAll((Collection)destination, (Iterable)((Iterable)$this$getValue$iv.getValue(callableId, null)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        void $this$getValue$iv;
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        FirCache firCache = this.functionCache;
        CallableId key$iv = new CallableId(packageFqName, name);
        boolean $i$f$getValue = false;
        CollectionsKt.addAll((Collection)destination, (Iterable)((Iterable)$this$getValue$iv.getValue(key$iv, null)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        void $this$getValue$iv;
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        FirCache firCache = this.propertyCache;
        CallableId key$iv = new CallableId(packageFqName, name);
        boolean $i$f$getValue = false;
        CollectionsKt.addAll((Collection)destination, (Iterable)((Iterable)$this$getValue$iv.getValue(key$iv, null)));
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirRegularClassSymbol firRegularClassSymbol = AbstractFirDeserializedSymbolsProvider.getClass$default(this, classId, null, 2, null);
        return firRegularClassSymbol == null ? (FirClassLikeSymbol)this.getTypeAlias(classId) : (FirClassLikeSymbol)firRegularClassSymbol;
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return null;
    }

    public static final /* synthetic */ List access$tryComputePackagePartInfos(AbstractFirDeserializedSymbolsProvider $this, FqName packageFqName) {
        return $this.tryComputePackagePartInfos(packageFqName);
    }

    public static final /* synthetic */ FirTypeAliasSymbol access$findAndDeserializeTypeAlias(AbstractFirDeserializedSymbolsProvider $this, ClassId classId) {
        return $this.findAndDeserializeTypeAlias(classId);
    }

    public static final /* synthetic */ List access$loadFunctionsByCallableId(AbstractFirDeserializedSymbolsProvider $this, CallableId callableId) {
        return $this.loadFunctionsByCallableId(callableId);
    }

    public static final /* synthetic */ List access$loadPropertiesByCallableId(AbstractFirDeserializedSymbolsProvider $this, CallableId callableId) {
        return $this.loadPropertiesByCallableId(callableId);
    }

    public static final /* synthetic */ Pair access$findAndDeserializeClass(AbstractFirDeserializedSymbolsProvider $this, ClassId classId, FirDeserializationContext parentContext) {
        return $this.findAndDeserializeClass(classId, parentContext);
    }

    @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult;", "", "()V", "ClassWithoutMetadata", "Metadata", "ShouldDeserializeViaParent", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult$Metadata;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult$ClassWithoutMetadata;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult$ShouldDeserializeViaParent;", "fir-deserialization"})
    public static abstract class ClassMetadataFindResult {
        private ClassMetadataFindResult() {
        }

        public /* synthetic */ ClassMetadataFindResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00c6\u0003J\u0019\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010H\u00c6\u0003JW\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0018\b\u0002\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult$Metadata;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "annotationDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "containingLibraryPath", "Ljava/nio/file/Path;", "sourceElement", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "classPostProcessor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "", "Lorg/jetbrains/kotlin/fir/deserialization/DeserializedClassPostProcessor;", "(Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;Ljava/nio/file/Path;Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;Lkotlin/jvm/functions/Function1;)V", "getAnnotationDeserializer", "()Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "getClassPostProcessor", "()Lkotlin/jvm/functions/Function1;", "getClassProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "getContainingLibraryPath", "()Ljava/nio/file/Path;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "getSourceElement", "()Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fir-deserialization"})
        public static final class Metadata
        extends ClassMetadataFindResult {
            @NotNull
            private final NameResolver nameResolver;
            @NotNull
            private final ProtoBuf.Class classProto;
            @NotNull
            private final AbstractAnnotationDeserializer annotationDeserializer;
            @Nullable
            private final Path containingLibraryPath;
            @NotNull
            private final DeserializedContainerSource sourceElement;
            @NotNull
            private final Function1<FirRegularClassSymbol, Unit> classPostProcessor;

            public Metadata(@NotNull NameResolver nameResolver2, @NotNull ProtoBuf.Class classProto, @NotNull AbstractAnnotationDeserializer annotationDeserializer, @Nullable Path containingLibraryPath, @NotNull DeserializedContainerSource sourceElement, @NotNull Function1<? super FirRegularClassSymbol, Unit> classPostProcessor) {
                Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
                Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
                Intrinsics.checkNotNullParameter((Object)annotationDeserializer, (String)"annotationDeserializer");
                Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
                Intrinsics.checkNotNullParameter(classPostProcessor, (String)"classPostProcessor");
                super(null);
                this.nameResolver = nameResolver2;
                this.classProto = classProto;
                this.annotationDeserializer = annotationDeserializer;
                this.containingLibraryPath = containingLibraryPath;
                this.sourceElement = sourceElement;
                this.classPostProcessor = classPostProcessor;
            }

            @NotNull
            public final NameResolver getNameResolver() {
                return this.nameResolver;
            }

            @NotNull
            public final ProtoBuf.Class getClassProto() {
                return this.classProto;
            }

            @NotNull
            public final AbstractAnnotationDeserializer getAnnotationDeserializer() {
                return this.annotationDeserializer;
            }

            @Nullable
            public final Path getContainingLibraryPath() {
                return this.containingLibraryPath;
            }

            @NotNull
            public final DeserializedContainerSource getSourceElement() {
                return this.sourceElement;
            }

            @NotNull
            public final Function1<FirRegularClassSymbol, Unit> getClassPostProcessor() {
                return this.classPostProcessor;
            }

            @NotNull
            public final NameResolver component1() {
                return this.nameResolver;
            }

            @NotNull
            public final ProtoBuf.Class component2() {
                return this.classProto;
            }

            @NotNull
            public final AbstractAnnotationDeserializer component3() {
                return this.annotationDeserializer;
            }

            @Nullable
            public final Path component4() {
                return this.containingLibraryPath;
            }

            @NotNull
            public final DeserializedContainerSource component5() {
                return this.sourceElement;
            }

            @NotNull
            public final Function1<FirRegularClassSymbol, Unit> component6() {
                return this.classPostProcessor;
            }

            @NotNull
            public final Metadata copy(@NotNull NameResolver nameResolver2, @NotNull ProtoBuf.Class classProto, @NotNull AbstractAnnotationDeserializer annotationDeserializer, @Nullable Path containingLibraryPath, @NotNull DeserializedContainerSource sourceElement, @NotNull Function1<? super FirRegularClassSymbol, Unit> classPostProcessor) {
                Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
                Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
                Intrinsics.checkNotNullParameter((Object)annotationDeserializer, (String)"annotationDeserializer");
                Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
                Intrinsics.checkNotNullParameter(classPostProcessor, (String)"classPostProcessor");
                return new Metadata(nameResolver2, classProto, annotationDeserializer, containingLibraryPath, sourceElement, classPostProcessor);
            }

            public static /* synthetic */ Metadata copy$default(Metadata metadata, NameResolver nameResolver2, ProtoBuf.Class clazz, AbstractAnnotationDeserializer abstractAnnotationDeserializer, Path path2, DeserializedContainerSource deserializedContainerSource, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    nameResolver2 = metadata.nameResolver;
                }
                if ((n & 2) != 0) {
                    clazz = metadata.classProto;
                }
                if ((n & 4) != 0) {
                    abstractAnnotationDeserializer = metadata.annotationDeserializer;
                }
                if ((n & 8) != 0) {
                    path2 = metadata.containingLibraryPath;
                }
                if ((n & 0x10) != 0) {
                    deserializedContainerSource = metadata.sourceElement;
                }
                if ((n & 0x20) != 0) {
                    function1 = metadata.classPostProcessor;
                }
                return metadata.copy(nameResolver2, clazz, abstractAnnotationDeserializer, path2, deserializedContainerSource, function1);
            }

            @NotNull
            public String toString() {
                return "Metadata(nameResolver=" + this.nameResolver + ", classProto=" + this.classProto + ", annotationDeserializer=" + this.annotationDeserializer + ", containingLibraryPath=" + this.containingLibraryPath + ", sourceElement=" + this.sourceElement + ", classPostProcessor=" + this.classPostProcessor + ')';
            }

            public int hashCode() {
                int result2 = this.nameResolver.hashCode();
                result2 = result2 * 31 + this.classProto.hashCode();
                result2 = result2 * 31 + this.annotationDeserializer.hashCode();
                result2 = result2 * 31 + (this.containingLibraryPath == null ? 0 : ((Object)this.containingLibraryPath).hashCode());
                result2 = result2 * 31 + this.sourceElement.hashCode();
                result2 = result2 * 31 + this.classPostProcessor.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Metadata)) {
                    return false;
                }
                Metadata metadata = (Metadata)other;
                if (!Intrinsics.areEqual((Object)this.nameResolver, (Object)metadata.nameResolver)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.classProto, (Object)metadata.classProto)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.annotationDeserializer, (Object)metadata.annotationDeserializer)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.containingLibraryPath, (Object)metadata.containingLibraryPath)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.sourceElement, (Object)metadata.sourceElement)) {
                    return false;
                }
                return Intrinsics.areEqual(this.classPostProcessor, metadata.classPostProcessor);
            }
        }

        @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult$ClassWithoutMetadata;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "fir-deserialization"})
        public static final class ClassWithoutMetadata
        extends ClassMetadataFindResult {
            @Nullable
            private final FirRegularClassSymbol symbol;

            public ClassWithoutMetadata(@Nullable FirRegularClassSymbol symbol2) {
                super(null);
                this.symbol = symbol2;
            }

            @Nullable
            public final FirRegularClassSymbol getSymbol() {
                return this.symbol;
            }
        }

        @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult$ShouldDeserializeViaParent;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractFirDeserializedSymbolsProvider$ClassMetadataFindResult;", "()V", "fir-deserialization"})
        public static final class ShouldDeserializeViaParent
        extends ClassMetadataFindResult {
            @NotNull
            public static final ShouldDeserializeViaParent INSTANCE = new ShouldDeserializeViaParent();

            private ShouldDeserializeViaParent() {
                super(null);
            }
        }
    }
}

