/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphBuilderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirOverloadsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "JVM_OVERLOADS_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirOverloadsChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirOverloadsChecker INSTANCE = new FirOverloadsChecker();
    @NotNull
    private static final FqName JVM_OVERLOADS_FQ_NAME = new FqName("kotlin.jvm.JvmOverloads");

    private FirOverloadsChecker() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        FirAnnotationCall annotation2;
        block18: {
            FirDeclaration it;
            Object $this$any$iv;
            FirClassLikeSymbol<?> containingDeclaration;
            block21: {
                block20: {
                    boolean bl2;
                    block17: {
                        block19: {
                            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                            FirAnnotationCall firAnnotationCall = FirAnnotationUtilsKt.getAnnotationByFqName(declaration, JVM_OVERLOADS_FQ_NAME);
                            if (firAnnotationCall == null) {
                                return;
                            }
                            annotation2 = firAnnotationCall;
                            FirMemberDeclaration $this$isActual$iv = declaration;
                            boolean $i$f$isActual22 = false;
                            if ($this$isActual$iv.getStatus().isActual()) {
                                return;
                            }
                            containingDeclaration = FirHelpersKt.getContainingClassSymbol(declaration, context2.getSession());
                            FirClassLikeSymbol<?> $i$f$isActual22 = containingDeclaration;
                            if (($i$f$isActual22 == null ? null : FirHelpersKt.getClassKind($i$f$isActual22)) == ClassKind.INTERFACE) {
                                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_INTERFACE(), context2, null, 8, null);
                                return;
                            }
                            FirMemberDeclaration $this$isAbstract$iv = declaration;
                            boolean $i$f$isAbstract = false;
                            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
                                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_ABSTRACT(), context2, null, 8, null);
                                return;
                            }
                            if (!(declaration instanceof FirSimpleFunction)) break block19;
                            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)declaration;
                            boolean $i$f$isLocal = false;
                            if (Intrinsics.areEqual((Object)$this$isLocal$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block20;
                        }
                        $this$any$iv = context2.getContainingDeclarations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            Iterator iterator2 = $this$any$iv.iterator();
                            while (iterator2.hasNext()) {
                                Object element$iv = iterator2.next();
                                it = (FirDeclaration)element$iv;
                                boolean bl3 = false;
                                if (!ControlFlowGraphBuilderKt.isLocalClassOrAnonymousObject(it)) continue;
                                bl2 = true;
                                break block17;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) break block21;
                }
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_LOCAL(), context2, null, 8, null);
                return;
            }
            if (declaration instanceof FirConstructor && (($this$any$iv = containingDeclaration) == null ? null : FirHelpersKt.getClassKind($this$any$iv)) == ClassKind.ANNOTATION_CLASS) {
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR(), context2, null, 8, null);
                return;
            }
            FirMemberDeclaration $this$visibility$iv = declaration;
            boolean $i$f$getVisibility = false;
            if (!$this$visibility$iv.getStatus().getVisibility().isPublicAPI()) {
                $this$visibility$iv = declaration;
                $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Internal.INSTANCE)) {
                    DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_PRIVATE(), context2, null, 8, null);
                    return;
                }
            }
            Iterable $this$none$iv = declaration.getValueParameters();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    if (!(((FirValueParameter)it).getDefaultValue() != null)) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (!bl) return;
        DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_WITHOUT_DEFAULT_ARGUMENTS(), context2, null, 8, null);
    }
}

