/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirTypeParameterSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "()V", "checkLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkPsi", "Lorg/jetbrains/kotlin/fir/FirPsiSourceElement;", "psi", "isApplicable", "", "checkers"})
public final class FirTypeParameterSyntaxChecker
extends FirDeclarationSyntaxChecker<FirTypeParameter, KtTypeParameter> {
    @NotNull
    public static final FirTypeParameterSyntaxChecker INSTANCE = new FirTypeParameterSyntaxChecker();

    private FirTypeParameterSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirTypeParameter element, @NotNull FirSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return element.getBounds().size() >= 2;
    }

    @Override
    public void checkPsi(@NotNull FirTypeParameter element, @NotNull FirPsiSourceElement source, @NotNull KtTypeParameter psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable $this$partition$iv = element.getBounds();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirTypeRef it = (FirTypeRef)element$iv;
            boolean bl = false;
            PsiElement psiElement = FirSourceElementKt.getPsi(it);
            if ((psiElement == null ? null : psiElement.getParent()) instanceof KtTypeConstraint) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List constraint = (List)pair.component1();
        List params = (List)pair.component2();
        if (!((Collection)params).isEmpty() && !((Collection)constraint).isEmpty()) {
            DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)source, FirErrors.INSTANCE.getMISPLACED_TYPE_PARAMETER_CONSTRAINTS(), context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkLightTree(@NotNull FirTypeParameter element, @NotNull FirSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void this_$iv;
        SourceNavigator sourceNavigator;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        SourceNavigator.Companion companion = SourceNavigator.Companion;
        FirElement $this$withNavigator$iv = element;
        boolean $i$f$withNavigator = false;
        SourceNavigator $this$checkLightTree_u24lambda_u2d2 = sourceNavigator = this_$iv.forSource($this$withNavigator$iv.getSource());
        boolean bl = false;
        Iterable $this$partition$iv = element.getBounds();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirTypeRef it = (FirTypeRef)element$iv;
            boolean bl2 = false;
            if ($this$checkLightTree_u24lambda_u2d2.isInTypeConstraint(it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List constraint = (List)pair.component1();
        List params = (List)pair.component2();
        if (!((Collection)params).isEmpty() && !((Collection)constraint).isEmpty()) {
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getMISPLACED_TYPE_PARAMETER_CONSTRAINTS(), context2, null, 8, null);
        }
    }
}

