/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterChecker;", "()V", "classKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkBoundUniqueness", "checkConflictingBounds", "checkDynamicBounds", "checkExtensionFunctionTypeBound", "checkFinalUpperBounds", "containingDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkInconsistentTypeParameterBounds", "checkOnlyOneTypeParameterBound", "checkTypeAliasBound", "isRelated", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "checkers"})
public final class FirTypeParameterBoundsChecker
extends FirDeclarationChecker<FirTypeParameter> {
    @NotNull
    public static final FirTypeParameterBoundsChecker INSTANCE = new FirTypeParameterBoundsChecker();
    @NotNull
    private static final Set<ClassKind> classKinds;

    private FirTypeParameterBoundsChecker() {
    }

    @Override
    public void check(@NotNull FirTypeParameter declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirElement firElement = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (firElement == null) {
            return;
        }
        FirDeclaration containingDeclaration = firElement;
        if (containingDeclaration instanceof FirConstructor) {
            return;
        }
        this.checkFinalUpperBounds(declaration, containingDeclaration, context2, reporter);
        this.checkExtensionFunctionTypeBound(declaration, context2, reporter);
        FirDeclaration $this$safeAs$iv = containingDeclaration;
        boolean $i$f$safeAs = false;
        FirDeclaration firDeclaration = $this$safeAs$iv;
        if (!(firDeclaration instanceof FirMemberDeclaration)) {
            firDeclaration = null;
        }
        if (!((firElement = (FirMemberDeclaration)((Object)firDeclaration)) == null ? false : FirHelpersKt.isInlineOnly((FirMemberDeclaration)firElement))) {
            this.checkOnlyOneTypeParameterBound(declaration, context2, reporter);
        }
        this.checkBoundUniqueness(declaration, context2, reporter);
        this.checkConflictingBounds(declaration, context2, reporter);
        this.checkTypeAliasBound(declaration, containingDeclaration, context2, reporter);
        this.checkDynamicBounds(declaration, context2, reporter);
        this.checkInconsistentTypeParameterBounds(declaration, context2, reporter);
    }

    private final void checkFinalUpperBounds(FirTypeParameter declaration, FirDeclaration containingDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        boolean $i$f$isOverride;
        FirMemberDeclaration $this$isOverride$iv;
        if (containingDeclaration instanceof FirSimpleFunction) {
            $this$isOverride$iv = (FirMemberDeclaration)((Object)containingDeclaration);
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        if (containingDeclaration instanceof FirProperty) {
            $this$isOverride$iv = (FirMemberDeclaration)((Object)containingDeclaration);
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        Iterable $this$forEach$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (FirHelpersKt.canHaveSubtypes(FirTypeUtilsKt.getConeType(bound), context2.getSession())) continue;
            DiagnosticReporterKt.reportOn$default(reporter, bound.getSource(), FirErrors.INSTANCE.getFINAL_UPPER_BOUND(), (Object)FirTypeUtilsKt.getConeType(bound), context2, null, 16, null);
        }
    }

    private final void checkExtensionFunctionTypeBound(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (!TypeUtilsKt.isExtensionFunctionType(bound, context2.getSession())) continue;
            DiagnosticReporterKt.reportOn$default(reporter, bound.getSource(), FirErrors.INSTANCE.getUPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE(), context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeAliasBound(FirTypeParameter declaration, FirDeclaration containingDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        if (containingDeclaration instanceof FirTypeAlias) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = declaration.getBounds();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirTypeRef it = (FirTypeRef)element$iv$iv;
                boolean bl = false;
                FirSourceElement firSourceElement = it.getSource();
                if (!Intrinsics.areEqual((Object)(firSourceElement == null ? null : firSourceElement.getKind()), (Object)FirRealSourceElementKind.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeRef bound = (FirTypeRef)element$iv;
                boolean bl = false;
                DiagnosticReporterKt.reportOn$default(reporter, bound.getSource(), FirErrors.INSTANCE.getBOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED(), context2, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$distinctBy$iv = declaration.getBounds();
        boolean $i$f$distinctBy = false;
        HashSet<ConeKotlinType> set$iv = new HashSet<ConeKotlinType>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            FirTypeRef it = (FirTypeRef)e$iv;
            boolean bl = false;
            ConeKotlinType key$iv = FirTypeUtilsKt.getConeType(it);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List bounds = list$iv;
        Iterable $this$partition$iv = bounds;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        Object second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirTypeRef it = (FirTypeRef)element$iv;
            boolean bl = false;
            if (FirTypeUtilsKt.getConeType(it) instanceof ConeTypeParameterType) {
                first$iv.add(element$iv);
                continue;
            }
            ((ArrayList)second$iv).add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List boundWithParam = (List)pair.component1();
        List otherBounds = (List)pair.component2();
        if (boundWithParam.size() > 1 || boundWithParam.size() == 1 && !((Collection)otherBounds).isEmpty()) {
            FirSourceElement firSourceElement;
            void $this$filterTo$iv$iv;
            Object $this$checkOnlyOneTypeParameterBound_u24lambda_u2d7 = second$iv = SourceNavigator.Companion.forElement(declaration);
            boolean bl = false;
            Iterable $this$filter$iv = bounds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirTypeRef it = (FirTypeRef)element$iv$iv;
                boolean bl2 = false;
                if (!$this$checkOnlyOneTypeParameterBound_u24lambda_u2d7.isInTypeConstraint(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set constraintBounds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (bounds.size() == 2) {
                FirTypeRef boundDecl;
                FirTypeRef firTypeRef = (FirTypeRef)CollectionsKt.firstOrNull((List)otherBounds);
                FirTypeRef firTypeRef2 = boundDecl = firTypeRef == null ? (FirTypeRef)CollectionsKt.last((List)boundWithParam) : firTypeRef;
                firSourceElement = constraintBounds.contains(boundDecl) ? boundDecl.getSource() : declaration.getSource();
            } else {
                firSourceElement = declaration.getSource();
            }
            FirSourceElement reportOn = firSourceElement;
            DiagnosticReporterKt.reportOn$default(reporter, reportOn, FirErrors.INSTANCE.getBOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER(), context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBoundUniqueness(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeRef bound;
        FirTypeRef it;
        void $this$filterTo$iv$iv;
        Set seenClasses = new LinkedHashSet();
        Iterable $this$filter$iv = declaration.getBounds();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirTypeRef)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof FirErrorTypeRef))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allNonErrorBounds = (List)destination$iv$iv;
        Iterable $this$distinctBy$iv = allNonErrorBounds;
        boolean $i$f$distinctBy = false;
        HashSet<Object> set$iv = new HashSet<Object>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            it = (FirTypeRef)e$iv;
            boolean bl = false;
            ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it));
            Object key$iv = classId == null ? FirTypeUtilsKt.getConeType(it) : classId;
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List uniqueBounds = list$iv;
        Iterable $this$forEach$iv = uniqueBounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirRegularClassSymbol firRegularClassSymbol;
            bound = (FirTypeRef)element$iv;
            boolean bl = false;
            FirRegularClassSymbol firRegularClassSymbol2 = FirHelpersKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(bound), context2.getSession());
            if (firRegularClassSymbol2 == null) continue;
            FirRegularClassSymbol symbol2 = firRegularClassSymbol = firRegularClassSymbol2;
            boolean bl2 = false;
            if (!classKinds.contains((Object)symbol2.getClassKind()) || !seenClasses.add(symbol2) || seenClasses.size() <= 1) continue;
            DiagnosticReporterKt.reportOn$default(reporter, bound.getSource(), FirErrors.INSTANCE.getONLY_ONE_CLASS_BOUND_ALLOWED(), context2, null, 8, null);
        }
        $this$forEach$iv = CollectionsKt.minus((Iterable)allNonErrorBounds, (Iterable)uniqueBounds);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            bound = (FirTypeRef)element$iv;
            boolean bl = false;
            DiagnosticReporterKt.reportOn$default(reporter, bound.getSource(), FirErrors.INSTANCE.getREPEATED_BOUND(), context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConflictingBounds(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Collection<ConeKotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (declaration.getBounds().size() < 2) {
            return;
        }
        Iterable iterable = declaration.getBounds();
        CheckerContext checkerContext = context2;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)it);
            collection.add(coneKotlinType);
        }
        collection = (List)destination$iv$iv;
        if (FirTypeParameterBoundsChecker.checkConflictingBounds$anyConflictingTypes(checkerContext, (List<? extends ConeKotlinType>)collection)) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration.getSource(), FirErrors.INSTANCE.getCONFLICTING_UPPER_BOUNDS(), (Object)declaration.getSymbol(), context2, null, 16, null);
        }
    }

    private final void checkDynamicBounds(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration.getBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeRef bound = (FirTypeRef)element$iv;
            boolean bl = false;
            if (!(bound instanceof FirDynamicTypeRef)) continue;
            DiagnosticReporterKt.reportOn$default(reporter, bound.getSource(), FirErrors.INSTANCE.getDYNAMIC_UPPER_BOUND(), context2, null, 8, null);
        }
    }

    private final boolean isRelated(KotlinTypeMarker $this$isRelated, TypeCheckerProviderContext context2, KotlinTypeMarker type2) {
        return FirHelpersKt.isSubtypeOf($this$isRelated, context2, type2) || FirHelpersKt.isSupertypeOf($this$isRelated, context2, type2);
    }

    private final void checkInconsistentTypeParameterBounds(FirTypeParameter declaration, CheckerContext context2, DiagnosticReporter reporter) {
        if (declaration.getBounds().size() <= 1) {
            return;
        }
        List firTypeRefClasses = new ArrayList();
        Set firRegularClassesSet = new LinkedHashSet();
        for (FirTypeRef bound : declaration.getBounds()) {
            FirRegularClassSymbol classSymbol = FirHelpersKt.toRegularClassSymbol(bound, context2.getSession());
            if (CollectionsKt.contains((Iterable)firRegularClassesSet, (Object)classSymbol)) {
                return;
            }
            if (classSymbol == null) continue;
            firRegularClassesSet.add(classSymbol);
            firTypeRefClasses.add(new Pair((Object)bound, (Object)classSymbol));
        }
        FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(firTypeRefClasses, context2, reporter, declaration.getSource(), false);
    }

    private static final boolean checkConflictingBounds$anyConflictingTypes(CheckerContext $context, List<? extends ConeKotlinType> types2) {
        Iterable $this$forEach$iv = types2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeKotlinType type2 = (ConeKotlinType)element$iv;
            boolean bl = false;
            if (FirHelpersKt.canHaveSubtypes(type2, $context.getSession())) continue;
            Iterable $this$forEach$iv2 = types2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConeKotlinType otherType = (ConeKotlinType)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)type2, (Object)otherType) || INSTANCE.isRelated(type2, SessionUtilsKt.getTypeContext($context.getSession()), otherType)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ClassKind[] classKindArray = new ClassKind[]{ClassKind.CLASS, ClassKind.ENUM_CLASS, ClassKind.OBJECT};
        classKinds = SetsKt.setOf((Object[])classKindArray);
    }
}

