/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.metrics;

import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0012\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\nH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "()V", "myBuildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "myBuildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetrics;", "myBuildTimeStartNs", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "", "myBuildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "addAttribute", "", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addMetric", "metric", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "value", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTimeMetric", "time", "durationMs", "endMeasure", "endNs", "getMetrics", "startMeasure", "startNs", "kotlin-build-common"})
public final class BuildMetricsReporterImpl
implements BuildMetricsReporter {
    @NotNull
    private final EnumMap<BuildTime, Long> myBuildTimeStartNs = new EnumMap(BuildTime.class);
    @NotNull
    private final BuildTimes myBuildTimes = new BuildTimes();
    @NotNull
    private final BuildPerformanceMetrics myBuildMetrics = new BuildPerformanceMetrics();
    @NotNull
    private final BuildAttributes myBuildAttributes = new BuildAttributes();

    @Override
    public void startMeasure(@NotNull BuildTime time, long startNs) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Object object2 = object = (Map)this.myBuildTimeStartNs;
        if (object2.containsKey(time)) {
            object = time + " was restarted before it finished";
            throw new IllegalStateException(object.toString());
        }
        object = this.myBuildTimeStartNs;
        object2 = startNs;
        object.put(time, object2);
    }

    @Override
    public void endMeasure(@NotNull BuildTime time, long endNs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Long l = this.myBuildTimeStartNs.remove(time);
        if (l == null) {
            throw new IllegalStateException((time + " finished before it started").toString());
        }
        Long l2 = l;
        long startNs = ((Number)l2).longValue();
        long durationMs = (endNs - startNs) / (long)1000000;
        this.myBuildTimes.add(time, durationMs);
    }

    @Override
    public void addTimeMetric(@NotNull BuildTime time, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.myBuildTimes.add(time, durationMs);
    }

    @Override
    public void addMetric(@NotNull BuildPerformanceMetric metric, long value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.myBuildMetrics.add(metric, value2);
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        BuildAttributes.add$default(this.myBuildAttributes, attribute, 0, 2, null);
    }

    @Override
    @NotNull
    public BuildMetrics getMetrics() {
        return new BuildMetrics(this.myBuildTimes, this.myBuildMetrics, this.myBuildAttributes);
    }

    @Override
    public void addMetrics(@Nullable BuildMetrics metrics) {
        if (metrics == null) {
            return;
        }
        this.myBuildAttributes.addAll(metrics.getBuildAttributes());
        this.myBuildTimes.addAll(metrics.getBuildTimes());
        this.myBuildMetrics.addAll(metrics.getBuildPerformanceMetrics());
    }
}

