/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.SamEqualsHashCodeMethodsGenerator;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLowering;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArguments;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArgumentsBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBlock;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBuilder;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrTypeParameterBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0002GHB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0014H\u0002J\"\u0010%\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0002J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020'H\u0016J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020#H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020-H\u0016J \u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020'H\u0002J \u00103\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020'2\u0006\u00104\u001a\u00020\u00142\u0006\u00100\u001a\u000201H\u0002J\u0018\u00105\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0002J \u00106\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00107\u001a\u0002082\u0006\u00100\u001a\u000201H\u0002J\u0018\u00109\u001a\u00020#2\u0006\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0002J\u001c\u0010:\u001a\u00020\u001e*\u00020;2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020;H\u0002J\u0014\u0010<\u001a\u00020=*\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u001a\u0010A\u001a\u00020B*\u00020>2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020@0DH\u0002J\f\u0010E\u001a\u00020\r*\u00020@H\u0002J\f\u0010F\u001a\u00020\r*\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\r*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "crossinlineLambdas", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lkotlin/collections/HashSet;", "jvmIndyLambdaMetafactoryIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "shouldGenerateIndyLambdas", "", "shouldGenerateIndySamConversions", "specialNullabilityAnnotationsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.jvm.PlatformType", "isIgnored", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)Z", "canGenerateIndySamConversionOnFunctionalExpression", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getDeclarationParentForDelegatingLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "rewriteDirectInvokeToFunctionReference", "irInvokeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "irFunRef", "rewriteDirectInvokeToLambda", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "lastFunRef", "visitBlock", "visitCall", "visitFunctionReference", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "wrapFunctionReferenceInsideBlockWithIndySamConversion", "samType", "lambdaMetafactoryArguments", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArguments;", "block", "wrapLambdaReferenceWithIndySamConversion", "reference", "wrapSamConversionArgumentWithIndySamConversion", "wrapSamDelegatingLambdaWithIndySamConversion", "lambdaBlock", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/SamDelegatingLambdaBlock;", "wrapWithIndySamConversion", "copyReceiverAndValueArgumentsForDirectInvoke", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "irRawFunctionRef", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrRawFunctionReferenceImpl;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "irFun", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irVarargOfRawFunctionRefs", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrVarargImpl;", "irFuns", "", "isInvokeOperator", "isSuspendFunctionReference", "Companion", "FunctionReferenceBuilder", "backend.jvm.lower"})
public final class FunctionReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashSet<IrSimpleFunction> crossinlineLambdas;
    private final boolean shouldGenerateIndySamConversions;
    private final boolean shouldGenerateIndyLambdas;
    @NotNull
    private final IrSimpleFunctionSymbol jvmIndyLambdaMetafactoryIntrinsic;
    @NotNull
    private final Set<FqName> specialNullabilityAnnotationsFqNames;

    public FunctionReferenceLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.crossinlineLambdas = new HashSet();
        this.shouldGenerateIndySamConversions = this.context.getState().getSamConversionsScheme() == JvmClosureGenerationScheme.INDY;
        this.shouldGenerateIndyLambdas = this.context.getState().getLambdasScheme() == JvmClosureGenerationScheme.INDY;
        this.jvmIndyLambdaMetafactoryIntrinsic = this.context.getIr().getSymbols().getIndyLambdaMetafactoryIntrinsic();
        Object[] objectArray = new FqName[]{JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION};
        this.specialNullabilityAnnotationsFqNames = SetsKt.setOf((Object[])objectArray);
    }

    private final boolean isIgnored(IrFunctionReference $this$isIgnored) {
        return !IrTypeUtilsKt.isFunctionOrKFunction($this$isIgnored.getType()) && !this.isSuspendFunctionReference($this$isIgnored) || Intrinsics.areEqual((Object)$this$isIgnored.getOrigin(), (Object)JvmLoweredStatementOrigin.INLINE_LAMBDA.INSTANCE);
    }

    private final boolean isSuspendFunctionReference(IrFunctionReference $this$isSuspendFunctionReference) {
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend($this$isSuspendFunctionReference) && ($this$isSuspendFunctionReference.getOrigin() == null || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE) || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.SUSPEND_CONVERSION.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrFile irFile) {
        void $this$findInlineLambdas$iv;
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrFile irFile2 = irFile;
        JvmBackendContext context$iv = this.context;
        boolean $i$f$findInlineLambdas = false;
        $this$findInlineLambdas$iv.accept(new IrInlineReferenceLocator(context$iv, this){
            final /* synthetic */ JvmBackendContext $context;
            final /* synthetic */ FunctionReferenceLowering this$0;
            {
                this.$context = $context;
                this.this$0 = functionReferenceLowering;
                super($context);
            }

            /*
             * WARNING - void declaration
             */
            public void visitInlineLambda(@NotNull IrFunctionReference argument2, @NotNull IrFunction callee, @NotNull IrValueParameter parameter, @NotNull IrDeclaration scope2) {
                void parameter2;
                Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                IrDeclaration irDeclaration2 = scope2;
                IrValueParameter irValueParameter = parameter;
                IrFunction irFunction2 = callee;
                IrFunctionReference argument3 = argument2;
                boolean bl = false;
                if (parameter2.isCrossinline()) {
                    FunctionReferenceLowering.access$getCrossinlineLambdas$p(this.this$0).add((IrSimpleFunction)((IrFunctionSymbol)argument3.getSymbol()).getOwner());
                }
            }
        }, null);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
        this.crossinlineLambdas.clear();
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        LambdaMetafactoryArguments lambdaMetafactoryArguments;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!IrUtilsKt.isLambda(expression2.getOrigin())) {
            return super.visitBlock(expression2);
        }
        IrFunctionReference reference = (IrFunctionReference)CollectionsKt.last(expression2.getStatements());
        if (this.isIgnored(reference)) {
            return super.visitBlock(expression2);
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast(expression2.getStatements(), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            it.transform(this, null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(reference, this);
        if (this.shouldGenerateIndyLambdas && (lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArgumentsOrNull(reference, reference.getType(), true)) != null) {
            return this.wrapLambdaReferenceWithIndySamConversion(expression2, reference, lambdaMetafactoryArguments);
        }
        return new FunctionReferenceBuilder(reference, null, 2, null).build();
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isInvokeOperator(expression2.getSymbol().getOwner())) {
            IrExpression irExpression;
            IrStatement last;
            IrExpression receiver = expression2.getDispatchReceiver();
            if (receiver instanceof IrFunctionReference) {
                IrExpression irExpression2 = this.rewriteDirectInvokeToFunctionReference(expression2, (IrFunctionReference)receiver);
                if (irExpression2 != null) {
                    IrExpression irExpression3;
                    IrExpression it = irExpression3 = irExpression2;
                    boolean bl = false;
                    this.transformChildrenVoid(it);
                    return it;
                }
            } else if (receiver instanceof IrBlock && (last = (IrStatement)CollectionsKt.last(((IrBlock)receiver).getStatements())) instanceof IrFunctionReference && (irExpression = this.rewriteDirectInvokeToLambda(expression2, (IrBlock)receiver, (IrFunctionReference)last)) != null) {
                IrExpression irExpression4;
                IrExpression it = irExpression4 = irExpression;
                boolean bl = false;
                this.transformChildrenVoid(it);
                return it;
            }
        }
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        return expression2;
    }

    private final boolean isInvokeOperator(IrFunction $this$isInvokeOperator) {
        return Intrinsics.areEqual((Object)$this$isInvokeOperator.getName(), (Object)OperatorNameConventions.INVOKE);
    }

    private final IrExpression rewriteDirectInvokeToLambda(IrCall irInvokeCall, IrBlock irBlock, IrFunctionReference lastFunRef) {
        boolean bl;
        IrFunction callee;
        block5: {
            callee = ((IrFunctionSymbol)lastFunRef.getSymbol()).getOwner();
            if (!Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE) && !AdditionalIrUtilsKt.isAnonymousFunction(callee)) {
                return null;
            }
            Sequence<IrDeclarationParent> $this$any$iv = LocalDeclarationsLoweringKt.getParents(callee);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IrDeclarationParent it = (IrDeclarationParent)element$iv;
                boolean bl2 = false;
                if (!(it instanceof IrSimpleFunction && ((IrSimpleFunction)it).isInline())) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        IrExpression $i$f$any = this.rewriteDirectInvokeToFunctionReference(irInvokeCall, lastFunRef);
        if ($i$f$any == null) {
            return null;
        }
        IrExpression irDirectCall = $i$f$any;
        if (callee instanceof IrFunctionImpl) {
            this.context.getDirectInvokedLambdas().add(((IrFunctionImpl)callee).getAttributeOwnerId());
        }
        IrBlockImpl newBlock = new IrBlockImpl(irBlock.getStartOffset(), irBlock.getEndOffset(), irDirectCall.getType(), null, 8, null);
        newBlock.getStatements().addAll((Collection<IrStatement>)irBlock.getStatements());
        newBlock.getStatements().set(CollectionsKt.getLastIndex(newBlock.getStatements()), irDirectCall);
        return newBlock;
    }

    private final IrExpression rewriteDirectInvokeToFunctionReference(IrCall irInvokeCall, IrFunctionReference irFunRef) {
        IrExpression irExpression;
        IrFunction irFun = ((IrFunctionSymbol)irFunRef.getSymbol()).getOwner();
        if (irFun instanceof IrSimpleFunction) {
            IrCallImpl irCallImpl;
            if (!((Collection)irFun.getTypeParameters()).isEmpty()) {
                return null;
            }
            IrCallImpl $this$rewriteDirectInvokeToFunctionReference_u24lambda_u2d5 = irCallImpl = new IrCallImpl(irInvokeCall.getStartOffset(), irInvokeCall.getEndOffset(), irInvokeCall.getType(), ((IrSimpleFunction)irFun).getSymbol(), irFun.getTypeParameters().size(), irFun.getValueParameters().size(), null, null, 192, null);
            boolean bl = false;
            this.copyReceiverAndValueArgumentsForDirectInvoke($this$rewriteDirectInvokeToFunctionReference_u24lambda_u2d5, irFunRef, irInvokeCall);
            irExpression = irCallImpl;
        } else if (irFun instanceof IrConstructor) {
            IrConstructorCallImpl irConstructorCallImpl;
            IrConstructorCallImpl $this$rewriteDirectInvokeToFunctionReference_u24lambda_u2d6 = irConstructorCallImpl = new IrConstructorCallImpl(irInvokeCall.getStartOffset(), irInvokeCall.getEndOffset(), irInvokeCall.getType(), ((IrConstructor)irFun).getSymbol(), irFun.getTypeParameters().size(), 0, irFun.getValueParameters().size(), null, 128, null);
            boolean bl = false;
            this.copyReceiverAndValueArgumentsForDirectInvoke($this$rewriteDirectInvokeToFunctionReference_u24lambda_u2d6, irFunRef, irInvokeCall);
            irExpression = irConstructorCallImpl;
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Simple function or constructor expected: ", (Object)RenderIrElementKt.render(irFun)));
        }
        return irExpression;
    }

    private final void copyReceiverAndValueArgumentsForDirectInvoke(IrFunctionAccessExpression $this$copyReceiverAndValueArgumentsForDirectInvoke, IrFunctionReference irFunRef, IrFunctionAccessExpression irInvokeCall) {
        int n;
        IrExpression irExpression;
        IrFunction irFun = ((IrFunctionSymbol)irFunRef.getSymbol()).getOwner();
        int invokeArgIndex = 0;
        if (irFun.getDispatchReceiverParameter() != null) {
            IrExpression irExpression2;
            irExpression = irFunRef.getDispatchReceiver();
            if (irExpression == null) {
                n = invokeArgIndex;
                invokeArgIndex = n + 1;
                irExpression2 = irInvokeCall.getValueArgument(n);
            } else {
                irExpression2 = irExpression;
            }
            $this$copyReceiverAndValueArgumentsForDirectInvoke.setDispatchReceiver(irExpression2);
        }
        if (irFun.getExtensionReceiverParameter() != null) {
            IrExpression irExpression3;
            irExpression = irFunRef.getExtensionReceiver();
            if (irExpression == null) {
                n = invokeArgIndex;
                invokeArgIndex = n + 1;
                irExpression3 = irInvokeCall.getValueArgument(n);
            } else {
                irExpression3 = irExpression;
            }
            $this$copyReceiverAndValueArgumentsForDirectInvoke.setExtensionReceiver(irExpression3);
        }
        if (invokeArgIndex + $this$copyReceiverAndValueArgumentsForDirectInvoke.getValueArgumentsCount() != irInvokeCall.getValueArgumentsCount()) {
            throw new AssertionError((Object)("Mismatching value arguments: " + invokeArgIndex + " arguments used for receivers\n" + DumpIrTreeKt.dump$default(irInvokeCall, false, false, 3, null)));
        }
        int n2 = 0;
        n = $this$copyReceiverAndValueArgumentsForDirectInvoke.getValueArgumentsCount();
        while (n2 < n) {
            int i = n2++;
            int n3 = invokeArgIndex;
            invokeArgIndex = n3 + 1;
            $this$copyReceiverAndValueArgumentsForDirectInvoke.putValueArgument(i, irInvokeCall.getValueArgument(n3));
        }
    }

    private final IrBlock wrapLambdaReferenceWithIndySamConversion(IrBlock expression2, IrFunctionReference reference, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall indySamConversion = this.wrapWithIndySamConversion(reference.getType(), lambdaMetafactoryArguments);
        expression2.getStatements().set(expression2.getStatements().size() - 1, indySamConversion);
        expression2.setType(indySamConversion.getType());
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        return this.isIgnored(expression2) ? (IrExpression)expression2 : new FunctionReferenceBuilder(expression2, null, 2, null).build();
    }

    private final IrDeclarationParent getDeclarationParentForDelegatingLambda() {
        for (ScopeWithIr s : CollectionsKt.asReversedMutable(this.getAllScopes())) {
            IrSymbolOwner scopeOwner = s.getScope().getScopeOwnerSymbol().getOwner();
            if (!(scopeOwner instanceof IrDeclarationParent)) continue;
            return (IrDeclarationParent)((Object)scopeOwner);
        }
        throw new AssertionError((Object)Intrinsics.stringPlus((String)"No IrDeclarationParent found in scopes:\n", (Object)CollectionsKt.joinToString$default((Iterable)this.getAllScopes(), (CharSequence)"\n", null, null, (int)0, null, (Function1)getDeclarationParentForDelegatingLambda.1.INSTANCE, (int)30, null)));
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        LambdaMetafactoryArguments lambdaMetafactoryArguments;
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getOperator() != IrTypeOperator.SAM_CONVERSION) {
            return super.visitTypeOperator(expression2);
        }
        IrType samSuperType = expression2.getTypeOperand();
        IrExpression invokable = expression2.getArgument();
        if (invokable instanceof IrFunctionReference) {
            irFunctionReference = (IrFunctionReference)invokable;
        } else if (invokable instanceof IrBlock && IrUtilsKt.isLambda(((IrBlock)invokable).getOrigin()) && CollectionsKt.last(((IrBlock)invokable).getStatements()) instanceof IrFunctionReference) {
            Iterable $this$forEach$iv = CollectionsKt.dropLast(((IrBlock)invokable).getStatements(), (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl = false;
                it.transform(this, null);
            }
            irFunctionReference = (IrFunctionReference)CollectionsKt.last(((IrBlock)invokable).getStatements());
        } else {
            if (this.shouldGenerateIndySamConversions && this.canGenerateIndySamConversionOnFunctionalExpression(samSuperType, invokable)) {
                SamDelegatingLambdaBuilder samDelegatingLambdaBuilder = new SamDelegatingLambdaBuilder(this.context);
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                SamDelegatingLambdaBlock lambdaBlock = samDelegatingLambdaBuilder.build(invokable, samSuperType, scopeWithIr.getScope().getScopeOwnerSymbol(), this.getDeclarationParentForDelegatingLambda());
                LambdaMetafactoryArguments lambdaMetafactoryArguments2 = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArgumentsOrNull(lambdaBlock.getRef(), samSuperType, false);
                if (lambdaMetafactoryArguments2 == null) {
                    return super.visitTypeOperator(expression2);
                }
                LambdaMetafactoryArguments lambdaMetafactoryArguments3 = lambdaMetafactoryArguments2;
                this.transformChildrenVoid(invokable);
                return this.wrapSamDelegatingLambdaWithIndySamConversion(samSuperType, lambdaBlock, lambdaMetafactoryArguments3);
            }
            return super.visitTypeOperator(expression2);
        }
        IrFunctionReference reference = irFunctionReference;
        this.transformChildrenVoid(reference);
        if (this.shouldGenerateIndySamConversions && (lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArgumentsOrNull(reference, samSuperType, false)) != null) {
            return this.wrapSamConversionArgumentWithIndySamConversion(expression2, lambdaMetafactoryArguments);
        }
        IrType erasedSamSuperType = JvmIrUtilsKt.rawType(JvmIrTypeUtilsKt.getErasedUpperBound(samSuperType), this.context);
        return new FunctionReferenceBuilder(reference, erasedSamSuperType).build();
    }

    private final boolean canGenerateIndySamConversionOnFunctionalExpression(IrType samSuperType, IrExpression expression2) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(samSuperType);
        if (irClassSymbol == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Class type expected: ", (Object)RenderIrElementKt.render(samSuperType)));
        }
        IrClassSymbol samClass = irClassSymbol;
        if (!IrUtilsKt.isFromJava((IrDeclaration)samClass.getOwner())) {
            return false;
        }
        return !(expression2 instanceof IrBlock) || !Intrinsics.areEqual((Object)((IrBlock)expression2).getOrigin(), (Object)IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE);
    }

    private final IrExpression wrapSamDelegatingLambdaWithIndySamConversion(IrType samSuperType, SamDelegatingLambdaBlock lambdaBlock, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall indySamConversion = this.wrapWithIndySamConversion(samSuperType, lambdaMetafactoryArguments);
        lambdaBlock.replaceRefWith(indySamConversion);
        return lambdaBlock.getBlock();
    }

    private final IrExpression wrapSamConversionArgumentWithIndySamConversion(IrTypeOperatorCall expression2, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrExpression irExpression;
        IrType samType = expression2.getTypeOperand();
        IrExpression argument2 = expression2.getArgument();
        if (argument2 instanceof IrFunctionReference) {
            irExpression = this.wrapWithIndySamConversion(samType, lambdaMetafactoryArguments);
        } else if (argument2 instanceof IrBlock) {
            irExpression = this.wrapFunctionReferenceInsideBlockWithIndySamConversion(samType, lambdaMetafactoryArguments, (IrBlock)argument2);
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Block or function reference expected: ", (Object)RenderIrElementKt.render(expression2)));
        }
        return irExpression;
    }

    private final IrExpression wrapFunctionReferenceInsideBlockWithIndySamConversion(IrType samType, LambdaMetafactoryArguments lambdaMetafactoryArguments, IrBlock block) {
        IrCall indySamConversion = this.wrapWithIndySamConversion(samType, lambdaMetafactoryArguments);
        block.getStatements().set(block.getStatements().size() - 1, indySamConversion);
        block.setType(indySamConversion.getType());
        return block;
    }

    private final IrCall wrapWithIndySamConversion(IrType samType, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall irCall;
        JvmIrBuilder jvmIrBuilder;
        IrType notNullSamType2 = IrTypesKt.removeAnnotations(IrTypesKt.makeNotNull(samType), (Function1<? super IrConstructorCall, Boolean>)((Function1)new Function1<IrConstructorCall, Boolean>(this){
            final /* synthetic */ FunctionReferenceLowering this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IrConstructorCall it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FunctionReferenceLowering.access$getSpecialNullabilityAnnotationsFqNames$p(this.this$0).contains(IrTypesKt.getClassFqName(it.getType()));
            }
        }));
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        JvmIrBuilder $this$wrapWithIndySamConversion_u24lambda_u2d9 = jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null);
        boolean bl = false;
        IrCall $this$wrapWithIndySamConversion_u24lambda_u2d9_u24lambda_u2d8 = irCall = ExpressionHelpersKt.irCall$default($this$wrapWithIndySamConversion_u24lambda_u2d9, this.jvmIndyLambdaMetafactoryIntrinsic, notNullSamType2, 0, 0, null, 28, null);
        boolean bl2 = false;
        $this$wrapWithIndySamConversion_u24lambda_u2d9_u24lambda_u2d8.putTypeArgument(0, notNullSamType2);
        $this$wrapWithIndySamConversion_u24lambda_u2d9_u24lambda_u2d8.putValueArgument(0, this.irRawFunctionRef($this$wrapWithIndySamConversion_u24lambda_u2d9, lambdaMetafactoryArguments.getSamMethod()));
        $this$wrapWithIndySamConversion_u24lambda_u2d9_u24lambda_u2d8.putValueArgument(1, lambdaMetafactoryArguments.getImplMethodReference());
        $this$wrapWithIndySamConversion_u24lambda_u2d9_u24lambda_u2d8.putValueArgument(2, this.irRawFunctionRef($this$wrapWithIndySamConversion_u24lambda_u2d9, lambdaMetafactoryArguments.getFakeInstanceMethod()));
        $this$wrapWithIndySamConversion_u24lambda_u2d9_u24lambda_u2d8.putValueArgument(3, this.irVarargOfRawFunctionRefs($this$wrapWithIndySamConversion_u24lambda_u2d9, lambdaMetafactoryArguments.getExtraOverriddenMethods()));
        return irCall;
    }

    private final IrRawFunctionReferenceImpl irRawFunctionRef(IrBuilderWithScope $this$irRawFunctionRef, IrFunction irFun) {
        return ExpressionHelpersKt.irRawFunctionReferefence($this$irRawFunctionRef, $this$irRawFunctionRef.getContext().getIrBuiltIns().getAnyType(), irFun.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrVarargImpl irVarargOfRawFunctionRefs(IrBuilderWithScope $this$irVarargOfRawFunctionRefs, List<? extends IrFunction> irFuns) {
        Collection<IrRawFunctionReferenceImpl> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = irFuns;
        IrType irType = $this$irVarargOfRawFunctionRefs.getContext().getIrBuiltIns().getAnyType();
        IrBuilderWithScope irBuilderWithScope = $this$irVarargOfRawFunctionRefs;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrFunction irFunction2 = (IrFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrRawFunctionReferenceImpl irRawFunctionReferenceImpl = this.irRawFunctionRef($this$irVarargOfRawFunctionRefs, (IrFunction)it);
            collection.add(irRawFunctionReferenceImpl);
        }
        collection = (List)destination$iv$iv;
        return ExpressionHelpersKt.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection);
    }

    public static final /* synthetic */ Set access$getSpecialNullabilityAnnotationsFqNames$p(FunctionReferenceLowering $this) {
        return $this.specialNullabilityAnnotationsFqNames;
    }

    public static final /* synthetic */ HashSet access$getCrossinlineLambdas$p(FunctionReferenceLowering $this) {
        return $this.crossinlineLambdas;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010/\u001a\u00020\u0010J\u001a\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020%2\b\b\u0002\u00102\u001a\u00020\u0005H\u0002J\b\u00103\u001a\u000204H\u0002J\u0014\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002060\u000eH\u0002J$\u00107\u001a\b\u0012\u0004\u0012\u0002080\f2\f\u00109\u001a\b\u0012\u0004\u0012\u0002080\f2\u0006\u0010:\u001a\u00020\u0013H\u0002J\u0012\u0010;\u001a\u00020%2\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J)\u0010>\u001a\u00020%2\u0006\u00101\u001a\u00020%2\u0017\u0010?\u001a\u0013\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\u00100@\u00a2\u0006\u0002\bBH\u0002J\b\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020\bH\u0002J\b\u0010G\u001a\u00020\u0019H\u0002J\u0010\u0010H\u001a\u00020\u00192\u0006\u0010I\u001a\u00020%H\u0002J\u0010\u0010J\u001a\u00020\u00192\u0006\u0010I\u001a\u00020%H\u0002J\u0016\u0010K\u001a\u00020L*\u00020%2\b\u0010M\u001a\u0004\u0018\u00010=H\u0002J\f\u0010N\u001a\u00020L*\u00020%H\u0002J-\u0010O\u001a\u00020L*\u00020A2\u0006\u0010P\u001a\u00020\n2\u0017\u0010Q\u001a\u0013\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020\u00100@\u00a2\u0006\u0002\bBH\u0002J\u0016\u0010S\u001a\u00020L*\u00020A2\b\u0010T\u001a\u0004\u0018\u00010UH\u0002J\u0014\u0010V\u001a\u00020\u0010*\u00020A2\u0006\u0010W\u001a\u00020XH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00050(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010+\u001a\u00020,*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder;", "", "irFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "adaptedReferenceOriginalTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "adapteeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "argumentTypes", "", "boundReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "callee", "functionReferenceClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "functionSuperClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getIrFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "isAdaptedReference", "", "isKotlinFunInterface", "isLambda", "needToGenerateSamEqualsHashCodeMethods", "parameterTypes", "receiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "referenceReturnType", "samInterface", "getSamSuperType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "superMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "superType", "typeArgumentsMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "useOptimizedSuperClass", "originalName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/name/Name;", "build", "buildOverride", "superFunction", "newReturnType", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "createFakeBoundReceiverForJvmStaticInObject", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "createFakeFormalTypeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "sourceTypeParameters", "irClass", "createInvokeMethod", "receiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createLegacyMethodOverride", "generator", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "Lkotlin/ExtensionFunctionType;", "getAdaptedCallableReferenceFlags", "", "getFunctionReferenceFlags", "callableReferenceTarget", "hasVarargMappedToElement", "isEqualsFromAny", "f", "isHashCodeFromAny", "createFunctionReferenceInvokeMethod", "", "receiver", "createLambdaInvokeMethod", "generateConstructorCallArguments", "call", "generateBoundReceiver", "Lorg/jetbrains/kotlin/ir/builders/IrBuilder;", "generateSamEqualsHashCodeMethods", "boundReceiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "generateSignature", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "backend.jvm.lower"})
    private final class FunctionReferenceBuilder {
        @NotNull
        private final IrFunctionReference irFunctionReference;
        @Nullable
        private final IrType samSuperType;
        private final boolean isLambda;
        @NotNull
        private final IrFunction callee;
        @Nullable
        private final Pair<IrValueParameter, IrExpression> boundReceiver;
        @NotNull
        private final List<IrType> parameterTypes;
        @NotNull
        private final List<IrType> argumentTypes;
        @NotNull
        private final IrType referenceReturnType;
        @NotNull
        private final Map<IrTypeParameterSymbol, IrType> typeArgumentsMap;
        @NotNull
        private final IrClassSymbol functionSuperClass;
        @NotNull
        private final IrSimpleFunction superMethod;
        private final boolean useOptimizedSuperClass;
        @Nullable
        private final IrFunctionAccessExpression adapteeCall;
        @Nullable
        private final IrFunction adaptedReferenceOriginalTarget;
        private final boolean isAdaptedReference;
        @Nullable
        private final IrClass samInterface;
        private final boolean isKotlinFunInterface;
        private final boolean needToGenerateSamEqualsHashCodeMethods;
        @NotNull
        private final IrType superType;
        @NotNull
        private final IrClass functionReferenceClass;
        @NotNull
        private final IrField receiverField;

        /*
         * WARNING - void declaration
         */
        public FunctionReferenceBuilder(@Nullable IrFunctionReference irFunctionReference, IrType samSuperType) {
            void $this$functionReferenceClass_u24lambda_u2d3;
            void $this$functionReferenceClass_u24lambda_u2d2;
            IrFunction irFunction2;
            IrFunctionAccessExpression irFunctionAccessExpression;
            Object call2;
            Object statement2;
            Object object;
            Object object2;
            void $this$mapTo$iv$iv2;
            Object $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)FunctionReferenceLowering.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)irFunctionReference, (String)"irFunctionReference");
            this.irFunctionReference = irFunctionReference;
            this.samSuperType = samSuperType;
            this.isLambda = IrUtilsKt.isLambda(this.irFunctionReference.getOrigin());
            this.callee = ((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner();
            this.boundReceiver = JvmStaticAnnotationLoweringKt.isJvmStaticInObject(this.callee) ? this.createFakeBoundReceiverForJvmStaticInObject() : (Pair)CollectionsKt.singleOrNull(IrUtilsKt.getArgumentsWithIr(this.irFunctionReference));
            Object object3 = ((IrSimpleType)this.irFunctionReference.getType()).getArguments();
            FunctionReferenceBuilder functionReferenceBuilder = this;
            boolean $i$f$map22 = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                object2 = (IrTypeArgument)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                IrType irType = ((IrTypeProjection)it).getType();
                object.add(irType);
            }
            object = (List)destination$iv$iv;
            functionReferenceBuilder.parameterTypes = object;
            this.argumentTypes = CollectionsKt.dropLast(this.parameterTypes, (int)1);
            this.referenceReturnType = (IrType)CollectionsKt.last(this.parameterTypes);
            this.typeArgumentsMap = IrUtilsKt.getTypeSubstitutionMap(this.irFunctionReference);
            IrType $i$f$map22 = this.samSuperType;
            Object object4 = $this$map$iv = $i$f$map22 == null ? null : IrTypesKt.getClassOrNull($i$f$map22);
            this.functionSuperClass = $this$map$iv == null ? (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(this.irFunctionReference) ? FunctionReferenceLowering.this.context.getIr().getSymbols().getJvmSuspendFunctionClass(this.argumentTypes.size()) : FunctionReferenceLowering.this.context.getIr().getSymbols().getJvmFunctionClass(this.argumentTypes.size())) : $this$map$iv;
            $this$map$iv = JvmIrUtilsKt.getSingleAbstractMethod((IrClass)this.functionSuperClass.getOwner());
            if ($this$map$iv == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Not a SAM class: ", (Object)RenderIrElementKt.render(this.functionSuperClass.getOwner())));
            }
            this.superMethod = $this$map$iv;
            this.useOptimizedSuperClass = FunctionReferenceLowering.this.context.getState().getGenerateOptimizedCallableReferenceSuperClasses();
            if (Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.ADAPTER_FOR_CALLABLE_REFERENCE.INSTANCE)) {
                Object object5;
                IrBody irBody = this.callee.getBody();
                Intrinsics.checkNotNull((Object)irBody);
                statement2 = (IrStatement)CollectionsKt.single(IrUtilsKt.getStatements(irBody));
                if (statement2 instanceof IrTypeOperatorCall) {
                    boolean $this$mapTo$iv$iv2;
                    boolean bl = $this$mapTo$iv$iv2 = ((IrTypeOperatorCall)statement2).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                    if (_Assertions.ENABLED && !$this$mapTo$iv$iv2) {
                        functionReferenceBuilder = this;
                        boolean $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22 = false;
                        object = Intrinsics.stringPlus((String)"Unexpected type operator in ADAPTER_FOR_CALLABLE_REFERENCE: ", (Object)RenderIrElementKt.render(this.callee));
                        FunctionReferenceBuilder functionReferenceBuilder2 = functionReferenceBuilder;
                        Object $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22 = object;
                        throw new AssertionError($i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22);
                    }
                    object5 = ((IrTypeOperatorCall)statement2).getArgument();
                } else {
                    object5 = call2 = statement2 instanceof IrReturn ? (IrStatement)((IrReturn)statement2).getValue() : statement2;
                }
                if (!(call2 instanceof IrFunctionAccessExpression)) {
                    throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unknown structure of ADAPTER_FOR_CALLABLE_REFERENCE: ", (Object)RenderIrElementKt.render(this.callee)));
                }
                irFunctionAccessExpression = (IrFunctionAccessExpression)call2;
            } else {
                irFunctionAccessExpression = null;
            }
            this.adapteeCall = irFunctionAccessExpression;
            call2 = this.adapteeCall;
            if (call2 == null) {
                irFunction2 = null;
            } else {
                statement2 = (IrFunctionSymbol)((IrMemberAccessExpression)call2).getSymbol();
                irFunction2 = statement2.getOwner();
            }
            this.adaptedReferenceOriginalTarget = irFunction2;
            this.isAdaptedReference = this.adaptedReferenceOriginalTarget != null;
            call2 = this.samSuperType;
            this.samInterface = call2 == null ? null : IrTypesKt.getClass((IrType)call2);
            this.isKotlinFunInterface = this.samInterface != null && !IrUtilsKt.isFromJava(this.samInterface);
            this.needToGenerateSamEqualsHashCodeMethods = this.isKotlinFunInterface && (this.isAdaptedReference || !this.isLambda);
            call2 = this.samSuperType;
            this.superType = call2 == null ? IrTypesKt.getDefaultType(this.isLambda ? FunctionReferenceLowering.this.context.getIr().getSymbols().getLambdaClass() : (this.useOptimizedSuperClass ? (this.isAdaptedReference ? FunctionReferenceLowering.this.context.getIr().getSymbols().getAdaptedFunctionReference() : FunctionReferenceLowering.this.context.getIr().getSymbols().getFunctionReferenceImpl()) : FunctionReferenceLowering.this.context.getIr().getSymbols().getFunctionReference())) : call2;
            IrFactory $this$buildClass$iv = FunctionReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildClass = false;
            Object $this$mapTo$iv$iv2 = new IrClassBuilder();
            IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = $this$mapTo$iv$iv2;
            boolean bl = false;
            IrClassBuilder irClassBuilder = $this$buildClass_u24lambda_u2d1$iv;
            functionReferenceBuilder = this;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$functionReferenceClass_u24lambda_u2d2, this.getIrFunctionReference());
            object2 = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"LOCAL");
            $this$functionReferenceClass_u24lambda_u2d2.setVisibility((DescriptorVisibility)object2);
            $this$functionReferenceClass_u24lambda_u2d2.setOrigin(this.isLambda ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE);
            $this$functionReferenceClass_u24lambda_u2d2.setName(SpecialNames.NO_NAME_PROVIDED);
            object = Unit.INSTANCE;
            object3 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
            FunctionReferenceLowering functionReferenceLowering = FunctionReferenceLowering.this;
            $this$mapTo$iv$iv2 = object3;
            boolean bl3 = false;
            Object[] objectArray = functionReferenceLowering.getCurrentDeclarationParent();
            if (objectArray == null) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"No current declaration parent at ", (Object)DumpIrTreeKt.dump$default(this.getIrFunctionReference(), false, false, 3, null)).toString());
            }
            $this$functionReferenceClass_u24lambda_u2d3.setParent((IrDeclarationParent)objectArray);
            objectArray = new IrType[]{this.superType, this.getSamSuperType() == null ? IrTypesKt.typeWith((IrClassifierSymbol)this.functionSuperClass, this.parameterTypes) : null, org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(this.getIrFunctionReference()) ? IrTypesKt.getDefaultType(functionReferenceLowering.context.getIr().getSymbols().getSuspendFunctionInterface()) : null, this.needToGenerateSamEqualsHashCodeMethods ? IrTypesKt.getDefaultType(functionReferenceLowering.context.getIr().getSymbols().getFunctionAdapter()) : null};
            $this$functionReferenceClass_u24lambda_u2d3.setSuperTypes(CollectionsKt.listOfNotNull((Object[])objectArray));
            if (this.samInterface != null && Intrinsics.areEqual((Object)$this$functionReferenceClass_u24lambda_u2d3.getOrigin(), (Object)JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE)) {
                $this$functionReferenceClass_u24lambda_u2d3.setTypeParameters(this.createFakeFormalTypeParameters(this.samInterface.getTypeParameters(), (IrClass)$this$functionReferenceClass_u24lambda_u2d3));
            }
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$functionReferenceClass_u24lambda_u2d3);
            IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$functionReferenceClass_u24lambda_u2d3, this.getIrFunctionReference());
            if (this.isLambda) {
                $this$functionReferenceClass_u24lambda_u2d3.setMetadata(((IrFunctionSymbol)this.getIrFunctionReference().getSymbol()).getOwner().getMetadata());
            }
            object = Unit.INSTANCE;
            functionReferenceBuilder.functionReferenceClass = object3;
            this.receiverField = (IrField)FunctionReferenceLowering.this.context.getIr().getSymbols().getFunctionReferenceReceiverField().getOwner();
        }

        public /* synthetic */ FunctionReferenceBuilder(IrFunctionReference irFunctionReference, IrType irType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irType = null;
            }
            this(irFunctionReference, irType);
        }

        @NotNull
        public final IrFunctionReference getIrFunctionReference() {
            return this.irFunctionReference;
        }

        @Nullable
        public final IrType getSamSuperType() {
            return this.samSuperType;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrTypeParameter> createFakeFormalTypeParameters(List<? extends IrTypeParameter> sourceTypeParameters, IrClass irClass2) {
            Object object;
            Object object2;
            Object $this$buildTypeParameter_u24lambda_u2d36$iv;
            Object object3;
            void $this$mapTo$iv$iv;
            if (sourceTypeParameters.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = sourceTypeParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                boolean $i$f$buildTypeParameter = false;
                IrTypeParameterBuilder irTypeParameterBuilder = new IrTypeParameterBuilder();
                $this$buildTypeParameter_u24lambda_u2d36$iv = irTypeParameterBuilder;
                boolean bl2 = false;
                IrTypeParameterBuilder $this$createFakeFormalTypeParameters_u24lambda_u2d5_u24lambda_u2d4 = $this$buildTypeParameter_u24lambda_u2d36$iv;
                boolean bl3 = false;
                $this$createFakeFormalTypeParameters_u24lambda_u2d5_u24lambda_u2d4.updateFrom((IrTypeParameter)it);
                $this$createFakeFormalTypeParameters_u24lambda_u2d5_u24lambda_u2d4.setName(it.getName());
                object2 = DeclarationBuildersKt.buildTypeParameter(((IrTypeParametersContainer)irClass2).getFactory(), (IrTypeParameterBuilder)$this$buildTypeParameter_u24lambda_u2d36$iv, irClass2);
                object3.add(object2);
            }
            List fakeTypeParameters = (List)destination$iv$iv;
            Iterable $this$associateWith$iv = sourceTypeParameters;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                IrTypeParameter bl = (IrTypeParameter)element$iv$iv;
                Object e = element$iv$iv;
                object = result$iv;
                boolean bl4 = false;
                IrTypeParameter irTypeParameter3 = (IrTypeParameter)fakeTypeParameters.get(it.getIndex());
                object.put(e, irTypeParameter3);
            }
            object = result$iv;
            Map map = object;
            IrTypeParameterRemapper typeRemapper = new IrTypeParameterRemapper(map);
            for (IrTypeParameter fakeTypeParameter : fakeTypeParameters) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object item$iv$iv;
                IrTypeParameter sourceTypeParameter = sourceTypeParameters.get(fakeTypeParameter.getIndex());
                $this$associateWithTo$iv$iv = sourceTypeParameter.getSuperTypes();
                object3 = fakeTypeParameter;
                boolean $i$f$map2 = false;
                item$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    $this$buildTypeParameter_u24lambda_u2d36$iv = (IrType)item$iv$iv2;
                    object2 = destination$iv$iv2;
                    boolean bl = false;
                    object = typeRemapper.remapType((IrType)it);
                    object2.add(object);
                }
                object2 = (List)destination$iv$iv2;
                ((IrTypeParameter)object3).setSuperTypes((List<? extends IrType>)object2);
            }
            return fakeTypeParameters;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression build() {
            void $this$build_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8;
            IrConstructorCall irConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock_u24default$iv;
            JvmIrBuilder jvmIrBuilder;
            JvmBackendContext jvmBackendContext = FunctionReferenceLowering.this.context;
            ScopeWithIr scopeWithIr = FunctionReferenceLowering.this.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            JvmIrBuilder $this$build_u24lambda_u2d10 = jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(jvmBackendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null);
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$build_u24lambda_u2d10;
            int n = this.getIrFunctionReference().getStartOffset();
            int endOffset$iv = this.getIrFunctionReference().getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$build_u24lambda_u2d10_u24lambda_u2d9 = this_$iv$iv;
            boolean bl2 = false;
            IrConstructor constructor2 = this.createConstructor();
            IrVariable boundReceiverVar = this.getSamSuperType() != null && this.boundReceiver != null ? ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$build_u24lambda_u2d10_u24lambda_u2d9, (IrExpression)this.boundReceiver.getSecond(), null, null, false, 14, null) : null;
            this.createInvokeMethod(boundReceiverVar);
            if (!this.isLambda && this.getSamSuperType() == null && !this.useOptimizedSuperClass) {
                this.createLegacyMethodOverride((IrSimpleFunction)$this$build_u24lambda_u2d10.getIrSymbols().getFunctionReferenceGetSignature().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>(this){
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)$this$createLegacyMethodOverride, (String)"$this$createLegacyMethodOverride");
                        return FunctionReferenceBuilder.access$generateSignature(this.this$0, $this$createLegacyMethodOverride, FunctionReferenceBuilder.access$getCallee$p(this.this$0).getSymbol());
                    }
                }));
                this.createLegacyMethodOverride((IrSimpleFunction)$this$build_u24lambda_u2d10.getIrSymbols().getFunctionReferenceGetName().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>(this){
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)$this$createLegacyMethodOverride, (String)"$this$createLegacyMethodOverride");
                        IrBuilderWithScope irBuilderWithScope = $this$createLegacyMethodOverride;
                        String string2 = FunctionReferenceBuilder.access$getOriginalName(this.this$0, FunctionReferenceBuilder.access$getCallee$p(this.this$0)).asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"callee.originalName.asString()");
                        return ExpressionHelpersKt.irString(irBuilderWithScope, string2);
                    }
                }));
                this.createLegacyMethodOverride((IrSimpleFunction)$this$build_u24lambda_u2d10.getIrSymbols().getFunctionReferenceGetOwner().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>(this){
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)$this$createLegacyMethodOverride, (String)"$this$createLegacyMethodOverride");
                        return FunctionReferenceLowering.Companion.calculateOwner$backend_jvm_lower($this$createLegacyMethodOverride, FunctionReferenceBuilder.access$getCallee$p(this.this$0).getParent());
                    }
                }));
            }
            if (this.needToGenerateSamEqualsHashCodeMethods) {
                this.generateSamEqualsHashCodeMethods($this$build_u24lambda_u2d10, boundReceiverVar);
            }
            if (this.isKotlinFunInterface) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.addFakeOverrides$default(this.functionReferenceClass, $this$build_u24lambda_u2d10.getBackendContext().getTypeSystem(), null, 2, null);
            }
            $this$build_u24lambda_u2d10_u24lambda_u2d9.unaryPlus(this.functionReferenceClass);
            IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$build_u24lambda_u2d10_u24lambda_u2d9, constructor2.getSymbol());
            void var18_18 = $this$build_u24lambda_u2d10_u24lambda_u2d9;
            boolean bl3 = false;
            if ($this$build_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8.getValueArgumentsCount() > 0) {
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                Intrinsics.checkNotNull(pair);
                $this$build_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8.putValueArgument(0, (IrExpression)pair.getSecond());
            }
            Unit unit2 = Unit.INSTANCE;
            var18_18.unaryPlus(irConstructorCall);
            return this_$iv$iv.doBuild();
        }

        private final void generateSamEqualsHashCodeMethods(JvmIrBuilder $this$generateSamEqualsHashCodeMethods, IrVariable boundReceiverVar) {
            IrAnnotationContainer irAnnotationContainer = this.samSuperType;
            if (irAnnotationContainer == null) {
                boolean $i$a$-checkNotNull-FunctionReferenceLowering$FunctionReferenceBuilder$generateSamEqualsHashCodeMethods$22 = false;
                String $i$a$-checkNotNull-FunctionReferenceLowering$FunctionReferenceBuilder$generateSamEqualsHashCodeMethods$22 = Intrinsics.stringPlus((String)"equals/hashCode can only be generated for fun interface wrappers: ", (Object)RenderIrElementKt.render(this.callee));
                throw new IllegalStateException($i$a$-checkNotNull-FunctionReferenceLowering$FunctionReferenceBuilder$generateSamEqualsHashCodeMethods$22.toString());
            }
            if (!this.useOptimizedSuperClass) {
                IrSimpleFunctionSymbol it;
                Sequence<IrSimpleFunctionSymbol> $this$single$iv;
                IrAnnotationContainer $this$generateSamEqualsHashCodeMethods_u24lambda_u2d13 = irAnnotationContainer = DeclarationBuildersKt.addFunction$default(this.functionReferenceClass, "equals", $this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getBooleanType(), Modality.ABSTRACT, null, false, false, false, null, 0, 0, 1016, null);
                boolean bl = false;
                DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$generateSamEqualsHashCodeMethods_u24lambda_u2d13, "other", $this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getAnyNType(), null, 4, null);
                Sequence<IrSimpleFunctionSymbol> sequence2 = IrUtilsKt.getFunctions(this.functionSuperClass);
                IrAnnotationContainer irAnnotationContainer2 = $this$generateSamEqualsHashCodeMethods_u24lambda_u2d13;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl2 = false;
                    if (!this.isEqualsFromAny((IrSimpleFunction)it.getOwner())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                Object var15_17 = single$iv;
                irAnnotationContainer2.setOverriddenSymbols(CollectionsKt.listOf(var15_17));
                IrAnnotationContainer $this$generateSamEqualsHashCodeMethods_u24lambda_u2d15 = irAnnotationContainer = DeclarationBuildersKt.addFunction$default(this.functionReferenceClass, "hashCode", $this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getIntType(), Modality.ABSTRACT, null, false, false, false, null, 0, 0, 1016, null);
                boolean bl3 = false;
                $this$single$iv = IrUtilsKt.getFunctions(this.functionSuperClass);
                irAnnotationContainer2 = $this$generateSamEqualsHashCodeMethods_u24lambda_u2d15;
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl4 = false;
                    if (!this.isHashCodeFromAny((IrSimpleFunction)it.getOwner())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                var15_17 = single$iv;
                irAnnotationContainer2.setOverriddenSymbols(CollectionsKt.listOf(var15_17));
                return;
            }
            new SamEqualsHashCodeMethodsGenerator($this$generateSamEqualsHashCodeMethods.getBackendContext(), this.functionReferenceClass, this.samSuperType, (Function2<? super IrBuilderWithScope, ? super IrExpression, ? extends IrExpression>)((Function2)new Function2<IrBuilderWithScope, IrExpression, IrExpression>(this, $this$generateSamEqualsHashCodeMethods, boundReceiverVar){
                final /* synthetic */ FunctionReferenceBuilder this$0;
                final /* synthetic */ JvmIrBuilder $this_generateSamEqualsHashCodeMethods;
                final /* synthetic */ IrVariable $boundReceiverVar;
                {
                    this.this$0 = $receiver;
                    this.$this_generateSamEqualsHashCodeMethods = $receiver2;
                    this.$boundReceiverVar = $boundReceiverVar;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final IrExpression invoke(@NotNull IrBuilderWithScope $this$$receiver, @NotNull IrExpression it) {
                    void $this$single$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IrClassSymbol internalClass = FunctionReferenceBuilder.access$isAdaptedReference$p(this.this$0) ? this.$this_generateSamEqualsHashCodeMethods.getBackendContext().getIr().getSymbols().getAdaptedFunctionReference() : this.$this_generateSamEqualsHashCodeMethods.getBackendContext().getIr().getSymbols().getFunctionReferenceImpl();
                    Object object = IrUtilsKt.getConstructors((IrClass)internalClass.getOwner());
                    FunctionReferenceBuilder functionReferenceBuilder = this.this$0;
                    boolean $i$f$single = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (E element$iv : $this$single$iv) {
                        IrConstructor it2 = (IrConstructor)element$iv;
                        boolean bl = false;
                        if (!(it2.getValueParameters().size() == 1 + (FunctionReferenceBuilder.access$getBoundReceiver$p(functionReferenceBuilder) != null ? 1 : 0) + 4)) continue;
                        if (found$iv) {
                            throw new IllegalArgumentException("Sequence contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    IrConstructor constructor2 = single$iv;
                    object = ExpressionHelpersKt.irCallConstructor($this$$receiver, constructor2.getSymbol(), CollectionsKt.emptyList());
                    functionReferenceBuilder = this.this$0;
                    JvmIrBuilder jvmIrBuilder = this.$this_generateSamEqualsHashCodeMethods;
                    IrVariable irVariable2 = this.$boundReceiverVar;
                    Object $this$invoke_u24lambda_u2d1 = object;
                    boolean bl = false;
                    FunctionReferenceBuilder.access$generateConstructorCallArguments(functionReferenceBuilder, jvmIrBuilder, (IrFunctionAccessExpression)$this$invoke_u24lambda_u2d1, (Function1)new Function1<IrBuilder, IrExpression>($this$$receiver, irVariable2){
                        final /* synthetic */ IrBuilderWithScope $this_$receiver;
                        final /* synthetic */ IrVariable $boundReceiverVar;
                        {
                            this.$this_$receiver = $this_$receiver;
                            this.$boundReceiverVar = $boundReceiverVar;
                            super(1);
                        }

                        @NotNull
                        public final IrExpression invoke(@NotNull IrBuilder $this$generateConstructorCallArguments) {
                            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
                            IrVariable irVariable2 = this.$boundReceiverVar;
                            Intrinsics.checkNotNull((Object)irVariable2);
                            return ExpressionHelpersKt.irGet(this.$this_$receiver, irVariable2);
                        }
                    });
                    return (IrExpression)object;
                }
            })).generate();
        }

        private final boolean isEqualsFromAny(IrSimpleFunction f) {
            IrType irType;
            IrValueParameter irValueParameter;
            return Intrinsics.areEqual((Object)f.getName().asString(), (Object)"equals") && f.getExtensionReceiverParameter() == null && ((irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(f.getValueParameters())) == null ? false : IrTypePredicatesKt.isNullableAny(irType = irValueParameter.getType()));
        }

        private final boolean isHashCodeFromAny(IrSimpleFunction f) {
            return Intrinsics.areEqual((Object)f.getName().asString(), (Object)"hashCode") && f.getExtensionReceiverParameter() == null && f.getValueParameters().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor() {
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            void $this$createConstructor_u24lambda_u2d21_u24lambda_u2d20;
            Object it;
            int found$iv;
            IrBuilderWithScope single$iv;
            Object $this$single$iv;
            IrConstructor irConstructor2;
            IrFunctionBuilder irFunctionBuilder;
            IrClass $this$addConstructor$iv = this.functionReferenceClass;
            boolean $i$f$addConstructor = false;
            Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv$iv = irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u2d21$iv = $this$buildConstructor_u24lambda_u2d20$iv$iv;
            boolean bl2 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u2d16 = $this$addConstructor_u24lambda_u2d21$iv;
            boolean bl3 = false;
            $this$createConstructor_u24lambda_u2d16.setOrigin(JvmLoweredDeclarationOrigin.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$createConstructor_u24lambda_u2d16.setReturnType(IrUtilsKt.getDefaultType(this.functionReferenceClass));
            $this$createConstructor_u24lambda_u2d16.setPrimary(true);
            $this$addConstructor_u24lambda_u2d21$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2d20$iv$iv);
            boolean bl4 = false;
            $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
            constructor$iv.setParent($this$addConstructor$iv);
            Object object = $this$buildConstructor$iv$iv;
            FunctionReferenceLowering functionReferenceLowering = FunctionReferenceLowering.this;
            Object $this$createConstructor_u24lambda_u2d21 = object;
            boolean bl5 = false;
            if (this.getSamSuperType() == null && this.boundReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$createConstructor_u24lambda_u2d21, "receiver", functionReferenceLowering.context.getIrBuiltIns().getAnyNType(), null, 4, null);
            }
            if (this.getSamSuperType() != null) {
                irConstructor2 = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)functionReferenceLowering.context.getIrBuiltIns().getAnyClass().getOwner()));
            } else {
                int expectedArity = this.isLambda && !this.isAdaptedReference ? 1 : 1 + (this.boundReceiver != null ? 1 : 0) + (this.useOptimizedSuperClass ? 4 : 0);
                IrClass irClass2 = IrTypesKt.getClass(this.superType);
                Intrinsics.checkNotNull((Object)irClass2);
                $this$single$iv = IrUtilsKt.getConstructors(irClass2);
                boolean $i$f$single = false;
                single$iv = null;
                found$iv = 0;
                for (Object element$iv : $this$single$iv) {
                    it = (IrConstructor)element$iv;
                    boolean bl6 = false;
                    if (!(((IrFunction)it).getValueParameters().size() == expectedArity)) continue;
                    if (found$iv != 0) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = 1;
                }
                if (found$iv == 0) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                irConstructor2 = (IrConstructor)((Object)single$iv);
            }
            IrConstructor constructor2 = irConstructor2;
            JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(functionReferenceLowering.context, ((IrConstructor)$this$createConstructor_u24lambda_u2d21).getSymbol(), 0, 0, 6, null);
            $this$single$iv = jvmIrBuilder;
            Object object2 = $this$createConstructor_u24lambda_u2d21;
            boolean bl7 = false;
            single$iv = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2d21_u24lambda_u2d20;
            found$iv = $this$createConstructor_u24lambda_u2d21_u24lambda_u2d20.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u2d21_u24lambda_u2d20.getEndOffset();
            boolean $i$f$irBlockBody = false;
            it = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$createConstructor_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19 = this_$iv$iv;
            boolean bl8 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$createConstructor_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19, constructor2);
            void var20_27 = $this$createConstructor_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19;
            boolean bl9 = false;
            if (this.getSamSuperType() == null) {
                void call2;
                this.generateConstructorCallArguments((JvmIrBuilder)$this$createConstructor_u24lambda_u2d21_u24lambda_u2d20, (IrFunctionAccessExpression)call2, (Function1<? super IrBuilder, ? extends IrExpression>)((Function1)new Function1<IrBuilder, IrExpression>((IrBlockBodyBuilder)$this$createConstructor_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19, (IrConstructor)$this$createConstructor_u24lambda_u2d21){
                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                    final /* synthetic */ IrConstructor $this_apply;
                    {
                        this.$this_irBlockBody = $receiver;
                        this.$this_apply = $receiver2;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull IrBuilder $this$generateConstructorCallArguments) {
                        Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
                        return ExpressionHelpersKt.irGet(this.$this_irBlockBody, (IrValueDeclaration)CollectionsKt.first(this.$this_apply.getValueParameters()));
                    }
                }));
            }
            Unit unit2 = Unit.INSTANCE;
            var20_27.unaryPlus(irDelegatingConstructorCall);
            $this$createConstructor_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19.unaryPlus(new IrInstanceInitializerCallImpl($this$createConstructor_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19.getStartOffset(), $this$createConstructor_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19.getEndOffset(), this.functionReferenceClass.getSymbol(), $this$createConstructor_u24lambda_u2d21_u24lambda_u2d20_u24lambda_u2d19.getContext().getIrBuiltIns().getUnitType()));
            IrBlockBody irBlockBody = this_$iv$iv.doBuild();
            ((IrFunction)object2).setBody(irBlockBody);
            return object;
        }

        private final void generateConstructorCallArguments(JvmIrBuilder $this$generateConstructorCallArguments, IrFunctionAccessExpression call2, Function1<? super IrBuilder, ? extends IrExpression> generateBoundReceiver) {
            int index2;
            int n = index2 = 0;
            index2 = n + 1;
            call2.putValueArgument(n, ExpressionHelpersKt.irInt$default($this$generateConstructorCallArguments, this.argumentTypes.size() + (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(this.irFunctionReference) ? 1 : 0), null, 2, null));
            if (this.boundReceiver != null) {
                n = index2;
                index2 = n + 1;
                call2.putValueArgument(n, (IrExpression)generateBoundReceiver.invoke((Object)$this$generateConstructorCallArguments));
            }
            if (!this.isLambda && this.useOptimizedSuperClass) {
                IrFunction irFunction2 = this.adaptedReferenceOriginalTarget;
                IrFunction callableReferenceTarget = irFunction2 == null ? this.callee : irFunction2;
                IrExpression owner = Companion.calculateOwnerKClass$backend_jvm_lower($this$generateConstructorCallArguments, callableReferenceTarget.getParent());
                int n2 = index2;
                index2 = n2 + 1;
                call2.putValueArgument(n2, JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, owner));
                n2 = index2;
                index2 = n2 + 1;
                IrBuilderWithScope irBuilderWithScope = $this$generateConstructorCallArguments;
                String string2 = this.getOriginalName(callableReferenceTarget).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"callableReferenceTarget.originalName.asString()");
                call2.putValueArgument(n2, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
                int n3 = index2;
                index2 = n3 + 1;
                call2.putValueArgument(n3, this.generateSignature($this$generateConstructorCallArguments, callableReferenceTarget.getSymbol()));
                call2.putValueArgument(index2, ExpressionHelpersKt.irInt$default($this$generateConstructorCallArguments, this.getFunctionReferenceFlags(callableReferenceTarget), null, 2, null));
            }
        }

        private final int getFunctionReferenceFlags(IrFunction callableReferenceTarget) {
            int isTopLevelBit = JvmIrUtilsKt.getCallableReferenceTopLevelFlag(callableReferenceTarget);
            int adaptedCallableReferenceFlags = this.getAdaptedCallableReferenceFlags();
            return isTopLevelBit + (adaptedCallableReferenceFlags << 1);
        }

        private final int getAdaptedCallableReferenceFlags() {
            if (this.adaptedReferenceOriginalTarget == null) {
                return 0;
            }
            int isVarargMappedToElementBit = this.hasVarargMappedToElement() ? 1 : 0;
            int isSuspendConvertedBit = !AdditionalIrUtilsKt.isSuspend(this.adaptedReferenceOriginalTarget) && AdditionalIrUtilsKt.isSuspend(this.callee) ? 1 : 0;
            int isCoercedToUnitBit = !IrTypePredicatesKt.isUnit(this.adaptedReferenceOriginalTarget.getReturnType()) && IrTypePredicatesKt.isUnit(this.callee.getReturnType()) ? 1 : 0;
            return isVarargMappedToElementBit + (isSuspendConvertedBit << 1) + (isCoercedToUnitBit << 2);
        }

        private final boolean hasVarargMappedToElement() {
            if (this.adapteeCall == null) {
                return false;
            }
            int n = 0;
            int n2 = this.adapteeCall.getValueArgumentsCount();
            while (n < n2) {
                IrExpression arg;
                int i;
                Object object;
                if ((object = this.adapteeCall.getValueArgument(i = n++)) == null || !((arg = object) instanceof IrVararg)) continue;
                object = ((IrVararg)arg).getElements().iterator();
                while (object.hasNext()) {
                    IrVarargElement varargElement = (IrVarargElement)object.next();
                    if (!(varargElement instanceof IrGetValue)) continue;
                    return true;
                }
            }
            return false;
        }

        private final IrSimpleFunction createInvokeMethod(IrValueDeclaration receiverVar) {
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irSimpleFunction2;
            IrFunctionBuilder irFunctionBuilder;
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv$iv$iv = irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u2d22 = $this$buildFun_u24lambda_u2d16$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$createInvokeMethod_u24lambda_u2d22, this.isLambda ? (IrElement)this.callee : (IrElement)this.getIrFunctionReference());
            $this$createInvokeMethod_u24lambda_u2d22.setName(this.superMethod.getName());
            $this$createInvokeMethod_u24lambda_u2d22.setReturnType(this.referenceReturnType);
            $this$createInvokeMethod_u24lambda_u2d22.setSuspend(AdditionalIrUtilsKt.isSuspend(this.callee));
            IrSimpleFunction function$iv$iv = irSimpleFunction2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d16$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            IrSimpleFunction $this$createInvokeMethod_u24lambda_u2d23 = irSimpleFunction = irSimpleFunction2;
            boolean bl4 = false;
            $this$createInvokeMethod_u24lambda_u2d23.setMetadata(this.functionReferenceClass.getMetadata());
            IrSimpleFunction irSimpleFunction3 = $this$createInvokeMethod_u24lambda_u2d23;
            irSimpleFunction3.setOverriddenSymbols(CollectionsKt.plus((Collection)irSimpleFunction3.getOverriddenSymbols(), (Object)this.superMethod.getSymbol()));
            $this$createInvokeMethod_u24lambda_u2d23.setDispatchReceiverParameter(DeclarationBuildersKt.buildReceiverParameter$default($this$createInvokeMethod_u24lambda_u2d23, IrDeclarationOrigin.INSTANCE_RECEIVER.INSTANCE, IrTypesKt.getDefaultType(this.functionReferenceClass.getSymbol()), 0, 0, 24, null));
            if (this.isLambda) {
                this.createLambdaInvokeMethod($this$createInvokeMethod_u24lambda_u2d23);
            } else {
                this.createFunctionReferenceInvokeMethod($this$createInvokeMethod_u24lambda_u2d23, receiverVar);
            }
            return irSimpleFunction;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            IrSimpleFunction irSimpleFunction = $this$createLambdaInvokeMethod;
            irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)irSimpleFunction.getAnnotations(), (Iterable)this.callee.getAnnotations()));
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.callee));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int index2 = $dstr$index$param.component1();
                IrValueParameter param = (IrValueParameter)$dstr$index$param.component2();
                Pair pair = TuplesKt.to((Object)param, (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, index2, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            IrSimpleFunction irSimpleFunction2 = $this$createLambdaInvokeMethod;
            irSimpleFunction2.setValueParameters(CollectionsKt.plus((Collection)irSimpleFunction2.getValueParameters(), (Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.callee, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod, IrValueDeclaration receiver) {
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u2d28;
            IrFunctionAccessExpression irFunctionAccessExpression;
            Name name;
            Object object = this.argumentTypes.iterator();
            int n = 0;
            while (object.hasNext()) {
                IrValueParameter irValueParameter;
                IrValueParameterBuilder irValueParameterBuilder;
                int index2 = n++;
                IrType argumentType = object.next();
                IrFunction $this$addValueParameter$iv = $this$createFunctionReferenceInvokeMethod;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25 = $this$addValueParameter_u24lambda_u2d28$iv;
                boolean bl2 = false;
                name = Name.identifier(Intrinsics.stringPlus((String)"p", (Object)index2));
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"p$index\")");
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25.setName(name);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25.setType(argumentType);
                if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
                boolean bl3 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
            }
            object = JvmIrBuilderKt.createJvmIrBuilder(FunctionReferenceLowering.this.context, $this$createFunctionReferenceInvokeMethod.getSymbol(), $this$createFunctionReferenceInvokeMethod.getStartOffset(), $this$createFunctionReferenceInvokeMethod.getEndOffset());
            FunctionReferenceLowering functionReferenceLowering = FunctionReferenceLowering.this;
            Object index2 = object;
            IrSimpleFunction irSimpleFunction = $this$createFunctionReferenceInvokeMethod;
            boolean bl = false;
            int unboundIndex = 0;
            IrFunctionAccessExpression $this$createFunctionReferenceInvokeMethod_u24lambda_u2d28_u24lambda_u2d27 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d28, this.callee.getSymbol(), this.referenceReturnType);
            boolean bl4 = false;
            for (IrTypeParameter typeParameter : IrUtilsKt.getAllTypeParameters(((IrFunctionSymbol)this.getIrFunctionReference().getSymbol()).getOwner())) {
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d28_u24lambda_u2d27.putTypeArgument(typeParameter.getIndex(), this.typeArgumentsMap.get(typeParameter.getSymbol()));
            }
            for (IrValueParameter parameter : IrUtilsKt.getExplicitParameters(this.callee)) {
                Name name2;
                Object object2;
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                if (Intrinsics.areEqual((Object)(pair == null ? null : (IrValueParameter)pair.getFirst()), (Object)parameter)) {
                    if (this.getSamSuperType() == null) {
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d28;
                        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d28;
                        IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d28;
                        IrValueParameter irValueParameter = $this$createFunctionReferenceInvokeMethod.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter);
                        object2 = ExpressionHelpersKt.irImplicitCast(irBuilderWithScope, ExpressionHelpersKt.irGetField(irBuilderWithScope2, ExpressionHelpersKt.irGet(irBuilderWithScope3, irValueParameter), this.receiverField), ((IrExpression)this.boundReceiver.getSecond()).getType());
                    } else {
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d28;
                        IrValueDeclaration irValueDeclaration = receiver;
                        Intrinsics.checkNotNull((Object)irValueDeclaration);
                        object2 = ExpressionHelpersKt.irGet(irBuilderWithScope, irValueDeclaration);
                    }
                } else if (unboundIndex >= this.argumentTypes.size()) {
                    object2 = null;
                } else {
                    int n2 = unboundIndex;
                    unboundIndex = n2 + 1;
                    object2 = name = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d28, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n2));
                }
                if (name == null) continue;
                Name it = name2 = name;
                boolean bl5 = false;
                IrMemberAccessExpressionKt.putArgument($this$createFunctionReferenceInvokeMethod_u24lambda_u2d28_u24lambda_u2d27, this.callee, parameter, (IrExpression)((Object)it));
            }
            IrFunctionAccessExpression call2 = irFunctionAccessExpression;
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$createFunctionReferenceInvokeMethod_u24lambda_u2d28, (IrExpression)(VarargLoweringKt.isArrayOf(((IrFunctionSymbol)this.getIrFunctionReference().getSymbol()).getOwner()) ? call2.transform((IrElementTransformer)new VarargLowering(functionReferenceLowering.context), (Object)null) : (IrExpression)call2));
            irSimpleFunction.setBody(irExpressionBody);
        }

        private final IrSimpleFunction buildOverride(IrSimpleFunction superFunction, IrType newReturnType) {
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irSimpleFunction2;
            IrFunctionBuilder irFunctionBuilder;
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv$iv$iv = irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildOverride_u24lambda_u2d29 = $this$buildFun_u24lambda_u2d16$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$buildOverride_u24lambda_u2d29, this.getIrFunctionReference());
            $this$buildOverride_u24lambda_u2d29.setOrigin(JvmLoweredDeclarationOrigin.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$buildOverride_u24lambda_u2d29.setName(superFunction.getName());
            $this$buildOverride_u24lambda_u2d29.setReturnType(newReturnType);
            $this$buildOverride_u24lambda_u2d29.setVisibility(superFunction.getVisibility());
            $this$buildOverride_u24lambda_u2d29.setSuspend(superFunction.isSuspend());
            IrSimpleFunction function$iv$iv = irSimpleFunction2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d16$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            IrSimpleFunction $this$buildOverride_u24lambda_u2d30 = irSimpleFunction = irSimpleFunction2;
            boolean bl4 = false;
            IrDeclarationBase irDeclarationBase = $this$buildOverride_u24lambda_u2d30;
            irDeclarationBase.setOverriddenSymbols(CollectionsKt.plus((Collection)irDeclarationBase.getOverriddenSymbols(), (Object)superFunction.getSymbol()));
            irDeclarationBase = this.functionReferenceClass.getThisReceiver();
            $this$buildOverride_u24lambda_u2d30.setDispatchReceiverParameter(irDeclarationBase == null ? null : org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)irDeclarationBase, $this$buildOverride_u24lambda_u2d30, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
            return irSimpleFunction;
        }

        static /* synthetic */ IrSimpleFunction buildOverride$default(FunctionReferenceBuilder functionReferenceBuilder, IrSimpleFunction irSimpleFunction, IrType irType, int n, Object object) {
            if ((n & 2) != 0) {
                irType = irSimpleFunction.getReturnType();
            }
            return functionReferenceBuilder.buildOverride(irSimpleFunction, irType);
        }

        private final Name getOriginalName(IrFunction $this$originalName) {
            MetadataSource metadataSource = $this$originalName.getMetadata();
            Name name = metadataSource == null ? null : metadataSource.getName();
            return name == null ? $this$originalName.getName() : name;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression generateSignature(JvmIrBuilder $this$generateSignature, IrFunctionSymbol target) {
            void $this$generateSignature_u24lambda_u2d32_u24lambda_u2d31;
            IrFunctionReferenceImpl irFunctionReferenceImpl;
            IrCall irCall;
            IrCall $this$generateSignature_u24lambda_u2d32 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateSignature, $this$generateSignature.getBackendContext().getIr().getSymbols().getSignatureStringIntrinsic());
            boolean bl = false;
            IrFunctionReferenceImpl irFunctionReferenceImpl2 = irFunctionReferenceImpl = new IrFunctionReferenceImpl(-1, -1, this.getIrFunctionReference().getType(), target, this.getIrFunctionReference().getTypeArgumentsCount(), target.getOwner().getValueParameters().size(), this.getIrFunctionReference().getReflectionTarget(), null);
            int n = 0;
            IrCall irCall2 = $this$generateSignature_u24lambda_u2d32;
            boolean bl2 = false;
            IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$generateSignature_u24lambda_u2d32_u24lambda_u2d31, this.getIrFunctionReference(), 0, 2, null);
            Unit unit2 = Unit.INSTANCE;
            irCall2.putValueArgument(n, irFunctionReferenceImpl);
            return irCall;
        }

        private final Pair<IrValueParameter, IrGetObjectValueImpl> createFakeBoundReceiverForJvmStaticInObject() {
            IrValueParameterBuilder irValueParameterBuilder;
            IrClass objectClass = IrUtilsKt.getParentAsClass(this.callee);
            IrDeclaration declaration$iv = this.callee;
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2d26$iv = irValueParameterBuilder = new IrValueParameterBuilder();
            boolean bl = false;
            IrValueParameterBuilder $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2d33 = $this$buildValueParameter_u24lambda_u2d26$iv;
            boolean bl2 = false;
            Name name = Name.identifier("$this");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"\\$this\")");
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2d33.setName(name);
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u2d33.setType(IrTypesKt.typeWith(objectClass, new IrType[0]));
            return TuplesKt.to((Object)DeclarationBuildersKt.buildValueParameter(declaration$iv.getFactory(), $this$buildValueParameter_u24lambda_u2d26$iv, (IrDeclarationParent)((Object)declaration$iv)), (Object)new IrGetObjectValueImpl(-1, -1, IrTypesKt.typeWith(objectClass, new IrType[0]), objectClass.getSymbol()));
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createLegacyMethodOverride(IrSimpleFunction superFunction, Function1<? super JvmIrBuilder, ? extends IrExpression> generator2) {
            void $this$createLegacyMethodOverride_u24lambda_u2d35_u24lambda_u2d34;
            JvmIrBuilder jvmIrBuilder;
            IrSimpleFunction irSimpleFunction = FunctionReferenceBuilder.buildOverride$default(this, superFunction, null, 2, null);
            FunctionReferenceLowering functionReferenceLowering = FunctionReferenceLowering.this;
            IrSimpleFunction $this$createLegacyMethodOverride_u24lambda_u2d35 = irSimpleFunction;
            boolean bl = false;
            JvmIrBuilder jvmIrBuilder2 = jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder(functionReferenceLowering.context, $this$createLegacyMethodOverride_u24lambda_u2d35.getSymbol(), $this$createLegacyMethodOverride_u24lambda_u2d35.getStartOffset(), $this$createLegacyMethodOverride_u24lambda_u2d35.getEndOffset());
            IrSimpleFunction irSimpleFunction2 = $this$createLegacyMethodOverride_u24lambda_u2d35;
            boolean bl2 = false;
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$createLegacyMethodOverride_u24lambda_u2d35_u24lambda_u2d34, (IrExpression)generator2.invoke((Object)$this$createLegacyMethodOverride_u24lambda_u2d35_u24lambda_u2d34));
            irSimpleFunction2.setBody(irExpressionBody);
            return irSimpleFunction;
        }

        public static final /* synthetic */ boolean access$isAdaptedReference$p(FunctionReferenceBuilder $this) {
            return $this.isAdaptedReference;
        }

        public static final /* synthetic */ Pair access$getBoundReceiver$p(FunctionReferenceBuilder $this) {
            return $this.boundReceiver;
        }

        public static final /* synthetic */ void access$generateConstructorCallArguments(FunctionReferenceBuilder $this, JvmIrBuilder $receiver, IrFunctionAccessExpression call2, Function1 generateBoundReceiver) {
            $this.generateConstructorCallArguments($receiver, call2, (Function1<? super IrBuilder, ? extends IrExpression>)generateBoundReceiver);
        }

        public static final /* synthetic */ IrExpression access$generateSignature(FunctionReferenceBuilder $this, JvmIrBuilder $receiver, IrFunctionSymbol target) {
            return $this.generateSignature($receiver, target);
        }

        public static final /* synthetic */ IrFunction access$getCallee$p(FunctionReferenceBuilder $this) {
            return $this.callee;
        }

        public static final /* synthetic */ Name access$getOriginalName(FunctionReferenceBuilder $this, IrFunction $receiver) {
            return $this.getOriginalName($receiver);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0019\u0010\t\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion;", "", "()V", "calculateOwner", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "irContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "calculateOwner$backend_jvm_lower", "calculateOwnerKClass", "calculateOwnerKClass$backend_jvm_lower", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrExpression calculateOwner$backend_jvm_lower(@NotNull JvmIrBuilder $this$calculateOwner, @NotNull IrDeclarationParent irContainer) {
            IrElementBase irElementBase;
            Intrinsics.checkNotNullParameter((Object)$this$calculateOwner, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            IrExpression kClass2 = this.calculateOwnerKClass$backend_jvm_lower($this$calculateOwner, irContainer);
            IrElementBase irElementBase2 = irElementBase = irContainer instanceof IrClass ? (IrClass)irContainer : null;
            if (!(irElementBase == null ? false : IrUtilsKt.isFileClass((IrDeclaration)((Object)irElementBase))) && !(irContainer instanceof IrPackageFragment)) {
                return kClass2;
            }
            IrElementBase $this$calculateOwner_u24lambda_u2d0 = irElementBase = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$calculateOwner, $this$calculateOwner.getIrSymbols().getGetOrCreateKotlinPackage());
            boolean bl = false;
            ((IrFunctionAccessExpression)$this$calculateOwner_u24lambda_u2d0).putValueArgument(0, JvmIrUtilsKt.kClassToJavaClass($this$calculateOwner, kClass2));
            ((IrFunctionAccessExpression)$this$calculateOwner_u24lambda_u2d0).putValueArgument(1, ExpressionHelpersKt.irString($this$calculateOwner, $this$calculateOwner.getBackendContext().getState().getModuleName()));
            return (IrExpression)irElementBase;
        }

        @NotNull
        public final IrExpression calculateOwnerKClass$backend_jvm_lower(@NotNull JvmIrBuilder $this$calculateOwnerKClass, @NotNull IrDeclarationParent irContainer) {
            Intrinsics.checkNotNullParameter((Object)$this$calculateOwnerKClass, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            return JvmIrUtilsKt.kClassReference($this$calculateOwnerKClass, JvmIrUtilsKt.getCallableReferenceOwnerKClassType(irContainer, $this$calculateOwnerKClass.getBackendContext()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

