/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbi;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.storage.CacheWithNotNullValues;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ;\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u00032\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020)0\n\u00a2\u0006\u0002\b*H\u0002JA\u0010+\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020)0\n\u00a2\u0006\u0002\b*H\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0010\u0010.\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0016\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u000202J\f\u00103\u001a\u00020\u0003*\u00020\u0010H\u0002J\f\u00104\u001a\u00020\u0003*\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001e\u001a\u001e\u0012\f\u0012\n  *\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n  *\u0004\u0018\u00010\f0\f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/MemoizedInlineClassReplacements;", "", "mangleReturnTypes", "", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(ZLorg/jetbrains/kotlin/ir/declarations/IrFactory;Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getBoxFunction", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getGetBoxFunction", "()Lkotlin/jvm/functions/Function1;", "getReplacementFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getGetReplacementFunction", "getUnboxFunction", "getGetUnboxFunction", "originalFunctionForMethodReplacement", "", "getOriginalFunctionForMethodReplacement$backend_jvm", "()Ljava/util/Map;", "originalFunctionForStaticReplacement", "getOriginalFunctionForStaticReplacement", "propertyMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "specializedEqualsCache", "Lorg/jetbrains/kotlin/storage/CacheWithNotNullValues;", "kotlin.jvm.PlatformType", "storageManager", "Lorg/jetbrains/kotlin/storage/LockBasedStorageManager;", "buildReplacement", "function", "replacementOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "noFakeOverride", "body", "", "Lkotlin/ExtensionFunctionType;", "buildReplacementInner", "useOldManglingScheme", "createMethodReplacement", "createStaticReplacement", "getSpecializedEqualsMethod", "irClass", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod", "isRemoveAtSpecialBuiltinStub", "backend.jvm"})
public final class MemoizedInlineClassReplacements {
    private final boolean mangleReturnTypes;
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final LockBasedStorageManager storageManager;
    @NotNull
    private final ConcurrentHashMap<IrPropertySymbol, IrProperty> propertyMap;
    @NotNull
    private final Map<IrFunction, IrFunction> originalFunctionForStaticReplacement;
    @NotNull
    private final Map<IrFunction, IrFunction> originalFunctionForMethodReplacement;
    @NotNull
    private final Function1<IrFunction, IrSimpleFunction> getReplacementFunction;
    @NotNull
    private final Function1<IrClass, IrSimpleFunction> getBoxFunction;
    @NotNull
    private final Function1<IrClass, IrSimpleFunction> getUnboxFunction;
    @NotNull
    private final CacheWithNotNullValues<IrClass, IrSimpleFunction> specializedEqualsCache;

    public MemoizedInlineClassReplacements(boolean mangleReturnTypes, @NotNull IrFactory irFactory, @NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.mangleReturnTypes = mangleReturnTypes;
        this.irFactory = irFactory;
        this.context = context2;
        this.storageManager = new LockBasedStorageManager("inline-class-replacements");
        this.propertyMap = new ConcurrentHashMap();
        this.originalFunctionForStaticReplacement = new ConcurrentHashMap();
        this.originalFunctionForMethodReplacement = new ConcurrentHashMap();
        Object object = this.storageManager.createMemoizedFunctionWithNullableValues((Function1)new Function1<IrFunction, IrSimpleFunction>(this){
            final /* synthetic */ MemoizedInlineClassReplacements this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final IrSimpleFunction invoke(IrFunction it) {
                Object object;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (AdditionalIrUtilsKt.isLocal(it) && it instanceof IrSimpleFunction && ((IrSimpleFunction)it).getOverriddenSymbols().isEmpty() || Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.DELEGATED_PROPERTY_ACCESSOR.INSTANCE) && Intrinsics.areEqual((Object)it.getVisibility(), (Object)DescriptorVisibilities.LOCAL) || JvmIrUtilsKt.isStaticInlineClassReplacement(it) || it.getOrigin().isSynthetic()) {
                    object = null;
                } else if (InlineClassAbiKt.isInlineClassFieldGetter(it)) {
                    object = InlineClassAbiKt.getHasMangledReturnType(it) ? MemoizedInlineClassReplacements.access$createMethodReplacement(this.this$0, it) : null;
                } else {
                    IrClass irClass2;
                    IrDeclarationParent $this$safeAs$iv = it.getParent();
                    boolean $i$f$safeAs = false;
                    IrDeclarationParent irDeclarationParent = $this$safeAs$iv;
                    if (!(irDeclarationParent instanceof IrClass)) {
                        irDeclarationParent = null;
                    }
                    object = ((irClass2 = (IrClass)irDeclarationParent) == null ? false : irClass2.isInline()) ? (MemoizedInlineClassReplacements.access$isRemoveAtSpecialBuiltinStub(this.this$0, it) ? null : (MemoizedInlineClassReplacements.access$isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod(this.this$0, it) ? null : (Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.IR_BUILTINS_STUB.INSTANCE) ? MemoizedInlineClassReplacements.access$createMethodReplacement(this.this$0, it) : MemoizedInlineClassReplacements.access$createStaticReplacement(this.this$0, it)))) : (it instanceof IrSimpleFunction && !IrUtilsKt.isFromJava(it) && (InlineClassAbiKt.getHasMangledParameters(it) || MemoizedInlineClassReplacements.access$getMangleReturnTypes$p(this.this$0) && InlineClassAbiKt.getHasMangledReturnType(it)) ? (it.getDispatchReceiverParameter() != null ? MemoizedInlineClassReplacements.access$createMethodReplacement(this.this$0, it) : MemoizedInlineClassReplacements.access$createStaticReplacement(this.this$0, it)) : null);
                }
                return object;
            }
        });
        Intrinsics.checkNotNullExpressionValue(object, (String)"storageManager.createMem\u2026l\n            }\n        }");
        this.getReplacementFunction = (Function1)object;
        object = this.storageManager.createMemoizedFunction((Function1)new Function1<IrClass, IrSimpleFunction>(this){
            final /* synthetic */ MemoizedInlineClassReplacements this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrSimpleFunction invoke(IrClass irClass2) {
                IrValueParameter irValueParameter;
                IrValueParameterBuilder irValueParameterBuilder;
                IrSimpleFunction irSimpleFunction;
                IrFunctionBuilder irFunctionBuilder;
                if (!irClass2.isInline()) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                IrFactory $this$buildFun$iv = MemoizedInlineClassReplacements.access$getIrFactory$p(this.this$0);
                boolean $i$f$buildFun = false;
                IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = irFunctionBuilder = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$invoke_u24lambda_u2d0 = $this$buildFun_u24lambda_u2d16$iv;
                boolean bl2 = false;
                Name name = Name.identifier(KotlinTypeMapper.BOX_JVM_METHOD_NAME);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(KotlinTypeMapper.BOX_JVM_METHOD_NAME)");
                $this$invoke_u24lambda_u2d0.setName(name);
                $this$invoke_u24lambda_u2d0.setOrigin(JvmLoweredDeclarationOrigin.SYNTHETIC_INLINE_CLASS_MEMBER.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)irClass2, (String)"irClass");
                $this$invoke_u24lambda_u2d0.setReturnType(IrUtilsKt.getDefaultType(irClass2));
                IrSimpleFunction $this$invoke_u24lambda_u2d2 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
                boolean bl3 = false;
                $this$invoke_u24lambda_u2d2.setParent(irClass2);
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default($this$invoke_u24lambda_u2d2, irClass2, null, null, 6, null);
                IrFunction $this$addValueParameter$iv = $this$invoke_u24lambda_u2d2;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl4 = false;
                IrValueParameterBuilder $this$invoke_u24lambda_u2d2_u24lambda_u2d1 = $this$addValueParameter_u24lambda_u2d28$iv;
                boolean bl5 = false;
                $this$invoke_u24lambda_u2d2_u24lambda_u2d1.setName(InlineClassDescriptorResolver.INSTANCE.getBOXING_VALUE_PARAMETER_NAME());
                InlineClassRepresentation<IrSimpleType> inlineClassRepresentation2 = irClass2.getInlineClassRepresentation();
                Intrinsics.checkNotNull(inlineClassRepresentation2);
                $this$invoke_u24lambda_u2d2_u24lambda_u2d1.setType(inlineClassRepresentation2.getUnderlyingType());
                if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
                boolean bl6 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
                return irSimpleFunction;
            }
        });
        Intrinsics.checkNotNullExpressionValue(object, (String)"storageManager.createMem\u2026}\n            }\n        }");
        this.getBoxFunction = (Function1)object;
        object = this.storageManager.createMemoizedFunction((Function1)new Function1<IrClass, IrSimpleFunction>(this){
            final /* synthetic */ MemoizedInlineClassReplacements this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrSimpleFunction invoke(IrClass irClass2) {
                IrSimpleFunction irSimpleFunction;
                IrFunctionBuilder irFunctionBuilder;
                if (!irClass2.isInline()) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                IrFactory $this$buildFun$iv = MemoizedInlineClassReplacements.access$getIrFactory$p(this.this$0);
                boolean $i$f$buildFun = false;
                IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = irFunctionBuilder = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$invoke_u24lambda_u2d0 = $this$buildFun_u24lambda_u2d16$iv;
                boolean bl2 = false;
                Name name = Name.identifier(KotlinTypeMapper.UNBOX_JVM_METHOD_NAME);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(KotlinTypeMapper.UNBOX_JVM_METHOD_NAME)");
                $this$invoke_u24lambda_u2d0.setName(name);
                $this$invoke_u24lambda_u2d0.setOrigin(JvmLoweredDeclarationOrigin.SYNTHETIC_INLINE_CLASS_MEMBER.INSTANCE);
                InlineClassRepresentation<IrSimpleType> inlineClassRepresentation2 = irClass2.getInlineClassRepresentation();
                Intrinsics.checkNotNull(inlineClassRepresentation2);
                $this$invoke_u24lambda_u2d0.setReturnType(inlineClassRepresentation2.getUnderlyingType());
                IrSimpleFunction $this$invoke_u24lambda_u2d1 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)irClass2, (String)"irClass");
                $this$invoke_u24lambda_u2d1.setParent(irClass2);
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createDispatchReceiverParameter$default($this$invoke_u24lambda_u2d1, null, 1, null);
                return irSimpleFunction;
            }
        });
        Intrinsics.checkNotNullExpressionValue(object, (String)"storageManager.createMem\u2026)\n            }\n        }");
        this.getUnboxFunction = (Function1)object;
        object = this.storageManager.createCacheWithNotNullValues();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"storageManager.createCac\u2026lass, IrSimpleFunction>()");
        this.specializedEqualsCache = object;
    }

    @NotNull
    public final Map<IrFunction, IrFunction> getOriginalFunctionForStaticReplacement() {
        return this.originalFunctionForStaticReplacement;
    }

    @NotNull
    public final Map<IrFunction, IrFunction> getOriginalFunctionForMethodReplacement$backend_jvm() {
        return this.originalFunctionForMethodReplacement;
    }

    @NotNull
    public final Function1<IrFunction, IrSimpleFunction> getGetReplacementFunction() {
        return this.getReplacementFunction;
    }

    private final boolean isRemoveAtSpecialBuiltinStub(IrFunction $this$isRemoveAtSpecialBuiltinStub) {
        return Intrinsics.areEqual((Object)$this$isRemoveAtSpecialBuiltinStub.getOrigin(), (Object)IrDeclarationOrigin.IR_BUILTINS_STUB.INSTANCE) && Intrinsics.areEqual((Object)$this$isRemoveAtSpecialBuiltinStub.getName().asString(), (Object)"remove") && $this$isRemoveAtSpecialBuiltinStub.getValueParameters().size() == 1 && IrTypePredicatesKt.isInt($this$isRemoveAtSpecialBuiltinStub.getValueParameters().get(0).getType());
    }

    private final boolean isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod(IrFunction $this$isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod) {
        if (!($this$isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod instanceof IrSimpleFunction)) {
            return false;
        }
        if (!((IrSimpleFunction)$this$isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod).isFakeOverride()) {
            return false;
        }
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull($this$isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod);
        if (irClass2 == null) {
            return false;
        }
        IrClass parentClass = irClass2;
        if (!parentClass.isInline()) {
            return false;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)((Object)$this$isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod), false, null, 3, null);
        if (irSimpleFunction == null) {
            return false;
        }
        IrSimpleFunction overridden = irSimpleFunction;
        if (!IrCodegenUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(overridden))) {
            return false;
        }
        if (overridden.getModality() == Modality.ABSTRACT) {
            return false;
        }
        return IrUtilsKt.isFromJava(overridden) || JvmIrUtilsKt.isCompiledToJvmDefault(overridden, this.context.getState().getJvmDefaultMode());
    }

    @NotNull
    public final Function1<IrClass, IrSimpleFunction> getGetBoxFunction() {
        return this.getBoxFunction;
    }

    @NotNull
    public final Function1<IrClass, IrSimpleFunction> getGetUnboxFunction() {
        return this.getUnboxFunction;
    }

    @NotNull
    public final IrSimpleFunction getSpecializedEqualsMethod(@NotNull IrClass irClass2, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (!irClass2.isInline()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        IrSimpleFunction irSimpleFunction = this.specializedEqualsCache.computeIfAbsent(irClass2, (Function0<IrSimpleFunction>)((Function0)new Function0<IrSimpleFunction>(this, irBuiltIns, irClass2){
            final /* synthetic */ MemoizedInlineClassReplacements this$0;
            final /* synthetic */ IrBuiltIns $irBuiltIns;
            final /* synthetic */ IrClass $irClass;
            {
                this.this$0 = $receiver;
                this.$irBuiltIns = $irBuiltIns;
                this.$irClass = $irClass;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final IrSimpleFunction invoke() {
                IrValueParameter irValueParameter;
                IrValueParameterBuilder irValueParameterBuilder;
                ArrayList<IrStarProjectionImpl> arrayList;
                void $this$buildFun$iv;
                IrFunctionBuilder irFunctionBuilder;
                Object object = MemoizedInlineClassReplacements.access$getIrFactory$p(this.this$0);
                Object object2 = this.$irBuiltIns;
                boolean $i$f$buildFun = false;
                IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv22 = irFunctionBuilder = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$invoke_u24lambda_u2d0 = $this$buildFun_u24lambda_u2d16$iv22;
                boolean bl2 = false;
                $this$invoke_u24lambda_u2d0.setName(InlineClassDescriptorResolver.SPECIALIZED_EQUALS_NAME);
                $this$invoke_u24lambda_u2d0.setOrigin(JvmLoweredDeclarationOrigin.INLINE_CLASS_GENERATED_IMPL_METHOD.INSTANCE);
                $this$invoke_u24lambda_u2d0.setReturnType(((IrBuiltIns)object2).getBooleanType());
                object = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv22);
                object2 = this.$irClass;
                Object $this$invoke_u24lambda_u2d4 = object;
                boolean bl3 = false;
                $this$invoke_u24lambda_u2d4.setParent((IrDeclarationParent)object2);
                int $this$buildFun_u24lambda_u2d16$iv22 = object2.getTypeParameters().size();
                boolean bl4 = false;
                IrClassifierSymbol irClassifierSymbol = ((IrClass)object2).getSymbol();
                KotlinType kotlinType = null;
                ArrayList<IrStarProjectionImpl> arrayList2 = new ArrayList<IrStarProjectionImpl>($this$buildFun_u24lambda_u2d16$iv22);
                int n = 0;
                while (n < $this$buildFun_u24lambda_u2d16$iv22) {
                    int n2;
                    int n3;
                    int n4 = n3 = (n2 = n++);
                    arrayList = arrayList2;
                    boolean bl5 = false;
                    IrStarProjectionImpl irStarProjectionImpl = IrStarProjectionImpl.INSTANCE;
                    arrayList.add(irStarProjectionImpl);
                }
                arrayList = arrayList2;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n5 = 32;
                IrTypeAbbreviation irTypeAbbreviation = null;
                List list2 = CollectionsKt.emptyList();
                ArrayList<IrStarProjectionImpl> arrayList3 = arrayList;
                boolean bl6 = bl4;
                IrClassifierSymbol irClassifierSymbol2 = irClassifierSymbol;
                KotlinType kotlinType2 = kotlinType;
                IrSimpleTypeImpl typeArgument = new IrSimpleTypeImpl(kotlinType2, irClassifierSymbol2, bl6, arrayList3, list2, irTypeAbbreviation, n5, defaultConstructorMarker);
                IrFunction $this$addValueParameter$iv = (IrFunction)$this$invoke_u24lambda_u2d4;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl7 = false;
                IrValueParameterBuilder $this$invoke_u24lambda_u2d4_u24lambda_u2d2 = $this$addValueParameter_u24lambda_u2d28$iv;
                boolean bl8 = false;
                $this$invoke_u24lambda_u2d4_u24lambda_u2d2.setName(InlineClassDescriptorResolver.INSTANCE.getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME());
                $this$invoke_u24lambda_u2d4_u24lambda_u2d2.setType(typeArgument);
                if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
                boolean bl9 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
                $this$addValueParameter$iv = (IrFunction)$this$invoke_u24lambda_u2d4;
                $i$f$addValueParameter = false;
                $this$addValueParameter_u24lambda_u2d28$iv = irValueParameterBuilder = new IrValueParameterBuilder();
                bl7 = false;
                IrValueParameterBuilder $this$invoke_u24lambda_u2d4_u24lambda_u2d3 = $this$addValueParameter_u24lambda_u2d28$iv;
                boolean bl10 = false;
                $this$invoke_u24lambda_u2d4_u24lambda_u2d3.setName(InlineClassDescriptorResolver.INSTANCE.getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME());
                $this$invoke_u24lambda_u2d4_u24lambda_u2d3.setType(typeArgument);
                if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
                bl9 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
                return object;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)irSimpleFunction, (String)"fun getSpecializedEquals\u2026        }\n        }\n    }");
        return irSimpleFunction;
    }

    private final IrSimpleFunction createMethodReplacement(IrFunction function2) {
        return MemoizedInlineClassReplacements.buildReplacement$default(this, function2, function2.getOrigin(), false, (Function1)new Function1<IrFunction, Unit>(this, function2){
            final /* synthetic */ MemoizedInlineClassReplacements this$0;
            final /* synthetic */ IrFunction $function;
            {
                this.this$0 = $receiver;
                this.$function = $function;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull IrFunction $this$buildReplacement) {
                Collection<IrValueParameter> collection;
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                IrValueParameter irValueParameter;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)$this$buildReplacement, (String)"$this$buildReplacement");
                Map<IrFunction, IrFunction> map = this.this$0.getOriginalFunctionForMethodReplacement$backend_jvm();
                Object object = this.$function;
                map.put($this$buildReplacement, (IrFunction)object);
                boolean bl2 = bl = this.$function.getDispatchReceiverParameter() != null && this.$function instanceof IrSimpleFunction;
                if (!bl) {
                    object = "Failed requirement.";
                    throw new IllegalArgumentException(object.toString());
                }
                Object object2 = this.$function.getDispatchReceiverParameter();
                $this$buildReplacement.setDispatchReceiverParameter(object2 == null ? null : org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)object2, $this$buildReplacement, null, -1, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                object2 = this.$function.getExtensionReceiverParameter();
                if (object2 == null) {
                    irValueParameter = null;
                } else {
                    object = Name.identifier("$receiver");
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"\\$receiver\")");
                    irValueParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)object2, $this$buildReplacement, null, -1, 0, 0, (Name)object, null, null, null, null, false, false, false, 8154, null);
                }
                $this$buildReplacement.setExtensionReceiverParameter(irValueParameter);
                object2 = this.$function.getValueParameters();
                IrFunction irFunction2 = $this$buildReplacement;
                boolean $i$f$mapIndexed = false;
                void var4_8 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index2;
                    void parameter;
                    IrValueParameter irValueParameter2;
                    int n = index$iv$iv;
                    index$iv$iv = n + 1;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IrValueParameter irValueParameter3 = (IrValueParameter)item$iv$iv;
                    int n2 = n;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    IrValueParameter it = irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)parameter, $this$buildReplacement, null, (int)index2, 0, 0, null, null, null, null, null, false, false, false, 7674, null);
                    boolean bl4 = false;
                    IrExpressionBody irExpressionBody = parameter.getDefaultValue();
                    it.setDefaultValue(irExpressionBody == null ? null : (IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irExpressionBody, $this$buildReplacement));
                    IrValueParameter irValueParameter4 = irValueParameter2;
                    collection.add(irValueParameter4);
                }
                collection = (List)destination$iv$iv;
                irFunction2.setValueParameters((List<? extends IrValueParameter>)collection);
            }
        }, 4, null);
    }

    private final IrSimpleFunction createStaticReplacement(IrFunction function2) {
        return this.buildReplacement(function2, JvmLoweredDeclarationOrigin.STATIC_INLINE_CLASS_REPLACEMENT.INSTANCE, true, (Function1<? super IrFunction, Unit>)((Function1)new Function1<IrFunction, Unit>(this, function2){
            final /* synthetic */ MemoizedInlineClassReplacements this$0;
            final /* synthetic */ IrFunction $function;
            {
                this.this$0 = $receiver;
                this.$function = $function;
                super(1);
            }

            public final void invoke(@NotNull IrFunction $this$buildReplacement) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Intrinsics.checkNotNullParameter((Object)$this$buildReplacement, (String)"$this$buildReplacement");
                Map<IrFunction, IrFunction> map = this.this$0.getOriginalFunctionForStaticReplacement();
                Iterator<IrValueParameter> iterator2 = this.$function;
                map.put($this$buildReplacement, (IrFunction)((Object)iterator2));
                List newValueParameters = new ArrayList<E>();
                if (this.$function.getDispatchReceiverParameter() != null) {
                    iterator2 = newValueParameters;
                    IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(this.$function).getThisReceiver();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    object4 = irValueParameter;
                    int n = newValueParameters.size();
                    object3 = Name.identifier(Intrinsics.stringPlus((String)"arg", (Object)newValueParameters.size()));
                    IrSimpleType irSimpleType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(this.$function));
                    object2 = IrDeclarationOrigin.MOVED_DISPATCH_RECEIVER.INSTANCE;
                    IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)object2;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"identifier(\"arg${newValueParameters.size}\")");
                    object4 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(object4, $this$buildReplacement, irDeclarationOrigin, n, 0, 0, (Name)object3, null, irSimpleType, null, null, false, false, false, 8024, null);
                    iterator2.add((IrValueParameter)object4);
                }
                if ((iterator2 = this.$function.getExtensionReceiverParameter()) != null) {
                    Object object5;
                    Object object6;
                    Comparable comparable;
                    object4 = iterator2;
                    IrFunction irFunction2 = this.$function;
                    Iterator<IrValueParameter> it = object4;
                    boolean bl = false;
                    object2 = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
                    Object object7 = object = object2 == null ? null : ((IrSimpleFunction)object2).getCorrespondingPropertySymbol();
                    if (object == null) {
                        comparable = irFunction2.getName();
                    } else {
                        object6 = (IrProperty)object.getOwner();
                        object5 = object6.getName();
                        object2 = ((Name)object5).asStringStripSpecialMarkers();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"(function as? IrSimpleFu\u2026         ?: function.name");
                        comparable = (Comparable)object2;
                    }
                    Comparable baseName = comparable;
                    Collection collection = newValueParameters;
                    int n = newValueParameters.size();
                    object6 = Name.identifier(Intrinsics.stringPlus((String)"$this$", (Object)baseName));
                    object5 = IrDeclarationOrigin.MOVED_EXTENSION_RECEIVER.INSTANCE;
                    IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)object5;
                    Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"identifier(\"\\$this\\$$baseName\")");
                    collection.add(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(it, $this$buildReplacement, irDeclarationOrigin, n, 0, 0, (Name)object6, null, null, null, null, false, false, false, 8152, null));
                }
                for (IrValueParameter parameter : this.$function.getValueParameters()) {
                    Collection collection = newValueParameters;
                    Object it = object3 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(parameter, $this$buildReplacement, null, newValueParameters.size(), 0, 0, null, null, null, null, null, false, false, false, 7674, null);
                    boolean bl = false;
                    object = parameter.getDefaultValue();
                    ((IrValueParameter)it).setDefaultValue(object == null ? null : (IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)object, $this$buildReplacement));
                    collection.add(object3);
                }
                $this$buildReplacement.setValueParameters(newValueParameters);
            }
        }));
    }

    private final IrSimpleFunction buildReplacement(IrFunction function2, IrDeclarationOrigin replacementOrigin, boolean noFakeOverride, Function1<? super IrFunction, Unit> body2) {
        boolean useOldManglingScheme = this.context.getState().getUseOldManglingSchemeForFunctionsWithInlineClassesInSignatures();
        IrSimpleFunction replacement = this.buildReplacementInner(function2, replacementOrigin, noFakeOverride, useOldManglingScheme, body2);
        if (!useOldManglingScheme) {
            Object object = replacement.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"replacement.name.asString()");
            if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"-", (boolean)false, (int)2, null)) {
                boolean bl;
                object = IrCodegenUtilsKt.getParentClassId(function2);
                if (object == null) {
                    bl = false;
                } else {
                    Object object2;
                    Object it = object2 = object;
                    boolean bl2 = false;
                    bl = Intrinsics.areEqual((Object)IrCodegenUtilsKt.classFileContainsMethod((ClassId)it, replacement, this.context), (Object)false);
                }
                if (bl) {
                    return this.buildReplacementInner(function2, replacementOrigin, noFakeOverride, true, body2);
                }
            }
        }
        return replacement;
    }

    static /* synthetic */ IrSimpleFunction buildReplacement$default(MemoizedInlineClassReplacements memoizedInlineClassReplacements, IrFunction irFunction2, IrDeclarationOrigin irDeclarationOrigin, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return memoizedInlineClassReplacements.buildReplacement(irFunction2, irDeclarationOrigin, bl, (Function1<? super IrFunction, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction buildReplacementInner(IrFunction function2, IrDeclarationOrigin replacementOrigin, boolean noFakeOverride, boolean useOldManglingScheme, Function1<? super IrFunction, Unit> body2) {
        IrSimpleFunction irSimpleFunction;
        IrFunctionBuilder irFunctionBuilder;
        IrFactory $this$buildFun$iv = this.irFactory;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$buildReplacementInner_u24lambda_u2d1 = $this$buildFun_u24lambda_u2d16$iv;
        boolean bl22 = false;
        $this$buildReplacementInner_u24lambda_u2d1.updateFrom(function2);
        if (function2 instanceof IrConstructor) {
            $this$buildReplacementInner_u24lambda_u2d1.setModality(Modality.OPEN);
        }
        $this$buildReplacementInner_u24lambda_u2d1.setOrigin(Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.GENERATED_INLINE_CLASS_MEMBER.INSTANCE) ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INLINE_CLASS_GENERATED_IMPL_METHOD.INSTANCE : (function2 instanceof IrConstructor && AdditionalIrUtilsKt.getConstructedClass((IrConstructor)function2).isInline() ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.STATIC_INLINE_CLASS_CONSTRUCTOR.INSTANCE : replacementOrigin));
        if (noFakeOverride) {
            $this$buildReplacementInner_u24lambda_u2d1.setFakeOverride(false);
        }
        $this$buildReplacementInner_u24lambda_u2d1.setName(InlineClassAbi.INSTANCE.mangledNameFor(function2, this.mangleReturnTypes, useOldManglingScheme));
        $this$buildReplacementInner_u24lambda_u2d1.setReturnType(function2.getReturnType());
        IrSimpleFunction $this$buildReplacementInner_u24lambda_u2d6 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
        boolean bl3 = false;
        $this$buildReplacementInner_u24lambda_u2d6.setParent(function2.getParent());
        $this$buildReplacementInner_u24lambda_u2d6.setAnnotations(function2.getAnnotations());
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParameters$default($this$buildReplacementInner_u24lambda_u2d6, IrUtilsKt.getAllTypeParameters(function2), null, null, 6, null);
        if (function2.getMetadata() != null) {
            $this$buildReplacementInner_u24lambda_u2d6.setMetadata(function2.getMetadata());
            function2.setMetadata(null);
        }
        IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$buildReplacementInner_u24lambda_u2d6, function2 instanceof IrAttributeContainer ? (IrAttributeContainer)((Object)function2) : null);
        if (function2 instanceof IrSimpleFunction) {
            Collection<IrSimpleFunctionSymbol> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object property2;
            IrPropertySymbol propertySymbol = ((IrSimpleFunction)function2).getCorrespondingPropertySymbol();
            if (propertySymbol != null) {
                Object object;
                Object $this$getOrPut$iv = this.propertyMap;
                boolean $i$f$getOrPut = false;
                Object bl22 = $this$getOrPut$iv.get(propertySymbol);
                if (bl22 == null) {
                    Object object2;
                    Object object3;
                    IrPropertyBuilder irPropertyBuilder;
                    boolean bl4 = false;
                    IrFactory $this$buildProperty$iv = this.irFactory;
                    boolean $i$f$buildProperty = false;
                    IrPropertyBuilder $this$buildProperty_u24lambda_u2d8$iv = irPropertyBuilder = new IrPropertyBuilder();
                    boolean bl5 = false;
                    IrPropertyBuilder $this$buildReplacementInner_u24lambda_u2d6_u24lambda_u2d4_u24lambda_u2d2 = $this$buildProperty_u24lambda_u2d8$iv;
                    boolean bl6 = false;
                    $this$buildReplacementInner_u24lambda_u2d6_u24lambda_u2d4_u24lambda_u2d2.setName(((IrProperty)propertySymbol.getOwner()).getName());
                    $this$buildReplacementInner_u24lambda_u2d6_u24lambda_u2d4_u24lambda_u2d2.updateFrom((IrProperty)propertySymbol.getOwner());
                    Object $this$buildReplacementInner_u24lambda_u2d6_u24lambda_u2d4_u24lambda_u2d3 = object3 = DeclarationBuildersKt.buildProperty($this$buildProperty$iv, $this$buildProperty_u24lambda_u2d8$iv);
                    boolean bl7 = false;
                    $this$buildReplacementInner_u24lambda_u2d6_u24lambda_u2d4_u24lambda_u2d3.setParent(((IrProperty)propertySymbol.getOwner()).getParent());
                    IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$buildReplacementInner_u24lambda_u2d6_u24lambda_u2d4_u24lambda_u2d3, (IrAttributeContainer)propertySymbol.getOwner());
                    $this$buildReplacementInner_u24lambda_u2d6_u24lambda_u2d4_u24lambda_u2d3.setAnnotations(((IrProperty)propertySymbol.getOwner()).getAnnotations());
                    Object default$iv = object2 = object3;
                    boolean bl8 = false;
                    Object object4 = $this$getOrPut$iv.putIfAbsent(propertySymbol, default$iv);
                    object = object4 == null ? default$iv : object4;
                } else {
                    object = bl22;
                }
                property2 = (IrProperty)object;
                $this$buildReplacementInner_u24lambda_u2d6.setCorrespondingPropertySymbol(((IrProperty)property2).getSymbol());
                $this$getOrPut$iv = function2;
                if (Intrinsics.areEqual((Object)$this$getOrPut$iv, (Object)((IrProperty)propertySymbol.getOwner()).getGetter())) {
                    ((IrProperty)property2).setGetter($this$buildReplacementInner_u24lambda_u2d6);
                } else if (Intrinsics.areEqual((Object)$this$getOrPut$iv, (Object)((IrProperty)propertySymbol.getOwner()).getSetter())) {
                    ((IrProperty)property2).setSetter($this$buildReplacementInner_u24lambda_u2d6);
                } else {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Orphaned property getter/setter: ", (Object)RenderIrElementKt.render(function2)).toString());
                }
            }
            property2 = ((IrSimpleFunction)function2).getOverriddenSymbols();
            IrSimpleFunction irSimpleFunction2 = $this$buildReplacementInner_u24lambda_u2d6;
            boolean $i$f$map = false;
            void $i$f$getOrPut = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrSimpleFunctionSymbol bl7 = (IrSimpleFunctionSymbol)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                IrSimpleFunction irSimpleFunction3 = (IrSimpleFunction)this.getGetReplacementFunction().invoke((Object)it.getOwner());
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = irSimpleFunction3 == null ? it : irSimpleFunction3.getSymbol();
                collection.add(irSimpleFunctionSymbol);
            }
            collection = (List)destination$iv$iv;
            irSimpleFunction2.setOverriddenSymbols(collection);
        }
        body2.invoke((Object)$this$buildReplacementInner_u24lambda_u2d6);
        return irSimpleFunction;
    }

    public static final /* synthetic */ IrFactory access$getIrFactory$p(MemoizedInlineClassReplacements $this) {
        return $this.irFactory;
    }

    public static final /* synthetic */ IrSimpleFunction access$createMethodReplacement(MemoizedInlineClassReplacements $this, IrFunction function2) {
        return $this.createMethodReplacement(function2);
    }

    public static final /* synthetic */ boolean access$isRemoveAtSpecialBuiltinStub(MemoizedInlineClassReplacements $this, IrFunction $receiver) {
        return $this.isRemoveAtSpecialBuiltinStub($receiver);
    }

    public static final /* synthetic */ boolean access$isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod(MemoizedInlineClassReplacements $this, IrFunction $receiver) {
        return $this.isInlineClassMemberFakeOverriddenFromJvmDefaultInterfaceMethod($receiver);
    }

    public static final /* synthetic */ IrSimpleFunction access$createStaticReplacement(MemoizedInlineClassReplacements $this, IrFunction function2) {
        return $this.createStaticReplacement(function2);
    }

    public static final /* synthetic */ boolean access$getMangleReturnTypes$p(MemoizedInlineClassReplacements $this) {
        return $this.mangleReturnTypes;
    }
}

