/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "", "value", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "newInferenceEnabled", "", "convertedFromSigned", "(Ljava/lang/Number;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;ZZ)V", "getConvertedFromSigned", "()Z", "hasIntegerLiteralType", "getHasIntegerLiteralType", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "unknownIntegerType", "Lorg/jetbrains/kotlin/types/SimpleType;", "getUnknownIntegerType", "()Lorg/jetbrains/kotlin/types/SimpleType;", "equals", "other", "", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "hashCode", "", "toConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "toString", "", "Companion", "descriptors"})
public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Number value;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;
    private final boolean newInferenceEnabled;
    private final boolean convertedFromSigned;
    @NotNull
    private final TypeConstructor typeConstructor;
    @NotNull
    private final SimpleType unknownIntegerType;

    public IntegerValueTypeConstant(@NotNull Number value2, @NotNull ModuleDescriptor module, @NotNull CompileTimeConstant.Parameters parameters2, boolean newInferenceEnabled, boolean convertedFromSigned) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        this.value = value2;
        this.parameters = parameters2;
        this.newInferenceEnabled = newInferenceEnabled;
        this.convertedFromSigned = convertedFromSigned;
        this.typeConstructor = this.newInferenceEnabled ? (TypeConstructor)new IntegerLiteralTypeConstructor(this.value.longValue(), module, this.getParameters()) : (TypeConstructor)new IntegerValueTypeConstructor(this.value.longValue(), module, this.getParameters());
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        List list2 = CollectionsKt.emptyList();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor + ')', true);
        Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"createErrorScope(\"Scope \u2026$typeConstructor)\", true)");
        this.unknownIntegerType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, this.typeConstructor, list2, false, memberScope2);
    }

    public /* synthetic */ IntegerValueTypeConstant(Number number2, ModuleDescriptor moduleDescriptor, CompileTimeConstant.Parameters parameters2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(number2, moduleDescriptor, parameters2, bl, bl2);
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public final boolean getConvertedFromSigned() {
        return this.convertedFromSigned;
    }

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
        KotlinType type2 = this.getType(expectedType2);
        return KotlinBuiltIns.isInt(type2) ? (ConstantValue)new IntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type2) ? (ConstantValue)new ByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type2) ? (ConstantValue)new ShortValue(this.value.shortValue()) : (KotlinBuiltIns.isLong(type2) ? (ConstantValue)new LongValue(this.value.longValue()) : (KotlinBuiltIns.isUInt(type2) ? (ConstantValue)new UIntValue(this.value.intValue()) : (KotlinBuiltIns.isUByte(type2) ? (ConstantValue)new UByteValue(this.value.byteValue()) : (KotlinBuiltIns.isUShort(type2) ? (ConstantValue)new UShortValue(this.value.shortValue()) : (KotlinBuiltIns.isULong(type2) ? (ConstantValue)new ULongValue(this.value.longValue()) : (ConstantValue)new LongValue(this.value.longValue()))))))));
    }

    @NotNull
    public final SimpleType getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final KotlinType getType(@NotNull KotlinType expectedType2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
        if (this.newInferenceEnabled) {
            KotlinType kotlinType2 = TypeUtils.getPrimitiveNumberType((IntegerLiteralTypeConstructor)this.typeConstructor, expectedType2);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"{\n            TypeUtils.\u2026, expectedType)\n        }");
            kotlinType = kotlinType2;
        } else {
            KotlinType kotlinType3 = TypeUtils.getPrimitiveNumberType((IntegerValueTypeConstructor)this.typeConstructor, expectedType2);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"{\n            TypeUtils.\u2026, expectedType)\n        }");
            kotlinType = kotlinType3;
        }
        return kotlinType;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IntegerValueTypeConstant && Intrinsics.areEqual((Object)this.value, (Object)((IntegerValueTypeConstant)other).value) && Intrinsics.areEqual((Object)this.getParameters(), (Object)((IntegerValueTypeConstant)other).getParameters());
    }

    @Override
    public int hashCode() {
        return 31 * this.value.hashCode() + this.getParameters().hashCode();
    }

    @Override
    public boolean getHasIntegerLiteralType() {
        return true;
    }

    @Override
    @NotNull
    public Number getValue(@NotNull KotlinType expectedType2) {
        return CompileTimeConstant.DefaultImpls.getValue(this, expectedType2);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean isError() {
        return CompileTimeConstant.DefaultImpls.isError(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean isUnsignedNumberLiteral() {
        return CompileTimeConstant.DefaultImpls.isUnsignedNumberLiteral(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }

    @JvmStatic
    @NotNull
    public static final IntegerValueTypeConstant convertToUnsignedConstant(@NotNull IntegerValueTypeConstant $this$convertToUnsignedConstant, @NotNull ModuleDescriptor module) {
        return Companion.convertToUnsignedConstant($this$convertToUnsignedConstant, module);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant$Companion;", "", "()V", "convertToSignedConstant", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "convertToUnsignedConstant", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntegerValueTypeConstant convertToUnsignedConstant(@NotNull IntegerValueTypeConstant $this$convertToUnsignedConstant, @NotNull ModuleDescriptor module) {
            Intrinsics.checkNotNullParameter((Object)$this$convertToUnsignedConstant, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            CompileTimeConstant.Parameters newParameters = new CompileTimeConstant.Parameters($this$convertToUnsignedConstant.getParameters().getCanBeUsedInAnnotation(), $this$convertToUnsignedConstant.getParameters().isPure(), true, $this$convertToUnsignedConstant.getParameters().isUnsignedLongNumberLiteral(), $this$convertToUnsignedConstant.getParameters().getUsesVariableAsConstant(), $this$convertToUnsignedConstant.getParameters().getUsesNonConstValAsConstant(), $this$convertToUnsignedConstant.getParameters().isConvertableConstVal(), false);
            return new IntegerValueTypeConstant($this$convertToUnsignedConstant.value, module, newParameters, $this$convertToUnsignedConstant.newInferenceEnabled, true);
        }

        @NotNull
        public final IntegerValueTypeConstant convertToSignedConstant(@NotNull IntegerValueTypeConstant $this$convertToSignedConstant, @NotNull ModuleDescriptor module) {
            Intrinsics.checkNotNullParameter((Object)$this$convertToSignedConstant, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            CompileTimeConstant.Parameters newParameters = new CompileTimeConstant.Parameters($this$convertToSignedConstant.getParameters().getCanBeUsedInAnnotation(), $this$convertToSignedConstant.getParameters().isPure(), false, $this$convertToSignedConstant.getParameters().isUnsignedLongNumberLiteral(), $this$convertToSignedConstant.getParameters().getUsesVariableAsConstant(), $this$convertToSignedConstant.getParameters().getUsesNonConstValAsConstant(), $this$convertToSignedConstant.getParameters().isConvertableConstVal(), false);
            return new IntegerValueTypeConstant($this$convertToSignedConstant.value, module, newParameters, $this$convertToSignedConstant.newInferenceEnabled, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

