/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.resolve.ArrayFqNames;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\"\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getCallResolver", "()Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "checkSupportsArrayLiterals", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getArrayFunctionCallName", "Lorg/jetbrains/kotlin/name/Name;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getFunctionDescriptorForCollectionLiteral", "", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "callName", "isInsideAnnotationEntryOrClass", "", "resolveCollectionLiteral", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "collectionLiteralExpression", "resolveCollectionLiteralSpecialMethod", "frontend"})
public final class CollectionLiteralResolver {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public CollectionLiteralResolver(@NotNull ModuleDescriptor module, @NotNull CallResolver callResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)callResolver, (String)"callResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.module = module;
        this.callResolver = callResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public final ModuleDescriptor getModule() {
        return this.module;
    }

    @NotNull
    public final CallResolver getCallResolver() {
        return this.callResolver;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final KotlinTypeInfo resolveCollectionLiteral(@NotNull KtCollectionLiteralExpression collectionLiteralExpression, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)collectionLiteralExpression, (String)"collectionLiteralExpression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.isInsideAnnotationEntryOrClass(collectionLiteralExpression)) {
            context2.trace.report(Errors.UNSUPPORTED.on((PsiElement)collectionLiteralExpression, "Collection literals outside of annotations"));
        }
        this.checkSupportsArrayLiterals(collectionLiteralExpression, context2);
        return this.resolveCollectionLiteralSpecialMethod(collectionLiteralExpression, context2);
    }

    private final KotlinTypeInfo resolveCollectionLiteralSpecialMethod(KtCollectionLiteralExpression expression2, ExpressionTypingContext context2) {
        Call call2 = CallMaker.makeCallForCollectionLiteral(expression2);
        KotlinType kotlinType = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.expectedType");
        Name callName = this.getArrayFunctionCallName(kotlinType);
        Collection<FunctionDescriptor> functionDescriptors2 = this.getFunctionDescriptorForCollectionLiteral(expression2, callName);
        if (functionDescriptors2.isEmpty()) {
            context2.trace.report(Errors.MISSING_STDLIB.on((PsiElement)expression2, "Collection literal call '" + callName + "()' is unresolved"));
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveCollectionLiteralCallWithGivenDescriptor(context2, expression2, call2, functionDescriptors2);
        Intrinsics.checkNotNullExpressionValue(overloadResolutionResults, (String)"callResolver.resolveColl\u2026all, functionDescriptors)");
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = overloadResolutionResults;
        if (!resolutionResults.isSingleResult()) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        context2.trace.record(BindingContext.COLLECTION_LITERAL_CALL, expression2, resolutionResults.getResultingCall());
        return TypeInfoFactoryKt.createTypeInfo(resolutionResults.getResultingDescriptor().getReturnType(), context2);
    }

    private final Collection<SimpleFunctionDescriptor> getFunctionDescriptorForCollectionLiteral(KtCollectionLiteralExpression expression2, Name callName) {
        MemberScope memberScopeOfKotlinPackage = this.module.getPackage(StandardNames.BUILT_INS_PACKAGE_FQ_NAME).getMemberScope();
        return memberScopeOfKotlinPackage.getContributedFunctions(callName, new KotlinLookupLocation(expression2));
    }

    private final void checkSupportsArrayLiterals(KtCollectionLiteralExpression expression2, ExpressionTypingContext context2) {
        if (this.isInsideAnnotationEntryOrClass(expression2) && !this.languageVersionSettings.supportsFeature(LanguageFeature.ArrayLiteralsInAnnotations)) {
            context2.trace.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)expression2, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.ArrayLiteralsInAnnotations), (Object)this.languageVersionSettings)));
        }
    }

    private final boolean isInsideAnnotationEntryOrClass(KtCollectionLiteralExpression expression2) {
        Class[] classArray = new Class[]{KtAnnotationEntry.class, KtClass.class};
        KtElementImplStub parent2 = (KtElementImplStub)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), (Class[])classArray);
        return parent2 instanceof KtAnnotationEntry || parent2 instanceof KtClass && ((KtClass)parent2).isAnnotation();
    }

    private final Name getArrayFunctionCallName(KotlinType expectedType2) {
        if (TypeUtils.noExpectedType(expectedType2) || !KotlinBuiltIns.isPrimitiveArray(expectedType2) && !KotlinBuiltIns.isUnsignedArrayType(expectedType2)) {
            return ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        Object object = expectedType2.getConstructor().getDeclarationDescriptor();
        if (object == null) {
            return ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        Object object2 = object;
        ClassifierDescriptor descriptor2 = object2;
        object2 = ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().get((Object)KotlinBuiltIns.getPrimitiveArrayType(descriptor2));
        return object2 == null ? ((object = (Name)((Map)UnsignedTypes.INSTANCE.getUnsignedArrayTypeToArrayCall()).get((Object)UnsignedTypes.toUnsignedArrayType(descriptor2))) == null ? ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION() : object) : object2;
    }
}

