/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.enhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAbstractConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPrimaryConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyBuilderKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.java.JavaTypeParameterStack;
import org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaClass;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaConstructor;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaFieldBuilder;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethod;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancementSignatureParts;
import org.jetbrains.kotlin.fir.java.enhancement.FirAnnotationTypeQualifierResolver;
import org.jetbrains.kotlin.fir.java.enhancement.FirJavaEnhancementContext;
import org.jetbrains.kotlin.fir.java.enhancement.FirJavaEnhancementContextKt;
import org.jetbrains.kotlin.fir.java.enhancement.FirSignatureEnhancement;
import org.jetbrains.kotlin.fir.java.enhancement.JavaTypeEnhancementStateContainerKt;
import org.jetbrains.kotlin.fir.scopes.jvm.DescriptorUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.AnnotationQualifierApplicabilityType;
import org.jetbrains.kotlin.load.java.JavaTypeEnhancementState;
import org.jetbrains.kotlin.load.java.JavaTypeQualifiersByElementType;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.PredefinedEnhancementInfoKt;
import org.jetbrains.kotlin.load.java.typeEnhancement.PredefinedFunctionEnhancementInfo;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementInfo;
import org.jetbrains.kotlin.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001FB4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001d\u0010\u0006\u001a\u0019\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001f2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J&\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J&\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010*\u001a\u00020\u000eH\u0002J0\u0010+\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010*\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002JH\u0010.\u001a\u00020&2\u0006\u0010'\u001a\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J \u00105\u001a\u0006\u0012\u0002\b\u00030\u001b2\n\u00106\u001a\u0006\u0012\u0002\b\u00030\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001e\u00107\u001a\u0006\u0012\u0002\b\u00030\u001f2\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u001d\u001a\u00020\u001eJL\u00109\u001a\u00020:*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J<\u0010C\u001a\u00020:*\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010D\u001a\u0004\u0018\u00010<2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020BH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0006\u001a\u0019\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement;", "", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "overridden", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/FirSession;Lkotlin/jvm/functions/Function1;)V", "context", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirJavaEnhancementContext;", "enhancements", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "javaTypeParameterStack", "Lorg/jetbrains/kotlin/fir/java/JavaTypeParameterStack;", "jsr305State", "Lorg/jetbrains/kotlin/load/java/JavaTypeEnhancementState;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "typeQualifierResolver", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirAnnotationTypeQualifierResolver;", "enhance", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "original", "name", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "enhanceMethod", "firMethod", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "methodId", "Lorg/jetbrains/kotlin/name/CallableId;", "enhanceReceiverType", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "ownerFunction", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaMethod;", "overriddenMembers", "memberContext", "enhanceReturnType", "predefinedEnhancementInfo", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/PredefinedFunctionEnhancementInfo;", "enhanceValueParameterType", "hasReceiver", "", "ownerParameter", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaValueParameter;", "index", "", "enhancedFunction", "function", "enhancedProperty", "property", "parts", "Lorg/jetbrains/kotlin/fir/java/enhancement/EnhancementSignatureParts;", "typeContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "isCovariant", "containerContext", "containerApplicabilityType", "Lorg/jetbrains/kotlin/load/java/AnnotationQualifierApplicabilityType;", "typeInSignature", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "partsForValueParameter", "parameterContainer", "methodContext", "TypeInSignature", "java"})
public final class FirSignatureEnhancement {
    @NotNull
    private final FirRegularClass owner;
    @NotNull
    private final FirSession session;
    @NotNull
    private final Function1<FirSimpleFunction, List<FirCallableDeclaration>> overridden;
    @NotNull
    private final FirModuleData moduleData;
    @NotNull
    private final JavaTypeParameterStack javaTypeParameterStack;
    @NotNull
    private final JavaTypeEnhancementState jsr305State;
    @NotNull
    private final FirAnnotationTypeQualifierResolver typeQualifierResolver;
    @NotNull
    private final FirJavaEnhancementContext context;
    @NotNull
    private final Map<FirCallableSymbol<?>, FirCallableSymbol<?>> enhancements;

    public FirSignatureEnhancement(@NotNull FirRegularClass owner, @NotNull FirSession session, @NotNull Function1<? super FirSimpleFunction, ? extends List<? extends FirCallableDeclaration>> overridden) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(overridden, (String)"overridden");
        this.owner = owner;
        this.session = session;
        this.overridden = overridden;
        this.moduleData = this.owner.getModuleData();
        this.javaTypeParameterStack = this.owner instanceof FirJavaClass ? ((FirJavaClass)this.owner).getJavaTypeParameterStack$java() : JavaTypeParameterStack.Companion.getEMPTY();
        this.jsr305State = JavaTypeEnhancementStateContainerKt.getJavaTypeEnhancementState(this.session);
        this.typeQualifierResolver = new FirAnnotationTypeQualifierResolver(this.session, this.jsr305State);
        this.context = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(new FirJavaEnhancementContext(this.session, (Function0<JavaTypeQualifiersByElementType>)((Function0)context.1.INSTANCE)), this.typeQualifierResolver, this.jsr305State, this.owner.getAnnotations());
        this.enhancements = new LinkedHashMap();
    }

    @NotNull
    public final FirFunctionSymbol<?> enhancedFunction(@NotNull FirFunctionSymbol<?> function2, @Nullable Name name) {
        FirCallableSymbol firCallableSymbol;
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        Map<FirCallableSymbol<?>, FirCallableSymbol<?>> $this$getOrPut$iv = this.enhancements;
        boolean $i$f$getOrPut = false;
        FirCallableSymbol value$iv = $this$getOrPut$iv.get(function2);
        if (value$iv == null) {
            FirSimpleFunction firSimpleFunction;
            FirFunctionSymbol<?> firFunctionSymbol;
            boolean bl = false;
            FirFunctionSymbol<?> enhancedVersion = firFunctionSymbol = this.enhance(function2, name);
            boolean bl2 = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.getInitialSignatureAttr((FirCallableDeclaration)enhancedVersion.getFir());
            FirSimpleFunction firSimpleFunction2 = firSimpleFunction = firCallableDeclaration instanceof FirSimpleFunction ? (FirSimpleFunction)firCallableDeclaration : null;
            if (firSimpleFunction != null) {
                FirCallableDeclaration it = firCallableDeclaration = firSimpleFunction;
                boolean bl3 = false;
                ClassMembersKt.setInitialSignatureAttr((FirCallableDeclaration)enhancedVersion.getFir(), (FirCallableDeclaration)this.enhancedFunction(((FirSimpleFunction)it).getSymbol(), ((FirSimpleFunction)it).getName()).getFir());
            }
            FirCallableSymbol answer$iv = firFunctionSymbol;
            $this$getOrPut$iv.put(function2, answer$iv);
            firCallableSymbol = answer$iv;
        } else {
            firCallableSymbol = value$iv;
        }
        return (FirFunctionSymbol)firCallableSymbol;
    }

    @NotNull
    public final FirVariableSymbol<?> enhancedProperty(@NotNull FirVariableSymbol<?> property2, @NotNull Name name) {
        FirCallableSymbol firCallableSymbol;
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<FirCallableSymbol<?>, FirCallableSymbol<?>> $this$getOrPut$iv = this.enhancements;
        boolean $i$f$getOrPut = false;
        FirCallableSymbol value$iv = $this$getOrPut$iv.get(property2);
        if (value$iv == null) {
            boolean bl = false;
            FirCallableSymbol answer$iv = this.enhance(property2, name);
            $this$getOrPut$iv.put(property2, answer$iv);
            firCallableSymbol = answer$iv;
        } else {
            firCallableSymbol = value$iv;
        }
        return (FirVariableSymbol)firCallableSymbol;
    }

    private final FirVariableSymbol<?> enhance(FirVariableSymbol<?> original, Name name) {
        FirVariable firElement = (FirVariable)original.getFir();
        if (firElement instanceof FirEnumEntry) {
            FirEnumEntrySymbol firEnumEntrySymbol;
            if (!(firElement.getReturnTypeRef() instanceof FirJavaTypeRef)) {
                return original;
            }
            FirJavaEnhancementContext memberContext = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(this.context, this.typeQualifierResolver, this.jsr305State, firElement.getAnnotations());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)new JavaTypeQualifiers(NullabilityQualifier.NOT_NULL, null, false, false, 8, null))};
            PredefinedFunctionEnhancementInfo predefinedInfo = new PredefinedFunctionEnhancementInfo(new TypeEnhancementInfo(pairArray), CollectionsKt.emptyList());
            FirResolvedTypeRef newReturnTypeRef = this.enhanceReturnType(firElement, CollectionsKt.emptyList(), memberContext, predefinedInfo);
            FirEnumEntrySymbol $this$enhance_u24lambda_u2d4 = firEnumEntrySymbol = ((FirEnumEntry)firElement).getSymbol();
            boolean bl = false;
            ((FirEnumEntry)$this$enhance_u24lambda_u2d4.getFir()).replaceReturnTypeRef(newReturnTypeRef);
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, newReturnTypeRef, ((FirEnumEntry)$this$enhance_u24lambda_u2d4.getFir()).getSource(), null);
            }
            return firEnumEntrySymbol;
        }
        if (firElement instanceof FirField) {
            FirJavaFieldBuilder $this$enhance_u24lambda_u2d4;
            if (!(firElement.getReturnTypeRef() instanceof FirJavaTypeRef)) {
                return original;
            }
            FirJavaEnhancementContext memberContext = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(this.context, this.typeQualifierResolver, this.jsr305State, firElement.getAnnotations());
            FirResolvedTypeRef newReturnTypeRef = this.enhanceReturnType(firElement, CollectionsKt.emptyList(), memberContext, null);
            FirFieldSymbol symbol2 = new FirFieldSymbol(original.getCallableId());
            boolean $i$f$buildJavaField = false;
            FirJavaFieldBuilder $this$enhance_u24lambda_u2d5 = $this$enhance_u24lambda_u2d4 = new FirJavaFieldBuilder();
            boolean bl = false;
            $this$enhance_u24lambda_u2d5.setSource(firElement.getSource());
            $this$enhance_u24lambda_u2d5.setModuleData(this.moduleData);
            $this$enhance_u24lambda_u2d5.setSymbol(symbol2);
            $this$enhance_u24lambda_u2d5.setName(name);
            $this$enhance_u24lambda_u2d5.setReturnTypeRef(newReturnTypeRef);
            FirMemberDeclaration $this$visibility$iv = firElement;
            boolean $i$f$getVisibility = false;
            $this$enhance_u24lambda_u2d5.setVisibility($this$visibility$iv.getStatus().getVisibility());
            FirMemberDeclaration $this$modality$iv = firElement;
            boolean $i$f$getModality = false;
            $this$enhance_u24lambda_u2d5.setModality($this$modality$iv.getStatus().getModality());
            $this$enhance_u24lambda_u2d5.setVar(firElement.isVar());
            FirMemberDeclaration $this$isStatic$iv = firElement;
            boolean $i$f$isStatic = false;
            $this$enhance_u24lambda_u2d5.setStatic($this$isStatic$iv.getStatus().isStatic());
            $this$enhance_u24lambda_u2d5.setAnnotationBuilder((Function0<? extends List<? extends FirAnnotationCall>>)((Function0)new Function0<List<? extends FirAnnotationCall>>(firElement){
                final /* synthetic */ FirVariable $firElement;
                {
                    this.$firElement = $firElement;
                    super(0);
                }

                @NotNull
                public final List<FirAnnotationCall> invoke() {
                    return this.$firElement.getAnnotations();
                }
            }));
            $this$enhance_u24lambda_u2d5.setStatus(firElement.getStatus());
            $this$enhance_u24lambda_u2d5.setInitializer(firElement.getInitializer());
            $this$enhance_u24lambda_u2d5.setDispatchReceiverType(firElement.getDispatchReceiverType());
            $this$enhance_u24lambda_u2d5.setAttributes(firElement.getAttributes().copy());
            $this$enhance_u24lambda_u2d4.build();
            return symbol2;
        }
        if (firElement instanceof FirSyntheticProperty) {
            FirSimpleFunction firSimpleFunction;
            FirSimpleFunction setterDelegate;
            FirAccessorSymbol accessorSymbol = ((FirSyntheticProperty)firElement).getSymbol();
            FirSimpleFunction getterDelegate = ((FirSyntheticProperty)firElement).getGetter().getDelegate();
            FirFunctionSymbol<?> enhancedGetterSymbol = getterDelegate instanceof FirJavaMethod ? this.enhanceMethod(getterDelegate, getterDelegate.getSymbol().getCallableId(), getterDelegate.getName()) : (FirFunctionSymbol<?>)getterDelegate.getSymbol();
            FirSyntheticPropertyAccessor $this$enhance_u24lambda_u2d4 = ((FirSyntheticProperty)firElement).getSetter();
            FirSimpleFunction firSimpleFunction2 = setterDelegate = $this$enhance_u24lambda_u2d4 == null ? null : $this$enhance_u24lambda_u2d4.getDelegate();
            FirFunctionSymbol<?> enhancedSetterSymbol = setterDelegate instanceof FirJavaMethod ? this.enhanceMethod(setterDelegate, ((FirJavaMethod)setterDelegate).getSymbol().getCallableId(), ((FirJavaMethod)setterDelegate).getName()) : (FirFunctionSymbol<?>)((firSimpleFunction = setterDelegate) == null ? null : firSimpleFunction.getSymbol());
            return FirSyntheticPropertyBuilderKt.buildSyntheticProperty((Function1<? super FirSyntheticPropertyBuilder, Unit>)((Function1)new Function1<FirSyntheticPropertyBuilder, Unit>(this, name, accessorSymbol, enhancedGetterSymbol, enhancedSetterSymbol, firElement){
                final /* synthetic */ FirSignatureEnhancement this$0;
                final /* synthetic */ Name $name;
                final /* synthetic */ FirAccessorSymbol $accessorSymbol;
                final /* synthetic */ FirFunctionSymbol<? extends FirFunction> $enhancedGetterSymbol;
                final /* synthetic */ FirFunctionSymbol<? extends FirFunction> $enhancedSetterSymbol;
                final /* synthetic */ FirVariable $firElement;
                {
                    this.this$0 = $receiver;
                    this.$name = $name;
                    this.$accessorSymbol = $accessorSymbol;
                    this.$enhancedGetterSymbol = $enhancedGetterSymbol;
                    this.$enhancedSetterSymbol = $enhancedSetterSymbol;
                    this.$firElement = $firElement;
                    super(1);
                }

                public final void invoke(@NotNull FirSyntheticPropertyBuilder $this$buildSyntheticProperty) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildSyntheticProperty, (String)"$this$buildSyntheticProperty");
                    $this$buildSyntheticProperty.setModuleData(FirSignatureEnhancement.access$getModuleData$p(this.this$0));
                    $this$buildSyntheticProperty.setName(this.$name);
                    $this$buildSyntheticProperty.setSymbol(new FirAccessorSymbol(this.$accessorSymbol.getCallableId(), this.$accessorSymbol.getAccessorId()));
                    $this$buildSyntheticProperty.setDelegateGetter((FirSimpleFunction)this.$enhancedGetterSymbol.getFir());
                    FirFunctionSymbol<? extends FirFunction> firFunctionSymbol = this.$enhancedSetterSymbol;
                    $this$buildSyntheticProperty.setDelegateSetter((FirSimpleFunction)(firFunctionSymbol == null ? null : (FirFunction)firFunctionSymbol.getFir()));
                    $this$buildSyntheticProperty.setStatus(this.$firElement.getStatus());
                    $this$buildSyntheticProperty.setDeprecation(DeprecationUtilsKt.getDeprecationsFromAccessors($this$buildSyntheticProperty.getDelegateGetter(), $this$buildSyntheticProperty.getDelegateSetter(), FirLanguageSettingsComponentKt.getLanguageVersionSettings(FirSignatureEnhancement.access$getSession$p(this.this$0)).getApiVersion()));
                }
            })).getSymbol();
        }
        if (original instanceof FirPropertySymbol || original instanceof FirAccessorSymbol) {
            return original;
        }
        throw new IllegalStateException(("Can't make enhancement for " + original + ": `" + FirRendererKt.render$default(firElement, null, 1, null) + '`').toString());
    }

    private final FirFunctionSymbol<?> enhance(FirFunctionSymbol<?> original, Name name) {
        FirFunction firMethod = (FirFunction)original.getFir();
        if (!(firMethod instanceof FirJavaMethod) && !(firMethod instanceof FirJavaConstructor)) {
            return original;
        }
        return this.enhanceMethod(firMethod, original.getCallableId(), name);
    }

    /*
     * WARNING - void declaration
     */
    private final FirFunctionSymbol<?> enhanceMethod(FirFunction firMethod, CallableId methodId, Name name) {
        FirFunctionBuilder firFunctionBuilder;
        Iterable iterable;
        Object symbol2;
        Object object;
        Object object2;
        Object object3;
        Object element$iv2;
        boolean bl;
        List overriddenMembers;
        PredefinedFunctionEnhancementInfo predefinedEnhancementInfo2;
        FirJavaEnhancementContext memberContext;
        block19: {
            Unit unit2;
            Object object4;
            memberContext = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(this.context, this.typeQualifierResolver, this.jsr305State, firMethod.getAnnotations());
            Object signature2 = object4 = SignatureBuildingComponents.INSTANCE.signature(this.owner.getSymbol().getClassId(), DescriptorUtilsKt.computeJvmDescriptor$default(firMethod, null, false, (Function1)new Function1<FirTypeRef, ConeKotlinType>(this){
                final /* synthetic */ FirSignatureEnhancement this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final ConeKotlinType invoke(@NotNull FirTypeRef it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return JavaUtilsKt.toConeKotlinTypeProbablyFlexible(it, FirSignatureEnhancement.access$getSession$p(this.this$0), FirSignatureEnhancement.access$getJavaTypeParameterStack$p(this.this$0));
                }
            }, 3, null));
            boolean bl2 = false;
            predefinedEnhancementInfo2 = PredefinedEnhancementInfoKt.getPREDEFINED_FUNCTION_ENHANCEMENT_INFO_BY_SIGNATURE().get(signature2);
            object4 = predefinedEnhancementInfo2;
            if (object4 == null) {
                unit2 = null;
            } else {
                boolean bl3;
                Object it = signature2 = object4;
                boolean bl4 = false;
                boolean bl5 = bl3 = ((PredefinedFunctionEnhancementInfo)it).getParametersInfo().size() == firMethod.getValueParameters().size();
                if (_Assertions.ENABLED && !bl3) {
                    boolean $i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22 = false;
                    String $i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22 = "Predefined enhancement info for " + this + " has " + ((PredefinedFunctionEnhancementInfo)it).getParametersInfo().size() + ", but " + firMethod.getValueParameters().size() + " expected";
                    throw new AssertionError((Object)$i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22);
                }
                unit2 = Unit.INSTANCE;
            }
            signature2 = firMethod instanceof FirSimpleFunction ? (FirSimpleFunction)firMethod : null;
            List it = signature2 == null ? null : (List)this.overridden.invoke(signature2);
            overriddenMembers = it == null ? CollectionsKt.emptyList() : it;
            Iterable $this$any$iv = overriddenMembers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    FirCallableDeclaration it2 = (FirCallableDeclaration)element$iv2;
                    boolean bl6 = false;
                    if (!(it2.getReceiverTypeRef() != null)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        boolean hasReceiver = bl;
        FirResolvedTypeRef newReceiverTypeRef = firMethod instanceof FirJavaMethod && hasReceiver ? this.enhanceReceiverType((FirJavaMethod)firMethod, overriddenMembers, memberContext) : null;
        FirTypeRef newReturnTypeRef = !(firMethod instanceof FirJavaMethod) ? firMethod.getReturnTypeRef() : (FirTypeRef)this.enhanceReturnType(firMethod, overriddenMembers, memberContext, predefinedEnhancementInfo2);
        List enhancedValueParameterTypes = new ArrayList();
        element$iv2 = firMethod.getValueParameters().iterator();
        int it2 = 0;
        while (element$iv2.hasNext()) {
            int index2 = it2++;
            FirValueParameter valueParameter2 = (FirValueParameter)element$iv2.next();
            if (hasReceiver && index2 == 0) continue;
            ((Collection)enhancedValueParameterTypes).add(this.enhanceValueParameterType(firMethod, overriddenMembers, hasReceiver, memberContext, predefinedEnhancementInfo2, (FirJavaValueParameter)valueParameter2, hasReceiver ? index2 - 1 : index2));
        }
        Iterable $this$zip$iv = firMethod.getValueParameters();
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Object second$iv = ((Iterable)enhancedValueParameterTypes).iterator();
        ArrayList<FirValueParameter> list$iv = new ArrayList<FirValueParameter>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)enhancedValueParameterTypes, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void enhancedReturnType;
            Unit unit3;
            void valueParameter3;
            object3 = (FirResolvedTypeRef)second$iv.next();
            object2 = (FirValueParameter)first$iv.next();
            ArrayList<FirValueParameter> arrayList = list$iv;
            boolean bl7 = false;
            FirExpression firExpression2 = valueParameter3.getDefaultValue();
            if (firExpression2 == null) {
                unit3 = null;
            } else {
                firExpression2.replaceTypeRef((FirTypeRef)enhancedReturnType);
                unit3 = Unit.INSTANCE;
            }
            boolean $i$f$buildValueParameter = false;
            object = new FirValueParameterBuilder();
            FirValueParameterBuilder $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10 = object;
            boolean bl8 = false;
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setSource(valueParameter3.getSource());
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setModuleData(this.moduleData);
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setReturnTypeRef((FirTypeRef)enhancedReturnType);
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setName(valueParameter3.getName());
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setSymbol(new FirValueParameterSymbol($this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.getName()));
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setDefaultValue(valueParameter3.getDefaultValue());
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setCrossinline(valueParameter3.isCrossinline());
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setNoinline(valueParameter3.isNoinline());
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setVararg(valueParameter3.isVararg());
            $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            FirValueParameterBuilder firValueParameterBuilder = $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10;
            CollectionsKt.addAll((Collection)firValueParameterBuilder.getAnnotations(), (Iterable)valueParameter3.getAnnotations());
            FirValueParameter firValueParameter = ((FirValueParameterBuilder)object).build();
            arrayList.add(firValueParameter);
        }
        List newValueParameters = list$iv;
        Object object5 = firMethod;
        if (object5 instanceof FirJavaConstructor) {
            FirAbstractConstructorBuilder firAbstractConstructorBuilder;
            symbol2 = new FirConstructorSymbol(methodId);
            if (((FirJavaConstructor)firMethod).isPrimary()) {
                void $this$enhanceMethod_u24lambda_u2d13_u24lambda_u2d12;
                FirDeclarationStatusImpl firDeclarationStatusImpl;
                FirResolvedDeclarationStatus resolvedStatus;
                Object $this$enhanceMethod_u24lambda_u2d13 = second$iv = new FirPrimaryConstructorBuilder();
                boolean bl9 = false;
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setReturnTypeRef(newReturnTypeRef);
                FirDeclarationStatus $this$safeAs$iv = ((FirJavaConstructor)firMethod).getStatus();
                boolean $i$f$safeAs = false;
                FirDeclarationStatus firDeclarationStatus = $this$safeAs$iv;
                if (!(firDeclarationStatus instanceof FirResolvedDeclarationStatus)) {
                    firDeclarationStatus = null;
                }
                if ((resolvedStatus = (FirResolvedDeclarationStatus)firDeclarationStatus) != null) {
                    firDeclarationStatusImpl = new FirResolvedDeclarationStatusImpl(resolvedStatus.getVisibility(), Modality.FINAL, resolvedStatus.getEffectiveVisibility());
                } else {
                    FirMemberDeclaration $this$visibility$iv = firMethod;
                    boolean $i$f$getVisibility = false;
                    FirDeclarationStatusImpl firDeclarationStatusImpl2 = new FirDeclarationStatusImpl($this$visibility$iv.getStatus().getVisibility(), Modality.FINAL);
                    firDeclarationStatusImpl = firDeclarationStatusImpl2;
                }
                object2 = firDeclarationStatusImpl;
                FirPureAbstractElement $i$f$getVisibility = object2;
                object = $this$enhanceMethod_u24lambda_u2d13;
                boolean bl10 = false;
                $this$enhanceMethod_u24lambda_u2d13_u24lambda_u2d12.setExpect(false);
                $this$enhanceMethod_u24lambda_u2d13_u24lambda_u2d12.setActual(false);
                $this$enhanceMethod_u24lambda_u2d13_u24lambda_u2d12.setOverride(false);
                FirMemberDeclaration $this$isInner$iv = firMethod;
                boolean $i$f$isInner = false;
                $this$enhanceMethod_u24lambda_u2d13_u24lambda_u2d12.setInner($this$isInner$iv.getStatus().isInner());
                Unit unit4 = Unit.INSTANCE;
                ((FirPrimaryConstructorBuilder)object).setStatus((FirDeclarationStatus)object2);
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setSymbol((FirConstructorSymbol)symbol2);
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setDispatchReceiverType(firMethod.getDispatchReceiverType());
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setAttributes(firMethod.getAttributes().copy());
                firAbstractConstructorBuilder = (FirAbstractConstructorBuilder)second$iv;
            } else {
                Object $this$enhanceMethod_u24lambda_u2d14 = second$iv = new FirConstructorBuilder();
                boolean bl11 = false;
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d14).setReturnTypeRef(newReturnTypeRef);
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d14).setStatus(((FirJavaConstructor)firMethod).getStatus());
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d14).setSymbol((FirConstructorSymbol)symbol2);
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d14).setDispatchReceiverType(firMethod.getDispatchReceiverType());
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d14).setAttributes(firMethod.getAttributes().copy());
                firAbstractConstructorBuilder = (FirAbstractConstructorBuilder)second$iv;
            }
            Object $this$enhanceMethod_u24lambda_u2d15 = second$iv = firAbstractConstructorBuilder;
            boolean bl12 = false;
            $this$enhanceMethod_u24lambda_u2d15.setSource(firMethod.getSource());
            $this$enhanceMethod_u24lambda_u2d15.setModuleData(this.moduleData);
            $this$enhanceMethod_u24lambda_u2d15.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            $this$enhanceMethod_u24lambda_u2d15.setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            object2 = $this$enhanceMethod_u24lambda_u2d15;
            iterable = object2.getValueParameters();
            CollectionsKt.addAll((Collection)iterable, (Iterable)newValueParameters);
            object2 = $this$enhanceMethod_u24lambda_u2d15;
            iterable = object2.getTypeParameters();
            Iterable iterable2 = ((FirJavaConstructor)firMethod).getTypeParameters();
            CollectionsKt.addAll((Collection)iterable, (Iterable)iterable2);
            firFunctionBuilder = (FirFunctionBuilder)second$iv;
        } else if (object5 instanceof FirJavaMethod) {
            Object $this$enhanceMethod_u24lambda_u2d16 = symbol2 = new FirSimpleFunctionBuilder();
            boolean bl13 = false;
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setSource(firMethod.getSource());
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setModuleData(this.moduleData);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setReturnTypeRef(newReturnTypeRef);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setReceiverTypeRef(newReceiverTypeRef);
            Name name2 = name;
            Intrinsics.checkNotNull((Object)name2);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setName(name2);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setStatus(((FirJavaMethod)firMethod).getStatus());
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setSymbol(new FirNamedFunctionSymbol(methodId));
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            object3 = $this$enhanceMethod_u24lambda_u2d16;
            object2 = ((FirSimpleFunctionBuilder)object3).getValueParameters();
            CollectionsKt.addAll((Collection)object2, (Iterable)newValueParameters);
            object3 = $this$enhanceMethod_u24lambda_u2d16;
            object2 = ((FirSimpleFunctionBuilder)object3).getTypeParameters();
            iterable = ((FirJavaMethod)firMethod).getTypeParameters();
            CollectionsKt.addAll((Collection)object2, (Iterable)iterable);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setDispatchReceiverType(firMethod.getDispatchReceiverType());
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d16).setAttributes(firMethod.getAttributes().copy());
            firFunctionBuilder = (FirFunctionBuilder)symbol2;
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unknown Java method to enhance: ", (Object)FirRendererKt.render$default(firMethod, null, 1, null)));
        }
        Object $this$enhanceMethod_u24lambda_u2d17 = object5 = firFunctionBuilder;
        boolean bl14 = false;
        Object object6 = $this$enhanceMethod_u24lambda_u2d17;
        CollectionsKt.addAll((Collection)object6.getAnnotations(), (Iterable)firMethod.getAnnotations());
        $this$enhanceMethod_u24lambda_u2d17.setDeprecation(DeprecationUtilsKt.getDeprecationInfosFromAnnotations($this$enhanceMethod_u24lambda_u2d17.getAnnotations(), FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).getApiVersion(), true));
        FirFunction function2 = object5.build();
        return function2.getSymbol();
    }

    private final FirResolvedTypeRef enhanceReceiverType(FirJavaMethod ownerFunction, List<? extends FirCallableDeclaration> overriddenMembers, FirJavaEnhancementContext memberContext) {
        EnhancementSignatureParts.PartEnhancementResult signatureParts = EnhancementSignatureParts.enhance$java$default(this.partsForValueParameter(ownerFunction, this.typeQualifierResolver, overriddenMembers, ownerFunction, memberContext, TypeInSignature.Receiver.INSTANCE), this.session, this.jsr305State, null, false, 12, null);
        return signatureParts.getType();
    }

    private final FirResolvedTypeRef enhanceValueParameterType(FirFunction ownerFunction, List<? extends FirCallableDeclaration> overriddenMembers, boolean hasReceiver, FirJavaEnhancementContext memberContext, PredefinedFunctionEnhancementInfo predefinedEnhancementInfo2, FirJavaValueParameter ownerParameter, int index2) {
        TypeEnhancementInfo typeEnhancementInfo;
        if (ownerParameter.getReturnTypeRef() instanceof FirResolvedTypeRef) {
            return (FirResolvedTypeRef)ownerParameter.getReturnTypeRef();
        }
        EnhancementSignatureParts enhancementSignatureParts = this.partsForValueParameter(ownerFunction, this.typeQualifierResolver, overriddenMembers, ownerParameter, memberContext, new TypeInSignature.ValueParameter(hasReceiver, index2));
        PredefinedFunctionEnhancementInfo predefinedFunctionEnhancementInfo = predefinedEnhancementInfo2;
        if (predefinedFunctionEnhancementInfo == null) {
            typeEnhancementInfo = null;
        } else {
            List<TypeEnhancementInfo> list2 = predefinedFunctionEnhancementInfo.getParametersInfo();
            typeEnhancementInfo = (TypeEnhancementInfo)CollectionsKt.getOrNull(list2, (int)index2);
        }
        EnhancementSignatureParts.PartEnhancementResult signatureParts = enhancementSignatureParts.enhance$java(this.session, this.jsr305State, typeEnhancementInfo, this.owner.getClassKind() == ClassKind.ANNOTATION_CLASS);
        return signatureParts.getType();
    }

    private final FirResolvedTypeRef enhanceReturnType(FirCallableDeclaration owner, List<? extends FirCallableDeclaration> overriddenMembers, FirJavaEnhancementContext memberContext, PredefinedFunctionEnhancementInfo predefinedEnhancementInfo2) {
        PredefinedFunctionEnhancementInfo predefinedFunctionEnhancementInfo = predefinedEnhancementInfo2;
        EnhancementSignatureParts.PartEnhancementResult signatureParts = this.parts(owner, this.typeQualifierResolver, overriddenMembers, owner, true, memberContext, owner instanceof FirJavaField ? AnnotationQualifierApplicabilityType.FIELD : AnnotationQualifierApplicabilityType.METHOD_RETURN_TYPE, TypeInSignature.Return.INSTANCE).enhance$java(this.session, this.jsr305State, predefinedFunctionEnhancementInfo == null ? null : predefinedFunctionEnhancementInfo.getReturnTypeInfo(), this.owner.getClassKind() == ClassKind.ANNOTATION_CLASS);
        return signatureParts.getType();
    }

    /*
     * WARNING - void declaration
     */
    private final EnhancementSignatureParts partsForValueParameter(FirFunction $this$partsForValueParameter, FirAnnotationTypeQualifierResolver typeQualifierResolver, List<? extends FirCallableDeclaration> overriddenMembers, FirAnnotationContainer parameterContainer, FirJavaEnhancementContext methodContext2, TypeInSignature typeInSignature) {
        FirJavaEnhancementContext firJavaEnhancementContext;
        FirSignatureEnhancement firSignatureEnhancement = this;
        FirCallableDeclaration firCallableDeclaration = $this$partsForValueParameter;
        FirAnnotationTypeQualifierResolver firAnnotationTypeQualifierResolver = typeQualifierResolver;
        List<? extends FirCallableDeclaration> list2 = overriddenMembers;
        FirAnnotationContainer firAnnotationContainer = parameterContainer;
        boolean bl = false;
        FirAnnotationContainer firAnnotationContainer2 = parameterContainer;
        if (firAnnotationContainer2 == null) {
            firJavaEnhancementContext = methodContext2;
        } else {
            void it;
            FirAnnotationContainer firAnnotationContainer3;
            FirAnnotationContainer firAnnotationContainer4 = firAnnotationContainer3 = firAnnotationContainer2;
            boolean bl2 = bl;
            FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer;
            List<? extends FirCallableDeclaration> list3 = list2;
            FirAnnotationTypeQualifierResolver firAnnotationTypeQualifierResolver2 = firAnnotationTypeQualifierResolver;
            FirCallableDeclaration firCallableDeclaration2 = firCallableDeclaration;
            FirSignatureEnhancement firSignatureEnhancement2 = firSignatureEnhancement;
            boolean bl3 = false;
            FirJavaEnhancementContext firJavaEnhancementContext2 = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(methodContext2, typeQualifierResolver, this.jsr305State, it.getAnnotations());
            firSignatureEnhancement = firSignatureEnhancement2;
            firCallableDeclaration = firCallableDeclaration2;
            firAnnotationTypeQualifierResolver = firAnnotationTypeQualifierResolver2;
            list2 = list3;
            firAnnotationContainer = firAnnotationContainer5;
            bl = bl2;
            firJavaEnhancementContext = firJavaEnhancementContext2;
        }
        return firSignatureEnhancement.parts(firCallableDeclaration, firAnnotationTypeQualifierResolver, list2, firAnnotationContainer, bl, firJavaEnhancementContext, AnnotationQualifierApplicabilityType.VALUE_PARAMETER, typeInSignature);
    }

    /*
     * WARNING - void declaration
     */
    private final EnhancementSignatureParts parts(FirCallableDeclaration $this$parts, FirAnnotationTypeQualifierResolver typeQualifierResolver, List<? extends FirCallableDeclaration> overriddenMembers, FirAnnotationContainer typeContainer, boolean isCovariant, FirJavaEnhancementContext containerContext, AnnotationQualifierApplicabilityType containerApplicabilityType, TypeInSignature typeInSignature) {
        Collection<FirTypeRef> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FirTypeRef typeRef = typeInSignature.getTypeRef($this$parts);
        Iterable iterable = overriddenMembers;
        FirJavaTypeRef firJavaTypeRef = (FirJavaTypeRef)typeRef;
        JavaTypeParameterStack javaTypeParameterStack = this.javaTypeParameterStack;
        FirAnnotationContainer firAnnotationContainer = typeContainer;
        FirAnnotationTypeQualifierResolver firAnnotationTypeQualifierResolver = typeQualifierResolver;
        boolean $i$f$map = false;
        void var12_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirTypeRef firTypeRef = typeInSignature.getTypeRef((FirCallableDeclaration)it);
            collection.add(firTypeRef);
        }
        collection = (List)destination$iv$iv;
        AnnotationQualifierApplicabilityType annotationQualifierApplicabilityType = containerApplicabilityType;
        FirJavaEnhancementContext firJavaEnhancementContext = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(containerContext, typeQualifierResolver, this.jsr305State, typeRef.getAnnotations());
        boolean bl = isCovariant;
        Collection collection2 = collection;
        FirJavaTypeRef firJavaTypeRef2 = firJavaTypeRef;
        JavaTypeParameterStack javaTypeParameterStack2 = javaTypeParameterStack;
        FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer;
        FirAnnotationTypeQualifierResolver firAnnotationTypeQualifierResolver2 = firAnnotationTypeQualifierResolver;
        return new EnhancementSignatureParts(firAnnotationTypeQualifierResolver2, firAnnotationContainer2, javaTypeParameterStack2, firJavaTypeRef2, collection2, bl, firJavaEnhancementContext, annotationQualifierApplicabilityType);
    }

    public static final /* synthetic */ FirModuleData access$getModuleData$p(FirSignatureEnhancement $this) {
        return $this.moduleData;
    }

    public static final /* synthetic */ FirSession access$getSession$p(FirSignatureEnhancement $this) {
        return $this.session;
    }

    public static final /* synthetic */ JavaTypeParameterStack access$getJavaTypeParameterStack$p(FirSignatureEnhancement $this) {
        return $this.javaTypeParameterStack;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Receiver", "Return", "ValueParameter", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Return;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Receiver;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$ValueParameter;", "java"})
    private static abstract class TypeInSignature {
        private TypeInSignature() {
        }

        @NotNull
        public abstract FirTypeRef getTypeRef(@NotNull FirCallableDeclaration var1);

        public /* synthetic */ TypeInSignature(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Return;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "java"})
        public static final class Return
        extends TypeInSignature {
            @NotNull
            public static final Return INSTANCE = new Return();

            private Return() {
                super(null);
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableDeclaration member2) {
                Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
                return member2.getReturnTypeRef();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Receiver;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "java"})
        public static final class Receiver
        extends TypeInSignature {
            @NotNull
            public static final Receiver INSTANCE = new Receiver();

            private Receiver() {
                super(null);
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableDeclaration member2) {
                Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
                if (member2 instanceof FirJavaMethod) {
                    return ((FirJavaMethod)member2).getValueParameters().get(0).getReturnTypeRef();
                }
                FirTypeRef firTypeRef = member2.getReceiverTypeRef();
                Intrinsics.checkNotNull((Object)firTypeRef);
                return firTypeRef;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$ValueParameter;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "hasReceiver", "", "index", "", "(ZI)V", "getHasReceiver", "()Z", "getIndex", "()I", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "java"})
        public static final class ValueParameter
        extends TypeInSignature {
            private final boolean hasReceiver;
            private final int index;

            public ValueParameter(boolean hasReceiver, int index2) {
                super(null);
                this.hasReceiver = hasReceiver;
                this.index = index2;
            }

            public final boolean getHasReceiver() {
                return this.hasReceiver;
            }

            public final int getIndex() {
                return this.index;
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableDeclaration member2) {
                Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
                if (this.hasReceiver && member2 instanceof FirJavaMethod) {
                    return ((FirJavaMethod)member2).getValueParameters().get(this.index + 1).getReturnTypeRef();
                }
                return ((FirFunction)member2).getValueParameters().get(this.index).getReturnTypeRef();
            }
        }
    }
}

