/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationBuildingUtilsKt;
import org.jetbrains.kotlin.fir.deserialization.AbstractAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.SuspendTypeUtilsKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020!H\u0002J3\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002\u00a2\u0006\u0002\u00103J5\u00104\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002\u00a2\u0006\u0002\u00103J\u0018\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u0002082\u0006\u00101\u001a\u000202J\u000e\u00109\u001a\u00020:2\u0006\u00107\u001a\u000208J\u0016\u00109\u001a\u00020:2\u0006\u00107\u001a\u0002082\u0006\u00101\u001a\u000202J\u0010\u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020=H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020!H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u00107\u001a\u000208H\u0002J\f\u0010C\u001a\u00020D*\u00020EH\u0002J\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b*\u0006\u0012\u0002\b\u00030GR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001a0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001a0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "annotationDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "typeParameterProtos", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "parent", "containingSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;Ljava/util/List;Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "getAnnotationDeserializer", "()Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "getContainingSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "ownTypeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getOwnTypeParameters", "()Ljava/util/List;", "getParent", "()Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "typeParameterDescriptors", "", "", "typeParameterNames", "", "getTypeTable", "()Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "computeClassifier", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "fqNameIndex", "createSuspendFunctionType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "functionTypeConstructor", "arguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "isNullable", "", "attributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "(Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;ZLorg/jetbrains/kotlin/fir/types/ConeAttributes;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "createSuspendFunctionTypeForBasicCase", "simpleType", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeArgument", "typeArgumentProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "typeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "typeParameterId", "typeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierLookupTag;", "convertVariance", "Lorg/jetbrains/kotlin/types/Variance;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Variance;", "typeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "fir-deserialization"})
public final class FirTypeDeserializer {
    @NotNull
    private final FirModuleData moduleData;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;
    @NotNull
    private final AbstractAnnotationDeserializer annotationDeserializer;
    @Nullable
    private final FirTypeDeserializer parent;
    @Nullable
    private final FirBasedSymbol<?> containingSymbol;
    @NotNull
    private final Map<Integer, FirTypeParameterSymbol> typeParameterDescriptors;
    @NotNull
    private final Map<String, FirTypeParameterSymbol> typeParameterNames;

    /*
     * WARNING - void declaration
     */
    public FirTypeDeserializer(@NotNull FirModuleData moduleData, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @NotNull AbstractAnnotationDeserializer annotationDeserializer, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @Nullable FirTypeDeserializer parent2, @Nullable FirBasedSymbol<?> containingSymbol) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)annotationDeserializer, (String)"annotationDeserializer");
        Intrinsics.checkNotNullParameter(typeParameterProtos, (String)"typeParameterProtos");
        this.moduleData = moduleData;
        this.nameResolver = nameResolver2;
        this.typeTable = typeTable;
        this.annotationDeserializer = annotationDeserializer;
        this.parent = parent2;
        this.containingSymbol = containingSymbol;
        Collection collection = typeParameterProtos;
        this.typeParameterDescriptors = !collection.isEmpty() ? (Map)new LinkedHashMap() : MapsKt.emptyMap();
        collection = typeParameterProtos;
        if (!collection.isEmpty()) {
            Object object;
            Object object2;
            this.typeParameterNames = new LinkedHashMap();
            LinkedHashMap result2 = (LinkedHashMap)this.typeParameterDescriptors;
            List builders = new ArrayList();
            for (ProtoBuf.TypeParameter proto : typeParameterProtos) {
                if (!proto.hasId()) continue;
                Name name = NameResolverUtilKt.getName(this.nameResolver, proto.getName());
                Object object3 = new FirTypeParameterSymbol();
                FirTypeParameterSymbol it = object3;
                boolean bl = false;
                Map<String, FirTypeParameterSymbol> map = this.typeParameterNames;
                object2 = name.asString();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"name.asString()");
                map.put((String)object2, it);
                FirTypeParameterSymbol symbol2 = object3;
                object3 = builders;
                object = new FirTypeParameterBuilder();
                FirTypeParameterBuilder $this$_init__u24lambda_u2d1 = object;
                boolean bl2 = false;
                $this$_init__u24lambda_u2d1.setModuleData(this.getModuleData());
                $this$_init__u24lambda_u2d1.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
                $this$_init__u24lambda_u2d1.setOrigin(FirDeclarationOrigin.Library.INSTANCE);
                $this$_init__u24lambda_u2d1.setName(name);
                $this$_init__u24lambda_u2d1.setSymbol(symbol2);
                $this$_init__u24lambda_u2d1.setContainingDeclarationSymbol(this.getContainingSymbol());
                object2 = proto.getVariance();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.variance");
                $this$_init__u24lambda_u2d1.setVariance(this.convertVariance((ProtoBuf.TypeParameter.Variance)object2));
                $this$_init__u24lambda_u2d1.setReified(proto.getReified());
                object3.add(object);
                object3 = result2;
                object = proto.getId();
                object3.put(object, symbol2);
            }
            Iterator<ProtoBuf.TypeParameter> iterator2 = typeParameterProtos.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                void $this$mapTo$iv;
                int index2 = n++;
                ProtoBuf.TypeParameter proto = iterator2.next();
                FirTypeParameterBuilder builder = (FirTypeParameterBuilder)builders.get(index2);
                object = builder;
                FirTypeParameterBuilder $this$_init__u24lambda_u2d4 = object;
                boolean bl = false;
                object2 = ProtoTypeTableUtilKt.upperBounds(proto, this.getTypeTable());
                Collection destination$iv = $this$_init__u24lambda_u2d4.getBounds();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
                    ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv;
                    Collection collection2 = destination$iv;
                    boolean bl3 = false;
                    boolean $i$f$buildResolvedTypeRef = false;
                    FirResolvedTypeRefBuilder $this$lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                    boolean bl4 = false;
                    $this$lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.setType(this.type((ProtoBuf.Type)it));
                    FirResolvedTypeRef firResolvedTypeRef = firResolvedTypeRefBuilder.build();
                    collection2.add(firResolvedTypeRef);
                }
                FirDeclarationBuildingUtilsKt.addDefaultBoundIfNecessary$default($this$_init__u24lambda_u2d4, false, 1, null);
                ((FirTypeParameterBuilder)object).build();
            }
        } else {
            this.typeParameterNames = MapsKt.emptyMap();
        }
    }

    @NotNull
    public final FirModuleData getModuleData() {
        return this.moduleData;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    @NotNull
    public final AbstractAnnotationDeserializer getAnnotationDeserializer() {
        return this.annotationDeserializer;
    }

    @Nullable
    public final FirTypeDeserializer getParent() {
        return this.parent;
    }

    @Nullable
    public final FirBasedSymbol<?> getContainingSymbol() {
        return this.containingSymbol;
    }

    @NotNull
    public final List<FirTypeParameterSymbol> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    private final ConeClassLikeLookupTag computeClassifier(int fqNameIndex) {
        try {
            ClassId classId;
            ClassId it = classId = NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex);
            boolean bl = false;
            ClassId classId2 = !it.isLocal() ? classId : null;
            ClassId id = classId2 == null ? StandardClassIds.INSTANCE.getAny() : classId2;
            return new ConeClassLikeLookupTagImpl(id);
        }
        catch (Throwable e) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Looking up for ", (Object)NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex)), e);
        }
    }

    @NotNull
    public final ConeKotlinType type(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        List<FirAnnotationCall> annotations2 = this.annotationDeserializer.loadTypeAnnotations(proto, this.nameResolver);
        ConeAttributes attributes2 = FirTypeUtilsKt.computeTypeAttributes$default(annotations2, null, 1, null);
        return this.type(proto, attributes2);
    }

    @NotNull
    public final ConeKotlinType type(@NotNull ProtoBuf.Type proto, @NotNull ConeAttributes attributes2) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            ConeSimpleKotlinType lowerBound = this.simpleType(proto, attributes2);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.typeTable);
            Intrinsics.checkNotNull((Object)type2);
            ConeSimpleKotlinType upperBound = this.simpleType(type2, attributes2);
            ConeSimpleKotlinType coneSimpleKotlinType = lowerBound;
            Intrinsics.checkNotNull((Object)coneSimpleKotlinType);
            ConeKotlinType coneKotlinType = coneSimpleKotlinType;
            ConeSimpleKotlinType coneSimpleKotlinType2 = upperBound;
            Intrinsics.checkNotNull((Object)coneSimpleKotlinType2);
            return new ConeFlexibleType(coneKotlinType, coneSimpleKotlinType2);
        }
        ConeSimpleKotlinType coneSimpleKotlinType = this.simpleType(proto, attributes2);
        return coneSimpleKotlinType == null ? (ConeKotlinType)new ConeClassErrorType(new ConeSimpleDiagnostic("?!id:0", DiagnosticKind.DeserializationError), false, 2, null) : (ConeKotlinType)coneSimpleKotlinType;
    }

    private final ConeTypeParameterLookupTag typeParameterSymbol(int typeParameterId) {
        FirTypeDeserializer firTypeDeserializer;
        FirTypeParameterSymbol firTypeParameterSymbol = this.typeParameterDescriptors.get(typeParameterId);
        return firTypeParameterSymbol == null ? ((firTypeDeserializer = this.parent) == null ? null : firTypeDeserializer.typeParameterSymbol(typeParameterId)) : firTypeParameterSymbol.toLookupTag();
    }

    private final Variance convertVariance(ProtoBuf.TypeParameter.Variance $this$convertVariance) {
        Variance variance;
        ProtoBuf.TypeParameter.Variance variance2 = $this$convertVariance;
        int n = WhenMappings.$EnumSwitchMapping$0[variance2.ordinal()];
        switch (n) {
            case 1: {
                variance = Variance.IN_VARIANCE;
                break;
            }
            case 2: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            case 3: {
                variance = Variance.INVARIANT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> typeParameters(@NotNull FirClassLikeSymbol<?> $this$typeParameters) {
        List list2;
        FirTypeParameterRefsOwner firTypeParameterRefsOwner;
        Intrinsics.checkNotNullParameter($this$typeParameters, (String)"<this>");
        Object object = $this$typeParameters.getFir();
        FirTypeParameterRefsOwner firTypeParameterRefsOwner2 = firTypeParameterRefsOwner = object instanceof FirTypeParameterRefsOwner ? (FirTypeParameterRefsOwner)object : null;
        if (firTypeParameterRefsOwner == null) {
            list2 = null;
        } else {
            void $this$mapTo$iv$iv;
            object = firTypeParameterRefsOwner.getTypeParameters();
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirTypeParameterSymbol firTypeParameterSymbol = it.getSymbol();
                collection.add(firTypeParameterSymbol);
            }
            list2 = (List)destination$iv$iv;
        }
        object = list2;
        return object == null ? CollectionsKt.emptyList() : object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConeSimpleKotlinType simpleType(@NotNull ProtoBuf.Type proto, @NotNull ConeAttributes attributes2) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        Object object = this.typeSymbol(proto);
        if (object == null) {
            return null;
        }
        Object constructor2 = object;
        if (constructor2 instanceof ConeTypeParameterLookupTag) {
            Object it = object = new ConeTypeParameterTypeImpl((ConeTypeParameterLookupTag)constructor2, proto.getNullable(), null, 4, null);
            boolean bl = false;
            Boolean bl2 = Flags.DEFINITELY_NOT_NULL_TYPE.get(proto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"DEFINITELY_NOT_NULL_TYPE.get(proto.flags)");
            return bl2.booleanValue() ? (ConeSimpleKotlinType)TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, (ConeKotlinType)it, SessionUtilsKt.getTypeContext(this.getModuleData().getSession()), false, 4, null) : (ConeSimpleKotlinType)it;
        }
        if (!(constructor2 instanceof ConeClassLikeLookupTag)) {
            return null;
        }
        Iterable $this$map$iv = FirTypeDeserializer.simpleType$collectAllArguments(proto, this);
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProtoBuf.Type.Argument argument2 = (ProtoBuf.Type.Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeTypeProjection coneTypeProjection = this.typeArgument((ProtoBuf.Type.Argument)p0);
            collection.add(coneTypeProjection);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray22 = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ConeTypeProjection[] arguments2 = coneTypeProjectionArray;
        Boolean $i$f$toTypedArray22 = Flags.SUSPEND_TYPE.get(proto.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$toTypedArray22, (String)"SUSPEND_TYPE.get(proto.flags)");
        ConeClassLikeType simpleType2 = $i$f$toTypedArray22 != false ? this.createSuspendFunctionType((ConeClassLikeLookupTag)constructor2, arguments2, proto.getNullable(), attributes2) : (ConeClassLikeType)new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)constructor2, arguments2, proto.getNullable(), attributes2);
        object2 = ProtoTypeTableUtilKt.abbreviatedType(proto, this.typeTable);
        if (object2 == null) {
            return simpleType2;
        }
        Object abbreviatedTypeProto = object2;
        return this.simpleType((ProtoBuf.Type)abbreviatedTypeProto, attributes2);
    }

    private final ConeClassLikeType createSuspendFunctionTypeForBasicCase(ConeClassLikeLookupTag functionTypeConstructor, ConeTypeProjection[] arguments2, boolean isNullable, ConeAttributes attributes2) {
        ConeClassLikeType coneClassLikeType;
        Object object = ArraysKt.getOrNull((Object[])arguments2, (int)(ArraysKt.getLastIndex((Object[])arguments2) - 1));
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType continuationType = coneClassLikeType;
        if (!FirTypeDeserializer.createSuspendFunctionTypeForBasicCase$isContinuation(continuationType)) {
            return new ConeClassLikeTypeImpl(functionTypeConstructor, arguments2, isNullable, attributes2);
        }
        ConeKotlinTypeProjection suspendReturnType = (ConeKotlinTypeProjection)ArraysKt.single((Object[])continuationType.getTypeArguments());
        List valueParameters2 = ArraysKt.dropLast((Object[])arguments2, (int)2);
        FunctionClassKind kind = FunctionClassKind.SuspendFunction;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)valueParameters2, (Object)suspendReturnType);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(new ClassId(kind.getPackageFqName(), kind.numberedClassName(valueParameters2.size()))), coneTypeProjectionArray, isNullable, attributes2);
    }

    private final ConeClassLikeType createSuspendFunctionType(ConeClassLikeLookupTag functionTypeConstructor, ConeTypeProjection[] arguments2, boolean isNullable, ConeAttributes attributes2) {
        ConeClassLikeType result2;
        ConeClassLikeType coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(functionTypeConstructor, this.moduleData.getSession());
        Intrinsics.checkNotNull(firClassLikeSymbol);
        FirBasedSymbol $this$firUnsafe$iv = firClassLikeSymbol;
        boolean $i$f$firUnsafe = false;
        Object fir$iv = $this$firUnsafe$iv.getFir();
        boolean bl = fir$iv instanceof FirTypeParameterRefsOwner;
        if (!bl) {
            boolean bl2 = false;
            String string2 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypeParameterRefsOwner.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType$default((FirElement)fir$iv, null, 1, null);
            throw new IllegalArgumentException(string2.toString());
        }
        int n = ((FirTypeParameterRefsOwner)((FirElement)fir$iv)).getTypeParameters().size() - arguments2.length;
        switch (n) {
            case 0: {
                coneClassLikeType = this.createSuspendFunctionTypeForBasicCase(functionTypeConstructor, arguments2, isNullable, attributes2);
                break;
            }
            case 1: {
                ConeClassLikeTypeImpl coneClassLikeTypeImpl;
                int arity = arguments2.length - 1;
                if (arity >= 0) {
                    FunctionClassKind kind = FunctionClassKind.SuspendFunction;
                    coneClassLikeTypeImpl = new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(new ClassId(kind.getPackageFqName(), kind.numberedClassName(arity))), arguments2, isNullable, attributes2);
                } else {
                    coneClassLikeTypeImpl = null;
                }
                coneClassLikeType = coneClassLikeTypeImpl;
                break;
            }
            default: {
                coneClassLikeType = null;
            }
        }
        ConeClassLikeType coneClassLikeType2 = result2 = coneClassLikeType;
        return coneClassLikeType2 == null ? (ConeClassLikeType)new ConeClassErrorType(new ConeSimpleDiagnostic(Intrinsics.stringPlus((String)"Bad suspend function in metadata with constructor: ", (Object)functionTypeConstructor), DiagnosticKind.DeserializationError), false, 2, null) : coneClassLikeType2;
    }

    private final ConeClassifierLookupTag typeSymbol(ProtoBuf.Type proto) {
        String name;
        FirTypeParameterSymbol firTypeParameterSymbol;
        return proto.hasClassName() ? (ConeClassifierLookupTag)this.computeClassifier(proto.getClassName()) : (proto.hasTypeAliasName() ? (ConeClassifierLookupTag)this.computeClassifier(proto.getTypeAliasName()) : (proto.hasTypeParameter() ? (ConeClassifierLookupTag)this.typeParameterSymbol(proto.getTypeParameter()) : (proto.hasTypeParameterName() ? (ConeClassifierLookupTag)((firTypeParameterSymbol = this.typeParameterNames.get(name = this.nameResolver.getString(proto.getTypeParameterName()))) == null ? null : firTypeParameterSymbol.toLookupTag()) : null)));
    }

    private final ConeTypeProjection typeArgument(ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return ConeStarProjection.INSTANCE;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"typeArgumentProto.projection");
        Variance variance = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.typeTable);
        if (type2 == null) {
            return new ConeClassErrorType(new ConeSimpleDiagnostic("No type recorded", DiagnosticKind.DeserializationError), false, 2, null);
        }
        ProtoBuf.Type type3 = type2;
        ConeKotlinType coneType = this.type(type3);
        return ConeTypeUtilsKt.toTypeProjection(coneType, variance);
    }

    private static final List<ProtoBuf.Type.Argument> simpleType$collectAllArguments(ProtoBuf.Type $this$simpleType_u24collectAllArguments, FirTypeDeserializer this$0) {
        Object object = $this$simpleType_u24collectAllArguments.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(object, (String)"argumentList");
        Collection collection = (Collection)object;
        object = ProtoTypeTableUtilKt.outerType($this$simpleType_u24collectAllArguments, this$0.typeTable);
        List<ProtoBuf.Type.Argument> list2 = object == null ? null : FirTypeDeserializer.simpleType$collectAllArguments((ProtoBuf.Type)object, this$0);
        return CollectionsKt.plus((Collection)collection, (Iterable)(list2 == null ? CollectionsKt.emptyList() : list2));
    }

    private static final boolean createSuspendFunctionTypeForBasicCase$isContinuation(ConeClassLikeType $this$createSuspendFunctionTypeForBasicCase_u24isContinuation) {
        if ($this$createSuspendFunctionTypeForBasicCase_u24isContinuation.getTypeArguments().length != 1) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$createSuspendFunctionTypeForBasicCase_u24isContinuation.getLookupTag().getClassId(), (Object)SuspendTypeUtilsKt.getCONTINUATION_INTERFACE_CLASS_ID());
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.TypeParameter.Variance.values().length];
            nArray[ProtoBuf.TypeParameter.Variance.IN.ordinal()] = 1;
            nArray[ProtoBuf.TypeParameter.Variance.OUT.ordinal()] = 2;
            nArray[ProtoBuf.TypeParameter.Variance.INV.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

