/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\t2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/FirJvmOverridesBackwardCompatibilityHelper;", "Lorg/jetbrains/kotlin/fir/analysis/FirOverridesBackwardCompatibilityHelper;", "()V", "javaOrigin", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "platformDependentAnnotation", "Lorg/jetbrains/kotlin/name/ClassId;", "isPlatformSpecificSymbolThatCanBeImplicitlyOverridden", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "visitedSymbols", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "overrideCanBeOmitted", "overriddenMemberSymbols", "", "checkers.jvm"})
public final class FirJvmOverridesBackwardCompatibilityHelper
implements FirOverridesBackwardCompatibilityHelper {
    @NotNull
    public static final FirJvmOverridesBackwardCompatibilityHelper INSTANCE = new FirJvmOverridesBackwardCompatibilityHelper();
    @NotNull
    private static final Set<FirDeclarationOrigin> javaOrigin;
    @NotNull
    private static final ClassId platformDependentAnnotation;

    private FirJvmOverridesBackwardCompatibilityHelper() {
    }

    @Override
    public boolean overrideCanBeOmitted(@NotNull List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, @NotNull CheckerContext context2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(overriddenMemberSymbols, (String)"overriddenMemberSymbols");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            HashSet visitedSymbols = new HashSet();
            Iterable $this$all$iv = overriddenMemberSymbols;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(it, visitedSymbols, context2)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(FirCallableSymbol<?> symbol2, Set<FirCallableSymbol<?>> visitedSymbols, CheckerContext context2) {
        boolean bl;
        block28: {
            List list2;
            FirRegularClassSymbol $i$f$isAbstract22;
            Object $this$isInterface$iv;
            Object it;
            Object element$iv2;
            boolean bl2;
            FirCallableDeclaration originalMember;
            block27: {
                Object object;
                FirPureAbstractElement firPureAbstractElement;
                Modality modality$iv;
                Object $this$isFinal$iv = symbol2;
                boolean $i$f$isFinal = false;
                Modality modality = ((FirCallableSymbol)$this$isFinal$iv).getResolvedStatus().getModality();
                if (modality == null ? true : (modality$iv = modality) == Modality.FINAL) {
                    return false;
                }
                if (visitedSymbols.contains(symbol2)) {
                    return true;
                }
                $this$isFinal$iv = visitedSymbols;
                $this$isFinal$iv.add(symbol2);
                FirCallableSymbol<?> $this$originalOrSelf$iv = symbol2;
                boolean $i$f$originalOrSelf = false;
                FirCallableDeclaration $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                boolean $i$f$originalOrSelf2 = false;
                FirCallableDeclaration result$iv$iv = $this$originalOrSelf$iv$iv;
                while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                    Object object2;
                    FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                    boolean $i$f$originalIfFakeOverride = false;
                    FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    boolean $i$f$getOriginalForSubstitutionOverride = false;
                    FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                    if (firPureAbstractElement == null) {
                        FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        boolean $i$f$getBaseForIntersectionOverride = false;
                        object2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                    } else {
                        object2 = object = firPureAbstractElement;
                    }
                    if (object == null) break;
                    result$iv$iv = object;
                }
                FirCallableSymbol<? extends FirCallableDeclaration> firCallableSymbol = result$iv$iv.getSymbol();
                if (firCallableSymbol == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                }
                FirCallableSymbol<? extends FirCallableDeclaration> originalMemberSymbol = firCallableSymbol;
                FirPhaseManagerKt.ensureResolved((FirBasedSymbol)originalMemberSymbol, FirResolvePhase.BODY_RESOLVE);
                originalMember = (FirCallableDeclaration)originalMemberSymbol.getFir();
                Iterable $this$any$iv = originalMember.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        it = (FirAnnotationCall)element$iv2;
                        boolean bl3 = false;
                        FirTypeRef $this$coneTypeSafe$iv = ((FirAnnotationCall)it).getAnnotationTypeRef();
                        boolean $i$f$coneTypeSafe = false;
                        firPureAbstractElement = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                        ConeKotlinType coneKotlinType = firPureAbstractElement == null ? null : ((FirResolvedTypeRef)firPureAbstractElement).getType();
                        if (!(coneKotlinType instanceof ConeClassLikeType)) {
                            coneKotlinType = null;
                        }
                        if (!Intrinsics.areEqual((Object)((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : ConeTypeUtilsKt.getClassId((ConeKotlinType)object)), (Object)platformDependentAnnotation)) continue;
                        bl2 = true;
                        break block27;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            if (!javaOrigin.contains(originalMember.getOrigin())) {
                return false;
            }
            ConeClassLikeLookupTag $i$f$originalOrSelf2 = ClassMembersKt.containingClass(originalMember);
            if ($i$f$originalOrSelf2 == null) {
                return false;
            }
            element$iv2 = $i$f$originalOrSelf2.getClassId();
            it = ((ClassId)element$iv2).asSingleFqName();
            FqNameUnsafe $i$f$any = ((FqName)it).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$any, (String)"originalMember.containin\u2026oUnsafe() ?: return false");
            FqNameUnsafe containingClassName = $i$f$any;
            if (JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(containingClassName) != null) {
                return true;
            }
            FirMemberDeclaration $this$isAbstract$iv = originalMember;
            boolean $i$f$isAbstract22 = false;
            if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) {
                boolean bl4;
                Object $i$f$isAbstract22 = ClassMembersKt.containingClass(originalMember);
                FirRegularClass containingClass = $i$f$isAbstract22 == null ? null : LookupTagUtilsKt.toFirRegularClass((ConeClassLikeLookupTag)$i$f$isAbstract22, context2.getSession());
                $i$f$isAbstract22 = containingClass;
                if ($i$f$isAbstract22 == null) {
                    bl4 = false;
                } else {
                    $this$isInterface$iv = (FirClass)$i$f$isAbstract22;
                    boolean $i$f$isInterface = false;
                    ClassKind $this$isInterface$iv$iv = ((FirClass)$this$isInterface$iv).getClassKind();
                    boolean $i$f$isInterface2 = false;
                    bl4 = !($this$isInterface$iv$iv == ClassKind.INTERFACE);
                }
                if (bl4) {
                    return false;
                }
            }
            FirRegularClassSymbol firRegularClassSymbol = $i$f$isAbstract22 = ($this$isInterface$iv = ClassMembersKt.dispatchReceiverTypeOrNull(symbol2)) == null ? null : FirHelpersKt.toRegularClassSymbol((ConeKotlinType)$this$isInterface$iv, context2.getSession());
            if ($i$f$isAbstract22 == null) {
                return false;
            }
            FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope($i$f$isAbstract22, context2);
            $this$isInterface$iv = originalMember;
            if ($this$isInterface$iv instanceof FirSimpleFunction) {
                list2 = FirTypeScopeKt.getDirectOverriddenFunctions$default(scope2, ((FirSimpleFunction)originalMember).getSymbol(), false, 2, null);
            } else if ($this$isInterface$iv instanceof FirProperty) {
                list2 = FirTypeScopeKt.getDirectOverriddenProperties$default(scope2, ((FirProperty)originalMember).getSymbol(), false, 2, null);
            } else {
                return false;
            }
            List overriddenSymbols2 = list2;
            if (overriddenSymbols2.isEmpty()) {
                return false;
            }
            Iterable $this$all$iv = overriddenSymbols2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv3 : $this$all$iv) {
                    FirCallableSymbol it2 = (FirCallableSymbol)element$iv3;
                    boolean bl5 = false;
                    if (INSTANCE.isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(it2, visitedSymbols, context2)) continue;
                    bl = false;
                    break block28;
                }
                bl = true;
            }
        }
        return bl;
    }

    static {
        Object object = new FirDeclarationOrigin[]{FirDeclarationOrigin.Java.INSTANCE, FirDeclarationOrigin.Enhancement.INSTANCE};
        javaOrigin = SetsKt.setOf((Object[])object);
        object = ClassId.fromString("kotlin/internal/PlatformDependent");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromString(\"kotlin/internal/PlatformDependent\")");
        platformDependentAnnotation = object;
    }
}

