/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinValue;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.AnnotationsKt;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"checkSinceKotlinVersionAccessibility", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinAccessibility;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getOwnSinceKotlinVersion", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinValue;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "loadWasExperimentalMarkerClasses", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
public final class FirSinceKotlinHelpersKt {
    @NotNull
    public static final FirSinceKotlinAccessibility checkSinceKotlinVersionAccessibility(@NotNull FirAnnotatedDeclaration $this$checkSinceKotlinVersionAccessibility, @NotNull CheckerContext context2) {
        FirSinceKotlinValue value2;
        Intrinsics.checkNotNullParameter((Object)$this$checkSinceKotlinVersionAccessibility, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirSinceKotlinValue firSinceKotlinValue = value2 = FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion($this$checkSinceKotlinVersionAccessibility, context2.getSession());
        ApiVersion version = firSinceKotlinValue == null ? null : firSinceKotlinValue.getApiVersion();
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        if (version == null || version.compareTo(languageVersionSettings.getApiVersion()) <= 0) {
            return FirSinceKotlinAccessibility.Accessible.INSTANCE;
        }
        List<FirRegularClassSymbol> wasExperimentalFqNames = value2.getWasExperimentalMarkerClasses();
        if (!((Collection)wasExperimentalFqNames).isEmpty()) {
            return new FirSinceKotlinAccessibility.NotAccessibleButWasExperimental(version, wasExperimentalFqNames);
        }
        return new FirSinceKotlinAccessibility.NotAccessible(version);
    }

    private static final FirSinceKotlinValue getOwnSinceKotlinVersion(FirAnnotatedDeclaration $this$getOwnSinceKotlinVersion, FirSession session) {
        FirClassLikeSymbol<?> classSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ClassId classId;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider($this$getOwnSinceKotlinVersion, (Ref.ObjectRef<FirSinceKotlinValue>)result2);
        if ($this$getOwnSinceKotlinVersion instanceof FirConstructor && (classId = ((FirConstructor)$this$getOwnSinceKotlinVersion).getSymbol().getCallableId().getClassId()) != null && (firClassLikeSymbol = (classSymbol = MainSessionComponentsKt.getSymbolProvider(session).getClassLikeSymbolByFqName(classId))) != null) {
            FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider-0(firClassLikeSymbol, (Ref.ObjectRef<FirSinceKotlinValue>)result2);
        }
        if ($this$getOwnSinceKotlinVersion instanceof FirTypeAlias) {
            ConeClassLikeType coneClassLikeType;
            Object object = FirTypeUtilsKt.getConeType(((FirTypeAlias)$this$getOwnSinceKotlinVersion).getExpandedTypeRef());
            ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType != null && (firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)(object = coneClassLikeType.getLookupTag()), session)) != null) {
                FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider-0(firClassLikeSymbol, (Ref.ObjectRef<FirSinceKotlinValue>)result2);
            }
        }
        return (FirSinceKotlinValue)result2.element;
    }

    private static final List<FirRegularClassSymbol> loadWasExperimentalMarkerClasses(FirAnnotatedDeclaration $this$loadWasExperimentalMarkerClasses) {
        FirAnnotationCall firAnnotationCall = FirAnnotationHelpersKt.getAnnotationByClassId($this$loadWasExperimentalMarkerClasses, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_CLASS_ID());
        if (firAnnotationCall == null) {
            return CollectionsKt.emptyList();
        }
        FirAnnotationCall wasExperimental = firAnnotationCall;
        FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(wasExperimental, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_ANNOTATION_CLASS());
        if (firExpression2 == null) {
            return CollectionsKt.emptyList();
        }
        FirExpression annotationClasses = firExpression2;
        return FirAnnotationHelpersKt.extractClassesFromArgument(annotationClasses);
    }

    private static final void getOwnSinceKotlinVersion$consider(FirAnnotatedDeclaration $this$getOwnSinceKotlinVersion_u24consider, Ref.ObjectRef<FirSinceKotlinValue> result2) {
        block7: {
            ApiVersion apiVersion;
            block8: {
                ApiVersion apiVersion2;
                Object object;
                FirExpression firExpression2;
                FirAnnotationCall firAnnotationCall = FirAnnotationUtilsKt.getAnnotationByFqName($this$getOwnSinceKotlinVersion_u24consider, AnnotationsKt.getSINCE_KOTLIN_FQ_NAME());
                if (firAnnotationCall == null) {
                    firExpression2 = null;
                } else {
                    FirCall $this$arguments$iv = firAnnotationCall;
                    boolean $i$f$getArguments = false;
                    object = $this$arguments$iv.getArgumentList().getArguments();
                    firExpression2 = (FirExpression)CollectionsKt.singleOrNull(object);
                }
                FirExpression sinceKotlinSingleArgument = firExpression2;
                Object object2 = sinceKotlinSingleArgument instanceof FirConstExpression ? (FirConstExpression)sinceKotlinSingleArgument : null;
                Object object3 = object2 == null ? null : (Object)((FirConstExpression)object2).getValue();
                Object object4 = object = object3 instanceof String ? (String)object3 : null;
                if (object == null) {
                    apiVersion2 = null;
                } else {
                    object3 = object;
                    object2 = ApiVersion.Companion;
                    Object p0 = object3;
                    boolean bl = false;
                    apiVersion2 = ((ApiVersion.Companion)object2).parse((String)p0);
                }
                apiVersion = apiVersion2;
                if (apiVersion == null) break block7;
                if (result2.element == null) break block8;
                Object object5 = result2.element;
                Intrinsics.checkNotNull((Object)object5);
                if (apiVersion.compareTo(((FirSinceKotlinValue)object5).getApiVersion()) <= 0) break block7;
            }
            result2.element = new FirSinceKotlinValue(apiVersion, FirSinceKotlinHelpersKt.loadWasExperimentalMarkerClasses($this$getOwnSinceKotlinVersion_u24consider));
        }
    }

    private static final void getOwnSinceKotlinVersion$consider-0(FirClassLikeSymbol<?> $this$getOwnSinceKotlinVersion_u24consider_u2d0, Ref.ObjectRef<FirSinceKotlinValue> result2) {
        FirPhaseManagerKt.ensureResolved((FirBasedSymbol)$this$getOwnSinceKotlinVersion_u24consider_u2d0, FirResolvePhase.BODY_RESOLVE);
        FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider((FirAnnotatedDeclaration)$this$getOwnSinceKotlinVersion_u24consider_u2d0.getFir(), result2);
    }
}

