/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.InitializerCallReplacer;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndexedGetIterationHandler;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J<\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0007H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetLoopHeader;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericForLoopHeader;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetHeaderInfo;", "headerInfo", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetHeaderInfo;Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "loopInitStatements", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getLoopInitStatements", "()Ljava/util/List;", "buildLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "oldLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "newBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "initializeIteration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "loopVariable", "loopVariableComponents", "", "", "backendContext", "ir.backend.common"})
public final class IndexedGetLoopHeader
extends NumericForLoopHeader<IndexedGetHeaderInfo> {
    @NotNull
    private final List<IrVariable> loopInitStatements;

    public IndexedGetLoopHeader(@NotNull IndexedGetHeaderInfo headerInfo, @NotNull DeclarationIrBuilder builder, @NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)headerInfo, (String)"headerInfo");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((NumericHeaderInfo)headerInfo, builder, context2);
        Object[] objectArray = new IrVariable[]{headerInfo.getObjectVariable(), this.getInductionVariable(), this.getLastVariableIfCanCacheLast(), this.getStepVariable()};
        this.loopInitStatements = CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @NotNull
    public List<IrVariable> getLoopInitStatements() {
        return this.loopInitStatements;
    }

    @Override
    @NotNull
    public List<IrStatement> initializeIteration(@Nullable IrVariable loopVariable, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull DeclarationIrBuilder builder, @NotNull CommonBackendContext backendContext) {
        IndexedGetIterationHandler indexedGetIterationHandler;
        Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        DeclarationIrBuilder $this$initializeIteration_u24lambda_u2d2 = builder;
        boolean bl = false;
        IndexedGetIterationHandler $this$initializeIteration_u24lambda_u2d2_u24lambda_u2d0 = indexedGetIterationHandler = ((IndexedGetHeaderInfo)this.getHeaderInfo()).getExpressionHandler();
        boolean bl2 = false;
        IrSimpleFunction indexedGetFun = $this$initializeIteration_u24lambda_u2d2_u24lambda_u2d0.getGetFunction(((IndexedGetHeaderInfo)this.getHeaderInfo()).getObjectVariable().getType());
        IrElementBase irElementBase = loopVariable;
        IrElementBase $this$initializeIteration_u24lambda_u2d2_u24lambda_u2d1 = irElementBase = ExpressionHelpersKt.irCall$default($this$initializeIteration_u24lambda_u2d2, indexedGetFun.getSymbol(), irElementBase == null ? indexedGetFun.getReturnType() : ((IrValueDeclaration)irElementBase).getType(), 0, 0, null, 28, null);
        boolean bl3 = false;
        ((IrMemberAccessExpression)$this$initializeIteration_u24lambda_u2d2_u24lambda_u2d1).setDispatchReceiver(ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u2d2, ((IndexedGetHeaderInfo)this.getHeaderInfo()).getObjectVariable()));
        ((IrFunctionAccessExpression)$this$initializeIteration_u24lambda_u2d2_u24lambda_u2d1).putValueArgument(0, ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u2d2, this.getInductionVariable()));
        IrElementBase get2 = irElementBase;
        irElementBase = loopVariable;
        if (irElementBase != null) {
            IrExpression irExpression;
            IrVariable irVariable2 = loopVariable;
            ((IrVariable)irElementBase).setInitializer((IrExpression)(irVariable2 == null ? null : ((irExpression = irVariable2.getInitializer()) == null ? null : irExpression.transform((IrElementTransformer)new InitializerCallReplacer((IrCall)get2), (Object)null))));
        }
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((irElementBase = loopVariable) == null ? (IrElement)get2 : (IrElement)irElementBase)), (Object)this.incrementInductionVariable($this$initializeIteration_u24lambda_u2d2));
    }

    @Override
    @NotNull
    public LoopReplacement buildLoop(@NotNull DeclarationIrBuilder builder, @NotNull IrLoop oldLoop, @Nullable IrExpression newBody) {
        IrWhileLoopImpl irWhileLoopImpl;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)oldLoop, (String)"oldLoop");
        DeclarationIrBuilder $this$buildLoop_u24lambda_u2d4 = builder;
        boolean bl = false;
        IrWhileLoopImpl $this$buildLoop_u24lambda_u2d4_u24lambda_u2d3 = irWhileLoopImpl = new IrWhileLoopImpl(oldLoop.getStartOffset(), oldLoop.getEndOffset(), oldLoop.getType(), oldLoop.getOrigin());
        boolean bl2 = false;
        $this$buildLoop_u24lambda_u2d4_u24lambda_u2d3.setLabel(oldLoop.getLabel());
        $this$buildLoop_u24lambda_u2d4_u24lambda_u2d3.setCondition(this.buildLoopCondition($this$buildLoop_u24lambda_u2d4));
        $this$buildLoop_u24lambda_u2d4_u24lambda_u2d3.setBody(newBody);
        IrWhileLoopImpl newLoop = irWhileLoopImpl;
        return new LoopReplacement(newLoop, newLoop);
    }
}

