/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.common.ir.BuiltinSymbolsBase;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.linkage.IrDeserializer;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u000200H\u0016J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u000204H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020:062\u0006\u00103\u001a\u000204H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<062\u0006\u00103\u001a\u000204H\u0016J\"\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u00103\u001a\u000204H\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u00103\u001a\u000204H\u0002J7\u0010G\u001a\u0004\u0018\u0001HH\"\b\b\u0000\u0010H*\u00020>2\u0006\u00103\u001a\u0002042\u0014\u0010I\u001a\u0010\u0012\u0004\u0012\u00020F\u0012\u0006\u0012\u0004\u0018\u0001HH0JH\u0002\u00a2\u0006\u0002\u0010KJ:\u0010L\u001a\b\u0012\u0004\u0012\u0002HH06\"\b\b\u0000\u0010H*\u00020>2\u0006\u00103\u001a\u0002042\u0018\u0010I\u001a\u0014\u0012\u0004\u0012\u00020F\u0012\n\u0012\b\u0012\u0004\u0012\u0002HH060JH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\tX\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010\u001f\u001a\u0004\b(\u0010)R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContextImpl;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "st", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "linker", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/BuiltinSymbolsBase;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/ir/util/TypeTranslator;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/backend/common/ir/BuiltinSymbolsBase;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLinker", "()Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "moduleDescriptor", "getModuleDescriptor$annotations", "()V", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "symbolTable", "getSymbolTable$annotations", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/common/ir/BuiltinSymbolsBase;", "getTypeTranslator", "()Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "createDiagnosticReporter", "pluginId", "", "referenceClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "referenceConstructors", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "classFqn", "referenceFunctions", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "referenceProperties", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "referenceTopLevel", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "kind", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$TopLevelSymbolKind;", "referenceTypeAlias", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "resolveMemberScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "resolveSymbol", "S", "referencer", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/name/FqName;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "resolveSymbolCollection", "ir.backend.common"})
public class IrPluginContextImpl
implements IrPluginContext {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final ReferenceSymbolTable st;
    @NotNull
    private final TypeTranslator typeTranslator;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final IrDeserializer linker;
    @NotNull
    private final IrMessageLogger diagnosticReporter;
    @NotNull
    private final BuiltinSymbolsBase symbols;
    @Nullable
    private final TargetPlatform platform;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final ReferenceSymbolTable symbolTable;

    public IrPluginContextImpl(@NotNull ModuleDescriptor module, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ReferenceSymbolTable st, @NotNull TypeTranslator typeTranslator2, @NotNull IrBuiltIns irBuiltIns, @NotNull IrDeserializer linker, @NotNull IrMessageLogger diagnosticReporter, @NotNull BuiltinSymbolsBase symbols) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        Intrinsics.checkNotNullParameter((Object)typeTranslator2, (String)"typeTranslator");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        this.module = module;
        this.bindingContext = bindingContext;
        this.languageVersionSettings = languageVersionSettings;
        this.st = st;
        this.typeTranslator = typeTranslator2;
        this.irBuiltIns = irBuiltIns;
        this.linker = linker;
        this.diagnosticReporter = diagnosticReporter;
        this.symbols = symbols;
        this.platform = this.module.getPlatform();
        this.moduleDescriptor = this.module;
        this.symbolTable = this.st;
    }

    public /* synthetic */ IrPluginContextImpl(ModuleDescriptor moduleDescriptor, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings, ReferenceSymbolTable referenceSymbolTable, TypeTranslator typeTranslator2, IrBuiltIns irBuiltIns, IrDeserializer irDeserializer, IrMessageLogger irMessageLogger, BuiltinSymbolsBase builtinSymbolsBase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            builtinSymbolsBase = new BuiltinSymbolsBase(irBuiltIns, referenceSymbolTable);
        }
        this(moduleDescriptor, bindingContext, languageVersionSettings, referenceSymbolTable, typeTranslator2, irBuiltIns, irDeserializer, irMessageLogger, builtinSymbolsBase);
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @Override
    @NotNull
    public TypeTranslator getTypeTranslator() {
        return this.typeTranslator;
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final IrDeserializer getLinker() {
        return this.linker;
    }

    @Override
    @NotNull
    public BuiltinSymbolsBase getSymbols() {
        return this.symbols;
    }

    @Override
    @Nullable
    public TargetPlatform getPlatform() {
        return this.platform;
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public static /* synthetic */ void getModuleDescriptor$annotations() {
    }

    @Override
    @NotNull
    public ReferenceSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public static /* synthetic */ void getSymbolTable$annotations() {
    }

    private final MemberScope resolveMemberScope(FqName fqName2) {
        PackageViewDescriptor pkg = this.module.getPackage(fqName2);
        if (fqName2.isRoot() || !((Collection)pkg.getFragments()).isEmpty()) {
            return pkg.getMemberScope();
        }
        Object object = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fqName.parent()");
        MemberScope memberScope2 = this.resolveMemberScope((FqName)object);
        if (memberScope2 == null) {
            return null;
        }
        MemberScope parentMemberScope = memberScope2;
        Name name = fqName2.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"fqName.shortName()");
        ClassifierDescriptor classifierDescriptor = parentMemberScope.getContributedClassifier(name, NoLookupLocation.FROM_BACKEND);
        Object object2 = object = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (object == null) {
            return null;
        }
        Object classDescriptor = object;
        return classDescriptor.getUnsubstitutedMemberScope();
    }

    private final <S extends IrSymbol> S resolveSymbol(FqName fqName2, Function1<? super MemberScope, ? extends S> referencer) {
        MemberScope memberScope2 = this.resolveMemberScope(fqName2);
        if (memberScope2 == null) {
            return null;
        }
        MemberScope memberScope3 = memberScope2;
        IrSymbol irSymbol2 = (IrSymbol)referencer.invoke((Object)memberScope3);
        if (irSymbol2 == null) {
            return null;
        }
        IrSymbol symbol2 = irSymbol2;
        if (symbol2.isBound()) {
            return (S)symbol2;
        }
        this.linker.getDeclaration(symbol2);
        this.linker.postProcess();
        return (S)symbol2;
    }

    @Override
    @NotNull
    public IrMessageLogger createDiagnosticReporter(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return new IrMessageLogger(this, pluginId){
            final /* synthetic */ IrPluginContextImpl this$0;
            final /* synthetic */ String $pluginId;
            {
                this.this$0 = $receiver;
                this.$pluginId = $pluginId;
            }

            public void report(@NotNull IrMessageLogger.Severity severity, @NotNull String message2, @Nullable IrMessageLogger.Location location2) {
                Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                IrPluginContextImpl.access$getDiagnosticReporter$p(this.this$0).report(severity, "[Plugin " + this.$pluginId + "] " + message2, location2);
            }
        };
    }

    private final <S extends IrSymbol> Collection<S> resolveSymbolCollection(FqName fqName2, Function1<? super MemberScope, ? extends Collection<? extends S>> referencer) {
        MemberScope memberScope2 = this.resolveMemberScope(fqName2);
        if (memberScope2 == null) {
            return CollectionsKt.emptyList();
        }
        MemberScope memberScope3 = memberScope2;
        Collection symbols = (Collection)referencer.invoke((Object)memberScope3);
        Iterable $this$forEach$iv = symbols;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSymbol it = (IrSymbol)element$iv;
            boolean bl = false;
            if (it.isBound()) continue;
            this.getLinker().getDeclaration(it);
        }
        this.linker.postProcess();
        return symbols;
    }

    @Override
    @Nullable
    public IrClassSymbol referenceClass(@NotNull FqName fqName2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        boolean bl2 = bl = !fqName2.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.parent()");
        return (IrClassSymbol)this.resolveSymbol(fqName3, (Function1)new Function1<MemberScope, IrClassSymbol>(fqName2, this){
            final /* synthetic */ FqName $fqName;
            final /* synthetic */ IrPluginContextImpl this$0;
            {
                this.$fqName = $fqName;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final IrClassSymbol invoke(@NotNull MemberScope scope2) {
                IrClassSymbol irClassSymbol;
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                Object object = this.$fqName.shortName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fqName.shortName()");
                ClassifierDescriptor classifierDescriptor = scope2.getContributedClassifier((Name)object, NoLookupLocation.FROM_BACKEND);
                ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                classifierDescriptor = classDescriptor;
                if (classifierDescriptor == null) {
                    irClassSymbol = null;
                } else {
                    object = classifierDescriptor;
                    IrPluginContextImpl irPluginContextImpl = this.this$0;
                    Object it = object;
                    boolean bl = false;
                    irClassSymbol = IrPluginContextImpl.access$getSt$p(irPluginContextImpl).referenceClass((ClassDescriptor)it);
                }
                return irClassSymbol;
            }
        });
    }

    @Override
    @Nullable
    public IrTypeAliasSymbol referenceTypeAlias(@NotNull FqName fqName2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        boolean bl2 = bl = !fqName2.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.parent()");
        return (IrTypeAliasSymbol)this.resolveSymbol(fqName3, (Function1)new Function1<MemberScope, IrTypeAliasSymbol>(fqName2, this){
            final /* synthetic */ FqName $fqName;
            final /* synthetic */ IrPluginContextImpl this$0;
            {
                this.$fqName = $fqName;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final IrTypeAliasSymbol invoke(@NotNull MemberScope scope2) {
                IrTypeAliasSymbol irTypeAliasSymbol;
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                Object object = this.$fqName.shortName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fqName.shortName()");
                ClassifierDescriptor classifierDescriptor = scope2.getContributedClassifier((Name)object, NoLookupLocation.FROM_BACKEND);
                TypeAliasDescriptor aliasDescriptor = classifierDescriptor instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)classifierDescriptor : null;
                classifierDescriptor = aliasDescriptor;
                if (classifierDescriptor == null) {
                    irTypeAliasSymbol = null;
                } else {
                    object = classifierDescriptor;
                    IrPluginContextImpl irPluginContextImpl = this.this$0;
                    Object it = object;
                    boolean bl = false;
                    irTypeAliasSymbol = IrPluginContextImpl.access$getSt$p(irPluginContextImpl).referenceTypeAlias((TypeAliasDescriptor)it);
                }
                return irTypeAliasSymbol;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<IrConstructorSymbol> referenceConstructors(@NotNull FqName classFqn) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        IrClassSymbol irClassSymbol = this.referenceClass(classFqn);
        if (irClassSymbol == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot find class ", (Object)classFqn).toString());
        }
        IrClassSymbol classSymbol = irClassSymbol;
        Iterable $this$filterIsInstance$iv = ((IrClass)classSymbol.getOwner()).getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrConstructor irConstructor2 = (IrConstructor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrConstructorSymbol irConstructorSymbol = it.getSymbol();
            collection.add(irConstructorSymbol);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Collection<IrSimpleFunctionSymbol> referenceFunctions(@NotNull FqName fqName2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        boolean bl2 = bl = !fqName2.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.parent()");
        return this.resolveSymbolCollection(fqName3, (Function1)new Function1<MemberScope, Collection<? extends IrSimpleFunctionSymbol>>(fqName2, this){
            final /* synthetic */ FqName $fqName;
            final /* synthetic */ IrPluginContextImpl this$0;
            {
                this.$fqName = $fqName;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<IrSimpleFunctionSymbol> invoke(@NotNull MemberScope scope2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                Object object = this.$fqName.shortName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fqName.shortName()");
                Collection<? extends SimpleFunctionDescriptor> descriptors = scope2.getContributedFunctions((Name)object, NoLookupLocation.FROM_BACKEND);
                object = descriptors;
                IrPluginContextImpl irPluginContextImpl = this.this$0;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol = IrPluginContextImpl.access$getSt$p(irPluginContextImpl).referenceSimpleFunction((FunctionDescriptor)it);
                    collection.add(irSimpleFunctionSymbol);
                }
                return (List)destination$iv$iv;
            }
        });
    }

    @Override
    @NotNull
    public Collection<IrPropertySymbol> referenceProperties(@NotNull FqName fqName2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        boolean bl2 = bl = !fqName2.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.parent()");
        return this.resolveSymbolCollection(fqName3, (Function1)new Function1<MemberScope, Collection<? extends IrPropertySymbol>>(fqName2, this){
            final /* synthetic */ FqName $fqName;
            final /* synthetic */ IrPluginContextImpl this$0;
            {
                this.$fqName = $fqName;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<IrPropertySymbol> invoke(@NotNull MemberScope scope2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                Object object = this.$fqName.shortName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fqName.shortName()");
                Collection<? extends PropertyDescriptor> descriptors = scope2.getContributedVariables((Name)object, NoLookupLocation.FROM_BACKEND);
                object = descriptors;
                IrPluginContextImpl irPluginContextImpl = this.this$0;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrPropertySymbol irPropertySymbol = IrPluginContextImpl.access$getSt$p(irPluginContextImpl).referenceProperty((PropertyDescriptor)it);
                    collection.add(irPropertySymbol);
                }
                return (List)destination$iv$iv;
            }
        });
    }

    @Override
    @Nullable
    public IrSymbol referenceTopLevel(@NotNull IdSignature signature2, @NotNull IrDeserializer.TopLevelSymbolKind kind, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Name name = moduleDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"moduleDescriptor.name");
        IrSymbol symbol2 = this.linker.resolveBySignatureInModule(signature2, kind, name);
        this.linker.postProcess();
        return symbol2;
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return IrPluginContext.DefaultImpls.getIrFactory(this);
    }

    public static final /* synthetic */ IrMessageLogger access$getDiagnosticReporter$p(IrPluginContextImpl $this) {
        return $this.diagnosticReporter;
    }

    public static final /* synthetic */ ReferenceSymbolTable access$getSt$p(IrPluginContextImpl $this) {
        return $this.st;
    }
}

