/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001aX\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000bH\u0000\u001a\u0016\u0010\u0010\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\"\u0010\u0014\u001a\u0002H\u0015\"\n\b\u0000\u0010\u0015\u0018\u0001*\u00020\u0016*\u0006\u0012\u0002\b\u00030\u0017H\u0086\b\u00a2\u0006\u0002\u0010\u0018\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013\"*\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018\u00c0\u0002@\u00c0\u0002X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"type", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resultType", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "setResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "remapArgumentsWithVararg", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "varargParameter", "varargArrayType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "argumentMapping", "expectedConeType", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "firUnsafe", "T", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/fir/FirElement;", "writeResultType", "", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolve"})
public final class BodyResolveUtilsKt {
    public static final /* synthetic */ FirElement firUnsafe(FirBasedSymbol $this$firUnsafe) {
        Intrinsics.checkNotNullParameter((Object)$this$firUnsafe, (String)"<this>");
        boolean $i$f$firUnsafe = false;
        Object fir = $this$firUnsafe.getFir();
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        boolean bl = fir instanceof FirElement;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder2 = new StringBuilder().append("Not an expected fir element type = ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string2 = stringBuilder2.append(Reflection.getOrCreateKotlinClass(FirElement.class)).append(", symbol = ").append($this$firUnsafe).append(", fir = ").append(FirRendererKt.renderWithType$default((FirElement)fir, null, 1, null)).toString();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return (FirElement)fir;
    }

    @NotNull
    public static final FirTypeRef getResultType(@NotNull FirExpression $this$resultType) {
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"<this>");
        boolean $i$f$getResultType = false;
        return $this$resultType.getTypeRef();
    }

    public static final void setResultType(@NotNull FirExpression $this$resultType, @NotNull FirTypeRef type2) {
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        boolean $i$f$setResultType = false;
        $this$resultType.replaceTypeRef(type2);
    }

    @NotNull
    public static final LinkedHashMap<FirExpression, FirValueParameter> remapArgumentsWithVararg(@NotNull FirValueParameter varargParameter, @NotNull ConeKotlinType varargArrayType, @NotNull LinkedHashMap<FirExpression, FirValueParameter> argumentMapping) {
        Intrinsics.checkNotNullParameter((Object)varargParameter, (String)"varargParameter");
        Intrinsics.checkNotNullParameter((Object)varargArrayType, (String)"varargArrayType");
        Intrinsics.checkNotNullParameter(argumentMapping, (String)"argumentMapping");
        FirTypeRef varargParameterTypeRef = varargParameter.getReturnTypeRef();
        ConeKotlinType varargElementType = ArrayUtilsKt.arrayElementType(varargArrayType);
        Set<FirExpression> set = argumentMapping.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"argumentMapping.keys");
        List argumentList2 = CollectionsKt.toList((Iterable)set);
        int indexAfterVarargs = 0;
        indexAfterVarargs = argumentList2.size();
        boolean bl = false;
        LinkedHashMap<FirExpression, FirValueParameter> newArgumentMapping = new LinkedHashMap<FirExpression, FirValueParameter>();
        boolean $i$f$buildVarargArgumentsExpression = false;
        boolean bl2 = false;
        FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        FirVarargArgumentsExpressionBuilder $this$remapArgumentsWithVararg_u24lambda_u2d1 = firVarargArgumentsExpressionBuilder;
        boolean bl5 = false;
        $this$remapArgumentsWithVararg_u24lambda_u2d1.setVarargElementType(TypeUtilsKt.withReplacedConeType$default(varargParameterTypeRef, varargElementType, null, 2, null));
        $this$remapArgumentsWithVararg_u24lambda_u2d1.setTypeRef(TypeUtilsKt.withReplacedConeType$default(varargParameterTypeRef, varargArrayType, null, 2, null));
        Iterator iterator2 = argumentList2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            boolean bl6;
            Object object;
            Object object2;
            int i = n++;
            FirExpression arg = (FirExpression)iterator2.next();
            Map map = argumentMapping;
            Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
            FirValueParameter valueParameter2 = (FirValueParameter)MapsKt.getValue((Map)map, (Object)arg);
            if (Intrinsics.areEqual((Object)valueParameter2, (Object)varargParameter) || valueParameter2.isVararg() && !(arg instanceof FirNamedArgumentExpression)) {
                object2 = $this$remapArgumentsWithVararg_u24lambda_u2d1;
                object = ((FirVarargArgumentsExpressionBuilder)object2).getArguments();
                bl6 = false;
                object.add(arg);
                if ($this$remapArgumentsWithVararg_u24lambda_u2d1.getSource() != null) continue;
                object2 = arg.getSource();
                $this$remapArgumentsWithVararg_u24lambda_u2d1.setSource(object2 == null ? null : FirSourceElementKt.fakeElement((FirSourceElement)object2, FirFakeSourceElementKind.VarargArgument.INSTANCE));
                continue;
            }
            if ($this$remapArgumentsWithVararg_u24lambda_u2d1.getArguments().isEmpty()) {
                object2 = newArgumentMapping;
                object = arg;
                bl6 = false;
                object2.put(object, valueParameter2);
                continue;
            }
            indexAfterVarargs = i;
            break;
        }
        FirVarargArgumentsExpression varargArgument = firVarargArgumentsExpressionBuilder.build();
        Map map = newArgumentMapping;
        int n2 = 0;
        map.put(varargArgument, varargParameter);
        int n3 = indexAfterVarargs;
        n2 = argumentList2.size();
        if (n3 < n2) {
            do {
                int i = n3++;
                Object object = argumentList2.get(i);
                Intrinsics.checkNotNullExpressionValue(object, (String)"argumentList[i]");
                FirExpression arg = (FirExpression)object;
                object = newArgumentMapping;
                Object object3 = MapsKt.getValue((Map)argumentMapping, (Object)arg);
                boolean bl7 = false;
                object.put((FirExpression)arg, (Object)object3);
            } while (n3 < n2);
        }
        return newArgumentMapping;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeResultType(@NotNull FirBlock $this$writeResultType, @NotNull FirSession session) {
        void type$iv;
        void $this$resultType$iv;
        FirTypeRef theType;
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)$this$writeResultType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirStatement statement2 = (FirStatement)CollectionsKt.lastOrNull($this$writeResultType.getStatements());
        FirExpression resultExpression = statement2 instanceof FirExpression ? (FirExpression)statement2 : null;
        statement2 = $this$writeResultType;
        if (resultExpression == null) {
            FirExpression $this$resultType$iv2 = $this$writeResultType;
            boolean $i$f$getResultType = false;
            firTypeRef = CopyUtilsKt.resolvedTypeFromPrototype($this$resultType$iv2.getTypeRef(), session.getBuiltinTypes().getUnitType().getType());
        } else {
            FirResolvedTypeRef firResolvedTypeRef;
            boolean bl;
            FirExpression $this$resultType$iv3 = resultExpression;
            boolean $i$f$getResultType = false;
            theType = $this$resultType$iv3.getTypeRef();
            if (theType instanceof FirResolvedTypeRef) {
                boolean $i$f$buildResolvedTypeRef = false;
                bl = false;
                FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirResolvedTypeRefBuilder $this$writeResultType_u24lambda_u2d2 = firResolvedTypeRefBuilder;
                boolean bl4 = false;
                Object object = theType.getSource();
                $this$writeResultType_u24lambda_u2d2.setSource(object == null ? null : FirSourceElementKt.fakeElement((FirSourceElement)object, FirFakeSourceElementKind.ImplicitTypeRef.INSTANCE));
                $this$writeResultType_u24lambda_u2d2.setType(((FirResolvedTypeRef)theType).getType());
                object = $this$writeResultType_u24lambda_u2d2;
                Collection collection = ((FirResolvedTypeRefBuilder)object).getAnnotations();
                Iterable iterable = theType.getAnnotations();
                boolean bl5 = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                firResolvedTypeRef = firResolvedTypeRefBuilder.build();
            } else {
                boolean $i$f$buildErrorTypeRef = false;
                bl = false;
                FirErrorTypeRefBuilder firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                boolean bl6 = false;
                boolean bl7 = false;
                FirErrorTypeRefBuilder $this$writeResultType_u24lambda_u2d3 = firErrorTypeRefBuilder;
                boolean bl8 = false;
                $this$writeResultType_u24lambda_u2d3.setDiagnostic(new ConeSimpleDiagnostic("No type for block", DiagnosticKind.InferenceError));
                firResolvedTypeRef = firErrorTypeRefBuilder.build();
            }
            firTypeRef = firResolvedTypeRef;
        }
        theType = firTypeRef;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceTypeRef((FirTypeRef)type$iv);
    }

    @NotNull
    public static final ConeKotlinType expectedConeType(@NotNull ConstantValueKind<?> $this$expectedConeType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$expectedConeType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConstantValueKind<?> constantValueKind = $this$expectedConeType;
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE)) {
            coneKotlinType = session.getBuiltinTypes().getNullableNothingType().getType();
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            coneKotlinType = session.getBuiltinTypes().getBooleanType().getType();
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getChar(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getByte(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getShort(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getLong(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getString(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getFloat(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getDouble(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUByte(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUShort(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getULong(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    private static final ConeKotlinType expectedConeType$constructLiteralType(FirSession $session, ClassId classId, boolean isNullable) {
        FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider($session).getClassLikeSymbolByFqName(classId);
        if (firClassLikeSymbol == null) {
            return new ConeClassErrorType(new ConeSimpleDiagnostic(Intrinsics.stringPlus((String)"Missing stdlib class: ", (Object)classId), DiagnosticKind.MissingStdlibClass));
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        return TypeConstructionUtilsKt.constructClassType$default(symbol2.toLookupTag(), new ConeTypeProjection[0], isNullable, null, 4, null);
    }

    static /* synthetic */ ConeKotlinType expectedConeType$constructLiteralType$default(FirSession firSession, ClassId classId, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return BodyResolveUtilsKt.expectedConeType$constructLiteralType(firSession, classId, bl);
    }
}

