/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSealedClassInheritorsTransformerKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0007\u001a\u001b\u001c\u001d\u001e\u001f B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J/\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "checkBooleanExhaustiveness", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "nullable", "checkEnumExhaustiveness", "enum", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkSealedClassExhaustiveness", "sealedClass", "processExhaustivenessCheck", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformWhenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "BooleanExhaustivenessFlags", "BooleanExhaustivenessVisitor", "EnumExhaustivenessData", "EnumExhaustivenessVisitor", "SealedClassInheritors", "SealedExhaustivenessData", "SealedExhaustivenessVisitor", "resolve"})
public final class FirWhenExhaustivenessTransformer
extends FirTransformer {
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;

    public FirWhenExhaustivenessTransformer(@NotNull BodyResolveComponents bodyResolveComponents) {
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        this.bodyResolveComponents = bodyResolveComponents;
    }

    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        throw new IllegalArgumentException("Should not be there");
    }

    @NotNull
    public CompositeTransformResult<FirStatement> transformWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        FirWhenExpression firWhenExpression = this.processExhaustivenessCheck(whenExpression);
        FirWhenExpression resultExpression = firWhenExpression == null ? whenExpression : firWhenExpression;
        FirElement $this$compose$iv = resultExpression;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    private final FirWhenExpression processExhaustivenessCheck(FirWhenExpression whenExpression) {
        FirWhenExpression firWhenExpression;
        boolean bl;
        ConeKotlinType coneKotlinType;
        FirTypeRef typeRef;
        Object object;
        FirTypeRef $i$f$any2;
        boolean bl2;
        block21: {
            Iterable $this$any$iv = whenExpression.getBranches();
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirWhenBranch it = (FirWhenBranch)element$iv;
                    boolean bl3 = false;
                    if (!(it.getCondition() instanceof FirElseIfTrueCondition)) continue;
                    bl2 = true;
                    break block21;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            whenExpression.replaceIsExhaustive(true);
            return whenExpression;
        }
        FirVariable<?> firVariable = whenExpression.getSubjectVariable();
        FirTypeRef firTypeRef = $i$f$any2 = firVariable == null ? null : firVariable.getReturnTypeRef();
        if ($i$f$any2 == null) {
            Object element$iv;
            element$iv = whenExpression.getSubject();
            FirVariable<?> firVariable2 = firVariable = element$iv == null ? null : ((FirExpression)element$iv).getTypeRef();
            if (firVariable == null) {
                return null;
            }
            object = firVariable;
        } else {
            object = $i$f$any2;
        }
        FirTypeRef $this$coneType$iv = typeRef = object;
        boolean $i$f$getConeType = false;
        Object $this$coneTypeSafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeSafe22 = false;
        boolean bl4 = false;
        FirPureAbstractElement firPureAbstractElement = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
        ConeKotlinType coneKotlinType2 = firPureAbstractElement == null ? null : ((FirResolvedTypeRef)firPureAbstractElement).getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) == null) {
            $this$coneTypeSafe$iv$iv = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
            $i$f$coneTypeSafe22 = false;
            throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv.toString());
        }
        ConeKotlinType type2 = ConeTypesKt.lowerBoundIfFlexible(coneKotlinType);
        $this$coneTypeSafe$iv$iv = type2 instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)type2 : null;
        ConeClassifierLookupTag coneClassifierLookupTag = $i$f$getConeType = $this$coneTypeSafe$iv$iv == null ? null : ((ConeLookupTagBasedType)$this$coneTypeSafe$iv$iv).getLookupTag();
        if ($i$f$getConeType == null) {
            return null;
        }
        ConeClassifierLookupTag lookupTag = $i$f$getConeType;
        boolean nullable = type2.getNullability() == ConeNullability.NULLABLE;
        ConeClassLikeLookupTag $i$f$coneTypeSafe22 = lookupTag instanceof ConeClassLikeLookupTag ? (ConeClassLikeLookupTag)lookupTag : null;
        if (Intrinsics.areEqual((Object)($i$f$coneTypeSafe22 == null ? null : $i$f$coneTypeSafe22.getClassId()), (Object)this.bodyResolveComponents.getSession().getBuiltinTypes().getBooleanType().getId())) {
            bl = this.checkBooleanExhaustiveness(whenExpression, nullable);
        } else if (whenExpression.getBranches().isEmpty()) {
            bl = false;
        } else {
            FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.toSymbol(lookupTag, this.bodyResolveComponents.getSession());
            coneKotlinType = firClassifierSymbol == null ? null : firClassifierSymbol.getFir();
            FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement = coneKotlinType instanceof FirRegularClass ? (FirRegularClass)((Object)coneKotlinType) : null;
            if (firPureAbstractElement == null) {
                return null;
            }
            FirPureAbstractElement klass = firPureAbstractElement;
            if (((FirRegularClass)klass).getClassKind() == ClassKind.ENUM_CLASS) {
                bl = this.checkEnumExhaustiveness(whenExpression, (FirRegularClass)klass, nullable);
            } else {
                FirPureAbstractElement $this$modality$iv = klass;
                boolean $i$f$getModality = false;
                if (((FirRegularClass)$this$modality$iv).getStatus().getModality() == Modality.SEALED) {
                    bl = this.checkSealedClassExhaustiveness(whenExpression, (FirRegularClass)klass, nullable);
                } else {
                    return null;
                }
            }
        }
        boolean isExhaustive = bl;
        boolean $i$f$runIf = false;
        if (isExhaustive) {
            boolean bl5 = false;
            whenExpression.replaceIsExhaustive(true);
            firWhenExpression = whenExpression;
        } else {
            firWhenExpression = null;
        }
        return firWhenExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkEnumExhaustiveness(FirWhenExpression whenExpression, FirRegularClass firRegularClass, boolean nullable) {
        Collection<FirVariableSymbol<FirEnumEntry>> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = FirDeclarationUtilKt.collectEnumEntries(firRegularClass);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirEnumEntry firEnumEntry = (FirEnumEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirVariableSymbol<FirEnumEntry> firVariableSymbol = it.getSymbol();
            collection.add(firVariableSymbol);
        }
        collection = (List)destination$iv$iv;
        boolean bl = !nullable;
        Set set = CollectionsKt.toMutableSet((Iterable)collection);
        EnumExhaustivenessData data = new EnumExhaustivenessData(set, bl);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(EnumExhaustivenessVisitor.INSTANCE, data);
        }
        return data.getContainsNull() && data.getRemainingEntries().isEmpty();
    }

    private final boolean checkSealedClassExhaustiveness(FirWhenExpression whenExpression, FirRegularClass sealedClass, boolean nullable) {
        Collection collection = FirSealedClassInheritorsTransformerKt.getSealedInheritors(sealedClass);
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            return true;
        }
        SealedExhaustivenessData data = new SealedExhaustivenessData(sealedClass, !nullable);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(SealedExhaustivenessVisitor.INSTANCE, data);
        }
        return data.isExhaustive();
    }

    private final boolean checkBooleanExhaustiveness(FirWhenExpression whenExpression, boolean nullable) {
        BooleanExhaustivenessFlags flags = new BooleanExhaustivenessFlags(!nullable);
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            branch.getCondition().accept(BooleanExhaustivenessVisitor.INSTANCE, flags);
        }
        return flags.getContainsTrue() && flags.getContainsFalse() && flags.getContainsNull();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessData;", "", "remainingEntries", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "containsNull", "", "(Ljava/util/Set;Z)V", "getContainsNull", "()Z", "setContainsNull", "(Z)V", "getRemainingEntries", "()Ljava/util/Set;", "resolve"})
    private static final class EnumExhaustivenessData {
        @NotNull
        private final Set<FirVariableSymbol<FirEnumEntry>> remainingEntries;
        private boolean containsNull;

        public EnumExhaustivenessData(@NotNull Set<FirVariableSymbol<FirEnumEntry>> remainingEntries, boolean containsNull) {
            Intrinsics.checkNotNullParameter(remainingEntries, (String)"remainingEntries");
            this.remainingEntries = remainingEntries;
            this.containsNull = containsNull;
        }

        @NotNull
        public final Set<FirVariableSymbol<FirEnumEntry>> getRemainingEntries() {
            return this.remainingEntries;
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$EnumExhaustivenessData;", "()V", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "resolve"})
    private static final class EnumExhaustivenessVisitor
    extends FirVisitor<Unit, EnumExhaustivenessData> {
        @NotNull
        public static final EnumExhaustivenessVisitor INSTANCE = new EnumExhaustivenessVisitor();

        private EnumExhaustivenessVisitor() {
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull EnumExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull EnumExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirOperation firOperation = equalityOperatorCall.getOperation();
            boolean bl = false;
            boolean bl2 = false;
            FirOperation it = firOperation;
            boolean bl3 = false;
            boolean bl4 = it == FirOperation.EQ || it == FirOperation.IDENTITY;
            if (bl4) {
                FirCall $this$arguments$iv = equalityOperatorCall;
                boolean $i$f$getArguments = false;
                FirExpression argument2 = $this$arguments$iv.getArgumentList().getArguments().get(1);
                if (argument2 instanceof FirConstExpression) {
                    if (((FirConstExpression)argument2).getValue() == null) {
                        data.setContainsNull(true);
                    }
                } else if (argument2 instanceof FirQualifiedAccessExpression) {
                    Object object = ((FirQualifiedAccessExpression)argument2).getCalleeReference();
                    FirResolvedNamedReference firResolvedNamedReference = $i$f$getArguments = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
                    if ($i$f$getArguments == null) {
                        return;
                    }
                    FirResolvedNamedReference reference = $i$f$getArguments;
                    Object obj = reference.getResolvedSymbol().getFir();
                    FirEnumEntry firEnumEntry = obj instanceof FirEnumEntry ? (FirEnumEntry)obj : null;
                    Object object2 = object = firEnumEntry == null ? null : firEnumEntry.getSymbol();
                    if (object == null) {
                        return;
                    }
                    Object symbol2 = object;
                    data.getRemainingEntries().remove(symbol2);
                }
            }
        }

        @Override
        public void visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @NotNull EnumExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (binaryLogicExpression.getKind() == LogicOperationKind.OR) {
                binaryLogicExpression.acceptChildren(this, data);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0017*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0018H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessData;", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "containsNull", "", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Z)V", "getContainsNull", "()Z", "setContainsNull", "(Z)V", "rootNode", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedClassInheritors;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "isExhaustive", "removeInheritor", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "mapToSealedInheritors", "", "", "resolve"})
    private final class SealedExhaustivenessData {
        private boolean containsNull;
        @NotNull
        private final FirSymbolProvider symbolProvider;
        @NotNull
        private final SealedClassInheritors rootNode;

        public SealedExhaustivenessData(FirRegularClass regularClass, boolean containsNull) {
            Intrinsics.checkNotNullParameter((Object)FirWhenExhaustivenessTransformer.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            this.containsNull = containsNull;
            this.symbolProvider = FirWhenExhaustivenessTransformer.this.bodyResolveComponents.getSymbolProvider();
            this.rootNode = new SealedClassInheritors(FirDeclarationUtilKt.getClassId(regularClass), this.mapToSealedInheritors(FirSealedClassInheritorsTransformerKt.getSealedInheritors(regularClass)));
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }

        @NotNull
        public final FirSymbolProvider getSymbolProvider() {
            return this.symbolProvider;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<SealedClassInheritors> mapToSealedInheritors(List<ClassId> $this$mapToSealedInheritors) {
            void $this$mapNotNullTo$iv$iv;
            Collection collection = $this$mapToSealedInheritors;
            boolean bl = false;
            boolean bl2 = false;
            if (collection == null || collection.isEmpty()) {
                return null;
            }
            Iterable $this$mapNotNull$iv = $this$mapToSealedInheritors;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                SealedClassInheritors sealedClassInheritors;
                FirRegularClass firRegularClass;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                ClassId it = (ClassId)element$iv$iv;
                boolean bl4 = false;
                FirClassLikeSymbol<?> firClassLikeSymbol = this.getSymbolProvider().getClassLikeSymbolByFqName(it);
                FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
                FirRegularClass firRegularClass2 = firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
                if (firRegularClass == null) {
                    sealedClassInheritors = null;
                } else {
                    FirRegularClass inheritor = firRegularClass;
                    sealedClassInheritors = new SealedClassInheritors(FirDeclarationUtilKt.getClassId(inheritor), this.mapToSealedInheritors(FirSealedClassInheritorsTransformerKt.getSealedInheritors(inheritor)));
                }
                if (sealedClassInheritors == null) continue;
                SealedClassInheritors sealedClassInheritors2 = sealedClassInheritors;
                boolean bl5 = false;
                boolean bl6 = false;
                SealedClassInheritors it$iv$iv = sealedClassInheritors2;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            bl2 = false;
            boolean bl8 = false;
            List it = list2;
            boolean bl9 = false;
            Collection collection2 = it;
            boolean bl10 = false;
            collection = !collection2.isEmpty() ? list2 : null;
            return collection == null ? null : CollectionsKt.toMutableSet((Iterable)collection);
        }

        public final void removeInheritor(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            if (Intrinsics.areEqual((Object)this.rootNode.getClassId(), (Object)classId)) {
                Set<SealedClassInheritors> set = this.rootNode.getInheritors();
                if (set != null) {
                    set.clear();
                }
                return;
            }
            this.rootNode.removeInheritor(classId);
        }

        public final boolean isExhaustive() {
            return this.containsNull && this.rootNode.isEmpty();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0005H\u00c6\u0003J%\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedClassInheritors;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "inheritors", "", "(Lorg/jetbrains/kotlin/name/ClassId;Ljava/util/Set;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getInheritors", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "removeInheritor", "toString", "", "resolve"})
    private static final class SealedClassInheritors {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final Set<SealedClassInheritors> inheritors;

        public SealedClassInheritors(@NotNull ClassId classId, @Nullable Set<SealedClassInheritors> inheritors) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            this.classId = classId;
            this.inheritors = inheritors;
        }

        public /* synthetic */ SealedClassInheritors(ClassId classId, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                set = null;
            }
            this(classId, set);
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final Set<SealedClassInheritors> getInheritors() {
            return this.inheritors;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean removeInheritor(@NotNull ClassId classId) {
            SealedClassInheritors it;
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            if (this.inheritors == null) return false;
            if (this.inheritors.removeIf(arg_0 -> SealedClassInheritors.removeInheritor$lambda-0(classId, arg_0))) return true;
            Iterable $this$any$iv = this.inheritors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (SealedClassInheritors)element$iv;
                boolean bl = false;
            } while (!it.removeInheritor(classId));
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEmpty() {
            SealedClassInheritors it;
            if (this.inheritors == null) return false;
            Iterable $this$all$iv = this.inheritors;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it = (SealedClassInheritors)element$iv;
                boolean bl = false;
            } while (it.isEmpty());
            return false;
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @Nullable
        public final Set<SealedClassInheritors> component2() {
            return this.inheritors;
        }

        @NotNull
        public final SealedClassInheritors copy(@NotNull ClassId classId, @Nullable Set<SealedClassInheritors> inheritors) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return new SealedClassInheritors(classId, inheritors);
        }

        public static /* synthetic */ SealedClassInheritors copy$default(SealedClassInheritors sealedClassInheritors, ClassId classId, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                classId = sealedClassInheritors.classId;
            }
            if ((n & 2) != 0) {
                set = sealedClassInheritors.inheritors;
            }
            return sealedClassInheritors.copy(classId, set);
        }

        @NotNull
        public String toString() {
            return "SealedClassInheritors(classId=" + this.classId + ", inheritors=" + this.inheritors + ')';
        }

        public int hashCode() {
            int result2 = this.classId.hashCode();
            result2 = result2 * 31 + (this.inheritors == null ? 0 : ((Object)this.inheritors).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SealedClassInheritors)) {
                return false;
            }
            SealedClassInheritors sealedClassInheritors = (SealedClassInheritors)other;
            if (!Intrinsics.areEqual((Object)this.classId, (Object)sealedClassInheritors.classId)) {
                return false;
            }
            return Intrinsics.areEqual(this.inheritors, sealedClassInheritors.inheritors);
        }

        private static final boolean removeInheritor$lambda-0(ClassId $classId, SealedClassInheritors it) {
            Intrinsics.checkNotNullParameter((Object)$classId, (String)"$classId");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getClassId(), (Object)$classId);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0003R\u00020\u0004H\u0016J\u001c\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\t\u001a\u00060\u0003R\u00020\u0004H\u0016J\u001c\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\t\u001a\u00060\u0003R\u00020\u0004H\u0016J\u001c\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\t\u001a\u00060\u0003R\u00020\u0004H\u0016J\u001c\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\t\u001a\u00060\u0003R\u00020\u0004H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$SealedExhaustivenessData;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "()V", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "resolve"})
    private static final class SealedExhaustivenessVisitor
    extends FirDefaultVisitor<Unit, SealedExhaustivenessData> {
        @NotNull
        public static final SealedExhaustivenessVisitor INSTANCE = new SealedExhaustivenessVisitor();

        private SealedExhaustivenessVisitor() {
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (typeOperatorCall.getOperation() == FirOperation.IS) {
                typeOperatorCall.getConversionTypeRef().accept(this, data);
            }
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirOperation firOperation = equalityOperatorCall.getOperation();
            boolean bl = false;
            boolean bl2 = false;
            FirOperation it = firOperation;
            boolean bl3 = false;
            boolean bl4 = it == FirOperation.EQ || it == FirOperation.IDENTITY;
            if (bl4) {
                FirCall $this$arguments$iv = equalityOperatorCall;
                boolean $i$f$getArguments = false;
                FirExpression argument2 = $this$arguments$iv.getArgumentList().getArguments().get(1);
                if (argument2 instanceof FirConstExpression) {
                    if (((FirConstExpression)argument2).getValue() == null) {
                        data.setContainsNull(true);
                    }
                } else if (argument2 instanceof FirResolvedQualifier) {
                    argument2.getTypeRef().accept(this, data);
                }
            }
        }

        @Override
        public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull SealedExhaustivenessData data) {
            ConeClassifierLookupTag coneClassifierLookupTag;
            Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirClassifierSymbol<?> firClassifierSymbol = resolvedTypeRef.getType();
            Object object = firClassifierSymbol instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)((Object)firClassifierSymbol) : null;
            ConeClassifierLookupTag coneClassifierLookupTag2 = coneClassifierLookupTag = object == null ? null : ((ConeLookupTagBasedType)object).getLookupTag();
            if (coneClassifierLookupTag == null) {
                return;
            }
            ConeClassifierLookupTag lookupTag = coneClassifierLookupTag;
            firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag(data.getSymbolProvider(), lookupTag);
            Object object2 = object = firClassifierSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassifierSymbol : null;
            if (object == null) {
                return;
            }
            Object symbol2 = object;
            data.removeInheritor(((FirClassLikeSymbol)symbol2).getClassId());
        }

        @Override
        public void visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @NotNull SealedExhaustivenessData data) {
            Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (binaryLogicExpression.getKind() == LogicOperationKind.OR) {
                binaryLogicExpression.acceptChildren(this, data);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0004R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u0004\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessFlags;", "", "containsNull", "", "(Z)V", "containsFalse", "getContainsFalse", "()Z", "setContainsFalse", "getContainsNull", "setContainsNull", "containsTrue", "getContainsTrue", "setContainsTrue", "resolve"})
    private static final class BooleanExhaustivenessFlags {
        private boolean containsNull;
        private boolean containsTrue;
        private boolean containsFalse;

        public BooleanExhaustivenessFlags(boolean containsNull) {
            this.containsNull = containsNull;
        }

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }

        public final boolean getContainsTrue() {
            return this.containsTrue;
        }

        public final void setContainsTrue(boolean bl) {
            this.containsTrue = bl;
        }

        public final boolean getContainsFalse() {
            return this.containsFalse;
        }

        public final void setContainsFalse(boolean bl) {
            this.containsFalse = bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$BooleanExhaustivenessFlags;", "()V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "resolve"})
    private static final class BooleanExhaustivenessVisitor
    extends FirVisitor<Unit, BooleanExhaustivenessFlags> {
        @NotNull
        public static final BooleanExhaustivenessVisitor INSTANCE = new BooleanExhaustivenessVisitor();

        private BooleanExhaustivenessVisitor() {
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull BooleanExhaustivenessFlags data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull BooleanExhaustivenessFlags data) {
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirOperation firOperation = equalityOperatorCall.getOperation();
            boolean bl = false;
            boolean bl2 = false;
            FirOperation it = firOperation;
            boolean bl3 = false;
            boolean bl4 = it == FirOperation.EQ || it == FirOperation.IDENTITY;
            if (bl4) {
                FirCall $this$arguments$iv = equalityOperatorCall;
                boolean $i$f$getArguments = false;
                FirExpression argument2 = $this$arguments$iv.getArgumentList().getArguments().get(1);
                if (argument2 instanceof FirConstExpression) {
                    Object t = ((FirConstExpression)argument2).getValue();
                    if (Intrinsics.areEqual(t, (Object)true)) {
                        data.setContainsTrue(true);
                    } else if (Intrinsics.areEqual(t, (Object)false)) {
                        data.setContainsFalse(true);
                    } else if (t == null) {
                        data.setContainsNull(true);
                    }
                }
            }
        }
    }
}

