/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.annotations.jvm.ReadOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForFunctionDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AccessorKind;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticAccessorUtilKt;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.AnonymousClassContext;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.DefaultImplsClassContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassPartContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class CodegenContext<T extends DeclarationDescriptor> {
    private final T contextDescriptor;
    private final OwnerKind contextKind;
    private final CodegenContext parentContext;
    private final ClassDescriptor thisDescriptor;
    @Nullable
    public final MutableClosure closure;
    private final LocalLookup enclosingLocalLookup;
    private final NullableLazyValue<StackValue.Field> outerExpression;
    private Map<DeclarationDescriptor, CodegenContext> childContexts;
    private Map<AccessorKey, AccessorForCallableDescriptor<?>> accessors;
    private Map<AccessorKey, AccessorForPropertyDescriptorFactory> propertyAccessorFactories;
    private final Map<ClassDescriptor, AccessorForCompanionObjectInstanceFieldDescriptor> accessorsForCompanionObjects;

    public CodegenContext(@NotNull T contextDescriptor, @NotNull OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable MutableClosure closure, @Nullable ClassDescriptor thisDescriptor, @Nullable LocalLookup localLookup2) {
        if (contextDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(0);
        }
        if (contextKind == null) {
            CodegenContext.$$$reportNull$$$0(1);
        }
        this.accessorsForCompanionObjects = new LinkedHashMap<ClassDescriptor, AccessorForCompanionObjectInstanceFieldDescriptor>();
        this.contextDescriptor = contextDescriptor;
        this.contextKind = contextKind;
        this.parentContext = parentContext;
        this.closure = closure;
        this.thisDescriptor = thisDescriptor;
        this.enclosingLocalLookup = localLookup2;
        this.outerExpression = LockBasedStorageManager.NO_LOCKS.createNullableLazyValue(this::computeOuterExpression);
        if (parentContext != null) {
            parentContext.addChild(this);
        }
    }

    @NotNull
    public GenerationState getState() {
        GenerationState generationState = this.parentContext.getState();
        if (generationState == null) {
            CodegenContext.$$$reportNull$$$0(2);
        }
        return generationState;
    }

    @NotNull
    public final ClassDescriptor getThisDescriptor() {
        if (this.thisDescriptor == null) {
            throw new UnsupportedOperationException("Context doesn't have a \"this\": " + this);
        }
        ClassDescriptor classDescriptor = this.thisDescriptor;
        if (classDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(3);
        }
        return classDescriptor;
    }

    public final boolean hasThisDescriptor() {
        return this.thisDescriptor != null;
    }

    @NotNull
    public CodegenContext<? extends ClassOrPackageFragmentDescriptor> getClassOrPackageParentContext() {
        CodegenContext context2 = this;
        while (true) {
            if (context2.getContextDescriptor() instanceof ClassOrPackageFragmentDescriptor) {
                CodegenContext codegenContext = context2;
                if (codegenContext == null) {
                    CodegenContext.$$$reportNull$$$0(4);
                }
                return codegenContext;
            }
            context2 = context2.getParentContext();
            assert (context2 != null) : "Context which is not top-level has no parent: " + this;
        }
    }

    @Nullable
    public final CallableDescriptor getCallableDescriptorWithReceiver() {
        if (this.contextDescriptor instanceof CallableDescriptor) {
            CallableDescriptor callableDescriptor = (CallableDescriptor)this.getContextDescriptor();
            return callableDescriptor.getExtensionReceiverParameter() != null ? callableDescriptor : null;
        }
        return null;
    }

    public StackValue getOuterExpression(@Nullable StackValue prefix, boolean ignoreNoOuter) {
        return this.getOuterExpression(prefix, ignoreNoOuter, true);
    }

    private StackValue getOuterExpression(@Nullable StackValue prefix, boolean ignoreNoOuter, boolean captureThis) {
        if (this.outerExpression.invoke() == null) {
            if (!ignoreNoOuter) {
                throw new UnsupportedOperationException("Don't know how to generate outer expression: " + this);
            }
            return null;
        }
        if (captureThis) {
            if (this.closure == null) {
                throw new IllegalStateException("Can't capture this for context without closure: " + this);
            }
            this.closure.setNeedsCaptureOuterClass();
        }
        return StackValue.changeReceiverForFieldAndSharedVar((StackValue.StackValueWithSimpleReceiver)this.outerExpression.invoke(), prefix);
    }

    @NotNull
    public T getContextDescriptor() {
        T t = this.contextDescriptor;
        if (t == null) {
            CodegenContext.$$$reportNull$$$0(5);
        }
        return t;
    }

    @NotNull
    public OwnerKind getContextKind() {
        OwnerKind ownerKind = this.contextKind;
        if (ownerKind == null) {
            CodegenContext.$$$reportNull$$$0(6);
        }
        return ownerKind;
    }

    @NotNull
    public PackageContext intoPackagePart(@NotNull PackageFragmentDescriptor descriptor2, Type packagePartType, @Nullable KtFile sourceFile) {
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(7);
        }
        return new PackageContext(descriptor2, this, packagePartType, sourceFile);
    }

    @NotNull
    public MultifileClassPartContext intoMultifileClassPart(@NotNull PackageFragmentDescriptor descriptor2, @NotNull Type multifileClassType, @NotNull Type filePartType, @NotNull KtFile sourceFile) {
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(8);
        }
        if (multifileClassType == null) {
            CodegenContext.$$$reportNull$$$0(9);
        }
        if (filePartType == null) {
            CodegenContext.$$$reportNull$$$0(10);
        }
        if (sourceFile == null) {
            CodegenContext.$$$reportNull$$$0(11);
        }
        return new MultifileClassPartContext(descriptor2, this, multifileClassType, filePartType, sourceFile);
    }

    @NotNull
    public FieldOwnerContext<PackageFragmentDescriptor> intoMultifileClass(@NotNull PackageFragmentDescriptor descriptor2, @NotNull Type multifileClassType, @NotNull Type filePartType) {
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(12);
        }
        if (multifileClassType == null) {
            CodegenContext.$$$reportNull$$$0(13);
        }
        if (filePartType == null) {
            CodegenContext.$$$reportNull$$$0(14);
        }
        return new MultifileClassFacadeContext(descriptor2, this, multifileClassType, filePartType);
    }

    public ClassContext intoDefaultImplsClass(ClassDescriptor descriptor2, ClassContext interfaceContext, GenerationState state) {
        return new DefaultImplsClassContext(state.getTypeMapper(), descriptor2, OwnerKind.DEFAULT_IMPLS, this, null, interfaceContext);
    }

    @NotNull
    public ClassContext intoClass(@NotNull ClassDescriptor descriptor2, @NotNull OwnerKind kind, @NotNull GenerationState state) {
        CodegenContext savedContext;
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            CodegenContext.$$$reportNull$$$0(16);
        }
        if (state == null) {
            CodegenContext.$$$reportNull$$$0(17);
        }
        if (CodegenContext.shouldAddChild(descriptor2) && (savedContext = this.findChildContext(descriptor2)) != null) {
            assert (savedContext.getContextKind() == kind) : "Kinds should be same, but: " + (Object)((Object)savedContext.getContextKind()) + "!= " + (Object)((Object)kind);
            ClassContext classContext = (ClassContext)savedContext;
            if (classContext == null) {
                CodegenContext.$$$reportNull$$$0(18);
            }
            return classContext;
        }
        ClassContext classContext = new ClassContext(state.getTypeMapper(), descriptor2, kind, this, null);
        if (descriptor2.getCompanionObjectDescriptor() != null) {
            classContext.intoClass(descriptor2.getCompanionObjectDescriptor(), OwnerKind.IMPLEMENTATION, state);
        }
        ClassContext classContext2 = classContext;
        if (classContext2 == null) {
            CodegenContext.$$$reportNull$$$0(19);
        }
        return classContext2;
    }

    @NotNull
    public ClassContext intoAnonymousClass(@NotNull ClassDescriptor descriptor2, @NotNull ExpressionCodegen codegen2, @NotNull OwnerKind ownerKind) {
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(20);
        }
        if (codegen2 == null) {
            CodegenContext.$$$reportNull$$$0(21);
        }
        if (ownerKind == null) {
            CodegenContext.$$$reportNull$$$0(22);
        }
        return new AnonymousClassContext(codegen2.getState().getTypeMapper(), descriptor2, ownerKind, this, codegen2);
    }

    @NotNull
    public MethodContext intoFunction(FunctionDescriptor descriptor2, boolean isDefaultFunctionContext) {
        return new MethodContext(descriptor2, this.getContextKind(), this, null, isDefaultFunctionContext);
    }

    @NotNull
    public MethodContext intoFunction(FunctionDescriptor descriptor2) {
        MethodContext methodContext2 = this.intoFunction(descriptor2, false);
        if (methodContext2 == null) {
            CodegenContext.$$$reportNull$$$0(23);
        }
        return methodContext2;
    }

    @NotNull
    public MethodContext intoInlinedLambda(FunctionDescriptor descriptor2, boolean isCrossInline, boolean isPropertyReference) {
        return new InlineLambdaContext(descriptor2, this.getContextKind(), this, null, isCrossInline, isPropertyReference);
    }

    @NotNull
    public ConstructorContext intoConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull KotlinTypeMapper typeMapper) {
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(24);
        }
        if (typeMapper == null) {
            CodegenContext.$$$reportNull$$$0(25);
        }
        return new ConstructorContext(descriptor2, this.getContextKind(), this, this.closure, typeMapper);
    }

    @NotNull
    public ScriptContext intoScript(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> earlierScripts, @NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        if (script == null) {
            CodegenContext.$$$reportNull$$$0(26);
        }
        if (earlierScripts == null) {
            CodegenContext.$$$reportNull$$$0(27);
        }
        if (classDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(28);
        }
        if (typeMapper == null) {
            CodegenContext.$$$reportNull$$$0(29);
        }
        return new ScriptContext(typeMapper, script, earlierScripts, classDescriptor, this);
    }

    @NotNull
    public ClosureContext intoClosure(@NotNull FunctionDescriptor funDescriptor, @NotNull LocalLookup localLookup2, @NotNull KotlinTypeMapper typeMapper) {
        if (funDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(30);
        }
        if (localLookup2 == null) {
            CodegenContext.$$$reportNull$$$0(31);
        }
        if (typeMapper == null) {
            CodegenContext.$$$reportNull$$$0(32);
        }
        return new ClosureContext(typeMapper, funDescriptor, this, localLookup2);
    }

    @NotNull
    public ClosureContext intoCoroutineClosure(@NotNull FunctionDescriptor jvmViewOfSuspendLambda, @NotNull FunctionDescriptor originalSuspendLambdaDescriptor, @NotNull LocalLookup localLookup2, @NotNull KotlinTypeMapper typeMapper) {
        if (jvmViewOfSuspendLambda == null) {
            CodegenContext.$$$reportNull$$$0(33);
        }
        if (originalSuspendLambdaDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(34);
        }
        if (localLookup2 == null) {
            CodegenContext.$$$reportNull$$$0(35);
        }
        if (typeMapper == null) {
            CodegenContext.$$$reportNull$$$0(36);
        }
        return new ClosureContext(typeMapper, jvmViewOfSuspendLambda, this, localLookup2, originalSuspendLambdaDescriptor);
    }

    public ClassContext intoWrapperForErasedInlineClass(ClassDescriptor descriptor2, GenerationState state) {
        return new ClassContext(state.getTypeMapper(), descriptor2, OwnerKind.ERASED_INLINE_CLASS, this, null);
    }

    @Nullable
    public CodegenContext getParentContext() {
        return this.parentContext;
    }

    public boolean isContextWithUninitializedThis() {
        return false;
    }

    @Nullable
    public CodegenContext getEnclosingClassContext() {
        for (CodegenContext cur = this.getEnclosingThisContext(); cur != null; cur = cur.getParentContext()) {
            T curDescriptor = cur.getContextDescriptor();
            if (!(curDescriptor instanceof ClassDescriptor)) continue;
            return cur;
        }
        return null;
    }

    @Nullable
    public CodegenContext getEnclosingThisContext() {
        CodegenContext cur = this.getParentContext();
        while (cur != null && cur.isContextWithUninitializedThis()) {
            CodegenContext parent2 = cur.getParentContext();
            assert (parent2 != null) : "Context " + cur + " should have a parent";
            cur = parent2.getParentContext();
        }
        return cur;
    }

    @Nullable
    public ClassDescriptor getEnclosingClass() {
        CodegenContext enclosingClassContext = this.getEnclosingClassContext();
        if (enclosingClassContext == null) {
            return null;
        }
        return (ClassDescriptor)enclosingClassContext.getContextDescriptor();
    }

    @Nullable
    public CodegenContext findParentContextWithDescriptor(DeclarationDescriptor descriptor2) {
        CodegenContext c;
        for (c = this; c != null && (c.isShadowedByParentContext() || c.getContextDescriptor() != descriptor2); c = c.getParentContext()) {
        }
        return c;
    }

    private boolean isShadowedByParentContext() {
        return this.getContextKind() == OwnerKind.ERASED_INLINE_CLASS;
    }

    @NotNull
    private PropertyDescriptor getPropertyAccessor(@NotNull PropertyDescriptor propertyDescriptor, @Nullable ClassDescriptor superCallTarget, boolean getterAccessorRequired, boolean setterAccessorRequired) {
        if (propertyDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(37);
        }
        return this.getAccessor(propertyDescriptor, AccessorKind.NORMAL, null, superCallTarget, getterAccessorRequired, setterAccessorRequired);
    }

    public <D extends CallableMemberDescriptor> D getAccessorForJvmDefaultCompatibility(@NotNull D descriptor2) {
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(38);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyAccessor = this.getAccessor(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty(), AccessorKind.JVM_DEFAULT_COMPATIBILITY, null, null, descriptor2 instanceof PropertyGetterDescriptor, descriptor2 instanceof PropertySetterDescriptor);
            return (D)(descriptor2 instanceof PropertyGetterDescriptor ? propertyAccessor.getGetter() : propertyAccessor.getSetter());
        }
        return this.getAccessor(descriptor2, AccessorKind.JVM_DEFAULT_COMPATIBILITY, null, null);
    }

    @NotNull
    private <D extends CallableMemberDescriptor> D getAccessor(@NotNull D descriptor2, @Nullable ClassDescriptor superCallTarget) {
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(39);
        }
        D d = this.getAccessor(descriptor2, AccessorKind.NORMAL, null, superCallTarget);
        if (d == null) {
            CodegenContext.$$$reportNull$$$0(40);
        }
        return d;
    }

    @NotNull
    public <D extends CallableMemberDescriptor> D getAccessorForSuperCallIfNeeded(@NotNull D descriptor2, @Nullable ClassDescriptor superCallTarget, @NotNull GenerationState state) {
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(41);
        }
        if (state == null) {
            CodegenContext.$$$reportNull$$$0(42);
        }
        if (superCallTarget != null && !JvmCodegenUtil.isNonDefaultInterfaceMember(descriptor2, state.getJvmDefaultMode())) {
            CodegenContext afterInline = this.getFirstCrossInlineOrNonInlineContext();
            CodegenContext c = afterInline.findParentContextWithDescriptor(superCallTarget);
            assert (c != null) : "Couldn't find a context for a super-call: " + descriptor2;
            if (c != afterInline.getParentContext()) {
                return c.getAccessor(descriptor2, superCallTarget);
            }
        }
        D d = descriptor2;
        if (d == null) {
            CodegenContext.$$$reportNull$$$0(43);
        }
        return d;
    }

    @NotNull
    public <D extends CallableMemberDescriptor> D getAccessor(@NotNull D possiblySubstitutedDescriptor, @NotNull AccessorKind accessorKind, @Nullable KotlinType delegateType, @Nullable ClassDescriptor superCallTarget) {
        if (possiblySubstitutedDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(44);
        }
        if (accessorKind == null) {
            CodegenContext.$$$reportNull$$$0(45);
        }
        return this.getAccessor(possiblySubstitutedDescriptor, accessorKind, delegateType, superCallTarget, true, true);
    }

    @NotNull
    private <D extends CallableMemberDescriptor> D getAccessor(@NotNull D possiblySubstitutedDescriptor, @NotNull AccessorKind accessorKind, @Nullable KotlinType delegateType, @Nullable ClassDescriptor superCallTarget, boolean getterAccessorRequired, boolean setterAccessorRequired) {
        DeclarationDescriptorNonRootImpl accessor;
        CallableMemberDescriptor descriptor2;
        AccessorKey key;
        if (possiblySubstitutedDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(46);
        }
        if (accessorKind == null) {
            CodegenContext.$$$reportNull$$$0(47);
        }
        if (this.accessors == null) {
            this.accessors = new LinkedHashMap();
        }
        if (this.propertyAccessorFactories == null) {
            this.propertyAccessorFactories = new LinkedHashMap<AccessorKey, AccessorForPropertyDescriptorFactory>();
        }
        if (this.propertyAccessorFactories.containsKey(key = new AccessorKey(descriptor2 = possiblySubstitutedDescriptor.getOriginal(), superCallTarget, accessorKind))) {
            PropertyDescriptor propertyDescriptor = this.propertyAccessorFactories.get(key).getOrCreateAccessorIfNeeded(getterAccessorRequired, setterAccessorRequired);
            if (propertyDescriptor == null) {
                CodegenContext.$$$reportNull$$$0(48);
            }
            return (D)propertyDescriptor;
        }
        if (this.accessors.containsKey(key)) {
            AccessorForCallableDescriptor<?> accessor2 = this.accessors.get(key);
            assert (accessorKind == AccessorKind.NORMAL || accessor2 instanceof AccessorForPropertyBackingField) : "There is already exists accessor with isForBackingField = false in this context";
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)((Object)accessor2);
            if (callableMemberDescriptor == null) {
                CodegenContext.$$$reportNull$$$0(49);
            }
            return (D)callableMemberDescriptor;
        }
        String nameSuffix = SyntheticAccessorUtilKt.getAccessorNameSuffix(descriptor2, key.superCallLabelTarget, accessorKind);
        if (descriptor2 instanceof SimpleFunctionDescriptor) {
            accessor = new AccessorForFunctionDescriptor((FunctionDescriptor)descriptor2, (DeclarationDescriptor)this.contextDescriptor, superCallTarget, nameSuffix, accessorKind);
        } else if (descriptor2 instanceof ClassConstructorDescriptor) {
            accessor = new AccessorForConstructorDescriptor((ClassConstructorDescriptor)descriptor2, (DeclarationDescriptor)this.contextDescriptor, superCallTarget, accessorKind);
        } else if (descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            if (accessorKind == AccessorKind.NORMAL || accessorKind == AccessorKind.JVM_DEFAULT_COMPATIBILITY) {
                AccessorForPropertyDescriptorFactory factory2 = new AccessorForPropertyDescriptorFactory(propertyDescriptor, (DeclarationDescriptor)this.contextDescriptor, superCallTarget, nameSuffix, accessorKind);
                this.propertyAccessorFactories.put(key, factory2);
                this.accessors.put(key, factory2.getOrCreateAccessorWithSyntheticGetterAndSetter());
                PropertyDescriptor propertyDescriptor2 = factory2.getOrCreateAccessorIfNeeded(getterAccessorRequired, setterAccessorRequired);
                if (propertyDescriptor2 == null) {
                    CodegenContext.$$$reportNull$$$0(50);
                }
                return (D)propertyDescriptor2;
            }
            accessor = new AccessorForPropertyBackingField(propertyDescriptor, (DeclarationDescriptor)this.contextDescriptor, delegateType, accessorKind == AccessorKind.IN_CLASS_COMPANION ? null : propertyDescriptor.getExtensionReceiverParameter(), accessorKind == AccessorKind.IN_CLASS_COMPANION ? null : propertyDescriptor.getDispatchReceiverParameter(), nameSuffix, accessorKind);
        } else {
            throw new UnsupportedOperationException("Do not know how to create accessor for descriptor " + descriptor2 + " in context " + this);
        }
        this.accessors.put(key, (AccessorForCallableDescriptor<?>)((Object)accessor));
        CallableMemberDescriptor callableMemberDescriptor = accessor;
        if (callableMemberDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(51);
        }
        return (D)callableMemberDescriptor;
    }

    @Nullable
    protected StackValue.Field computeOuterExpression() {
        return null;
    }

    public StackValue lookupInContext(DeclarationDescriptor d, @Nullable StackValue result2, GenerationState state, boolean ignoreNoOuter) {
        StackValue resultValue;
        StackValue myOuter = null;
        if (this.closure != null) {
            EnclosedValueDescriptor capturedVariable = this.closure.getCaptureVariables().get(d);
            if (capturedVariable != null) {
                return StackValue.changeReceiverForFieldAndSharedVar(capturedVariable.getInnerValue(), result2);
            }
            for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
                if (!aCase.isCase(d)) continue;
                Type classType = state.getTypeMapper().mapType(this.getThisDescriptor());
                StackValue.StackValueWithSimpleReceiver innerValue = aCase.innerValue(d, this.enclosingLocalLookup, state, this.closure, classType);
                if (innerValue == null) break;
                return StackValue.changeReceiverForFieldAndSharedVar(innerValue, result2);
            }
            result2 = myOuter = this.getOuterExpression(result2, ignoreNoOuter, false);
        }
        if (myOuter != null && this.getEnclosingClass() == d) {
            resultValue = result2;
        } else {
            CodegenContext enclosingClassContext = this.getEnclosingThisContext();
            StackValue stackValue = resultValue = enclosingClassContext != null ? enclosingClassContext.lookupInContext(d, result2, state, ignoreNoOuter) : null;
        }
        if (myOuter != null && resultValue != null && !CodegenContext.isStaticField(resultValue)) {
            this.closure.setNeedsCaptureOuterClass();
        }
        return resultValue;
    }

    @NotNull
    @ReadOnly
    public Collection<? extends AccessorForCallableDescriptor<?>> getAccessors() {
        Collection<Object> collection = this.accessors == null ? Collections.emptySet() : this.accessors.values();
        if (collection == null) {
            CodegenContext.$$$reportNull$$$0(52);
        }
        return collection;
    }

    @NotNull
    public <D extends CallableMemberDescriptor> D accessibleDescriptor(@NotNull D descriptor2, @Nullable ClassDescriptor superCallTarget) {
        boolean sameJvmDefault;
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(53);
        }
        CodegenContext properContext = this.getFirstCrossInlineOrNonInlineContext();
        DeclarationDescriptor enclosing = descriptor2.getContainingDeclaration();
        boolean isInliningContext = properContext.isInlineMethodContext();
        boolean bl = sameJvmDefault = JvmAnnotationUtilKt.isCompiledToJvmDefault(descriptor2, this.getState().getJvmDefaultMode()) == JvmAnnotationUtilKt.isCallableMemberCompiledToJvmDefault(properContext.contextDescriptor, this.getState().getJvmDefaultMode()) || properContext.contextDescriptor instanceof AccessorForCallableDescriptor;
        if (!isInliningContext && (!properContext.hasThisDescriptor() || enclosing == properContext.getThisDescriptor() && sameJvmDefault || enclosing == properContext.getClassOrPackageParentContext().getContextDescriptor() && sameJvmDefault)) {
            D d = descriptor2;
            if (d == null) {
                CodegenContext.$$$reportNull$$$0(54);
            }
            return d;
        }
        return properContext.accessibleDescriptorIfNeeded(descriptor2, superCallTarget, isInliningContext);
    }

    @NotNull
    private <D extends CallableMemberDescriptor> D accessibleDescriptorIfNeeded(@NotNull D descriptor2, @Nullable ClassDescriptor superCallTarget, boolean withinInliningContext) {
        CodegenContext parentContextForClass;
        ClassDescriptor classDescriptor;
        CodegenContext classContext;
        if (descriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(55);
        }
        D unwrappedDescriptor = DescriptorUtils.unwrapFakeOverride(descriptor2);
        DeclarationDescriptor enclosed = descriptor2.getContainingDeclaration();
        CodegenContext descriptorContext = this.findParentContextWithDescriptor(enclosed);
        if (descriptorContext == null && DescriptorUtils.isCompanionObject(enclosed) && (classContext = this.findParentContextWithDescriptor(enclosed.getContainingDeclaration())) instanceof ClassContext) {
            descriptorContext = ((ClassContext)classContext).getCompanionObjectContext();
        }
        if (descriptorContext == null && JavaDescriptorVisibilities.PROTECTED_STATIC_VISIBILITY == descriptor2.getVisibility() && !(descriptor2.getOriginal() instanceof SamConstructorDescriptor)) {
            descriptorContext = ExpressionCodegen.getParentContextSubclassOf((ClassDescriptor)enclosed, this);
            superCallTarget = (ClassDescriptor)enclosed;
        }
        if (descriptorContext == null && withinInliningContext && superCallTarget != null) {
            descriptorContext = ExpressionCodegen.getParentContextSubclassOf((ClassDescriptor)enclosed, this);
        }
        if (descriptorContext == null && descriptor2 instanceof ClassConstructorDescriptor && DescriptorUtils.isSealedClass(classDescriptor = ((ClassConstructorDescriptor)descriptor2).getContainingDeclaration()) && (parentContextForClass = this.findParentContextWithDescriptor(classDescriptor.getContainingDeclaration())) != null) {
            descriptorContext = parentContextForClass.findChildContext(classDescriptor);
        }
        if (descriptorContext == null) {
            D d = descriptor2;
            if (d == null) {
                CodegenContext.$$$reportNull$$$0(56);
            }
            return d;
        }
        if (this.getState().getJvmDefaultMode() == JvmDefaultMode.ENABLE && JvmAnnotationUtilKt.hasJvmDefaultAnnotation(descriptor2) && descriptorContext instanceof DefaultImplsClassContext) {
            descriptorContext = ((DefaultImplsClassContext)descriptorContext).getInterfaceContext();
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            int propertyAccessFlag = DescriptorAsmUtil.getVisibilityAccessFlag(descriptor2);
            PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
            int getterAccessFlag = getter2 == null ? propertyAccessFlag : propertyAccessFlag | DescriptorAsmUtil.getVisibilityAccessFlag(getter2);
            boolean getterAccessorRequired = CodegenContext.isAccessorRequired(getterAccessFlag, unwrappedDescriptor, descriptorContext, withinInliningContext, superCallTarget != null);
            PropertySetterDescriptor setter2 = propertyDescriptor.getSetter();
            int setterAccessFlag = propertyAccessFlag;
            if (setter2 != null && setter2.getVisibility().normalize() != DescriptorVisibilities.INVISIBLE_FAKE) {
                setterAccessFlag = propertyAccessFlag | DescriptorAsmUtil.getVisibilityAccessFlag(setter2);
            }
            boolean setterAccessorRequired = CodegenContext.isAccessorRequired(setterAccessFlag, unwrappedDescriptor, descriptorContext, withinInliningContext, superCallTarget != null);
            if (!getterAccessorRequired && !setterAccessorRequired) {
                D d = descriptor2;
                if (d == null) {
                    CodegenContext.$$$reportNull$$$0(57);
                }
                return d;
            }
            return (D)descriptorContext.getPropertyAccessor(propertyDescriptor, superCallTarget, getterAccessorRequired, setterAccessorRequired);
        }
        int flag = DescriptorAsmUtil.getVisibilityAccessFlag(unwrappedDescriptor);
        if (!CodegenContext.isAccessorRequired(flag, unwrappedDescriptor, descriptorContext, withinInliningContext, superCallTarget != null)) {
            D d = descriptor2;
            if (d == null) {
                CodegenContext.$$$reportNull$$$0(58);
            }
            return d;
        }
        return descriptorContext.getAccessor(descriptor2, superCallTarget);
    }

    private static boolean isAccessorRequired(int accessFlag, @NotNull CallableMemberDescriptor unwrappedDescriptor, @NotNull CodegenContext descriptorContext, boolean withinInline, boolean isSuperCall) {
        if (unwrappedDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(59);
        }
        if (descriptorContext == null) {
            CodegenContext.$$$reportNull$$$0(60);
        }
        if (InlineOnlyKt.isInlineOnlyPrivateInBytecode(unwrappedDescriptor)) {
            return false;
        }
        return isSuperCall && withinInline || (accessFlag & 2) != 0 || (accessFlag & 4) != 0 && (withinInline || !JvmCodegenUtil.isInSamePackage(unwrappedDescriptor, descriptorContext.getContextDescriptor()));
    }

    private void addChild(@NotNull CodegenContext child) {
        if (child == null) {
            CodegenContext.$$$reportNull$$$0(61);
        }
        if (CodegenContext.shouldAddChild(child.contextDescriptor)) {
            if (this.childContexts == null) {
                this.childContexts = new HashMap<DeclarationDescriptor, CodegenContext>();
            }
            T childContextDescriptor = child.getContextDescriptor();
            this.childContexts.put((DeclarationDescriptor)childContextDescriptor, child);
        }
    }

    private static boolean shouldAddChild(@NotNull DeclarationDescriptor childContextDescriptor) {
        if (childContextDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(62);
        }
        return DescriptorUtils.isCompanionObject(childContextDescriptor) || DescriptorUtils.isSealedClass(childContextDescriptor);
    }

    @Nullable
    protected CodegenContext findChildContext(@NotNull DeclarationDescriptor child) {
        if (child == null) {
            CodegenContext.$$$reportNull$$$0(63);
        }
        return this.childContexts == null ? null : this.childContexts.get(child);
    }

    private static boolean isStaticField(@NotNull StackValue value2) {
        if (value2 == null) {
            CodegenContext.$$$reportNull$$$0(64);
        }
        return value2 instanceof StackValue.Field && ((StackValue.Field)value2).isStaticPut;
    }

    public boolean isInlineMethodContext() {
        return false;
    }

    @NotNull
    public CodegenContext getFirstCrossInlineOrNonInlineContext() {
        CodegenContext codegenContext = this;
        if (codegenContext == null) {
            CodegenContext.$$$reportNull$$$0(65);
        }
        return codegenContext;
    }

    @Nullable
    public LocalLookup getEnclosingLocalLookup() {
        return this.enclosingLocalLookup;
    }

    @NotNull
    public AccessorForCompanionObjectInstanceFieldDescriptor getOrCreateAccessorForCompanionObject(@NotNull ClassDescriptor companionObjectDescriptor2) {
        if (companionObjectDescriptor2 == null) {
            CodegenContext.$$$reportNull$$$0(66);
        }
        AccessorForCompanionObjectInstanceFieldDescriptor accessorForCompanionObjectInstanceFieldDescriptor = this.accessorsForCompanionObjects.computeIfAbsent(companionObjectDescriptor2, it -> new AccessorForCompanionObjectInstanceFieldDescriptor((ClassDescriptor)it, Name.identifier(JvmCodegenUtil.getCompanionObjectAccessorName(it))));
        if (accessorForCompanionObjectInstanceFieldDescriptor == null) {
            CodegenContext.$$$reportNull$$$0(67);
        }
        return accessorForCompanionObjectInstanceFieldDescriptor;
    }

    @NotNull
    public Collection<AccessorForCompanionObjectInstanceFieldDescriptor> getRequiredAccessorsForCompanionObjects() {
        Collection<AccessorForCompanionObjectInstanceFieldDescriptor> collection = this.accessorsForCompanionObjects.values();
        if (collection == null) {
            CodegenContext.$$$reportNull$$$0(68);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 19: 
            case 23: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 67: 
            case 68: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 19: 
            case 23: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 67: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextKind";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 19: 
            case 23: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/context/CodegenContext";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 20: 
            case 24: 
            case 38: 
            case 39: 
            case 41: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multifileClassType";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePartType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerKind";
                break;
            }
            case 25: 
            case 29: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earlierScripts";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funDescriptor";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localLookup";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmViewOfSuspendLambda";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSuspendLambdaDescriptor";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possiblySubstitutedDescriptor";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorKind";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unwrappedDescriptor";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorContext";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childContextDescriptor";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "companionObjectDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/context/CodegenContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThisDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassOrPackageParentContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextKind";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "intoClass";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "intoFunction";
                break;
            }
            case 40: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorForSuperCallIfNeeded";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "accessibleDescriptor";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "accessibleDescriptorIfNeeded";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstCrossInlineOrNonInlineContext";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateAccessorForCompanionObject";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredAccessorsForCompanionObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 19: 
            case 23: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 67: 
            case 68: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intoPackagePart";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "intoMultifileClassPart";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "intoMultifileClass";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "intoClass";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "intoAnonymousClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "intoConstructor";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "intoScript";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "intoClosure";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "intoCoroutineClosure";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyAccessor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorForJvmDefaultCompatibility";
                break;
            }
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorForSuperCallIfNeeded";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "accessibleDescriptor";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "accessibleDescriptorIfNeeded";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isAccessorRequired";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddChild";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findChildContext";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isStaticField";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateAccessorForCompanionObject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 19: 
            case 23: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 67: 
            case 68: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AccessorForPropertyDescriptorFactory {
        @NotNull
        private final PropertyDescriptor property;
        @NotNull
        private final DeclarationDescriptor containingDeclaration;
        @Nullable
        private final ClassDescriptor superCallTarget;
        @NotNull
        private final String nameSuffix;
        @NotNull
        private final AccessorKind accessorKind;
        private AccessorForPropertyDescriptor withSyntheticGetterAndSetter;
        private AccessorForPropertyDescriptor withSyntheticGetter;
        private AccessorForPropertyDescriptor withSyntheticSetter;

        public AccessorForPropertyDescriptorFactory(@NotNull PropertyDescriptor property2, @NotNull DeclarationDescriptor containingDeclaration, @Nullable ClassDescriptor superCallTarget, @NotNull String nameSuffix, @NotNull AccessorKind accessorKind) {
            if (property2 == null) {
                AccessorForPropertyDescriptorFactory.$$$reportNull$$$0(0);
            }
            if (containingDeclaration == null) {
                AccessorForPropertyDescriptorFactory.$$$reportNull$$$0(1);
            }
            if (nameSuffix == null) {
                AccessorForPropertyDescriptorFactory.$$$reportNull$$$0(2);
            }
            if (accessorKind == null) {
                AccessorForPropertyDescriptorFactory.$$$reportNull$$$0(3);
            }
            this.withSyntheticGetterAndSetter = null;
            this.withSyntheticGetter = null;
            this.withSyntheticSetter = null;
            this.property = property2;
            this.containingDeclaration = containingDeclaration;
            this.superCallTarget = superCallTarget;
            this.nameSuffix = nameSuffix;
            this.accessorKind = accessorKind;
        }

        public PropertyDescriptor getOrCreateAccessorIfNeeded(boolean getterAccessorRequired, boolean setterAccessorRequired) {
            if (getterAccessorRequired && setterAccessorRequired) {
                return this.getOrCreateAccessorWithSyntheticGetterAndSetter();
            }
            if (getterAccessorRequired && !setterAccessorRequired) {
                if (this.withSyntheticGetter == null) {
                    this.withSyntheticGetter = new AccessorForPropertyDescriptor(this.property, this.containingDeclaration, this.superCallTarget, this.nameSuffix, true, false, this.accessorKind);
                }
                return this.withSyntheticGetter;
            }
            if (!getterAccessorRequired && setterAccessorRequired) {
                if (this.withSyntheticSetter == null) {
                    this.withSyntheticSetter = new AccessorForPropertyDescriptor(this.property, this.containingDeclaration, this.superCallTarget, this.nameSuffix, false, true, this.accessorKind);
                }
                return this.withSyntheticSetter;
            }
            return this.property;
        }

        @NotNull
        public AccessorForPropertyDescriptor getOrCreateAccessorWithSyntheticGetterAndSetter() {
            if (this.withSyntheticGetterAndSetter == null) {
                this.withSyntheticGetterAndSetter = new AccessorForPropertyDescriptor(this.property, this.containingDeclaration, this.superCallTarget, this.nameSuffix, true, true, this.accessorKind);
            }
            AccessorForPropertyDescriptor accessorForPropertyDescriptor = this.withSyntheticGetterAndSetter;
            if (accessorForPropertyDescriptor == null) {
                AccessorForPropertyDescriptorFactory.$$$reportNull$$$0(4);
            }
            return accessorForPropertyDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingDeclaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameSuffix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessorKind";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/codegen/context/CodegenContext$AccessorForPropertyDescriptorFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/context/CodegenContext$AccessorForPropertyDescriptorFactory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateAccessorWithSyntheticGetterAndSetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AccessorKey {
        public final DeclarationDescriptor descriptor;
        public final ClassDescriptor superCallLabelTarget;
        public final AccessorKind accessorKind;

        public AccessorKey(@NotNull DeclarationDescriptor descriptor2, @Nullable ClassDescriptor superCallLabelTarget, @NotNull AccessorKind accessorKind) {
            if (descriptor2 == null) {
                AccessorKey.$$$reportNull$$$0(0);
            }
            if (accessorKind == null) {
                AccessorKey.$$$reportNull$$$0(1);
            }
            this.descriptor = descriptor2;
            this.superCallLabelTarget = superCallLabelTarget;
            this.accessorKind = accessorKind;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AccessorKey)) {
                return false;
            }
            AccessorKey other = (AccessorKey)obj;
            return this.descriptor.equals(other.descriptor) && this.accessorKind == other.accessorKind && Objects.equals(this.superCallLabelTarget, other.superCallLabelTarget);
        }

        public int hashCode() {
            return 31 * this.descriptor.hashCode() + this.accessorKind.hashCode() + (this.superCallLabelTarget == null ? 0 : this.superCallLabelTarget.hashCode());
        }

        public String toString() {
            return this.descriptor.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessorKind";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/context/CodegenContext$AccessorKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

