/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.TypesKt;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bJ\u0014\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J$\u0010\u001a\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001dJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\bJ\u0014\u0010$\u001a\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020&J\u0006\u0010'\u001a\u00020\u000eJ\u0006\u0010(\u001a\u00020\u000eJ\u0014\u0010)\u001a\u00020\u000e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0018J\u000e\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.J\u001c\u0010/\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J)\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u00042\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020403\"\u000204H&\u00a2\u0006\u0002\u00105J\u001c\u00106\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u0012J\u000e\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u0012J\u000e\u0010?\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u0012J\u0014\u0010@\u001a\u00020\u000e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0018J\u000e\u0010A\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.J\"\u0010B\u001a\u00020\u000e2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u00182\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J\u0014\u0010F\u001a\u00020\u000e2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u0018J\"\u0010G\u001a\u00020\u000e2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u00182\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J\u0006\u0010H\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "", "()V", "lastInstr", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "getLastInstr", "()Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "numberOfNestedBlocks", "", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "buildBlock", "", "label", "", "resultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "buildBr", "absoluteBlockLevel", "buildBrIf", "buildCall", "symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "buildCallIndirect", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "tableIdx", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "buildConstF32", "value", "", "buildConstF64", "", "buildConstI32", "buildConstI32Symbol", "buildConstI64", "", "buildElse", "buildEnd", "buildGetGlobal", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "buildGetLocal", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "buildIf", "buildInstr", "op", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildLoop", "buildRefCast", "fromType", "toType", "buildRefNull", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "buildRttCanon", "heapType", "buildRttSub", "buildSetGlobal", "buildSetLocal", "buildStructGet", "struct", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "fieldId", "buildStructNew", "buildStructSet", "buildUnreachable", "wasm.ir"})
public abstract class WasmExpressionBuilder {
    public abstract void buildInstr(@NotNull WasmOp var1, WasmImmediate ... var2);

    public abstract int getNumberOfNestedBlocks();

    public abstract void setNumberOfNestedBlocks(int var1);

    @Nullable
    public abstract WasmOp getLastInstr();

    public final void buildConstI32(int value2) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI32(value2)};
        this.buildInstr(WasmOp.I32_CONST, wasmImmediateArray);
    }

    public final void buildConstI64(long value2) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI64(value2)};
        this.buildInstr(WasmOp.I64_CONST, wasmImmediateArray);
    }

    public final void buildConstF32(float value2) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        float f = value2;
        boolean bl = false;
        int n = Float.floatToRawIntBits(f);
        bl = false;
        wasmImmediateArray[0] = new WasmImmediate.ConstF32(UInt.constructor-impl((int)n), null);
        this.buildInstr(WasmOp.F32_CONST, wasmImmediateArray);
    }

    public final void buildConstF64(double value2) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        double d = value2;
        boolean bl = false;
        long l = Double.doubleToRawLongBits(d);
        bl = false;
        wasmImmediateArray[0] = new WasmImmediate.ConstF64(ULong.constructor-impl((long)l), null);
        this.buildInstr(WasmOp.F64_CONST, wasmImmediateArray);
    }

    public final void buildConstI32Symbol(@NotNull WasmSymbol<Integer> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.SymbolI32(value2)};
        this.buildInstr(WasmOp.I32_CONST, wasmImmediateArray);
    }

    public final void buildUnreachable() {
        if (this.getLastInstr() == WasmOp.UNREACHABLE || this.getLastInstr() == WasmOp.RETURN) {
            return;
        }
        this.buildInstr(WasmOp.UNREACHABLE, new WasmImmediate[0]);
    }

    public final void buildBlock(@Nullable String label, @Nullable WasmType resultType) {
        WasmImmediate[] wasmImmediateArray = this;
        int n = wasmImmediateArray.getNumberOfNestedBlocks();
        wasmImmediateArray.setNumberOfNestedBlocks(n + 1);
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.BLOCK, wasmImmediateArray);
    }

    public static /* synthetic */ void buildBlock$default(WasmExpressionBuilder wasmExpressionBuilder, String string2, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildBlock");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildBlock(string2, wasmType);
    }

    public final void buildLoop(@Nullable String label, @Nullable WasmType resultType) {
        WasmImmediate[] wasmImmediateArray = this;
        int n = wasmImmediateArray.getNumberOfNestedBlocks();
        wasmImmediateArray.setNumberOfNestedBlocks(n + 1);
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.LOOP, wasmImmediateArray);
    }

    public static /* synthetic */ void buildLoop$default(WasmExpressionBuilder wasmExpressionBuilder, String string2, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildLoop");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildLoop(string2, wasmType);
    }

    public final void buildIf(@Nullable String label, @Nullable WasmType resultType) {
        WasmImmediate[] wasmImmediateArray = this;
        int n = wasmImmediateArray.getNumberOfNestedBlocks();
        wasmImmediateArray.setNumberOfNestedBlocks(n + 1);
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.IF, wasmImmediateArray);
    }

    public static /* synthetic */ void buildIf$default(WasmExpressionBuilder wasmExpressionBuilder, String string2, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildIf");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildIf(string2, wasmType);
    }

    public final void buildElse() {
        this.buildInstr(WasmOp.ELSE, new WasmImmediate[0]);
    }

    public final void buildEnd() {
        WasmExpressionBuilder wasmExpressionBuilder = this;
        int n = wasmExpressionBuilder.getNumberOfNestedBlocks();
        wasmExpressionBuilder.setNumberOfNestedBlocks(n + -1);
        this.buildInstr(WasmOp.END, new WasmImmediate[0]);
    }

    public final void buildBr(int absoluteBlockLevel) {
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl = relativeLevel >= 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Negative relative block index";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LabelIdx(relativeLevel)};
        this.buildInstr(WasmOp.BR, wasmImmediateArray);
    }

    public final void buildBrIf(int absoluteBlockLevel) {
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl = relativeLevel >= 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Negative relative block index";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LabelIdx(relativeLevel)};
        this.buildInstr(WasmOp.BR_IF, wasmImmediateArray);
    }

    public final void buildCall(@NotNull WasmSymbol<? extends WasmFunction> symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(symbol2)};
        this.buildInstr(WasmOp.CALL, wasmImmediateArray);
    }

    public final void buildCallIndirect(@NotNull WasmSymbol<WasmFunctionType> symbol2, @NotNull WasmSymbolReadOnly<Integer> tableIdx) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter(tableIdx, (String)"tableIdx");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx(symbol2), new WasmImmediate.TableIdx(tableIdx)};
        this.buildInstr(WasmOp.CALL_INDIRECT, wasmImmediateArray);
    }

    public static /* synthetic */ void buildCallIndirect$default(WasmExpressionBuilder wasmExpressionBuilder, WasmSymbol wasmSymbol, WasmSymbolReadOnly wasmSymbolReadOnly, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildCallIndirect");
        }
        if ((n & 2) != 0) {
            wasmSymbolReadOnly = new WasmSymbol<Integer>(0);
        }
        wasmExpressionBuilder.buildCallIndirect(wasmSymbol, wasmSymbolReadOnly);
    }

    public final void buildGetLocal(@NotNull WasmLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_GET, wasmImmediateArray);
    }

    public final void buildSetLocal(@NotNull WasmLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_SET, wasmImmediateArray);
    }

    public final void buildGetGlobal(@NotNull WasmSymbol<WasmGlobal> global) {
        Intrinsics.checkNotNullParameter(global, (String)"global");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_GET, wasmImmediateArray);
    }

    public final void buildSetGlobal(@NotNull WasmSymbol<WasmGlobal> global) {
        Intrinsics.checkNotNullParameter(global, (String)"global");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_SET, wasmImmediateArray);
    }

    public final void buildStructGet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter(fieldId, (String)"fieldId");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_GET, wasmImmediateArray);
    }

    public final void buildStructNew(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct)};
        this.buildInstr(WasmOp.STRUCT_NEW_WITH_RTT, wasmImmediateArray);
    }

    public final void buildStructSet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter(fieldId, (String)"fieldId");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_SET, wasmImmediateArray);
    }

    public final void buildRefCast(@NotNull WasmType fromType, @NotNull WasmType toType) {
        Intrinsics.checkNotNullParameter((Object)fromType, (String)"fromType");
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(TypesKt.getHeapType(fromType)), new WasmImmediate.HeapType(TypesKt.getHeapType(toType))};
        this.buildInstr(WasmOp.REF_CAST, wasmImmediateArray);
    }

    public final void buildRefNull(@NotNull WasmHeapType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmRefType(type2))};
        this.buildInstr(WasmOp.REF_NULL, wasmImmediateArray);
    }

    public final void buildRttSub(@NotNull WasmType heapType) {
        Intrinsics.checkNotNullParameter((Object)heapType, (String)"heapType");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(heapType)};
        this.buildInstr(WasmOp.RTT_SUB, wasmImmediateArray);
    }

    public final void buildRttCanon(@NotNull WasmType heapType) {
        Intrinsics.checkNotNullParameter((Object)heapType, (String)"heapType");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(heapType)};
        this.buildInstr(WasmOp.RTT_CANON, wasmImmediateArray);
    }
}

