/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmStaticChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "isLessJVM18", "", "supportJvmStaticInInterface", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkVisibility", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "frontend.java"})
public final class JvmStaticChecker
implements DeclarationChecker {
    private final boolean isLessJVM18;
    private final boolean supportJvmStaticInInterface;

    public JvmStaticChecker(@NotNull JvmTarget jvmTarget, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.isLessJVM18 = jvmTarget.getMajorVersion() < JvmTarget.JVM_1_8.getMajorVersion();
        this.supportJvmStaticInInterface = languageVersionSettings.supportsFeature(LanguageFeature.JvmStaticInInterface);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2) && (declaration instanceof KtNamedFunction || declaration instanceof KtProperty || declaration instanceof KtPropertyAccessor || declaration instanceof KtParameter)) {
            this.checkDeclaration(declaration, descriptor2, context2.getTrace());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor, DiagnosticSink diagnosticHolder) {
        container = descriptor.getContainingDeclaration();
        insideObject = DescriptorUtils.isObject(container);
        if (!DescriptorUtils.isCompanionObject(container)) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)container);
        if (DescriptorUtils.isInterface(container.getContainingDeclaration())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = insideCompanionObjectInInterface = false;
        }
        if (!insideObject || insideCompanionObjectInInterface) {
            if (insideCompanionObjectInInterface && this.supportJvmStaticInInterface && descriptor instanceof DeclarationDescriptorWithVisibility) {
                this.checkVisibility((DeclarationDescriptorWithVisibility)descriptor, diagnosticHolder, declaration);
                if (this.isLessJVM18) {
                    diagnosticHolder.report(ErrorsJvm.JVM_STATIC_IN_INTERFACE_1_6.on((KtDeclaration)((PsiElement)declaration)));
                }
            } else {
                diagnosticHolder.report((this.supportJvmStaticInInterface != false ? ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT_OR_COMPANION : ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT_OR_CLASS_COMPANION).on((KtDeclaration)((PsiElement)declaration)));
            }
        }
        if ((var8_7 = declaration) instanceof KtPropertyAccessor) {
            var9_8 = declaration.getParent();
            if (var9_8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            v1 = (KtProperty)var9_8;
        } else {
            v1 = checkDeclaration = declaration;
        }
        if (DescriptorUtils.isNonCompanionObject(container) && Intrinsics.areEqual((Object)((var8_7 = checkDeclaration.getModifierList()) == null ? null : Boolean.valueOf(var8_7.hasModifier(KtTokens.OVERRIDE_KEYWORD))), (Object)true)) {
            diagnosticHolder.report(ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC.on((KtDeclaration)((PsiElement)declaration)));
        }
        if (descriptor instanceof PropertyDescriptor && (((PropertyDescriptor)descriptor).isConst() || JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor))) {
            diagnosticHolder.report(ErrorsJvm.JVM_STATIC_ON_CONST_OR_JVM_FIELD.on((KtDeclaration)((PsiElement)declaration)));
        }
    }

    private final void checkVisibility(DeclarationDescriptorWithVisibility descriptor2, DiagnosticSink diagnosticHolder, KtDeclaration declaration) {
        PropertySetterDescriptor propertySetterDescriptor;
        if (!Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PUBLIC)) {
            diagnosticHolder.report(ErrorsJvm.JVM_STATIC_ON_NON_PUBLIC_MEMBER.on((KtDeclaration)((PsiElement)declaration)));
        } else if (descriptor2 instanceof PropertyDescriptor && (propertySetterDescriptor = ((PropertyDescriptor)descriptor2).getSetter()) != null) {
            PropertySetterDescriptor propertySetterDescriptor2 = propertySetterDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            PropertySetterDescriptor it = propertySetterDescriptor2;
            boolean bl3 = false;
            this.checkVisibility(it, diagnosticHolder, declaration);
        }
    }
}

