/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleResolver", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "targetClassOrPackage", "Lorg/jetbrains/kotlin/descriptors/ClassOrPackageFragmentDescriptor;", "originalDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "fileFromOurModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFile", "descriptor", "ClassifierUsage", "frontend.java"})
public final class JvmModuleAccessibilityChecker
implements CallChecker {
    @NotNull
    private final JavaModuleResolver moduleResolver;

    public JvmModuleAccessibilityChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.moduleResolver = JavaModuleResolver.SERVICE.getInstance(project);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ClassOrPackageFragmentDescriptor classOrPackageFragmentDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof ClassConstructorDescriptor) {
            return;
        }
        Object object = DescriptorUtils.getParentOfType((DeclarationDescriptor)descriptor2, ClassOrPackageFragmentDescriptor.class);
        if (object == null) {
            return;
        }
        ClassOrPackageFragmentDescriptor targetDescriptor = classOrPackageFragmentDescriptor = object;
        object = DescriptorToSourceUtils.getContainingFile(context2.getScope().getOwnerDescriptor());
        VirtualFile fileFromOurModule = object == null ? null : object.getVirtualFile();
        object = this.diagnosticFor(targetDescriptor, (DeclarationDescriptorWithSource)descriptor2, fileFromOurModule, reportOn);
        if (object != null) {
            Object object2 = object;
            DiagnosticSink diagnosticSink = context2.getTrace();
            boolean bl = false;
            boolean bl2 = false;
            Object p0 = object2;
            boolean bl3 = false;
            diagnosticSink.report((Diagnostic)p0);
        }
    }

    private final Diagnostic diagnosticFor(ClassOrPackageFragmentDescriptor targetClassOrPackage, DeclarationDescriptorWithSource originalDescriptor, VirtualFile fileFromOurModule, PsiElement reportOn) {
        Diagnostic diagnostic;
        JvmClassName jvmClassName;
        FqName fqName2;
        Object object;
        VirtualFile virtualFile = this.findVirtualFile(targetClassOrPackage, originalDescriptor);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile referencedFile = virtualFile;
        Object object2 = object = originalDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)originalDescriptor : null;
        FqName fqName3 = object == null ? null : (fqName2 = (jvmClassName = UtilKt.getImplClassNameForDeserialized((DescriptorWithContainerSource)object)) == null ? null : jvmClassName.getPackageFqName());
        FqName referencedPackageFqName = fqName2 == null ? ((object = DescriptorUtils.getParentOfType(targetClassOrPackage, PackageFragmentDescriptor.class, false)) == null ? null : object.getFqName()) : fqName2;
        JavaModuleResolver.AccessError diagnostic2 = this.moduleResolver.checkAccessibility(fileFromOurModule, referencedFile, referencedPackageFqName);
        object = diagnostic2;
        if (object instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule) {
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE.on(reportOn);
        } else if (object instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadModule) {
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE.on(reportOn, ((JavaModuleResolver.AccessError.ModuleDoesNotReadModule)diagnostic2).getDependencyModuleName());
        } else if (object instanceof JavaModuleResolver.AccessError.ModuleDoesNotExportPackage) {
            String string2 = ((JavaModuleResolver.AccessError.ModuleDoesNotExportPackage)diagnostic2).getDependencyModuleName();
            Intrinsics.checkNotNull((Object)referencedPackageFqName);
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_EXPORT_PACKAGE.on(reportOn, string2, referencedPackageFqName.asString());
        } else {
            diagnostic = null;
        }
        return diagnostic;
    }

    private final VirtualFile findVirtualFile(ClassOrPackageFragmentDescriptor descriptor2, DeclarationDescriptorWithSource originalDescriptor) {
        Object object;
        Object object2;
        SourceElement source;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
        sourceElement = source = sourceElement;
        if (sourceElement instanceof KotlinJvmBinarySourceElement) {
            object2 = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            Object object3 = object = object2 instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)object2 : null;
            if (object != null && (object2 = ((VirtualFileKotlinClass)object).getFile()) != null) {
                Object object4 = object2;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object4;
                boolean bl3 = false;
                return it;
            }
        } else if (sourceElement instanceof JavaSourceElement) {
            object2 = ((JavaSourceElement)source).getJavaElement();
            Object object5 = object = object2 instanceof VirtualFileBoundJavaClass ? (VirtualFileBoundJavaClass)object2 : null;
            if (object != null && (object2 = object.getVirtualFile()) != null) {
                Object object6 = object2;
                boolean bl = false;
                boolean bl4 = false;
                Object it = object6;
                boolean bl5 = false;
                return it;
            }
        } else if (sourceElement instanceof KotlinJvmBinaryPackageSourceElement && originalDescriptor instanceof DeserializedMemberDescriptor) {
            object2 = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)originalDescriptor);
            Object object7 = object = object2 instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)object2 : null;
            if (object != null && (object2 = ((VirtualFileKotlinClass)object).getFile()) != null) {
                Object object8 = object2;
                boolean bl = false;
                boolean bl6 = false;
                Object it = object8;
                boolean bl7 = false;
                return it;
            }
        }
        if ((sourceElement = JvmModuleAccessibilityChecker.findVirtualFile$getContainingVirtualFile(source)) != null) {
            object = sourceElement;
            boolean bl = false;
            boolean bl8 = false;
            Object it = object;
            boolean bl9 = false;
            return it;
        }
        DeclarationDescriptorWithSource declarationDescriptorWithSource = originalDescriptor;
        Object object9 = object2 = declarationDescriptorWithSource == null ? null : declarationDescriptorWithSource.getSource();
        if (object2 == null) {
            return null;
        }
        Object originalSource = object = object2;
        return JvmModuleAccessibilityChecker.findVirtualFile$getContainingVirtualFile((SourceElement)originalSource);
    }

    private static final VirtualFile findVirtualFile$getContainingVirtualFile(SourceElement source) {
        Object object;
        PsiFile psiFile;
        PsiElement psiElement;
        boolean bl;
        PsiFile psiFile2;
        PsiElement psiElement2 = KotlinSourceElementKt.getPsi(source);
        if (psiElement2 == null) {
            psiFile2 = null;
        } else {
            PsiElement psiElement3 = psiElement2;
            bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement3;
            boolean bl3 = false;
            psiElement = it.isValid() ? psiElement3 : null;
            psiFile2 = psiFile = psiElement == null ? null : psiElement.getContainingFile();
        }
        if (psiFile == null) {
            object = null;
        } else {
            psiElement2 = psiFile.getVirtualFile();
            if (psiElement2 == null) {
                object = null;
            } else {
                psiElement = psiElement2;
                boolean bl4 = false;
                bl = false;
                PsiElement it = psiElement;
                boolean bl5 = false;
                object = it.isValid() ? psiElement : null;
            }
        }
        return object;
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "(Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;)V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend.java"})
    public final class ClassifierUsage
    implements ClassifierUsageChecker {
        public ClassifierUsage() {
            Intrinsics.checkNotNullParameter((Object)JvmModuleAccessibilityChecker.this, (String)"this$0");
        }

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            ClassifierDescriptor classifierDescriptor = targetDescriptor;
            if (classifierDescriptor instanceof ClassDescriptor) {
                Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor((ClassOrPackageFragmentDescriptor)((Object)targetDescriptor), targetDescriptor, virtualFile, element);
                if (diagnostic != null) {
                    Diagnostic diagnostic2 = diagnostic;
                    DiagnosticSink diagnosticSink = context2.getTrace();
                    boolean bl = false;
                    boolean bl2 = false;
                    Diagnostic p0 = diagnostic2;
                    boolean bl3 = false;
                    diagnosticSink.report(p0);
                }
            } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
                ClassDescriptor expandedClass;
                boolean bl;
                Object object;
                Object object2;
                Diagnostic diagnostic;
                ClassOrPackageFragmentDescriptor containingClassOrPackage = DescriptorUtils.getParentOfType(targetDescriptor, ClassOrPackageFragmentDescriptor.class);
                if (containingClassOrPackage != null && (diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor(containingClassOrPackage, targetDescriptor, virtualFile, element)) != null) {
                    object2 = diagnostic;
                    object = context2.getTrace();
                    boolean bl4 = false;
                    bl = false;
                    Object p0 = object2;
                    boolean bl5 = false;
                    object.report((Diagnostic)p0);
                }
                ClassDescriptor classDescriptor2 = expandedClass = (object2 = ((TypeAliasDescriptor)targetDescriptor).getExpandedType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)object2 : null;
                if (expandedClass != null && (object2 = JvmModuleAccessibilityChecker.this.diagnosticFor(expandedClass, expandedClass, virtualFile, element)) != null) {
                    object = object2;
                    DiagnosticSink diagnosticSink = context2.getTrace();
                    bl = false;
                    boolean bl6 = false;
                    Object p0 = object;
                    boolean bl7 = false;
                    diagnosticSink.report((Diagnostic)p0);
                }
            }
        }
    }
}

