/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PrivateInlineFunctionsReturningAnonymousObjectsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class PrivateInlineFunctionsReturningAnonymousObjectsChecker
implements DeclarationChecker {
    @NotNull
    public static final PrivateInlineFunctionsReturningAnonymousObjectsChecker INSTANCE = new PrivateInlineFunctionsReturningAnonymousObjectsChecker();

    private PrivateInlineFunctionsReturningAnonymousObjectsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        PsiElement $i$f$singleOrNull2;
        Object v1;
        TypeConstructor returnTypeConstructor;
        block9: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ApproximateAnonymousReturnTypesInPrivateInlineFunctions)) {
                return;
            }
            if (!(descriptor2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor2).isInline() && DescriptorVisibilities.isPrivate(((SimpleFunctionDescriptor)descriptor2).getVisibility()) && declaration instanceof KtNamedFunction)) {
                return;
            }
            KotlinType kotlinType = ((SimpleFunctionDescriptor)descriptor2).getReturnType();
            Object object2 = object = kotlinType == null ? null : kotlinType.getConstructor();
            if (object == null) {
                return;
            }
            returnTypeConstructor = object;
            object = returnTypeConstructor.getSupertypes();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"returnTypeConstructor.supertypes");
            Iterable $this$singleOrNull$iv = (Iterable)object;
            boolean $i$f$singleOrNull2 = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!TypeUtilsKt.isAnyOrNullableAny(it)) continue;
                if (found$iv) {
                    v1 = null;
                    break block9;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        if (v1 == null) {
            return;
        }
        Object object = ((KtNamedFunction)declaration).getNameIdentifier();
        if (object == null) {
            return;
        }
        PsiElement nameIdentifier = $i$f$singleOrNull2 = object;
        ClassifierDescriptor classifierDescriptor = returnTypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        object = classifierDescriptor;
        Object returnTypeDeclarationDescriptor = object;
        if (DescriptorUtils.isAnonymousObject((DeclarationDescriptor)returnTypeDeclarationDescriptor)) {
            context2.getTrace().report(Errors.PRIVATE_INLINE_FUNCTIONS_RETURNING_ANONYMOUS_OBJECTS.on(nameIdentifier));
        }
    }
}

