/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.InlineClassDeclarationCheckerKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isParameterAcceptableForInlineClass", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "isInapplicableParameterType", "frontend"})
public final class InlineClassDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final InlineClassDeclarationChecker INSTANCE = new InlineClassDeclarationChecker();

    private InlineClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean bl;
        PsiElement inlineOrValueKeyword;
        BindingTrace trace;
        block18: {
            ClassDescriptor classDescriptor2;
            PsiElement psiElement;
            PsiElement valueKeyword;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(declaration instanceof KtClass)) {
                return;
            }
            if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isInline() && !((ClassDescriptor)descriptor2).isValue()) {
                return;
            }
            if (((ClassDescriptor)descriptor2).getKind() != ClassKind.CLASS) {
                return;
            }
            trace = context2.getTrace();
            KtModifierList ktModifierList = ((KtClass)declaration).getModifierList();
            PsiElement psiElement2 = valueKeyword = ktModifierList == null ? null : ktModifierList.getModifier(KtTokens.VALUE_KEYWORD);
            if (valueKeyword != null && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmInlineValueClasses) && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClasses)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(valueKeyword, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.JvmInlineValueClasses), (Object)context2.getLanguageVersionSettings())));
                return;
            }
            KtModifierList ktModifierList2 = ((KtClass)declaration).getModifierList();
            inlineOrValueKeyword = ktModifierList2 == null ? valueKeyword : ((psiElement = ktModifierList2.getModifier(KtTokens.INLINE_KEYWORD)) == null ? valueKeyword : psiElement);
            boolean bl2 = inlineOrValueKeyword != null;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string2 = "Declaration of inline class must have 'inline' keyword";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            if (((ClassDescriptor)descriptor2).isInner() || DescriptorUtils.isLocal(descriptor2)) {
                trace.report(Errors.INLINE_CLASS_NOT_TOP_LEVEL.on(inlineOrValueKeyword));
                return;
            }
            PsiElement modalityModifier = KtPsiUtilKt.modalityModifier(declaration);
            if (modalityModifier != null && ((ClassDescriptor)descriptor2).getModality() != Modality.FINAL) {
                trace.report(Errors.INLINE_CLASS_NOT_FINAL.on(modalityModifier));
                return;
            }
            KtPrimaryConstructor primaryConstructor2 = ((KtClass)declaration).getPrimaryConstructor();
            if (primaryConstructor2 == null) {
                trace.report(Errors.ABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_INLINE_CLASS.on(inlineOrValueKeyword));
                return;
            }
            KtParameter baseParameter = (KtParameter)CollectionsKt.singleOrNull(primaryConstructor2.getValueParameters());
            if (baseParameter == null) {
                KtElementImplStub bl5 = primaryConstructor2.getValueParameterList();
                bl5 = bl5 == null ? (KtElementImplStub)((Object)declaration) : (KtElementImplStub)bl5;
                boolean bl6 = false;
                boolean bl7 = false;
                KtElementImplStub it = bl5;
                boolean bl8 = false;
                trace.report(Errors.INLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE.on((KtElement)((PsiElement)it)));
                return;
            }
            if (!this.isParameterAcceptableForInlineClass(baseParameter)) {
                trace.report(Errors.INLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER.on((KtParameter)((PsiElement)baseParameter)));
                return;
            }
            Object $this$safeAs$iv = descriptor2;
            boolean $i$f$safeAs = false;
            Object object = $this$safeAs$iv;
            if (!(object instanceof ClassDescriptor)) {
                object = null;
            }
            KotlinType baseParameterType = (classDescriptor2 = (ClassDescriptor)object) == null ? null : (($this$safeAs$iv = classDescriptor2.getDefaultType()) == null ? null : InlineClassesUtilsKt.substitutedUnderlyingType((KotlinType)$this$safeAs$iv));
            KtTypeReference baseParameterTypeReference = baseParameter.getTypeReference();
            if (baseParameterType != null && baseParameterTypeReference != null) {
                if (this.isInapplicableParameterType(baseParameterType)) {
                    trace.report(Errors.INLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE.on((KtTypeReference)((PsiElement)baseParameterTypeReference), baseParameterType));
                    return;
                }
                if (InlineClassesUtilsKt.isRecursiveInlineClassType(baseParameterType)) {
                    trace.report(Errors.INLINE_CLASS_CANNOT_BE_RECURSIVE.on((KtTypeReference)((PsiElement)baseParameterTypeReference)));
                    return;
                }
            }
            for (KtSuperTypeListEntry supertypeEntry : ((KtClass)declaration).getSuperTypeListEntries()) {
                Annotated typeDescriptor;
                Object type2;
                ClassifierDescriptor classifierDescriptor;
                KtTypeReference ktTypeReference;
                KtTypeReference typeReference;
                Annotated annotated;
                if (supertypeEntry instanceof KtDelegatedSuperTypeEntry) {
                    trace.report(Errors.INLINE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION.on((PsiElement)supertypeEntry));
                    return;
                }
                Object object2 = supertypeEntry.getTypeReference();
                if (object2 == null || (annotated = (KotlinType)trace.get(BindingContext.TYPE, typeReference = (ktTypeReference = object2))) == null || (classifierDescriptor = ((KotlinType)(type2 = (object2 = annotated))).getConstructor().getDeclarationDescriptor()) == null || DescriptorUtils.isInterface((DeclarationDescriptor)(typeDescriptor = (annotated = classifierDescriptor)))) continue;
                trace.report(Errors.INLINE_CLASS_CANNOT_EXTEND_CLASSES.on((KtTypeReference)((PsiElement)typeReference)));
                return;
            }
            Sequence<ClassifierDescriptor> $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ClassifierDescriptor it = (ClassifierDescriptor)element$iv;
                boolean bl9 = false;
                if (!(Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)StandardNames.FqNames.cloneable) || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)InlineClassDeclarationCheckerKt.access$getJavaLangCloneable$p()))) continue;
                bl = true;
                break block18;
            }
            bl = false;
        }
        if (bl) {
            trace.report(Errors.VALUE_CLASS_CANNOT_BE_CLONEABLE.on(inlineOrValueKeyword));
            return;
        }
    }

    private final boolean isInapplicableParameterType(KotlinType $this$isInapplicableParameterType) {
        return TypeUtilsKt.isUnit($this$isInapplicableParameterType) || TypeUtilsKt.isNothing($this$isInapplicableParameterType) || TypeUtilsKt.isTypeParameter($this$isInapplicableParameterType) || this.isGenericArrayOfTypeParameter($this$isInapplicableParameterType);
    }

    private final boolean isGenericArrayOfTypeParameter(KotlinType $this$isGenericArrayOfTypeParameter) {
        if (!KotlinBuiltIns.isArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        TypeProjection argument0 = $this$isGenericArrayOfTypeParameter.getArguments().get(0);
        if (argument0.isStarProjection()) {
            return false;
        }
        KotlinType kotlinType = argument0.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"argument0.type");
        KotlinType argument0type = kotlinType;
        return TypeUtilsKt.isTypeParameter(argument0type) || this.isGenericArrayOfTypeParameter(argument0type);
    }

    private final boolean isParameterAcceptableForInlineClass(KtParameter parameter) {
        ASTNode aSTNode;
        PsiElement psiElement = KtPsiUtilKt.modalityModifier(parameter);
        boolean isOpen = Intrinsics.areEqual(psiElement == null ? null : ((aSTNode = psiElement.getNode()) == null ? null : aSTNode.getElementType()), (Object)((Object)KtTokens.OPEN_KEYWORD));
        return parameter.hasValOrVar() && !parameter.isMutable() && !parameter.isVarArg() && !isOpen;
    }
}

