/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceSupport;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerContext;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!J\"\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020!H\u0002JL\u0010+\u001a\u00020\u00172\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030,26\u0010-\u001a2\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00170.H\u0002J\u001c\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030,H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceSupport;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "getArgumentTypeResolver", "()Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "<set-?>", "Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "callCompleter", "getCallCompleter", "()Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "setCallCompleter", "(Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;)V", "getExpressionTypingServices", "()Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "analyzeCoroutine", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunction;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "lambdaExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkCoroutineCalls", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "overloadResults", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "checkExpectedTypeForArgument", "", "expectedType", "forceInferenceForArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "argument", "argumentType", "getArgumentTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "CoroutineTypeCheckerContext", "frontend"})
public final class CoroutineInferenceSupport {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    public CallCompleter callCompleter;

    public CoroutineInferenceSupport(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        this.argumentTypeResolver = argumentTypeResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        return this.argumentTypeResolver;
    }

    @NotNull
    public final ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    @NotNull
    public final CallCompleter getCallCompleter() {
        CallCompleter callCompleter = this.callCompleter;
        if (callCompleter != null) {
            return callCompleter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"callCompleter");
        throw null;
    }

    @Inject
    public final void setCallCompleter(@NotNull CallCompleter callCompleter) {
        Intrinsics.checkNotNullParameter((Object)callCompleter, (String)"<set-?>");
        this.callCompleter = callCompleter;
    }

    private final LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings = this.expressionTypingServices.getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"expressionTypingServices.languageVersionSettings");
        return languageVersionSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void analyzeCoroutine(@NotNull KtFunction functionLiteral, @NotNull ValueArgument valueArgument, @NotNull ConstraintSystem.Builder csBuilder, @NotNull CallCandidateResolutionContext<?> context2, @NotNull KotlinType lambdaExpectedType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KotlinType kotlinType;
        KotlinType kotlinType2;
        TypeSubstitution typeSubstitution;
        Intrinsics.checkNotNullParameter((Object)functionLiteral, (String)"functionLiteral");
        Intrinsics.checkNotNullParameter((Object)valueArgument, (String)"valueArgument");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lambdaExpectedType, (String)"lambdaExpectedType");
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (!this.checkExpectedTypeForArgument(lambdaExpectedType)) {
            return;
        }
        KotlinType kotlinType3 = FunctionTypesKt.getReceiverTypeFromFunctionType(lambdaExpectedType);
        if (kotlinType3 == null) {
            return;
        }
        KotlinType lambdaReceiverType = kotlinType3;
        CoroutineInferenceData inferenceData = new CoroutineInferenceData();
        ConstraintSystem constraintSystem = csBuilder.build();
        DelegatedTypeSubstitution newSubstitution2 = new DelegatedTypeSubstitution(constraintSystem, inferenceData, typeSubstitution = constraintSystem.getCurrentSubstitutor().getSubstitution()){
            final /* synthetic */ ConstraintSystem $constraintSystem;
            final /* synthetic */ CoroutineInferenceData $inferenceData;
            {
                this.$constraintSystem = $constraintSystem;
                this.$inferenceData = $inferenceData;
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"substitution");
                super($super_call_param$1);
            }

            @Nullable
            public TypeProjection get(@NotNull KotlinType key) {
                Object v0;
                TypeProjection substitutedType;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    TypeProjection typeProjection = substitutedType = super.get(key);
                    if (!Intrinsics.areEqual((Object)(typeProjection == null ? null : typeProjection.getType()), (Object)TypeUtils.DONT_CARE)) {
                        return substitutedType;
                    }
                    Iterable $this$firstOrNull$iv = this.$constraintSystem.getTypeVariables();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        TypeVariable it = (TypeVariable)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getOriginalTypeParameter().getDefaultType(), (Object)key)) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                TypeVariable typeVariable2 = v0;
                if (typeVariable2 == null) {
                    return substitutedType;
                }
                TypeVariable typeVariable3 = typeVariable2;
                return TypeUtilsKt.asTypeProjection(this.$inferenceData.getTypeTemplate(typeVariable3));
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        };
        Object object = newSubstitution2.buildSubstitutor().substitute(lambdaReceiverType, Variance.INVARIANT);
        if (object == null) {
            return;
        }
        KotlinType newReceiverType = kotlinType2 = object;
        object = constraintSystem.getCurrentSubstitutor().getSubstitution();
        DelegatedTypeSubstitution approximationSubstitutor2 = new DelegatedTypeSubstitution((TypeSubstitution)object){
            {
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"substitution");
                super($super_call_param$1);
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        };
        Object object2 = approximationSubstitutor2.buildSubstitutor().substitute(lambdaExpectedType, Variance.IN_VARIANCE);
        if (object2 == null) {
            return;
        }
        KotlinType approximatedLambdaType = kotlinType = object2;
        object2 = FunctionTypesKt.getValueParameterTypesFromFunctionType(approximatedLambdaType);
        KotlinType kotlinType4 = newReceiverType;
        Annotations annotations2 = approximatedLambdaType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(newReceiverType);
        boolean $i$f$map = false;
        Object Context2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType5 = p0.getType();
            collection.add(kotlinType5);
        }
        collection = (List)destination$iv$iv;
        SimpleType newExpectedType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType4, (List<? extends KotlinType>)collection, null, FunctionTypesKt.getReturnTypeFromFunctionType(approximatedLambdaType), true);
        if (CallResolverUtilKt.hasUnknownFunctionParameter(newExpectedType)) {
            return;
        }
        inferenceData.initSystem();
        TemporaryTraceAndCache temporaryForCoroutine = TemporaryTraceAndCache.create(context2, "trace for type argument inference for coroutine", functionLiteral);
        Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceExpectedType(newExpectedType)).replaceDataFlowInfo(context2.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument))).replaceContextDependency(ContextDependency.INDEPENDENT)).replaceTraceAndCache(temporaryForCoroutine);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceExpectedType(newExpectedType)\n            .replaceDataFlowInfo(context.candidateCall.dataFlowInfoForArguments.getInfo(valueArgument))\n            .replaceContextDependency(ContextDependency.INDEPENDENT).replaceTraceAndCache(temporaryForCoroutine)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, true);
        inferenceData.reportInferenceResult(csBuilder);
    }

    private final boolean checkExpectedTypeForArgument(KotlinType expectedType2) {
        return this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType2) : FunctionTypesKt.isSuspendFunctionType(expectedType2);
    }

    public final void checkCoroutineCalls(@NotNull BasicCallResolutionContext context2, @NotNull TracingStrategy tracingStrategy, @NotNull OverloadResolutionResultsImpl<?> overloadResults) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tracingStrategy, (String)"tracingStrategy");
        Intrinsics.checkNotNullParameter(overloadResults, (String)"overloadResults");
        CoroutineInferenceData coroutineInferenceData = CoroutineInferenceUtilKt.access$getCoroutineInferenceData(overloadResults);
        if (coroutineInferenceData == null) {
            return;
        }
        CoroutineInferenceData inferenceData = coroutineInferenceData;
        ResolvedCall resolvedCall2 = overloadResults.getResultingCall();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"overloadResults.resultingCall");
        ResolvedCall resultingCall = resolvedCall2;
        this.forceInferenceForArguments(context2, (Function2<? super ValueArgument, ? super KotlinType, Unit>)((Function2)checkCoroutineCalls.1.INSTANCE));
        this.getCallCompleter().completeCall(context2, overloadResults, tracingStrategy);
        if (!ArgumentMappingKt.isReallySuccess(resultingCall)) {
            return;
        }
        Object resultingDescriptor = resultingCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(resultingDescriptor, (String)"resultingDescriptor");
        if (!CoroutineInferenceUtilKt.isApplicableCallForBuilderInference(resultingDescriptor, this.getLanguageVersionSettings())) {
            inferenceData.badCallHappened();
        }
        this.forceInferenceForArguments(context2, (Function2<? super ValueArgument, ? super KotlinType, Unit>)((Function2)new Function2<ValueArgument, KotlinType, Unit>((MutableResolvedCall<? extends CallableDescriptor>)resultingCall, context2){
            final /* synthetic */ MutableResolvedCall<? extends CallableDescriptor> $resultingCall;
            final /* synthetic */ BasicCallResolutionContext $context;
            {
                this.$resultingCall = $resultingCall;
                this.$context = $context;
                super(2);
            }

            public final void invoke(@NotNull ValueArgument valueArgument, @NotNull KotlinType kotlinType) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)valueArgument, (String)"valueArgument");
                Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
                Object object2 = this.$resultingCall.getArgumentMapping(valueArgument);
                Object object3 = object = object2 instanceof ArgumentMatch ? (ArgumentMatch)object2 : null;
                if (object == null) {
                    return;
                }
                ArgumentMatch argumentMatch = object;
                object = NewKotlinTypeChecker.Companion.getDefault();
                object2 = this.$context;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$invoke_u24lambda_u2d0 = object;
                boolean bl3 = false;
                KotlinType parameterType = CallResolverUtilKt.getEffectiveExpectedType(argumentMatch.getValueParameter(), valueArgument, (ResolutionContext)object2);
                ((NewKotlinTypeCheckerImpl)$this$invoke_u24lambda_u2d0).isSubtypeOf(new CoroutineTypeCheckerContext(false), kotlinType.unwrap(), parameterType.unwrap());
            }
        }));
        Object object = resultingDescriptor.getExtensionReceiverParameter();
        if (object == null) {
            return;
        }
        ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor = object;
        boolean allowOnlyTrivialConstraintsForReceiver = this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? !AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(resultingDescriptor) : false;
        object = resultingCall.getExtensionReceiver();
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object actualReceiver = object2;
            boolean bl3 = false;
            NewKotlinTypeCheckerImpl newKotlinTypeCheckerImpl = NewKotlinTypeChecker.Companion.getDefault();
            boolean bl4 = false;
            boolean bl5 = false;
            NewKotlinTypeCheckerImpl $this$checkCoroutineCalls_u24lambda_u2d1_u24lambda_u2d0 = newKotlinTypeCheckerImpl;
            boolean bl6 = false;
            $this$checkCoroutineCalls_u24lambda_u2d1_u24lambda_u2d0.isSubtypeOf(new CoroutineTypeCheckerContext(allowOnlyTrivialConstraintsForReceiver), actualReceiver.getType().unwrap(), extensionReceiver.getValue().getType().unwrap());
        }
    }

    private final void forceInferenceForArguments(CallResolutionContext<?> context2, Function2<? super ValueArgument, ? super KotlinType, Unit> callback) {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = context2.dataFlowInfoForArguments;
        Intrinsics.checkNotNullExpressionValue((Object)mutableDataFlowInfoForArguments, (String)"context.dataFlowInfoForArguments");
        MutableDataFlowInfoForArguments infoForArguments = mutableDataFlowInfoForArguments;
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"context.call");
        Call call3 = call2;
        CallResolutionContext baseContext = (CallResolutionContext)((CallResolutionContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        for (ValueArgument valueArgument : call3.getValueArguments()) {
            KtExpression ktExpression = valueArgument.getArgumentExpression();
            if (ktExpression == null) continue;
            KtExpression expression2 = ktExpression;
            Object object = baseContext.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            Intrinsics.checkNotNullExpressionValue(object, (String)"baseContext.replaceDataFlowInfo(infoForArguments.getInfo(argument))");
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, (CallResolutionContext)object);
            object = typeInfoForCall.getType();
            if (object == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"argument");
            callback.invoke((Object)valueArgument, it);
        }
    }

    private final KotlinTypeInfo getArgumentTypeInfo(KtExpression expression2, CallResolutionContext<?> context2) {
        Object object = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context2);
        if (object != null) {
            KtFunction ktFunction = object;
            boolean bl = false;
            boolean bl2 = false;
            KtFunction it = ktFunction;
            boolean bl3 = false;
            KotlinTypeInfo kotlinTypeInfo = this.getArgumentTypeResolver().getFunctionLiteralTypeInfo(expression2, it, context2, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"argumentTypeResolver.getFunctionLiteralTypeInfo(expression, it, context, RESOLVE_FUNCTION_ARGUMENTS, false)");
            return kotlinTypeInfo;
        }
        object = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context2);
        if (object != null) {
            KtExpression ktExpression = object;
            boolean bl = false;
            boolean bl4 = false;
            KtExpression it = ktExpression;
            boolean bl5 = false;
            KotlinTypeInfo kotlinTypeInfo = this.getArgumentTypeResolver().getCallableReferenceTypeInfo(expression2, (KtCallableReferenceExpression)it, context2, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"argumentTypeResolver.getCallableReferenceTypeInfo(expression, it, context, RESOLVE_FUNCTION_ARGUMENTS)");
            return kotlinTypeInfo;
        }
        object = this.expressionTypingServices.getTypeInfo(expression2, context2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"expressionTypingServices.getTypeInfo(expression, context)");
        return object;
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceSupport$CoroutineTypeCheckerContext;", "Lorg/jetbrains/kotlin/types/checker/ClassicTypeCheckerContext;", "allowOnlyTrivialConstraints", "", "(Z)V", "addSubtypeConstraint", "subType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "superType", "isFromNullabilityConstraint", "(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Z)Ljava/lang/Boolean;", "frontend"})
    private static final class CoroutineTypeCheckerContext
    extends ClassicTypeCheckerContext {
        private final boolean allowOnlyTrivialConstraints;

        public CoroutineTypeCheckerContext(boolean allowOnlyTrivialConstraints) {
            super(true, false, false, null, 14, null);
            this.allowOnlyTrivialConstraints = allowOnlyTrivialConstraints;
        }

        @Override
        @Nullable
        public Boolean addSubtypeConstraint(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType, boolean isFromNullabilityConstraint) {
            TypeTemplate typeTemplate;
            TypeTemplate typeTemplate2;
            Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
            Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
            boolean bl = subType instanceof UnwrappedType;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            bl = superType instanceof UnwrappedType;
            bl2 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl) {
                boolean bl6 = false;
                String string3 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            TypeTemplate typeTemplate3 = typeTemplate2 = subType instanceof TypeTemplate ? (TypeTemplate)subType : null;
            typeTemplate2 = typeTemplate = typeTemplate2 == null ? (superType instanceof TypeTemplate ? (TypeTemplate)superType : null) : typeTemplate2;
            if (typeTemplate2 != null) {
                CoroutineInferenceData coroutineInferenceData = typeTemplate2.getCoroutineInferenceData();
                coroutineInferenceData.addConstraint$frontend((KotlinType)subType, (KotlinType)superType, this.allowOnlyTrivialConstraints);
            }
            return null;
        }
    }
}

