/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.LateinitIntrinsicApplicabilityChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/LateinitIntrinsicApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "ACCESSIBLE_LATEINIT_PROPERTY_LITERAL", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isBackingFieldAccessible", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "frontend"})
public final class LateinitIntrinsicApplicabilityChecker
implements CallChecker {
    @NotNull
    public static final LateinitIntrinsicApplicabilityChecker INSTANCE = new LateinitIntrinsicApplicabilityChecker();
    @NotNull
    private static final FqName ACCESSIBLE_LATEINIT_PROPERTY_LITERAL = new FqName("kotlin.internal.AccessibleLateinitPropertyLiteral");

    private LateinitIntrinsicApplicabilityChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        Object object;
        KtExpression ktExpression;
        Object object2;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"isInitialized")) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        if (!Intrinsics.areEqual(receiverParameterDescriptor == null ? null : ((object2 = receiverParameterDescriptor.getAnnotations()) == null ? null : Boolean.valueOf(object2.hasAnnotation(ACCESSIBLE_LATEINIT_PROPERTY_LITERAL))), (Object)true)) {
            return;
        }
        Object object3 = resolvedCall2.getExtensionReceiver();
        Object object4 = object2 = object3 instanceof ExpressionReceiver ? (ExpressionReceiver)object3 : null;
        if (object2 == null) {
            ktExpression = null;
        } else {
            object3 = object2.getExpression();
            if (object3 == null) {
                ktExpression = null;
            } else {
                object = object3;
                bl = false;
                boolean bl2 = false;
                ResolvedCall<? extends CallableDescriptor> p0 = object;
                boolean bl3 = false;
                ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)((Object)p0));
            }
        }
        KtExpression expression2 = ktExpression;
        if (!(expression2 instanceof KtCallableReferenceExpression)) {
            context2.getTrace().report(Errors.LATEINIT_INTRINSIC_CALL_ON_NON_LITERAL.on(reportOn));
        } else {
            KtElement ktElement = ((KtCallableReferenceExpression)expression2).getCallableReference();
            object = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace.bindingContext");
            object3 = CallUtilKt.getResolvedCall(ktElement, (BindingContext)object);
            if (object3 == null) {
                return;
            }
            Object propertyReferenceResolvedCall = object3;
            CallableDescriptor referencedProperty = propertyReferenceResolvedCall.getResultingDescriptor();
            if (!(referencedProperty instanceof PropertyDescriptor)) {
                object = Intrinsics.stringPlus((String)"Lateinit intrinsic is incorrectly resolved not to a property: ", (Object)referencedProperty);
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            if (!((PropertyDescriptor)referencedProperty).isLateInit()) {
                context2.getTrace().report(Errors.LATEINIT_INTRINSIC_CALL_ON_NON_LATEINIT.on(reportOn));
            } else if (!this.isBackingFieldAccessible((PropertyDescriptor)referencedProperty, context2)) {
                context2.getTrace().report(Errors.LATEINIT_INTRINSIC_CALL_ON_NON_ACCESSIBLE_PROPERTY.on(reportOn, (PropertyDescriptor)referencedProperty));
            } else {
                DeclarationDescriptor declarationDescriptor = context2.getScope().getOwnerDescriptor();
                object = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                if (Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(object.isInline())), (Object)true)) {
                    context2.getTrace().report(Errors.LATEINIT_INTRINSIC_CALL_IN_INLINE_FUNCTION.on(reportOn));
                }
            }
        }
    }

    private final boolean isBackingFieldAccessible(PropertyDescriptor descriptor2, CallCheckerContext context2) {
        Object object = OverridingUtil.filterOutOverridden(OverridingUtil.getOverriddenDeclarations(descriptor2));
        Intrinsics.checkNotNullExpressionValue(object, (String)"filterOutOverridden(OverridingUtil.getOverriddenDeclarations(descriptor))");
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object));
        if (callableMemberDescriptor == null) {
            return false;
        }
        CallableMemberDescriptor declaration = callableMemberDescriptor;
        object = DescriptorToSourceUtils.getContainingFile(declaration);
        if (object == null) {
            return false;
        }
        Object declarationSourceFile = object;
        Object object2 = DescriptorToSourceUtils.getContainingFile(context2.getScope().getOwnerDescriptor());
        if (object2 == null) {
            return false;
        }
        Object usageSourceFile = object2;
        if (!Intrinsics.areEqual((Object)declarationSourceFile, (Object)usageSourceFile)) {
            return false;
        }
        Sequence sequence2 = SequencesKt.generateSequence((Object)context2.getScope().getOwnerDescriptor(), (Function1)isBackingFieldAccessible.1.INSTANCE);
        object2 = declaration.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"declaration.containingDeclaration");
        return SequencesKt.contains((Sequence)sequence2, (Object)object2);
    }
}

