/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopesKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a:\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\"\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e\u001a&\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a&\u0010!\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b\u001a\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\f2\u0006\u0010)\u001a\u00020\u0014H\u0002\u001a\u000e\u0010*\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014\u001a\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0014\u001a\u000e\u0010.\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0014\u001a\u0016\u0010/\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u00100\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u00101\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u00102\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u00103\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u00104\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u00105\u001a\u00020\u00012\u0006\u0010%\u001a\u000206\u001a\u000e\u00107\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u00108\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014\u001a\u0016\u00109\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u0014\u001a\u001e\u0010;\u001a\u00020<2\u0006\u0010)\u001a\u00020\u00142\f\u0010=\u001a\b\u0012\u0004\u0012\u00020(0\fH\u0002\u001a\u0012\u0010>\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010?\u001a\u00020@\u001a\u0014\u0010A\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010?\u001a\u00020@H\u0002\u001a\f\u0010B\u001a\u00020C*\u00020DH\u0000\u00a8\u0006E"}, d2={"arrayAssignmentToVarargInNamedFormInAnnotation", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "arrayAssignmentToVarargInNamedFormInFunction", "createResolutionCandidatesForConstructors", "", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate;", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "lexicalScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "typeWithConstructors", "Lorg/jetbrains/kotlin/types/KotlinType;", "useKnownTypeSubstitutor", "syntheticScopes", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticScopes;", "filterOutTypeParameters", "upperBounds", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getEffectiveExpectedType", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getEffectiveExpectedTypeForSingleArgument", "getErasedReceiverType", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptor", "getExpectedType", "getParameterArgumentsOfCallableType", "Lorg/jetbrains/kotlin/types/TypeProjection;", "type", "getReturnTypeForCallable", "getSuperCallExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "hasUnknownFunctionParameter", "hasUnknownReturnType", "isArrayOrArrayLiteral", "isBinaryRemOperator", "isConventionCall", "isInfixCall", "isInvokeCallOnExpressionWithBothReceivers", "isInvokeCallOnVariable", "isOrOverridesSynthesized", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isSuperOrDelegatingConstructorCall", "replaceReturnTypeByUnknown", "replaceReturnTypeForCallable", "given", "replaceTypeArguments", "Lorg/jetbrains/kotlin/types/SimpleType;", "newArguments", "hasInferredReturnType", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "hasReturnTypeDependentOnUninferredParams", "reportOnElement", "Lcom/intellij/psi/NavigatablePsiElement;", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "frontend"})
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull KotlinType type2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            boolean bl2 = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string2 = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            Iterable $this$any$iv = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeProjection it = (TypeProjection)element$iv;
                    boolean bl5 = false;
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                    if (!(TypeUtilsKt.contains(kotlinType, (Function1<? super UnwrappedType, Boolean>)((Function1)hasUnknownFunctionParameter.2.1.INSTANCE)) || ErrorUtils.containsUninferredParameter(it.getType()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        boolean bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final KotlinType replaceReturnTypeForCallable(@NotNull KotlinType type2, @NotNull KotlinType given) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        boolean bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ArrayList newArguments2 = Lists.newArrayList();
        newArguments2.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments2.add(new TypeProjectionImpl(Variance.INVARIANT, given));
        Intrinsics.checkNotNullExpressionValue((Object)newArguments2, (String)"newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, newArguments2);
    }

    @NotNull
    public static final KotlinType replaceReturnTypeByUnknown(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        SimpleType simpleType2 = TypeUtils.DONT_CARE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"DONT_CARE");
        return CallResolverUtilKt.replaceReturnTypeForCallable(type2, simpleType2);
    }

    private static final SimpleType replaceTypeArguments(KotlinType type2, List<? extends TypeProjection> newArguments2) {
        return KotlinTypeFactory.simpleType$default(type2.getAnnotations(), type2.getConstructor(), newArguments2, type2.isMarkedNullable(), null, 16, null);
    }

    private static final List<TypeProjection> getParameterArgumentsOfCallableType(KotlinType type2) {
        return CollectionsKt.dropLast(type2.getArguments(), (int)1);
    }

    @NotNull
    public static final KotlinType getReturnTypeForCallable(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.last(type2.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type.arguments.last().type");
        return kotlinType;
    }

    private static final boolean hasReturnTypeDependentOnUninferredParams(CallableDescriptor $this$hasReturnTypeDependentOnUninferredParams, ConstraintSystem constraintSystem) {
        boolean bl;
        block4: {
            KotlinType kotlinType;
            KotlinType kotlinType2 = $this$hasReturnTypeDependentOnUninferredParams.getReturnType();
            if (kotlinType2 == null) {
                return false;
            }
            KotlinType returnType2 = kotlinType = kotlinType2;
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(constraintSystem, returnType2);
            Iterable $this$any$iv = nestedTypeVariables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeVariable it = (TypeVariable)element$iv;
                    boolean bl2 = false;
                    if (!(constraintSystem.getTypeBounds(it).getValue() == null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(@NotNull CallableDescriptor $this$hasInferredReturnType, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$hasInferredReturnType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)constraintSystem, (String)"constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($this$hasInferredReturnType, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinType> filterOutTypeParameters(List<? extends KotlinType> upperBounds, CallableDescriptor candidateDescriptor) {
        void $this$filterNotTo$iv$iv;
        if (upperBounds.size() < 2) {
            return upperBounds;
        }
        Iterable $this$filterNot$iv = upperBounds;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl = false;
            ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
            if (declarationDescriptor instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)((TypeParameterDescriptor)declarationDescriptor).getContainingDeclaration(), (Object)candidateDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List result2 = (List)destination$iv$iv;
        if (result2.isEmpty()) {
            return upperBounds;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        TypeConstructor typeConstructor2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)receiverParameterDescriptor, (String)"receiverParameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        KotlinType kotlinType = receiverParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiverParameterDescriptor.type");
        Object receiverType = kotlinType;
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            if (!Intrinsics.areEqual((Object)typeParameterDescriptor.getTypeConstructor(), (Object)((KotlinType)receiverType).getConstructor())) continue;
            object = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(object, (String)"typeParameter.upperBounds");
            List<KotlinType> properUpperBounds = CallResolverUtilKt.filterOutTypeParameters(object, descriptor2);
            object = TypeIntersector.intersectUpperBounds(typeParameterDescriptor, properUpperBounds);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"intersectUpperBounds(typeParameter, properUpperBounds)");
            receiverType = object;
        }
        SmartList<TypeProjectionImpl> fakeTypeArguments = new SmartList<TypeProjectionImpl>();
        for (TypeProjection typeProjection : ((KotlinType)receiverType).getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        TypeConstructor typeConstructor3 = ((KotlinType)receiverType).getConstructor();
        if (typeConstructor3 instanceof IntersectionTypeConstructor) {
            IntersectionTypeConstructor intersectionTypeConstructor;
            Object object2;
            Iterable destination$iv$iv;
            void $this$mapTo$iv$iv$iv;
            IntersectionTypeConstructor $this$transformComponents_u24default$iv = (IntersectionTypeConstructor)typeConstructor3;
            boolean $i$f$transformComponents = false;
            boolean changed$iv = false;
            Iterable $this$map$iv$iv = $this$transformComponents_u24default$iv.getSupertypes();
            boolean $i$f$map = false;
            Object object3 = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                KotlinType kotlinType2;
                void it$iv;
                KotlinType kotlinType3 = (KotlinType)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                void it = it$iv;
                if (true) {
                    void $this$mapTo$iv$iv;
                    changed$iv = true;
                    void supertype2 = it$iv;
                    boolean bl2 = false;
                    Iterable $this$map$iv = supertype2.getArguments();
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                        object2 = destination$iv$iv;
                        boolean bl3 = false;
                        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(it2.getProjectionKind(), TypeUtils.DONT_CARE);
                        object2.add(typeProjectionImpl);
                    }
                    List fakeArguments = (List)destination$iv$iv;
                    kotlinType2 = TypeSubstitutionKt.replace$default((KotlinType)supertype2, fakeArguments, null, null, 6, null);
                } else {
                    kotlinType2 = it$iv;
                }
                void var21_25 = kotlinType2;
                collection.add(var21_25);
            }
            List newSupertypes$iv = (List)destination$iv$iv$iv;
            if (!changed$iv) {
                intersectionTypeConstructor = null;
            } else {
                Object object4;
                KotlinType kotlinType4 = $this$transformComponents_u24default$iv.getAlternativeType();
                if (kotlinType4 == null) {
                    object4 = null;
                } else {
                    object3 = kotlinType4;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object alternative$iv = object3;
                    boolean bl5 = false;
                    Object it = alternative$iv;
                    if (true) {
                        void $this$mapTo$iv$iv;
                        Object supertype3 = alternative$iv;
                        boolean bl6 = false;
                        Iterable $this$map$iv = ((KotlinType)supertype3).getArguments();
                        boolean $i$f$map3 = false;
                        destination$iv$iv = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo3 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it3;
                            object2 = (TypeProjection)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl7 = false;
                            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(it3.getProjectionKind(), TypeUtils.DONT_CARE);
                            collection.add(typeProjectionImpl);
                        }
                        List fakeArguments = (List)destination$iv$iv2;
                        object4 = TypeSubstitutionKt.replace$default((KotlinType)supertype3, fakeArguments, null, null, 6, null);
                    } else {
                        object4 = alternative$iv;
                    }
                }
                Object updatedAlternative$iv = object4;
                intersectionTypeConstructor = new IntersectionTypeConstructor(newSupertypes$iv).setAlternative((KotlinType)updatedAlternative$iv);
            }
            object = intersectionTypeConstructor;
            typeConstructor2 = (TypeConstructor)(object == null ? (IntersectionTypeConstructor)typeConstructor3 : object);
        } else {
            typeConstructor2 = typeConstructor3;
        }
        TypeConstructor receiverTypeConstructor = typeConstructor2;
        Annotations annotations2 = receiverType.getAnnotations();
        List list2 = fakeTypeArguments;
        boolean bl = ((KotlinType)receiverType).isMarkedNullable();
        object = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createErrorScope(\"Error scope for erased receiver type\", /*throwExceptions=*/true)");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, receiverTypeConstructor, list2, bl, (MemberScope)object);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return true;
        }
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            boolean bl;
            block5: {
                Collection<? extends CallableMemberDescriptor> collection = descriptor2.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.overriddenDescriptors");
                Iterable $this$all$iv = collection;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CallableMemberDescriptor p0 = (CallableMemberDescriptor)element$iv;
                        boolean bl2 = false;
                        if (CallResolverUtilKt.isOrOverridesSynthesized(p0)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    public static final boolean isBinaryRemOperator(@NotNull Call call2) {
        Name name;
        KtBinaryExpression ktBinaryExpression;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        KtElement ktElement = call2.getCallElement();
        KtBinaryExpression ktBinaryExpression2 = ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression callElement = ktBinaryExpression;
        ktElement = callElement.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"callElement.operationToken");
        KtElement operator = ktElement;
        if (!(operator instanceof KtToken)) {
            return false;
        }
        Name name2 = OperatorConventions.getNameForOperationSymbol((KtToken)((Object)operator), true, true);
        if (name2 == null) {
            return false;
        }
        Name name3 = name = name2;
        return ((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.keySet()).contains((Object)name3);
    }

    public static final boolean isConventionCall(@NotNull Call call2) {
        KtOperationReferenceExpression ktOperationReferenceExpression;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        if (call2 instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"call.callElement");
        KtElement callElement = ktElement;
        if (callElement instanceof KtArrayAccessExpression || callElement instanceof KtDestructuringDeclarationEntry) {
            return true;
        }
        KtExpression ktExpression = call2.getCalleeExpression();
        KtOperationReferenceExpression ktOperationReferenceExpression2 = ktOperationReferenceExpression = ktExpression instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)ktExpression : null;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        return calleeExpression.isConventionOperator();
    }

    public static final boolean isInfixCall(@NotNull Call call2) {
        KtOperationReferenceExpression ktOperationReferenceExpression;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        KtExpression ktExpression = call2.getCalleeExpression();
        KtOperationReferenceExpression ktOperationReferenceExpression2 = ktOperationReferenceExpression = ktExpression instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)ktExpression : null;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
        PsiElement psiElement = operationRefExpression.getParent();
        KtExpression ktExpression2 = ktExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if (ktExpression == null) {
            return false;
        }
        KtExpression binaryExpression = ktExpression;
        return ((KtBinaryExpression)binaryExpression).getOperationReference() == operationRefExpression && operationRefExpression.getOperationSignTokenType() == null;
    }

    public static final boolean isSuperOrDelegatingConstructorCall(@NotNull Call call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        KtExpression ktExpression = call2.getCalleeExpression();
        boolean bl = false;
        boolean bl2 = false;
        KtExpression it = ktExpression;
        boolean bl3 = false;
        return it instanceof KtConstructorCalleeExpression || it instanceof KtConstructorDelegationReferenceExpression;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        if (call2.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue dispatchReceiver = call2.getDispatchReceiver();
        if (dispatchReceiver == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        KtExpression expression2 = ((ExpressionReceiver)dispatchReceiver).getExpression();
        return expression2 instanceof KtSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        if (call2.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            return false;
        }
        return call2.getExplicitReceiver() != null && call2.getDispatchReceiver() != null;
    }

    @Nullable
    public static final KtSuperExpression getSuperCallExpression(@NotNull Call call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Receiver receiver = call2.getExplicitReceiver();
        ExpressionReceiver expressionReceiver = receiver instanceof ExpressionReceiver ? (ExpressionReceiver)receiver : null;
        KtExpression ktExpression = expressionReceiver == null ? null : expressionReceiver.getExpression();
        return ktExpression instanceof KtSuperExpression ? (KtSuperExpression)ktExpression : null;
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)resolvedArgument, (String)"resolvedArgument");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resolvedArgument.arguments");
        ValueArgument argument2 = (ValueArgument)CollectionsKt.singleOrNull(list2);
        return argument2 != null ? CallResolverUtilKt.getEffectiveExpectedTypeForSingleArgument(parameterDescriptor, argument2, languageVersionSettings, trace) : CallResolverUtilKt.getExpectedType(parameterDescriptor);
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument2, @NotNull ResolutionContext<?> context2) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Object object = context2.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.languageVersionSettings");
        LanguageVersionSettings languageVersionSettings = object;
        object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        return CallResolverUtilKt.getEffectiveExpectedTypeForSingleArgument(parameterDescriptor, argument2, languageVersionSettings, (BindingTrace)object);
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedTypeForSingleArgument(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (argument2.getSpreadElement() != null) {
            KotlinType kotlinType;
            if (parameterDescriptor.getVarargElementType() == null) {
                SimpleType simpleType2 = TypeUtils.DONT_CARE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"DONT_CARE");
                kotlinType = simpleType2;
            } else {
                KotlinType kotlinType2 = parameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"parameterDescriptor.type");
                kotlinType = kotlinType2;
            }
            return kotlinType;
        }
        if (CallResolverUtilKt.arrayAssignmentToVarargInNamedFormInAnnotation(parameterDescriptor, argument2, languageVersionSettings, trace) || CallResolverUtilKt.arrayAssignmentToVarargInNamedFormInFunction(parameterDescriptor, argument2, languageVersionSettings, trace)) {
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameterDescriptor.type");
            return kotlinType;
        }
        return CallResolverUtilKt.getExpectedType(parameterDescriptor);
    }

    private static final KotlinType getExpectedType(ValueParameterDescriptor parameterDescriptor) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = parameterDescriptor.getVarargElementType();
        if (kotlinType2 == null) {
            KotlinType kotlinType3 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"parameterDescriptor.type");
            kotlinType = kotlinType3;
        } else {
            kotlinType = kotlinType2;
        }
        return kotlinType;
    }

    private static final boolean arrayAssignmentToVarargInNamedFormInAnnotation(ValueParameterDescriptor parameterDescriptor, ValueArgument argument2, LanguageVersionSettings languageVersionSettings, BindingTrace trace) {
        boolean isAllowedAssigningSingleElementsToVarargsInNamedForm;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return false;
        }
        boolean bl = isAllowedAssigningSingleElementsToVarargsInNamedForm = !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm);
        if (isAllowedAssigningSingleElementsToVarargsInNamedForm && !CallResolverUtilKt.isArrayOrArrayLiteral(argument2, trace)) {
            return false;
        }
        return DescriptorUtilsKt.isParameterOfAnnotation(parameterDescriptor) && argument2.isNamed() && ArgumentsUtilsKt.isVararg(parameterDescriptor);
    }

    private static final boolean arrayAssignmentToVarargInNamedFormInFunction(ValueParameterDescriptor parameterDescriptor, ValueArgument argument2, LanguageVersionSettings languageVersionSettings, BindingTrace trace) {
        boolean isAllowedAssigningSingleElementsToVarargsInNamedForm;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions)) {
            return false;
        }
        boolean bl = isAllowedAssigningSingleElementsToVarargsInNamedForm = !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm);
        if (isAllowedAssigningSingleElementsToVarargsInNamedForm && !CallResolverUtilKt.isArrayOrArrayLiteral(argument2, trace)) {
            return false;
        }
        return argument2.isNamed() && ArgumentsUtilsKt.isVararg(parameterDescriptor);
    }

    public static final boolean isArrayOrArrayLiteral(@NotNull ValueArgument argument2, @NotNull BindingTrace trace) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        KtExpression ktExpression = argument2.getArgumentExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression argumentExpression = ktExpression;
        if (argumentExpression instanceof KtCollectionLiteralExpression) {
            return true;
        }
        KotlinType kotlinType2 = trace.getType(argumentExpression);
        if (kotlinType2 == null) {
            return false;
        }
        KotlinType type2 = kotlinType = kotlinType2;
        return KotlinBuiltIns.isArrayOrPrimitiveArray(type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResolutionCandidate<ConstructorDescriptor>> createResolutionCandidatesForConstructors(@NotNull LexicalScope lexicalScope, @NotNull Call call2, @NotNull KotlinType typeWithConstructors, boolean useKnownTypeSubstitutor, @NotNull SyntheticScopes syntheticScopes) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        CallableDescriptor it;
        Collection constructors2;
        Object object;
        Object $this$mapNotNullTo$iv$iv;
        Object destination$iv$iv;
        Object $this$mapNotNull$iv;
        List list2;
        TypeSubstitutor knownSubstitutor;
        TypeSubstitutor typeSubstitutor2;
        Annotated annotated;
        Intrinsics.checkNotNullParameter((Object)lexicalScope, (String)"lexicalScope");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)typeWithConstructors, (String)"typeWithConstructors");
        Intrinsics.checkNotNullParameter((Object)syntheticScopes, (String)"syntheticScopes");
        ClassifierDescriptor classifierDescriptor = typeWithConstructors.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor classWithConstructors = (ClassDescriptor)classifierDescriptor;
        UnwrappedType unwrappedType = typeWithConstructors.unwrap();
        if (useKnownTypeSubstitutor) {
            AbbreviatedType abbreviatedType;
            AbbreviatedType abbreviatedType2 = abbreviatedType = unwrappedType instanceof AbbreviatedType ? (AbbreviatedType)unwrappedType : null;
            typeSubstitutor2 = TypeSubstitutor.create(abbreviatedType == null ? unwrappedType : ((annotated = abbreviatedType.getAbbreviation()) == null ? unwrappedType : (UnwrappedType)annotated));
        } else {
            typeSubstitutor2 = knownSubstitutor = null;
        }
        TypeAliasDescriptor typeAliasDescriptor = unwrappedType instanceof AbbreviatedType ? ((annotated = ((AbbreviatedType)unwrappedType).getAbbreviation().getConstructor().getDeclarationDescriptor()) instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)annotated : null) : null;
        Object object2 = typeAliasDescriptor;
        if (object2 == null) {
            list2 = null;
        } else {
            Collection<TypeAliasConstructorDescriptor> collection = object2.getConstructors();
            if (collection == null) {
                list2 = null;
            } else {
                $this$mapNotNull$iv = collection;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    TypeAliasConstructorDescriptor typeAliasConstructorDescriptor;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    TypeAliasConstructorDescriptor p0 = (TypeAliasConstructorDescriptor)element$iv$iv;
                    boolean bl2 = false;
                    if (p0.getWithDispatchReceiver() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    TypeAliasConstructorDescriptor it$iv$iv = typeAliasConstructorDescriptor;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
        }
        List list3 = list2;
        if (list3 == null) {
            object2 = classWithConstructors.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"classWithConstructors.constructors");
            object = object2;
        } else {
            object = constructors2 = (Collection)list3;
        }
        if (constructors2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ExplicitReceiverKind receiverKind = null;
        ReceiverValue dispatchReceiver = null;
        if (classWithConstructors.isInner()) {
            Object v5;
            block18: {
                KotlinType $i$f$mapNotNull;
                destination$iv$iv = classWithConstructors.getContainingDeclaration();
                $this$mapNotNullTo$iv$iv = destination$iv$iv instanceof ClassDescriptor ? (ClassDescriptor)destination$iv$iv : null;
                SimpleType simpleType2 = $i$f$mapNotNull = $this$mapNotNullTo$iv$iv == null ? null : $this$mapNotNullTo$iv$iv.getDefaultType();
                if ($i$f$mapNotNull == null) {
                    return CollectionsKt.emptyList();
                }
                Object outerClassType = $this$mapNotNull$iv = $i$f$mapNotNull;
                $this$mapNotNullTo$iv$iv = knownSubstitutor;
                KotlinType substitutedOuterClassType = $i$f$mapNotNull = $this$mapNotNullTo$iv$iv == null ? (KotlinType)outerClassType : ((destination$iv$iv = ((TypeSubstitutor)$this$mapNotNullTo$iv$iv).substitute((KotlinType)outerClassType, Variance.INVARIANT)) == null ? (KotlinType)outerClassType : destination$iv$iv);
                Iterable $this$firstOrNull$iv = ScopeUtilsKt.getImplicitReceiversHierarchy(lexicalScope);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (ReceiverParameterDescriptor)element$iv;
                    boolean bl = false;
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(it.getType(), substitutedOuterClassType)) continue;
                    v5 = element$iv;
                    break block18;
                }
                v5 = null;
            }
            $this$mapNotNullTo$iv$iv = v5;
            if ($this$mapNotNullTo$iv$iv == null) {
                return CollectionsKt.emptyList();
            }
            Object receiver = $this$mapNotNullTo$iv$iv;
            receiverKind = ExplicitReceiverKind.DISPATCH_RECEIVER;
            dispatchReceiver = receiver.getValue();
        } else {
            receiverKind = ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            dispatchReceiver = null;
        }
        Iterable $this$flatMap$iv = constructors2;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ConstructorDescriptor)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            list$iv$iv = SyntheticScopesKt.collectSyntheticConstructors(syntheticScopes, (ConstructorDescriptor)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List syntheticConstructors = (List)destination$iv$iv;
        Iterable $this$map$iv = CollectionsKt.plus((Collection)constructors2, (Iterable)syntheticConstructors);
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ConstructorDescriptor)item$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, it, dispatchReceiver, receiverKind, knownSubstitutor);
            object3.add(resolutionCandidate);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final NavigatablePsiElement reportOnElement(@NotNull KtConstructorDelegationCall $this$reportOnElement) {
        NavigatablePsiElement navigatablePsiElement;
        Intrinsics.checkNotNullParameter((Object)$this$reportOnElement, (String)"<this>");
        if ($this$reportOnElement.isImplicit()) {
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$reportOnElement;
            boolean $i$f$getStrictParentOfType = false;
            KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtSecondaryConstructor.class, (boolean)true);
            Intrinsics.checkNotNull((Object)ktSecondaryConstructor);
            navigatablePsiElement = ktSecondaryConstructor;
        } else {
            navigatablePsiElement = $this$reportOnElement;
        }
        return navigatablePsiElement;
    }
}

