/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.typeEnhancement;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancedTypeAnnotations;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancementResult;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.MutabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPosition;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPositionKt;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnchancementUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0005H\u0002\u001a\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\"\u0004\b\u0000\u0010\u000e*\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\"\u0004\b\u0000\u0010\u000e*\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\n\u0010\u0014\u001a\u00020\u0012*\u00020\u0013\u001a\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\"\u0004\b\u0000\u0010\u000e*\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"ENHANCED_MUTABILITY_ANNOTATIONS", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancedTypeAnnotations;", "ENHANCED_NULLABILITY_ANNOTATIONS", "compositeAnnotationsOrSingle", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "", "enhanceMutability", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancementResult;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "qualifiers", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeQualifiers;", "position", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/TypeComponentPosition;", "enhancedMutability", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancementResult;", "enhancedNullability", "getEnhancedNullability", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasEnhancedNullability", "noChange", "descriptors.jvm"})
public final class TypeEnhancementKt {
    @NotNull
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    @NotNull
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    public static final boolean hasEnhancedNullability(@NotNull KotlinType $this$hasEnhancedNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$hasEnhancedNullability, (String)"<this>");
        return TypeEnchancementUtilsKt.hasEnhancedNullability(SimpleClassicTypeSystemContext.INSTANCE, $this$hasEnhancedNullability);
    }

    private static final Annotations compositeAnnotationsOrSingle(List<? extends Annotations> $this$compositeAnnotationsOrSingle) {
        Annotations annotations2;
        int n = $this$compositeAnnotationsOrSingle.size();
        switch (n) {
            case 0: {
                String string2 = "At least one Annotations object expected";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            case 1: {
                annotations2 = (Annotations)CollectionsKt.single($this$compositeAnnotationsOrSingle);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(CollectionsKt.toList((Iterable)$this$compositeAnnotationsOrSingle));
            }
        }
        return annotations2;
    }

    private static final <T> EnhancementResult<T> noChange(T $this$noChange) {
        return new EnhancementResult<T>($this$noChange, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $this$enhancedNullability) {
        return new EnhancementResult<T>($this$enhancedNullability, ENHANCED_NULLABILITY_ANNOTATIONS);
    }

    private static final <T> EnhancementResult<T> enhancedMutability(T $this$enhancedMutability) {
        return new EnhancementResult<T>($this$enhancedMutability, ENHANCED_MUTABILITY_ANNOTATIONS);
    }

    private static final EnhancementResult<ClassifierDescriptor> enhanceMutability(ClassifierDescriptor $this$enhanceMutability, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeComponentPositionKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($this$enhanceMutability);
        }
        if (!($this$enhanceMutability instanceof ClassDescriptor)) {
            return TypeEnhancementKt.noChange($this$enhanceMutability);
        }
        JavaToKotlinClassMapper mapper = JavaToKotlinClassMapper.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        int n = mutabilityQualifier == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mutabilityQualifier.ordinal()];
        switch (n) {
            case 1: {
                if (position != TypeComponentPosition.FLEXIBLE_LOWER || !mapper.isMutable((ClassDescriptor)$this$enhanceMutability)) break;
                return TypeEnhancementKt.enhancedMutability(mapper.convertMutableToReadOnly((ClassDescriptor)$this$enhanceMutability));
            }
            case 2: {
                if (position != TypeComponentPosition.FLEXIBLE_UPPER || !mapper.isReadOnly((ClassDescriptor)$this$enhanceMutability)) break;
                return TypeEnhancementKt.enhancedMutability(mapper.convertReadOnlyToMutable((ClassDescriptor)$this$enhanceMutability));
            }
        }
        return TypeEnhancementKt.noChange($this$enhanceMutability);
    }

    private static final EnhancementResult<Boolean> getEnhancedNullability(KotlinType $this$getEnhancedNullability, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        EnhancementResult<Boolean> enhancementResult;
        if (!TypeComponentPositionKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($this$getEnhancedNullability.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        int n = nullabilityQualifier == null ? -1 : WhenMappings.$EnumSwitchMapping$1[nullabilityQualifier.ordinal()];
        switch (n) {
            case 1: {
                enhancementResult = TypeEnhancementKt.enhancedNullability(true);
                break;
            }
            case 2: {
                enhancementResult = TypeEnhancementKt.enhancedNullability(false);
                break;
            }
            default: {
                enhancementResult = TypeEnhancementKt.noChange($this$getEnhancedNullability.isMarkedNullable());
            }
        }
        return enhancementResult;
    }

    public static final /* synthetic */ EnhancementResult access$enhanceMutability(ClassifierDescriptor $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        return TypeEnhancementKt.enhanceMutability($receiver, qualifiers, position);
    }

    public static final /* synthetic */ EnhancementResult access$getEnhancedNullability(KotlinType $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        return TypeEnhancementKt.getEnhancedNullability($receiver, qualifiers, position);
    }

    public static final /* synthetic */ Annotations access$compositeAnnotationsOrSingle(List $receiver) {
        return TypeEnhancementKt.compositeAnnotationsOrSingle($receiver);
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        fqName2 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
    }

    @Metadata(mv={1, 5, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MutabilityQualifier.values().length];
            nArray[MutabilityQualifier.READ_ONLY.ordinal()] = 1;
            nArray[MutabilityQualifier.MUTABLE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[NullabilityQualifier.values().length];
            nArray[NullabilityQualifier.NULLABLE.ordinal()] = 1;
            nArray[NullabilityQualifier.NOT_NULL.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

