/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser;", "Lcom/intellij/lang/PsiParser;", "()V", "isName", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "parse", "Lcom/intellij/lang/ASTNode;", "root", "builder", "Lcom/intellij/lang/PsiBuilder;", "parseQualifiedName", "", "Companion", "psi"})
public final class KDocLinkParser
implements PsiParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ASTNode parse(@NotNull IElementType root2, @NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"builder.mark()");
        PsiBuilder.Marker rootMarker = marker;
        boolean hasLBracket = Intrinsics.areEqual((Object)builder.getTokenType(), (Object)((Object)KtTokens.LBRACKET));
        if (hasLBracket) {
            builder.advanceLexer();
        }
        this.parseQualifiedName(builder);
        if (hasLBracket) {
            if (!builder.eof() && !Intrinsics.areEqual((Object)builder.getTokenType(), (Object)((Object)KtTokens.RBRACKET))) {
                builder.error("Closing bracket expected");
                while (!builder.eof() && !Intrinsics.areEqual((Object)builder.getTokenType(), (Object)((Object)KtTokens.RBRACKET))) {
                    builder.advanceLexer();
                }
            }
            if (Intrinsics.areEqual((Object)builder.getTokenType(), (Object)((Object)KtTokens.RBRACKET))) {
                builder.advanceLexer();
            }
        } else if (!builder.eof()) {
            builder.error("Expression expected");
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        rootMarker.done(root2);
        ASTNode aSTNode = builder.getTreeBuilt();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"builder.treeBuilt");
        return aSTNode;
    }

    private final void parseQualifiedName(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"builder.mark()");
        PsiBuilder.Marker marker2 = marker;
        while (true) {
            if (!this.isName(builder.getTokenType())) {
                marker2.drop();
                builder.error("Identifier expected");
                break;
            }
            builder.advanceLexer();
            marker2.done((IElementType)KDocElementTypes.KDOC_NAME);
            if (!Intrinsics.areEqual((Object)builder.getTokenType(), (Object)((Object)KtTokens.DOT))) break;
            marker = marker2.precede();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"marker.precede()");
            marker2 = marker;
            builder.advanceLexer();
        }
    }

    private final boolean isName(IElementType tokenType) {
        return Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.IDENTIFIER)) || KtTokens.KEYWORDS.contains(tokenType);
    }

    @JvmStatic
    @NotNull
    public static final ASTNode parseMarkdownLink(@NotNull IElementType root2, @NotNull ASTNode chameleon) {
        return Companion.parseMarkdownLink(root2, chameleon);
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser$Companion;", "", "()V", "parseMarkdownLink", "Lcom/intellij/lang/ASTNode;", "root", "Lcom/intellij/psi/tree/IElementType;", "chameleon", "psi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ASTNode parseMarkdownLink(@NotNull IElementType root2, @NotNull ASTNode chameleon) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter((Object)chameleon, (String)"chameleon");
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parentElement.project");
            Project project2 = project;
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(project2, chameleon, (Lexer)new KotlinLexer(), root2.getLanguage(), (CharSequence)chameleon.getText());
            Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"getInstance().createBuilder(\n                project,\n                chameleon,\n                KotlinLexer(),\n                root.language,\n                chameleon.text\n            )");
            PsiBuilder builder = psiBuilder;
            KDocLinkParser parser = new KDocLinkParser();
            ASTNode aSTNode = parser.parse(root2, builder).getFirstChildNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"parser.parse(root, builder).firstChildNode");
            return aSTNode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

