/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.impl.IrDynamicTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.types.impl.IrTypeAbbreviationImpl;
import org.jetbrains.kotlin.ir.util.ConstantValueGenerator;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.OriginalDescriptorsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.ScopedTypeParametersResolver;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.ir.util.TypeParametersResolver;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.RawType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u001e\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0$2\u0006\u0010%\u001a\u00020&H\u0002J-\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H(0,H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020*J\u000e\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020*J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001eJ\u0018\u00106\u001a\u00020\"2\u0006\u00108\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J \u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u00108\u001a\u00020\u001e2\b\b\u0002\u0010<\u001a\u00020\u001eH\u0002J\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020>0:2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0:H\u0002J'\u0010A\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0006\u0010B\u001a\u00020\u00172\f\u0010C\u001a\b\u0012\u0004\u0012\u0002H(0,\u00a2\u0006\u0002\u0010DJ\u001c\u0010E\u001a\u00020/*\b\u0012\u0004\u0012\u00020;0F2\b\u0010G\u001a\u0004\u0018\u00010HH\u0002J\f\u0010I\u001a\u00020J*\u00020KH\u0002R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "typeParametersResolver", "Lorg/jetbrains/kotlin/ir/util/TypeParametersResolver;", "enterTableScope", "", "extensions", "Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions;", "(Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/ir/util/TypeParametersResolver;ZLorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions;)V", "constantValueGenerator", "Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "getConstantValueGenerator", "()Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "setConstantValueGenerator", "(Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;)V", "erasureStack", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isWithNewInference", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeApproximatorForNI", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "approximate", "Lorg/jetbrains/kotlin/types/KotlinType;", "ktType", "approximateByKotlinRules", "approximateUpperBounds", "Lorg/jetbrains/kotlin/ir/types/IrTypeProjection;", "upperBounds", "", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "buildWithScope", "T", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "builder", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enterScope", "", "irElement", "leaveScope", "resolveTypeParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "translateType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "kotlinType", "translateTypeAnnotations", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "flexibleType", "translateTypeArguments", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "arguments", "Lorg/jetbrains/kotlin/types/TypeProjection;", "withTypeErasure", "propertyDescriptor", "b", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addSpecialAnnotation", "", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "toIrTypeAbbreviation", "Lorg/jetbrains/kotlin/ir/types/IrTypeAbbreviation;", "Lorg/jetbrains/kotlin/types/SimpleType;", "ir.tree"})
public final class TypeTranslator {
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final TypeParametersResolver typeParametersResolver;
    private final boolean enterTableScope;
    @NotNull
    private final StubGeneratorExtensions extensions;
    @NotNull
    private final Stack<PropertyDescriptor> erasureStack;
    @NotNull
    private final TypeApproximator typeApproximatorForNI;
    public ConstantValueGenerator constantValueGenerator;
    private final boolean isWithNewInference;

    public TypeTranslator(@NotNull ReferenceSymbolTable symbolTable, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull KotlinBuiltIns builtIns, @NotNull TypeParametersResolver typeParametersResolver, boolean enterTableScope, @NotNull StubGeneratorExtensions extensions) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)typeParametersResolver, (String)"typeParametersResolver");
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        this.symbolTable = symbolTable;
        this.languageVersionSettings = languageVersionSettings;
        this.typeParametersResolver = typeParametersResolver;
        this.enterTableScope = enterTableScope;
        this.extensions = extensions;
        this.erasureStack = new Stack();
        this.typeApproximatorForNI = new TypeApproximator(builtIns);
        this.isWithNewInference = this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
    }

    public /* synthetic */ TypeTranslator(ReferenceSymbolTable referenceSymbolTable, LanguageVersionSettings languageVersionSettings, KotlinBuiltIns kotlinBuiltIns, TypeParametersResolver typeParametersResolver, boolean bl, StubGeneratorExtensions stubGeneratorExtensions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            typeParametersResolver = new ScopedTypeParametersResolver();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            stubGeneratorExtensions = StubGeneratorExtensions.EMPTY;
        }
        this(referenceSymbolTable, languageVersionSettings, kotlinBuiltIns, typeParametersResolver, bl, stubGeneratorExtensions);
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final ConstantValueGenerator getConstantValueGenerator() {
        ConstantValueGenerator constantValueGenerator = this.constantValueGenerator;
        if (constantValueGenerator != null) {
            return constantValueGenerator;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"constantValueGenerator");
        throw null;
    }

    public final void setConstantValueGenerator(@NotNull ConstantValueGenerator constantValueGenerator) {
        Intrinsics.checkNotNullParameter((Object)constantValueGenerator, (String)"<set-?>");
        this.constantValueGenerator = constantValueGenerator;
    }

    public final void enterScope(@NotNull IrTypeParametersContainer irElement) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        this.typeParametersResolver.enterTypeParameterScope(irElement);
        if (this.enterTableScope) {
            this.symbolTable.enterScope(irElement);
        }
    }

    public final void leaveScope(@NotNull IrTypeParametersContainer irElement) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        this.typeParametersResolver.leaveTypeParameterScope();
        if (this.enterTableScope) {
            this.symbolTable.leaveScope(irElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withTypeErasure(@NotNull PropertyDescriptor propertyDescriptor, @NotNull Function0<? extends T> b) {
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"propertyDescriptor");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        try {
            this.erasureStack.push(propertyDescriptor);
            Object object = b.invoke();
            return (T)object;
        }
        finally {
            this.erasureStack.pop();
        }
    }

    public final <T> T buildWithScope(@NotNull IrTypeParametersContainer container2, @NotNull Function0<? extends T> builder) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        boolean $i$f$buildWithScope = false;
        this.enterScope(container2);
        Object result2 = builder.invoke();
        this.leaveScope(container2);
        return (T)result2;
    }

    private final IrTypeParameterSymbol resolveTypeParameter(TypeParameterDescriptor typeParameterDescriptor) {
        TypeParameterDescriptor originalTypeParameter = OriginalDescriptorsKt.getOriginalTypeParameter(typeParameterDescriptor);
        IrTypeParameterSymbol irTypeParameterSymbol = this.typeParametersResolver.resolveScopedTypeParameter(originalTypeParameter);
        return irTypeParameterSymbol == null ? this.symbolTable.referenceTypeParameter(originalTypeParameter) : irTypeParameterSymbol;
    }

    @NotNull
    public final IrType translateType(@NotNull KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        return this.translateType(kotlinType, Variance.INVARIANT).getType();
    }

    private final IrTypeProjection translateType(KotlinType kotlinType, Variance variance) {
        KotlinType approximatedType = this.approximate(kotlinType);
        if (KotlinTypeKt.isError(approximatedType)) {
            return new IrErrorTypeImpl(approximatedType, TypeTranslator.translateTypeAnnotations$default(this, approximatedType, null, 2, null), variance);
        }
        if (DynamicTypesKt.isDynamic(approximatedType)) {
            return new IrDynamicTypeImpl(approximatedType, TypeTranslator.translateTypeAnnotations$default(this, approximatedType, null, 2, null), variance);
        }
        SimpleType upperType = FlexibleTypesKt.upperIfFlexible(approximatedType);
        ClassifierDescriptor classifierDescriptor = upperType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"No descriptor for type ", (Object)upperType));
        }
        List<KotlinType> list2 = classifierDescriptor;
        ClassifierDescriptor upperTypeDescriptor = list2;
        list2 = this.erasureStack;
        boolean bl = false;
        if (!list2.isEmpty() && upperTypeDescriptor instanceof TypeParameterDescriptor && CollectionsKt.contains((Iterable)this.erasureStack, (Object)((TypeParameterDescriptor)upperTypeDescriptor).getContainingDeclaration())) {
            list2 = ((TypeParameterDescriptor)upperTypeDescriptor).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"upperTypeDescriptor.upperBounds");
            return this.approximateUpperBounds((Collection<? extends KotlinType>)list2, variance);
        }
        list2 = new IrSimpleTypeBuilder();
        bl = false;
        boolean bl2 = false;
        List<KotlinType> $this$translateType_u24lambda_u2d0 = list2;
        boolean bl3 = false;
        ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setKotlinType(approximatedType);
        ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setHasQuestionMark(upperType.isMarkedNullable());
        ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setVariance(variance);
        Annotated annotated = SpecialTypesKt.getAbbreviation(upperType);
        ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setAbbreviation(annotated == null ? null : this.toIrTypeAbbreviation((SimpleType)annotated));
        annotated = upperTypeDescriptor;
        if (annotated instanceof TypeParameterDescriptor) {
            ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setClassifier(this.resolveTypeParameter((TypeParameterDescriptor)upperTypeDescriptor));
            ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setAnnotations(this.translateTypeAnnotations(upperType, approximatedType));
        } else if (annotated instanceof ScriptDescriptor) {
            ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setClassifier(this.symbolTable.referenceScript((ScriptDescriptor)upperTypeDescriptor));
        } else if (annotated instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor2;
            SimpleType lowerType = FlexibleTypesKt.lowerIfFlexible(approximatedType);
            ClassifierDescriptor classifierDescriptor2 = lowerType.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor3 = classDescriptor2 = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
            if (classDescriptor2 == null) {
                throw new AssertionError((Object)("No class descriptor for lower type " + lowerType + " of " + approximatedType));
            }
            ClassDescriptor lowerTypeDescriptor = classDescriptor2;
            ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setClassifier(this.symbolTable.referenceClass(lowerTypeDescriptor));
            ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setArguments(approximatedType instanceof RawType ? this.translateTypeArguments(approximatedType.getArguments()) : (!Intrinsics.areEqual((Object)lowerTypeDescriptor, (Object)upperTypeDescriptor) ? this.translateTypeArguments(lowerType.getArguments()) : this.translateTypeArguments(upperType.getArguments())));
            ((IrSimpleTypeBuilder)((Object)$this$translateType_u24lambda_u2d0)).setAnnotations(this.translateTypeAnnotations(upperType, approximatedType));
        } else {
            throw new AssertionError((Object)("Unexpected type descriptor " + upperTypeDescriptor + " :: " + Reflection.getOrCreateKotlinClass(upperTypeDescriptor.getClass())));
        }
        return IrSimpleTypeImplKt.buildTypeProjection(list2);
    }

    private final IrTypeProjection approximateUpperBounds(Collection<? extends KotlinType> upperBounds, Variance variance) {
        KotlinType kotlinType = CommonSupertypes.commonSupertype(upperBounds);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"commonSupertype(upperBounds)");
        KotlinType commonSupertype = kotlinType;
        return this.translateType(this.approximate(TypeUtilsKt.replaceArgumentsWithStarProjections(commonSupertype)), variance);
    }

    private final IrTypeAbbreviation toIrTypeAbbreviation(SimpleType $this$toIrTypeAbbreviation) {
        TypeAliasDescriptor typeAliasDescriptor;
        ClassifierDescriptor classifierDescriptor = $this$toIrTypeAbbreviation.getConstructor().getDeclarationDescriptor();
        boolean bl = false;
        boolean bl2 = false;
        ClassifierDescriptor it = classifierDescriptor;
        boolean bl3 = false;
        TypeAliasDescriptor typeAliasDescriptor2 = typeAliasDescriptor = it instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)it : null;
        if (typeAliasDescriptor == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"TypeAliasDescriptor expected: ", (Object)it));
        }
        TypeAliasDescriptor typeAliasDescriptor3 = typeAliasDescriptor;
        return new IrTypeAbbreviationImpl(this.symbolTable.referenceTypeAlias(typeAliasDescriptor3), $this$toIrTypeAbbreviation.isMarkedNullable(), this.translateTypeArguments($this$toIrTypeAbbreviation.getArguments()), TypeTranslator.translateTypeAnnotations$default(this, $this$toIrTypeAbbreviation, null, 2, null));
    }

    @NotNull
    public final KotlinType approximate(@NotNull KotlinType ktType) {
        Intrinsics.checkNotNullParameter((Object)ktType, (String)"ktType");
        KotlinType properlyApproximatedType = this.approximateByKotlinRules(ktType);
        TypeConstructor typeConstructor2 = properlyApproximatedType.getConstructor();
        if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            KotlinType kotlinType = CommonSupertypes.commonSupertype(((IntersectionTypeConstructor)typeConstructor2).getSupertypes());
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"commonSupertype(typeConstructor.supertypes)");
            KotlinType commonSupertype = kotlinType;
            return this.approximate(TypeUtilsKt.replaceArgumentsWithStarProjections(commonSupertype));
        }
        return properlyApproximatedType;
    }

    private final KotlinType approximateByKotlinRules(KotlinType ktType) {
        return this.isWithNewInference ? (ktType.getConstructor().isDenotable() && ktType.getArguments().isEmpty() ? ktType : (KotlinType)this.typeApproximatorForNI.approximateDeclarationType(ktType, false, this.languageVersionSettings)) : (ktType.getConstructor().isDenotable() ? ktType : CapturedTypeApproximationKt.approximateCapturedTypes(ktType).getUpper());
    }

    private final List<IrConstructorCall> translateTypeAnnotations(KotlinType kotlinType, KotlinType flexibleType) {
        Annotations annotations2 = kotlinType.getAnnotations();
        ArrayList irAnnotations = new ArrayList();
        Iterable $this$mapNotNullTo$iv = annotations2;
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrConstructorCall irConstructorCall;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
            boolean bl2 = false;
            if (this.getConstantValueGenerator().generateAnnotationConstructorCall(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            IrConstructorCall it$iv = irConstructorCall;
            boolean bl5 = false;
            ((Collection)irAnnotations).add(it$iv);
        }
        if (this.extensions.getEnhancedNullability().hasEnhancedNullability(kotlinType)) {
            this.addSpecialAnnotation(irAnnotations, this.extensions.getEnhancedNullabilityAnnotationConstructor());
        }
        if (FlexibleTypesKt.isNullabilityFlexible(flexibleType)) {
            this.addSpecialAnnotation(irAnnotations, this.extensions.getFlexibleNullabilityAnnotationConstructor());
        }
        if (flexibleType instanceof RawType) {
            this.addSpecialAnnotation(irAnnotations, this.extensions.getRawTypeAnnotationConstructor());
        }
        return irAnnotations;
    }

    static /* synthetic */ List translateTypeAnnotations$default(TypeTranslator typeTranslator, KotlinType kotlinType, KotlinType kotlinType2, int n, Object object) {
        if ((n & 2) != 0) {
            kotlinType2 = kotlinType;
        }
        return typeTranslator.translateTypeAnnotations(kotlinType, kotlinType2);
    }

    private final void addSpecialAnnotation(List<IrConstructorCall> $this$addSpecialAnnotation, IrConstructor irConstructor2) {
        if (irConstructor2 != null) {
            $this$addSpecialAnnotation.add(IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, IrUtilsKt.getConstructedClassType(irConstructor2), irConstructor2.getSymbol(), null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrTypeArgument> translateTypeArguments(List<? extends TypeProjection> arguments2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = arguments2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument;
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it.isStarProjection()) {
                irTypeArgument = IrStarProjectionImpl.INSTANCE;
            } else {
                Object object = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.type");
                KotlinType kotlinType = object;
                object = it.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.projectionKind");
                irTypeArgument = this.translateType(kotlinType, (Variance)((Object)object));
            }
            IrTypeArgument irTypeArgument2 = irTypeArgument;
            collection.add(irTypeArgument2);
        }
        return (List)destination$iv$iv;
    }
}

