/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.interpreter.stack.Frame;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/InterpreterFrame;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "pool", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "typeArguments", "", "(Ljava/util/List;Ljava/util/List;)V", "returnStack", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "addAll", "", "variables", "addVar", "variable", "contains", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getAll", "getVariable", "hasReturnValue", "peekReturnValue", "popReturnValue", "pushReturnValue", "frame", "state", "ir.interpreter"})
public final class InterpreterFrame
implements Frame {
    @NotNull
    private final List<Variable> pool;
    @NotNull
    private final List<Variable> typeArguments;
    @NotNull
    private final List<State> returnStack;

    public InterpreterFrame(@NotNull List<Variable> pool, @NotNull List<Variable> typeArguments2) {
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        Intrinsics.checkNotNullParameter(typeArguments2, (String)"typeArguments");
        this.pool = pool;
        this.typeArguments = typeArguments2;
        boolean bl = false;
        this.returnStack = new ArrayList();
    }

    public /* synthetic */ InterpreterFrame(List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 1) != 0) {
            bl = false;
            list2 = new ArrayList();
        }
        if ((n & 2) != 0) {
            bl = false;
            list3 = CollectionsKt.emptyList();
        }
        this(list2, list3);
    }

    @Override
    public void addVar(@NotNull Variable variable2) {
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        this.pool.add(variable2);
    }

    @Override
    public void addAll(@NotNull List<Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.pool.addAll((Collection<Variable>)variables);
    }

    @Override
    @Nullable
    public Variable getVariable(@NotNull IrSymbol symbol2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            Iterable $this$firstOrNull$iv = symbol2 instanceof IrTypeParameterSymbol ? this.typeArguments : this.pool;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Variable it = (Variable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSymbol(), (Object)symbol2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public List<Variable> getAll() {
        return this.pool;
    }

    @Override
    public boolean contains(@NotNull IrSymbol symbol2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            Iterable $this$any$iv = CollectionsKt.plus((Collection)this.typeArguments, (Iterable)this.pool);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Variable it = (Variable)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getSymbol(), (Object)symbol2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void pushReturnValue(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        InterpreterFrame interpreterFrame = this;
        Collection collection = interpreterFrame.returnStack;
        boolean bl = false;
        collection.add(state);
    }

    @Override
    public void pushReturnValue(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (frame.hasReturnValue()) {
            this.pushReturnValue(frame.popReturnValue());
        }
    }

    @Override
    public boolean hasReturnValue() {
        Collection collection = this.returnStack;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Override
    @NotNull
    public State peekReturnValue() {
        Collection collection = this.returnStack;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return (State)CollectionsKt.last(this.returnStack);
        }
        throw new NoSuchElementException("Return values stack is empty");
    }

    @Override
    @NotNull
    public State popReturnValue() {
        Collection collection = this.returnStack;
        boolean bl = false;
        if (!collection.isEmpty()) {
            State item = (State)CollectionsKt.last(this.returnStack);
            this.returnStack.remove(this.returnStack.size() - 1);
            return item;
        }
        throw new NoSuchElementException("Return values stack is empty");
    }

    public InterpreterFrame() {
        this(null, null, 3, null);
    }
}

