/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.interpreter.BreakLoop;
import org.jetbrains.kotlin.ir.interpreter.BreakWhen;
import org.jetbrains.kotlin.ir.interpreter.Continue;
import org.jetbrains.kotlin.ir.interpreter.Exception;
import org.jetbrains.kotlin.ir.interpreter.ExecutionResult;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.LabelKt;
import org.jetbrains.kotlin.ir.interpreter.Next;
import org.jetbrains.kotlin.ir.interpreter.Return;
import org.jetbrains.kotlin.ir.interpreter.ReturnLabel;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.CompileTimeFunction;
import org.jetbrains.kotlin.ir.interpreter.builtins.CompileTimeUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.IrBuiltInsMapGeneratedKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterException;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterMethodNotFoundException;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterTimeOutException;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicEvaluator;
import org.jetbrains.kotlin.ir.interpreter.stack.Stack;
import org.jetbrains.kotlin.ir.interpreter.stack.StackImpl;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Lambda;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrTypeBaseKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u00fe\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010&\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00192\u0006\u0010&\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u00192\u0006\u0010&\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00192\u0006\u0010&\u001a\u000206H\u0002J\u0014\u00107\u001a\u00020\u00192\n\u0010&\u001a\u0006\u0012\u0002\b\u000308H\u0002J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010:\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u00192\u0006\u0010&\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\u00192\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020\u00192\u0006\u0010&\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020\u00192\u0006\u0010&\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020\u00192\u0006\u0010&\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020\u00192\u0006\u0010&\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020\u00192\u0006\u0010&\u001a\u00020ZH\u0002J\u0010\u0010[\u001a\u00020\u00192\u0006\u0010\\\u001a\u00020]H\u0002J\u0010\u0010^\u001a\u00020\u00192\u0006\u0010&\u001a\u00020_H\u0002J\u0010\u0010`\u001a\u00020\u00192\u0006\u0010&\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020\u00192\u0006\u0010&\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020\u00192\u0006\u0010e\u001a\u00020fH\u0002J\u0016\u0010g\u001a\u00020\u00192\f\u0010h\u001a\b\u0012\u0004\u0012\u00020j0iH\u0002J\u0010\u0010k\u001a\u00020\u00192\u0006\u0010&\u001a\u00020lH\u0002J\u0010\u0010m\u001a\u00020\u00192\u0006\u0010&\u001a\u00020nH\u0002J\u0010\u0010o\u001a\u00020\u00192\u0006\u0010p\u001a\u00020qH\u0002J\u0010\u0010r\u001a\u00020\u00192\u0006\u0010&\u001a\u00020sH\u0002J\u0010\u0010t\u001a\u00020\u00192\u0006\u0010&\u001a\u00020uH\u0002J&\u0010v\u001a\u00020\u00192\u0006\u0010&\u001a\u00020;2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010w\u001a\b\u0012\u0004\u0012\u00020x0\u000fH\u0002J\u0010\u0010y\u001a\u00020\u00192\u0006\u0010&\u001a\u00020zH\u0002J\u0010\u0010{\u001a\u00020\u00192\u0006\u0010&\u001a\u00020|H\u0002J\u0010\u0010}\u001a\u00020\u00192\u0006\u0010&\u001a\u00020~H\u0002J\u0011\u0010\u007f\u001a\u00020\u00192\u0007\u0010&\u001a\u00030\u0080\u0001H\u0002J\u0018\u0010\u0081\u0001\u001a\u00020\u001e*\u0004\u0018\u00010\u00012\u0007\u0010\u0082\u0001\u001a\u00020\u001eH\u0002J\r\u0010$\u001a\u00020\u0019*\u00030\u0083\u0001H\u0002J\u0018\u0010\u0084\u0001\u001a\u00020\u0019*\u0005\u0018\u00010\u0085\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000f\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u0019*\u00020\u001bH\u0002J\u000f\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0019*\u00020\u001bH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Ljava/util/Map;)V", "commandCount", "", "irExceptions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "mapOfEnums", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "mapOfObjects", "stack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/StackImpl;", "calculateBuiltIns", "Lorg/jetbrains/kotlin/ir/interpreter/ExecutionResult;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "calculateRangeTo", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getOrCreateObjectValue", "objectClass", "handleIntrinsicMethods", "incrementAndCheckCommands", "", "interpret", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "interpretBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "interpretBody", "body", "interpretBranch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "interpretBreak", "breakStatement", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "interpretCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "interpretCatch", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "interpretComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "interpretConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "interpretConstructor", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interpretConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "interpretContinue", "continueStatement", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "interpretDelegatedConstructorCall", "delegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "interpretDoWhile", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "interpretEnumConstructorCall", "enumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "interpretEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interpretFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "interpretFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "interpretFunctionReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "interpretGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "interpretGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interpretGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interpretGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "interpretInstanceInitializerCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "interpretReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "interpretSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "interpretSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "interpretSpreadElement", "spreadElement", "Lorg/jetbrains/kotlin/ir/expressions/IrSpreadElement;", "interpretStatements", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "interpretStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "interpretThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "interpretToString", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "interpretTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "interpretTypeOperatorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "interpretValueParameters", "pool", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "interpretVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "interpretVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "interpretWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "interpretWhile", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "getType", "defaultType", "Lorg/jetbrains/kotlin/ir/IrElement;", "invokeMethod", "Ljava/lang/invoke/MethodHandle;", "tryCalculateLazyConst", "trySubstituteFunctionBody", "ir.interpreter"})
public final class IrInterpreter {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;
    @NotNull
    private final List<IrClass> irExceptions;
    @NotNull
    private final StackImpl stack;
    private int commandCount;
    @NotNull
    private final Map<IrSymbol, Complex> mapOfEnums;
    @NotNull
    private final Map<IrSymbol, Complex> mapOfObjects;

    public IrInterpreter(@NotNull IrBuiltIns irBuiltIns, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter(bodyMap, (String)"bodyMap");
        this.irBuiltIns = irBuiltIns;
        this.bodyMap = bodyMap;
        boolean bl = false;
        this.irExceptions = new ArrayList();
        this.stack = new StackImpl();
        bl = false;
        this.mapOfEnums = new LinkedHashMap();
        bl = false;
        this.mapOfObjects = new LinkedHashMap();
    }

    public /* synthetic */ IrInterpreter(IrBuiltIns irBuiltIns, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irBuiltIns, map);
    }

    /*
     * WARNING - void declaration
     */
    public IrInterpreter(@NotNull IrModuleFragment irModule) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        IrElementBase it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        this(irModule.getIrBuiltins(), null, 2, null);
        Iterable iterable = irModule.getFiles();
        List<IrClass> list2 = this.irExceptions;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getDeclarations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        $this$flatMap$iv = list3;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list3 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = list3;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrClass)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.isSubclassOf((IrClass)it, (IrClass)this.irBuiltIns.getThrowableClass().getOwner())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list3 = (List)destination$iv$iv;
        list2.addAll(list3);
    }

    private final IrType getType(Object $this$getType, IrType defaultType) {
        IrType irType;
        Object object = $this$getType;
        if (object instanceof Boolean) {
            irType = this.irBuiltIns.getBooleanType();
        } else if (object instanceof Character) {
            irType = this.irBuiltIns.getCharType();
        } else if (object instanceof Byte) {
            irType = this.irBuiltIns.getByteType();
        } else if (object instanceof Short) {
            irType = this.irBuiltIns.getShortType();
        } else if (object instanceof Integer) {
            irType = this.irBuiltIns.getIntType();
        } else if (object instanceof Long) {
            irType = this.irBuiltIns.getLongType();
        } else if (object instanceof String) {
            irType = this.irBuiltIns.getStringType();
        } else if (object instanceof Float) {
            irType = this.irBuiltIns.getFloatType();
        } else if (object instanceof Double) {
            irType = this.irBuiltIns.getDoubleType();
        } else if (object == null) {
            irType = this.irBuiltIns.getNothingNType();
        } else {
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(defaultType);
            IrSymbolOwner irSymbolOwner = irClassifierSymbol == null ? null : irClassifierSymbol.getOwner();
            irType = irSymbolOwner instanceof IrTypeParameter ? (IrType)IrUtilsKt.getDefaultType(this.stack.getVariable(IrTypesKt.getClassifierOrFail(defaultType)).getState().getIrClass()) : defaultType;
        }
        return irType;
    }

    private final void incrementAndCheckCommands() {
        IrInterpreter irInterpreter = this;
        int n = irInterpreter.commandCount;
        irInterpreter.commandCount = n + 1;
        if (this.commandCount >= 500000) {
            throw new InterpreterTimeOutException();
        }
    }

    @NotNull
    public final IrExpression interpret(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.stack.clean();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<IrExpression>)result2, this, expression2){
            final /* synthetic */ Ref.ObjectRef<IrExpression> $result;
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrExpression $expression;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                this.$expression = $expression;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                IrExpression irExpression;
                Ref.ObjectRef<IrExpression> objectRef;
                Ref.ObjectRef<IrExpression> objectRef2 = this.$result;
                try {
                    IrExpression irExpression2;
                    objectRef = objectRef2;
                    ReturnLabel returnLabel = IrInterpreter.access$interpret(this.this$0, this.$expression).getReturnLabel();
                    int n = interpret.WhenMappings.$EnumSwitchMapping$0[returnLabel.ordinal()];
                    switch (n) {
                        case 1: {
                            irExpression2 = UtilsKt.toIrExpression(IrInterpreter.access$getStack$p(this.this$0).popReturnValue(), this.$expression);
                            break;
                        }
                        case 2: {
                            String message2 = ((ExceptionState)IrInterpreter.access$getStack$p(this.this$0).popReturnValue()).getFullDescription();
                            irExpression2 = new IrErrorExpressionImpl(this.$expression.getStartOffset(), this.$expression.getEndOffset(), this.$expression.getType(), Intrinsics.stringPlus((String)"\n", (Object)message2));
                            break;
                        }
                        default: {
                            String string2 = (Object)((Object)returnLabel) + " not supported as result of interpretation";
                            boolean bl = false;
                            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
                        }
                    }
                    irExpression = irExpression2;
                }
                catch (InterpreterException interpreterException) {
                    void e;
                    objectRef = objectRef2;
                    irExpression = new IrErrorExpressionImpl(this.$expression.getStartOffset(), this.$expression.getEndOffset(), this.$expression.getType(), Intrinsics.stringPlus((String)"\n", (Object)e.getMessage()));
                }
                objectRef.element = irExpression;
            }
        }), (int)30, null).join();
        if (result2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            throw null;
        }
        return (IrExpression)result2.element;
    }

    private final ExecutionResult interpret(IrElement $this$interpret) {
        try {
            ExecutionResult executionResult2;
            this.incrementAndCheckCommands();
            IrElement irElement = $this$interpret;
            if (irElement instanceof IrSimpleFunction) {
                executionResult2 = this.interpretFunction((IrSimpleFunction)$this$interpret);
            } else if (irElement instanceof IrCall) {
                executionResult2 = this.interpretCall((IrCall)$this$interpret);
            } else if (irElement instanceof IrConstructorCall) {
                executionResult2 = this.interpretConstructorCall((IrConstructorCall)$this$interpret);
            } else if (irElement instanceof IrEnumConstructorCall) {
                executionResult2 = this.interpretEnumConstructorCall((IrEnumConstructorCall)$this$interpret);
            } else if (irElement instanceof IrDelegatingConstructorCall) {
                executionResult2 = this.interpretDelegatedConstructorCall((IrDelegatingConstructorCall)$this$interpret);
            } else if (irElement instanceof IrInstanceInitializerCall) {
                executionResult2 = this.interpretInstanceInitializerCall((IrInstanceInitializerCall)$this$interpret);
            } else if (irElement instanceof IrBody) {
                executionResult2 = this.interpretBody((IrBody)$this$interpret);
            } else if (irElement instanceof IrBlock) {
                executionResult2 = this.interpretBlock((IrBlock)$this$interpret);
            } else if (irElement instanceof IrReturn) {
                executionResult2 = this.interpretReturn((IrReturn)$this$interpret);
            } else if (irElement instanceof IrSetField) {
                executionResult2 = this.interpretSetField((IrSetField)$this$interpret);
            } else if (irElement instanceof IrGetField) {
                executionResult2 = this.interpretGetField((IrGetField)$this$interpret);
            } else if (irElement instanceof IrGetValue) {
                executionResult2 = this.interpretGetValue((IrGetValue)$this$interpret);
            } else if (irElement instanceof IrGetObjectValue) {
                executionResult2 = this.interpretGetObjectValue((IrGetObjectValue)$this$interpret);
            } else if (irElement instanceof IrGetEnumValue) {
                executionResult2 = this.interpretGetEnumValue((IrGetEnumValue)$this$interpret);
            } else if (irElement instanceof IrEnumEntry) {
                executionResult2 = this.interpretEnumEntry((IrEnumEntry)$this$interpret);
            } else if (irElement instanceof IrConst) {
                executionResult2 = this.interpretConst((IrConst)$this$interpret);
            } else if (irElement instanceof IrVariable) {
                executionResult2 = this.interpretVariable((IrVariable)$this$interpret);
            } else if (irElement instanceof IrSetValue) {
                executionResult2 = this.interpretSetVariable((IrSetValue)$this$interpret);
            } else if (irElement instanceof IrTypeOperatorCall) {
                executionResult2 = this.interpretTypeOperatorCall((IrTypeOperatorCall)$this$interpret);
            } else if (irElement instanceof IrBranch) {
                executionResult2 = this.interpretBranch((IrBranch)$this$interpret);
            } else if (irElement instanceof IrWhileLoop) {
                executionResult2 = this.interpretWhile((IrWhileLoop)$this$interpret);
            } else if (irElement instanceof IrDoWhileLoop) {
                executionResult2 = this.interpretDoWhile((IrDoWhileLoop)$this$interpret);
            } else if (irElement instanceof IrWhen) {
                executionResult2 = this.interpretWhen((IrWhen)$this$interpret);
            } else if (irElement instanceof IrBreak) {
                executionResult2 = this.interpretBreak((IrBreak)$this$interpret);
            } else if (irElement instanceof IrContinue) {
                executionResult2 = this.interpretContinue((IrContinue)$this$interpret);
            } else if (irElement instanceof IrVararg) {
                executionResult2 = this.interpretVararg((IrVararg)$this$interpret);
            } else if (irElement instanceof IrSpreadElement) {
                executionResult2 = this.interpretSpreadElement((IrSpreadElement)$this$interpret);
            } else if (irElement instanceof IrTry) {
                executionResult2 = this.interpretTry((IrTry)$this$interpret);
            } else if (irElement instanceof IrCatch) {
                executionResult2 = this.interpretCatch((IrCatch)$this$interpret);
            } else if (irElement instanceof IrThrow) {
                executionResult2 = this.interpretThrow((IrThrow)$this$interpret);
            } else if (irElement instanceof IrStringConcatenation) {
                executionResult2 = this.interpretStringConcatenation((IrStringConcatenation)$this$interpret);
            } else if (irElement instanceof IrFunctionExpression) {
                executionResult2 = this.interpretFunctionExpression((IrFunctionExpression)$this$interpret);
            } else if (irElement instanceof IrFunctionReference) {
                executionResult2 = this.interpretFunctionReference((IrFunctionReference)$this$interpret);
            } else if (irElement instanceof IrComposite) {
                executionResult2 = this.interpretComposite((IrComposite)$this$interpret);
            } else {
                String string2 = $this$interpret.getClass() + " not supported";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }
            ExecutionResult executionResult3 = executionResult2;
            return executionResult3.getNextLabel($this$interpret, (Function1<? super IrElement, ? extends ExecutionResult>)((Function1)new Function1<IrElement, ExecutionResult>(this){
                final /* synthetic */ IrInterpreter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final ExecutionResult invoke(@NotNull IrElement $this$getNextLabel) {
                    Intrinsics.checkNotNullParameter((Object)$this$getNextLabel, (String)"$this$getNextLabel");
                    return IrInterpreter.access$interpret(this.this$0, $this$getNextLabel);
                }
            }));
        }
        catch (InterpreterException e) {
            throw e;
        }
        catch (Throwable e) {
            Object v1;
            block72: {
                String exceptionName = e.getClass().getSimpleName();
                Iterable $this$firstOrNull$iv = this.irExceptions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrClass it = (IrClass)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)exceptionName)) continue;
                    v1 = element$iv;
                    break block72;
                }
                v1 = null;
            }
            IrClass irClass2 = v1;
            IrClass irExceptionClass = irClass2 == null ? (IrClass)this.irBuiltIns.getThrowableClass().getOwner() : irClass2;
            this.stack.pushReturnValue(new ExceptionState(e, irExceptionClass, this.stack.getStackTrace()));
            return Exception.INSTANCE;
        }
    }

    private final ExecutionResult interpretFunction(IrSimpleFunction irFunction2) {
        if (IrUtilsKt.getFileOrNull(irFunction2) != null) {
            this.stack.setCurrentFrameName(irFunction2);
        }
        if (irFunction2.getBody() instanceof IrSyntheticBody) {
            return this.handleIntrinsicMethods(irFunction2);
        }
        IrBody irBody = irFunction2.getBody();
        if (irBody == null) {
            throw new InterpreterException("Ir function must be with body");
        }
        return this.interpret(irBody);
    }

    private final ExecutionResult invokeMethod(MethodHandle $this$invokeMethod, IrFunction irFunction2) {
        MethodHandle methodHandle = $this$invokeMethod;
        if (methodHandle == null) {
            return this.handleIntrinsicMethods(irFunction2);
        }
        Object result2 = $this$invokeMethod.invokeWithArguments(UtilsKt.getArgsForMethodInvocation(irFunction2, this.stack.getAll()));
        this.stack.pushReturnValue(UtilsKt.toState(result2, this.getType(result2, irFunction2.getReturnType())));
        return Next.INSTANCE;
    }

    private final ExecutionResult handleIntrinsicMethods(IrFunction irFunction2) {
        return new IntrinsicEvaluator().evaluate(irFunction2, this.stack, (Function1<? super IrElement, ? extends ExecutionResult>)((Function1)new Function1<IrElement, ExecutionResult>(this){
            final /* synthetic */ IrInterpreter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ExecutionResult invoke(@NotNull IrElement $this$evaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$evaluate, (String)"$this$evaluate");
                return IrInterpreter.access$interpret(this.this$0, $this$evaluate);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult calculateBuiltIns(IrFunction irFunction2) {
        Object object;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        Object object2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Object object3;
        Collection collection2;
        Iterable $this$mapTo$iv$iv4;
        IrSimpleFunction irSimpleFunction = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
        IrPropertySymbol property2 = irSimpleFunction == null ? null : irSimpleFunction.getCorrespondingPropertySymbol();
        String string2 = property2 == null ? irFunction2.getName().asString() : ((IrProperty)property2.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (val property = (irFunction as? IrSimpleFunction)?.correspondingPropertySymbol) {\n            null -> irFunction.name.asString()\n            else -> property.owner.name.asString()\n        }");
        String methodName = string2;
        Iterable $this$map$iv3 = this.stack.getAll();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            Iterator it;
            Variable variable2 = (Variable)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            object3 = ((Variable)((Object)it)).getState();
            collection2.add(object3);
        }
        List args = (List)destination$iv$iv;
        IrValueParameter $i$f$map22 = irFunction2.getDispatchReceiverParameter();
        IrType receiverType = $i$f$map22 == null ? null : $i$f$map22.getType();
        $this$mapTo$iv$iv4 = irFunction2.getValueParameters();
        collection2 = CollectionsKt.listOfNotNull((Object)receiverType);
        boolean $i$f$map = false;
        void $i$f$mapTo22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            object3 = destination$iv$iv2;
            boolean bl = false;
            object2 = it.getType();
            object3.add(object2);
        }
        object3 = (List)destination$iv$iv2;
        List argsType = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)object3));
        Iterable $this$map$iv4 = args;
        boolean $i$f$map32 = false;
        destination$iv$iv2 = $this$map$iv4;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Object object4;
            String string3;
            void it;
            State bl = (State)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl2 = false;
            void var16_37 = it;
            if (var16_37 instanceof Complex) {
                Object object5 = IrUtilsKt.getFqNameWhenAvailable(irFunction2);
                String string4 = string3 = object5 == null ? null : ((FqName)object5).asString();
                if (Intrinsics.areEqual((Object)string3, (Object)"kotlin.String.plus")) {
                    object5 = this.stack;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Object $this$calculateBuiltIns_u24lambda_u2d6_u24lambda_u2d5 = object5;
                    boolean bl5 = false;
                    this.interpretToString((State)it);
                    object4 = StateKt.asString(((StackImpl)object5).popReturnValue());
                } else {
                    object4 = ((Complex)it).getOriginal();
                }
            } else if (var16_37 instanceof Primitive) {
                object4 = ((Primitive)it).getValue();
            } else if (var16_37 instanceof Lambda) {
                object4 = it;
            } else {
                string3 = Intrinsics.stringPlus((String)"unsupported type of argument for builtins calculations: ", it.getClass());
                boolean bl6 = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string3);
            }
            object3 = object4;
            collection2.add(object3);
        }
        List argsValues = (List)destination$iv$iv3;
        Iterable $i$f$map32 = argsType;
        object2 = methodName;
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType bl2 = (IrType)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            String string5 = IrInterpreter.calculateBuiltIns$getOnlyName((IrType)it);
            collection.add(string5);
        }
        collection = (List)destination$iv$iv4;
        List list2 = collection;
        Object object6 = object2;
        CompileTimeFunction signature2 = new CompileTimeFunction((String)object6, list2);
        int n = argsType.size();
        switch (n) {
            case 1: {
                Object object7 = IrBuiltInsMapGeneratedKt.getUnaryFunctions().get(signature2);
                if (object7 == null) {
                    throw new InterpreterMethodNotFoundException("For given function " + signature2 + " there is no entry in unary map");
                }
                Function1<Object, Object> function2 = object7;
                object = function2.invoke(CollectionsKt.first((List)argsValues));
                break;
            }
            case 2: {
                Object object7 = IrBuiltInsMapGeneratedKt.getBinaryFunctions().get(signature2);
                if (object7 == null) {
                    throw new InterpreterMethodNotFoundException("For given function " + signature2 + " there is no entry in binary map");
                }
                Function1<Object, Object> function2 = object7;
                object7 = methodName;
                if (Intrinsics.areEqual(object7, (Object)"rangeTo")) {
                    return this.calculateRangeTo(irFunction2.getReturnType());
                }
                object = function2.invoke(argsValues.get(0), argsValues.get(1));
                break;
            }
            case 3: {
                Object object7 = IrBuiltInsMapGeneratedKt.getTernaryFunctions().get(signature2);
                if (object7 == null) {
                    throw new InterpreterMethodNotFoundException("For given function " + signature2 + " there is no entry in ternary map");
                }
                Function1<Object, Object> function2 = object7;
                object = function2.invoke(argsValues.get(0), argsValues.get(1), argsValues.get(2));
                break;
            }
            default: {
                throw new InterpreterException("Unsupported number of arguments");
            }
        }
        Object result2 = object;
        this.stack.pushReturnValue(UtilsKt.toState(result2, this.getType(result2, irFunction2.getReturnType())));
        return Next.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult calculateRangeTo(IrType type2) {
        Collection<Variable> collection;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Primitive it;
        Object object2;
        void $this$mapTo$iv$iv2;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        IrConstructor constructor2 = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors((IrClass)irClassSymbol.getOwner()));
        IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor2.getReturnType(), constructor2.getSymbol(), null, 4, null);
        Iterable $this$map$iv = this.stack.getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Variable variable2 = (Variable)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = (Primitive)((Variable)((Object)it)).getState();
            object2.add(object);
        }
        List primitiveValueParameters = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = primitiveValueParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void primitive;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (Primitive)item$iv;
            int index2 = n;
            boolean bl2 = false;
            constructorCall.putValueArgument(index2, UtilsKt.toIrConst$default(primitive.getValue(), primitive.getType(), 0, 0, 6, null));
        }
        Iterable $this$map$iv2 = constructor2.getValueParameters();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter index2 = (IrValueParameter)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object = it2.getSymbol();
            object2.add(object);
        }
        List constructorValueParameters = CollectionsKt.zip((Iterable)((List)destination$iv$iv2), (Iterable)primitiveValueParameters);
        $this$map$iv2 = constructorValueParameters;
        boolean bl = false;
        object2 = this.stack;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair it2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            Variable variable3 = new Variable((IrSymbol)it2.getFirst(), (State)it2.getSecond());
            collection.add(variable3);
        }
        collection = (List)destination$iv$iv2;
        return Stack.DefaultImpls.newFrame$default((Stack)object2, bl, (List)collection, (Function0)new Function0<ExecutionResult>(this, constructorCall){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrConstructorCallImpl $constructorCall;
            {
                this.this$0 = $receiver;
                this.$constructorCall = $constructorCall;
                super(0);
            }

            @NotNull
            public final ExecutionResult invoke() {
                return IrInterpreter.access$interpret(this.this$0, this.$constructorCall);
            }
        }, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult interpretValueParameters(IrFunctionAccessExpression expression2, IrFunction irFunction2, List<Variable> pool) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        int n;
        Object object;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        List list2;
        IrType irType;
        Boolean bl;
        Object object2 = expression2.getDispatchReceiver();
        Boolean bl2 = object2 == null ? null : (bl = (irType = ((IrExpression)object2).getType()) == null ? null : Boolean.valueOf(UtilsKt.isFunction(irType)));
        if (Intrinsics.areEqual(bl, (Object)true)) {
            list2 = CollectionsKt.listOfNotNull((Object)UtilsKt.getExtensionReceiver(irFunction2));
        } else {
            boolean bl3 = false;
            list2 = CollectionsKt.emptyList();
        }
        List receiverAsFirstArgument = list2;
        object2 = irFunction2.getValueParameters();
        Collection collection = receiverAsFirstArgument;
        boolean $i$f$map = false;
        void var8_12 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
            object = destination$iv$iv;
            n = 0;
            IrValueParameterSymbol irValueParameterSymbol = it.getSymbol();
            object.add(irValueParameterSymbol);
        }
        object = (List)destination$iv$iv;
        List valueParametersSymbols = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)expression2.getValueArgumentsCount());
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        item$iv$iv2 = $this$mapTo$iv$iv2.iterator();
        while (item$iv$iv2.hasNext()) {
            void it;
            int item$iv$iv3;
            n = item$iv$iv3 = ((IntIterator)item$iv$iv2).nextInt();
            collection = destination$iv$iv2;
            boolean bl4 = false;
            object = expression2.getValueArgument((int)it);
            collection.add(object);
        }
        List valueArguments = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getValueParameters();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter bl4 = (IrValueParameter)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl5 = false;
            IrExpressionBody irExpressionBody = it.getDefaultValue();
            object = irExpressionBody == null ? null : irExpressionBody.getExpression();
            collection.add(object);
        }
        List defaultValues = (List)destination$iv$iv3;
        return this.stack.newFrame(true, pool, (Function0<? extends ExecutionResult>)((Function0)new Function0<ExecutionResult>((List<? extends IrExpression>)valueArguments, (List<? extends IrExpression>)defaultValues, this, expression2, (List<? extends IrValueParameterSymbol>)valueParametersSymbols, irFunction2, pool){
            final /* synthetic */ List<IrExpression> $valueArguments;
            final /* synthetic */ List<IrExpression> $defaultValues;
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrFunctionAccessExpression $expression;
            final /* synthetic */ List<IrValueParameterSymbol> $valueParametersSymbols;
            final /* synthetic */ IrFunction $irFunction;
            final /* synthetic */ List<Variable> $pool;
            {
                this.$valueArguments = $valueArguments;
                this.$defaultValues = $defaultValues;
                this.this$0 = $receiver;
                this.$expression = $expression;
                this.$valueParametersSymbols = $valueParametersSymbols;
                this.$irFunction = $irFunction;
                this.$pool = $pool;
                super(0);
            }

            @NotNull
            public final ExecutionResult invoke() {
                int n = 0;
                int n2 = this.$valueArguments.size() + -1;
                if (n <= n2) {
                    do {
                        List<Variable> list2;
                        List<Variable> list3;
                        int i;
                        List<Variable> list4;
                        Object object;
                        Object object2 = object = (list4 = this.$valueArguments.get(i = n++)) == null ? this.$defaultValues.get(i) : list4;
                        if (object == null) {
                            list3 = null;
                        } else {
                            List<Variable> $this$check_u24default$iv = list4 = IrInterpreter.access$interpret(this.this$0, (IrElement)object);
                            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
                            boolean $i$f$check = false;
                            if (((ExecutionResult)((Object)$this$check_u24default$iv)).getReturnLabel() != toCheckLabel$iv) {
                                List<Variable> it = $this$check_u24default$iv;
                                boolean bl = false;
                                return it;
                            }
                            list3 = list2 = $this$check_u24default$iv;
                        }
                        if (list2 == null) {
                            StackImpl stackImpl = IrInterpreter.access$getStack$p(this.this$0);
                            boolean bl = false;
                            List list5 = CollectionsKt.emptyList();
                            object = UtilsKt.getVarargType(this.$expression, i);
                            Intrinsics.checkNotNull((Object)object);
                            stackImpl.pushReturnValue(UtilsKt.toPrimitiveStateArray(list5, (IrType)object));
                        }
                        StateKt.checkNullability(IrInterpreter.access$getStack$p(this.this$0).peekReturnValue(), ((IrValueParameter)this.$valueParametersSymbols.get(i).getOwner()).getType(), new Function0(this.$irFunction, this.$valueParametersSymbols, i){
                            final /* synthetic */ IrFunction $irFunction;
                            final /* synthetic */ List<IrValueParameterSymbol> $valueParametersSymbols;
                            final /* synthetic */ int $i;
                            {
                                this.$irFunction = $irFunction;
                                this.$valueParametersSymbols = $valueParametersSymbols;
                                this.$i = $i;
                                super(0);
                            }

                            @NotNull
                            public final Void invoke() {
                                String method = UtilsKt.getCapitalizedFileName(this.$irFunction) + '.' + IrUtilsKt.getFqNameWhenAvailable(this.$irFunction);
                                Name parameter = ((IrValueParameter)this.$valueParametersSymbols.get(this.$i).getOwner()).getName();
                                throw new IllegalArgumentException("Parameter specified as non-null is null: method " + method + ", parameter " + parameter);
                            }
                        });
                        list2 = new Variable(this.$valueParametersSymbols.get(i), IrInterpreter.access$getStack$p(this.this$0).popReturnValue());
                        object = this.this$0;
                        list4 = this.$pool;
                        boolean bl = false;
                        boolean bl2 = false;
                        List<Variable> $this$invoke_u24lambda_u2d1 = list2;
                        boolean bl3 = false;
                        IrInterpreter.access$getStack$p((IrInterpreter)object).addVar((Variable)((Object)$this$invoke_u24lambda_u2d1));
                        list4.add((Variable)((Object)$this$invoke_u24lambda_u2d1));
                    } while (n <= n2);
                }
                return Next.INSTANCE;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult interpretCall(IrCall expression2) {
        void $this$check_u24default$iv;
        ExecutionResult $this$forEach$iv;
        boolean isLocal;
        State receiver;
        boolean bl;
        boolean bl2;
        State state;
        State state2;
        boolean it4;
        State state3;
        State state4;
        boolean $i$f$check;
        Object toCheckLabel$iv;
        Object $this$check_u24default$iv2;
        Object object;
        boolean bl3 = false;
        List valueArguments = new ArrayList();
        IrExpression rawDispatchReceiver = expression2.getDispatchReceiver();
        IrExpression irExpression = rawDispatchReceiver;
        if (irExpression != null) {
            $this$check_u24default$iv2 = object = this.interpret((IrElement)irExpression);
            toCheckLabel$iv = ReturnLabel.REGULAR;
            $i$f$check = false;
            if (((ExecutionResult)$this$check_u24default$iv2).getReturnLabel() != toCheckLabel$iv) {
                Object it2 = $this$check_u24default$iv2;
                boolean bl4 = false;
                return it2;
            }
        }
        object = rawDispatchReceiver;
        if (object == null) {
            state4 = null;
        } else {
            toCheckLabel$iv = object;
            $i$f$check = false;
            boolean it2 = false;
            Object it3 = toCheckLabel$iv;
            boolean bl5 = false;
            $this$check_u24default$iv2 = this.stack.popReturnValue();
            state4 = $this$check_u24default$iv2 == null ? null : StateKt.checkNullability$default((State)$this$check_u24default$iv2, (toCheckLabel$iv = expression2.getDispatchReceiver()) == null ? null : ((IrExpression)toCheckLabel$iv).getType(), null, 2, null);
        }
        State dispatchReceiver = state4;
        IrExpression rawExtensionReceiver = expression2.getExtensionReceiver();
        $this$check_u24default$iv2 = rawExtensionReceiver;
        if ($this$check_u24default$iv2 != null) {
            Object $this$check_u24default$iv3 = toCheckLabel$iv = this.interpret((IrElement)$this$check_u24default$iv2);
            ReturnLabel toCheckLabel$iv2 = ReturnLabel.REGULAR;
            boolean $i$f$check2 = false;
            if (((ExecutionResult)$this$check_u24default$iv3).getReturnLabel() != toCheckLabel$iv2) {
                Object it4 = $this$check_u24default$iv3;
                boolean bl6 = false;
                return it4;
            }
        }
        toCheckLabel$iv = rawExtensionReceiver;
        if (toCheckLabel$iv == null) {
            state3 = null;
        } else {
            Object toCheckLabel$iv2 = toCheckLabel$iv;
            boolean $i$f$check2 = false;
            it4 = false;
            Object it5 = toCheckLabel$iv2;
            boolean bl7 = false;
            State $this$check_u24default$iv3 = this.stack.popReturnValue();
            state3 = $this$check_u24default$iv3 == null ? null : StateKt.checkNullability$default($this$check_u24default$iv3, (toCheckLabel$iv2 = expression2.getExtensionReceiver()) == null ? null : ((IrExpression)toCheckLabel$iv2).getType(), null, 2, null);
        }
        State extensionReceiver = state3;
        Object toCheckLabel$iv2 = dispatchReceiver;
        IrFunction $this$check_u24default$iv3 = toCheckLabel$iv2 == null ? null : toCheckLabel$iv2.getIrFunctionByIrCall(expression2);
        IrFunction irFunction2 = $this$check_u24default$iv3 == null ? expression2.getSymbol().getOwner() : $this$check_u24default$iv3;
        State functionReceiver = UtilsKt.getCorrectReceiverByFunction(dispatchReceiver, irFunction2);
        toCheckLabel$iv2 = UtilsKt.getDispatchReceiver(irFunction2);
        if (toCheckLabel$iv2 != null) {
            Object $i$f$check2 = toCheckLabel$iv2;
            it4 = false;
            boolean it5 = false;
            Object it6 = $i$f$check2;
            boolean bl8 = false;
            state2 = functionReceiver;
            if (state2 != null) {
                state = state2;
                bl2 = false;
                bl = false;
                receiver = state;
                boolean bl9 = false;
                valueArguments.add(new Variable((IrSymbol)it6, receiver));
            }
        }
        toCheckLabel$iv2 = UtilsKt.getExtensionReceiver(irFunction2);
        if (toCheckLabel$iv2 != null) {
            Object $i$f$check2 = toCheckLabel$iv2;
            it4 = false;
            boolean it5 = false;
            Object it7 = $i$f$check2;
            boolean bl10 = false;
            state2 = extensionReceiver;
            if (state2 != null) {
                state = state2;
                bl2 = false;
                bl = false;
                receiver = state;
                boolean bl11 = false;
                valueArguments.add(new Variable((IrSymbol)it7, receiver));
            }
        }
        ExecutionResult $this$check_u24default$iv4 = this.interpretValueParameters(expression2, irFunction2, valueArguments);
        Object toCheckLabel$iv3 = ReturnLabel.REGULAR;
        boolean $i$f$check3 = false;
        if ($this$check_u24default$iv4.getReturnLabel() != toCheckLabel$iv3) {
            ExecutionResult it8 = $this$check_u24default$iv4;
            boolean bl12 = false;
            return it8;
        }
        valueArguments.addAll((Collection)UtilsKt.getTypeArguments(irFunction2, expression2, (Function1<? super IrTypeParameterSymbol, ? extends State>)((Function1)new Function1<IrTypeParameterSymbol, State>(this){
            final /* synthetic */ IrInterpreter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final State invoke(@NotNull IrTypeParameterSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return IrInterpreter.access$getStack$p(this.this$0).getVariable(it).getState();
            }
        })));
        if (dispatchReceiver instanceof Complex) {
            valueArguments.addAll((Collection)((Complex)dispatchReceiver).getTypeArguments());
        }
        if (extensionReceiver instanceof Complex) {
            valueArguments.addAll((Collection)((Complex)extensionReceiver).getTypeArguments());
        }
        Object it8 = dispatchReceiver instanceof Complex ? (Complex)dispatchReceiver : null;
        Complex complex = $i$f$check3 = it8 == null ? null : ((Complex)it8).getOriginal();
        toCheckLabel$iv3 = $i$f$check3 == null ? null : ((it8 = $i$f$check3.getIrClass()) == null ? null : Boolean.valueOf(AdditionalIrUtilsKt.isLocal((IrDeclaration)it8)));
        boolean bl13 = isLocal = toCheckLabel$iv3 == null ? AdditionalIrUtilsKt.isLocal(irFunction2) : (Boolean)toCheckLabel$iv3;
        if (isLocal) {
            valueArguments.addAll((Collection)UtilsKt.extractNonLocalDeclarations(dispatchReceiver));
        }
        if (functionReceiver instanceof Complex && Intrinsics.areEqual((Object)((toCheckLabel$iv3 = IrUtilsKt.getParentClassOrNull(irFunction2)) == null ? null : Boolean.valueOf(((IrClass)toCheckLabel$iv3).isInner())), (Object)true)) {
            $this$forEach$iv = SequencesKt.generateSequence((Object)((Complex)functionReceiver).getOuterClass(), (Function1)interpretCall.7.INSTANCE);
            boolean $i$f$forEach = false;
            it8 = $this$forEach$iv.iterator();
            while (it8.hasNext()) {
                Object element$iv = it8.next();
                Variable it9 = (Variable)element$iv;
                boolean bl14 = false;
                valueArguments.add(it9);
            }
        }
        $this$forEach$iv = this.stack.newFrame(irFunction2.isInline() || AdditionalIrUtilsKt.isLocal(irFunction2), valueArguments, (Function0<? extends ExecutionResult>)((Function0)new Function0<ExecutionResult>(irFunction2, dispatchReceiver, this){
            final /* synthetic */ IrFunction $irFunction;
            final /* synthetic */ State $dispatchReceiver;
            final /* synthetic */ IrInterpreter this$0;
            {
                this.$irFunction = $irFunction;
                this.$dispatchReceiver = $dispatchReceiver;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ExecutionResult invoke() {
                ExecutionResult executionResult2;
                ExecutionResult executionResult3;
                boolean isInlineOnly = UtilsKt.hasAnnotation(this.$irFunction, new FqName("kotlin.internal.InlineOnly"));
                ExecutionResult executionResult4 = this.$dispatchReceiver instanceof Wrapper && !isInlineOnly ? IrInterpreter.access$invokeMethod(this.this$0, ((Wrapper)this.$dispatchReceiver).getMethod(this.$irFunction), this.$irFunction) : (UtilsKt.hasAnnotation(this.$irFunction, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation()) ? IrInterpreter.access$invokeMethod(this.this$0, Wrapper.Companion.getStaticMethod(this.$irFunction), this.$irFunction) : (this.$dispatchReceiver instanceof Primitive ? IrInterpreter.access$calculateBuiltIns(this.this$0, this.$irFunction) : (this.$irFunction.getBody() == null ? ((executionResult3 = IrInterpreter.access$trySubstituteFunctionBody(this.this$0, this.$irFunction)) == null ? ((executionResult2 = IrInterpreter.access$tryCalculateLazyConst(this.this$0, this.$irFunction)) == null ? IrInterpreter.access$calculateBuiltIns(this.this$0, this.$irFunction) : executionResult2) : executionResult3) : IrInterpreter.access$interpret(this.this$0, this.$irFunction))));
                return executionResult4;
            }
        }));
        ReturnLabel toCheckLabel$iv4 = ReturnLabel.REGULAR;
        boolean $i$f$check4 = false;
        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv4) {
            void it10 = $this$check_u24default$iv;
            boolean bl15 = false;
            return it10;
        }
        return LabelKt.implicitCastIfNeeded((ExecutionResult)$this$check_u24default$iv, expression2.getType(), irFunction2.getReturnType(), this.stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExecutionResult trySubstituteFunctionBody(IrFunction $this$trySubstituteFunctionBody) {
        ExecutionResult executionResult2;
        IdSignature idSignature = $this$trySubstituteFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return null;
        }
        IdSignature signature2 = idSignature;
        IrBody body2 = this.bodyMap.get(signature2);
        IrBody irBody = body2;
        if (irBody == null) {
            executionResult2 = null;
        } else {
            ExecutionResult executionResult3;
            IrBody irBody2 = irBody;
            boolean bl = false;
            boolean bl2 = false;
            IrBody it = irBody2;
            boolean bl3 = false;
            try {
                $this$trySubstituteFunctionBody.setBody(it);
                executionResult3 = this.interpret($this$trySubstituteFunctionBody);
            }
            finally {
                $this$trySubstituteFunctionBody.setBody(null);
            }
            executionResult2 = executionResult3;
        }
        return executionResult2;
    }

    private final ExecutionResult tryCalculateLazyConst(IrFunction $this$tryCalculateLazyConst) {
        IrProperty irProperty2;
        IrField irField;
        if (!($this$tryCalculateLazyConst instanceof IrSimpleFunction)) {
            return null;
        }
        Object object = ((IrSimpleFunction)$this$tryCalculateLazyConst).getCorrespondingPropertySymbol();
        IrField irField2 = object == null ? null : (irField = (irProperty2 = (IrProperty)object.getOwner()) == null ? null : irProperty2.getBackingField());
        return irField == null ? null : ((object = irField.getInitializer()) == null ? null : this.interpret((IrElement)object));
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult interpretInstanceInitializerCall(IrInstanceInitializerCall call2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object $this$check_u24default$iv;
        Object element$iv2;
        Object element$iv$iv;
        Iterator $this$filterIsInstanceTo$iv$iv2;
        IrClass irClass2 = (IrClass)call2.getClassSymbol().getOwner();
        Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator2 = $this$filterIsInstanceTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classProperties = (List)destination$iv$iv;
        Iterable $this$forEach$iv = classProperties;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            IrExpressionBody irExpressionBody;
            IrExpression irExpression;
            IrProperty property2 = (IrProperty)element$iv2;
            boolean bl = false;
            element$iv$iv = property2.getBackingField();
            IrExpression irExpression2 = element$iv$iv == null ? null : (irExpression = (irExpressionBody = ((IrField)element$iv$iv).getInitializer()) == null ? null : irExpressionBody.getExpression());
            if (irExpression != null) {
                $this$check_u24default$iv = element$iv$iv = this.interpret((IrElement)irExpression);
                ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
                boolean $i$f$check = false;
                if (((ExecutionResult)$this$check_u24default$iv).getReturnLabel() != toCheckLabel$iv) {
                    Object it = $this$check_u24default$iv;
                    boolean bl2 = false;
                    return it;
                }
            }
            element$iv$iv = irClass2.getThisReceiver();
            Intrinsics.checkNotNull((Object)element$iv$iv);
            IrValueParameterSymbol receiver = ((IrValueParameter)element$iv$iv).getSymbol();
            element$iv$iv = property2.getBackingField();
            if ((element$iv$iv == null ? null : ((IrField)element$iv$iv).getInitializer()) == null) continue;
            Iterator receiverState = this.stack.getVariable(receiver).getState();
            Variable propertyVar = new Variable(property2.getSymbol(), this.stack.popReturnValue());
            receiverState.setField(propertyVar);
        }
        Iterable $this$filterIsInstance$iv2 = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance2 = false;
        element$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            IrAnonymousInitializer it = (IrAnonymousInitializer)element$iv$iv2;
            boolean bl = false;
            if (!(!it.isStatic())) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List anonymousInitializer = (List)destination$iv$iv2;
        Iterable $this$forEach$iv2 = anonymousInitializer;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            IrAnonymousInitializer init2 = (IrAnonymousInitializer)element$iv3;
            boolean bl = false;
            $this$check_u24default$iv = this.interpret(init2.getBody());
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if (((ExecutionResult)$this$check_u24default$iv).getReturnLabel() == toCheckLabel$iv) continue;
            Object it = $this$check_u24default$iv;
            boolean bl3 = false;
            return it;
        }
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretConstructor(IrFunctionAccessExpression constructorCall) {
        IrValueParameter irValueParameter;
        Object $i$f$check22;
        List<Variable> typeArguments2;
        IrClass irClass2;
        List valueArguments;
        IrFunction owner;
        block9: {
            block8: {
                owner = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
                boolean bl = false;
                valueArguments = new ArrayList();
                ExecutionResult $this$check_u24default$iv = this.interpretValueParameters(constructorCall, owner, valueArguments);
                ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
                boolean $i$f$check22 = false;
                if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                    ExecutionResult it = $this$check_u24default$iv;
                    boolean bl2 = false;
                    return it;
                }
                irClass2 = (IrClass)owner.getParent();
                typeArguments2 = UtilsKt.getTypeArguments(irClass2, constructorCall, (Function1<? super IrTypeParameterSymbol, ? extends State>)((Function1)new Function1<IrTypeParameterSymbol, State>(this){
                    final /* synthetic */ IrInterpreter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final State invoke(@NotNull IrTypeParameterSymbol it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return IrInterpreter.access$getStack$p(this.this$0).getVariable(it).getState();
                    }
                }));
                if (UtilsKt.hasAnnotation(irClass2, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation())) break block8;
                $i$f$check22 = IrUtilsKt.getFqNameWhenAvailable(irClass2);
                Intrinsics.checkNotNull((Object)$i$f$check22);
                if (!((FqName)$i$f$check22).startsWith(Name.identifier("java"))) break block9;
            }
            ExecutionResult $i$f$check22 = Stack.DefaultImpls.newFrame$default(this.stack, false, valueArguments, (Function0)new Function0<ExecutionResult>(this, owner){
                final /* synthetic */ IrInterpreter this$0;
                final /* synthetic */ IrFunction $owner;
                {
                    this.this$0 = $receiver;
                    this.$owner = $owner;
                    super(0);
                }

                @NotNull
                public final ExecutionResult invoke() {
                    return IrInterpreter.access$invokeMethod(this.this$0, Wrapper.Companion.getConstructorMethod(this.$owner), this.$owner);
                }
            }, 1, null);
            boolean it = false;
            boolean bl2 = false;
            ExecutionResult $this$interpretConstructor_u24lambda_u2d33 = $i$f$check22;
            boolean bl = false;
            this.stack.peekReturnValue().addTypeArguments(typeArguments2);
            return $i$f$check22;
        }
        if (IrTypePredicatesKt.isArray(IrUtilsKt.getDefaultType(irClass2)) || UtilsKt.isPrimitiveArray(IrUtilsKt.getDefaultType(irClass2))) {
            $i$f$check22 = Stack.DefaultImpls.newFrame$default(this.stack, false, valueArguments, (Function0)new Function0<ExecutionResult>(this, owner){
                final /* synthetic */ IrInterpreter this$0;
                final /* synthetic */ IrFunction $owner;
                {
                    this.this$0 = $receiver;
                    this.$owner = $owner;
                    super(0);
                }

                @NotNull
                public final ExecutionResult invoke() {
                    return IrInterpreter.access$handleIntrinsicMethods(this.this$0, this.$owner);
                }
            }, 1, null);
            boolean it = false;
            boolean bl2 = false;
            Object $this$interpretConstructor_u24lambda_u2d34 = $i$f$check22;
            boolean bl = false;
            this.stack.peekReturnValue().addTypeArguments(typeArguments2);
            return $i$f$check22;
        }
        Object it = new Common(irClass2);
        boolean bl2 = false;
        boolean $this$interpretConstructor_u24lambda_u2d34 = false;
        Common $this$interpretConstructor_u24lambda_u2d35 = it;
        boolean bl = false;
        $this$interpretConstructor_u24lambda_u2d35.addTypeArguments(typeArguments2);
        Common state = it;
        if (AdditionalIrUtilsKt.isLocal(irClass2)) {
            state.getFields().addAll((Collection<Variable>)this.stack.getAll());
        }
        if (irClass2.isInner()) {
            it = constructorCall.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)it);
            ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)it);
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult it2 = $this$check_u24default$iv;
                boolean bl3 = false;
                return it2;
            }
            irValueParameter = IrUtilsKt.getParentAsClass(irClass2).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            state.setOuterClass(new Variable(irValueParameter.getSymbol(), this.stack.popReturnValue()));
        }
        irValueParameter = irClass2.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        valueArguments.add(new Variable(irValueParameter.getSymbol(), state));
        return Stack.DefaultImpls.newFrame$default(this.stack, false, CollectionsKt.plus((Collection)valueArguments, (Iterable)state.getTypeArguments()), (Function0)new Function0<ExecutionResult>(constructorCall, this, state){
            final /* synthetic */ IrFunctionAccessExpression $constructorCall;
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ Common $state;
            {
                this.$constructorCall = $constructorCall;
                this.this$0 = $receiver;
                this.$state = $state;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ExecutionResult invoke() {
                void $this$invoke_u24lambda_u2d2;
                Object $this$check_u24default$iv;
                IrElementBase irElementBase = UtilsKt.getBody(this.$constructorCall);
                Intrinsics.checkNotNull((Object)irElementBase);
                List<IrStatement> statements2 = IrUtilsKt.getStatements(irElementBase);
                IrStatement irStatement = statements2.get(0);
                IrTypeOperatorCall irTypeOperatorCall = irStatement instanceof IrTypeOperatorCall ? (IrTypeOperatorCall)irStatement : null;
                irElementBase = irTypeOperatorCall == null ? null : irTypeOperatorCall.getArgument();
                ExecutionResult $this$check_u24default$iv2 = IrInterpreter.access$interpret(this.this$0, irElementBase == null ? statements2.get(0) : (IrStatement)((Object)irElementBase));
                ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
                boolean $i$f$check = false;
                if ($this$check_u24default$iv2.getReturnLabel() != toCheckLabel$iv) {
                    ExecutionResult it = $this$check_u24default$iv2;
                    boolean bl = false;
                    return it;
                }
                Complex returnedState = (Complex)IrInterpreter.access$getStack$p(this.this$0).popReturnValue();
                int n = 1;
                int n2 = statements2.size();
                if (n < n2) {
                    do {
                        int i = n++;
                        $this$check_u24default$iv = IrInterpreter.access$interpret(this.this$0, statements2.get(i));
                        ReturnLabel toCheckLabel$iv2 = ReturnLabel.REGULAR;
                        boolean $i$f$check2 = false;
                        if (((ExecutionResult)$this$check_u24default$iv).getReturnLabel() == toCheckLabel$iv2) continue;
                        Object it = $this$check_u24default$iv;
                        boolean bl = false;
                        return it;
                    } while (n < n2);
                }
                Common common = this.$state;
                n2 = 0;
                boolean bl = false;
                $this$check_u24default$iv = common;
                StackImpl stackImpl = IrInterpreter.access$getStack$p(this.this$0);
                boolean bl2 = false;
                $this$invoke_u24lambda_u2d2.setSuperClassInstance(returnedState);
                Unit unit = Unit.INSTANCE;
                stackImpl.pushReturnValue(common);
                return Next.INSTANCE;
            }
        }, 1, null);
    }

    private final ExecutionResult interpretConstructorCall(IrConstructorCall constructorCall) {
        return this.interpretConstructor(constructorCall);
    }

    private final ExecutionResult interpretEnumConstructorCall(IrEnumConstructorCall enumConstructorCall) {
        return this.interpretConstructor(enumConstructorCall);
    }

    private final ExecutionResult interpretDelegatedConstructorCall(IrDelegatingConstructorCall delegatingConstructorCall) {
        if (Intrinsics.areEqual((Object)((IrConstructor)delegatingConstructorCall.getSymbol().getOwner()).getParent(), (Object)this.irBuiltIns.getAnyClass().getOwner())) {
            Common anyAsStateObject = new Common((IrClass)this.irBuiltIns.getAnyClass().getOwner());
            this.stack.pushReturnValue(anyAsStateObject);
            return Next.INSTANCE;
        }
        return this.interpretConstructor(delegatingConstructorCall);
    }

    private final ExecutionResult interpretConst(IrConst<?> expression2) {
        ExecutionResult executionResult2;
        IrType signedType = IrInterpreter.interpretConst$getSignedType(this, expression2.getType());
        if (signedType != null) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClassSymbol unsignedClass = irClassSymbol;
            IrConstructor constructor2 = (IrConstructor)((IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(unsignedClass))).getOwner();
            IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor2.getReturnType(), constructor2.getSymbol(), null, 4, null);
            constructorCall.putValueArgument(0, UtilsKt.toIrConst$default(expression2.getValue(), signedType, 0, 0, 6, null));
            executionResult2 = this.interpret((IrElement)constructorCall);
        } else {
            this.stack.pushReturnValue(UtilsKt.toPrimitive(expression2));
            executionResult2 = Next.INSTANCE;
        }
        return executionResult2;
    }

    private final ExecutionResult interpretStatements(List<? extends IrStatement> statements2) {
        ExecutionResult executionResult2 = Next.INSTANCE;
        for (IrStatement irStatement : statements2) {
            String string2;
            IrStatement irStatement2 = irStatement;
            if (irStatement2 instanceof IrClass) {
                if (AdditionalIrUtilsKt.isLocal((IrDeclaration)irStatement)) {
                    continue;
                }
                string2 = "Only local classes are supported";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }
            if (irStatement2 instanceof IrFunction) {
                if (AdditionalIrUtilsKt.isLocal((IrDeclaration)irStatement)) {
                    continue;
                }
                string2 = "Only local functions are supported";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }
            ExecutionResult $this$check_u24default$iv = this.interpret(irStatement);
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult it = $this$check_u24default$iv;
                boolean bl = false;
                return it;
            }
            executionResult2 = $this$check_u24default$iv;
        }
        return executionResult2;
    }

    private final ExecutionResult interpretBlock(IrBlock block) {
        return Stack.DefaultImpls.newFrame$default(this.stack, true, null, (Function0)new Function0<ExecutionResult>(this, block){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrBlock $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            @NotNull
            public final ExecutionResult invoke() {
                return IrInterpreter.access$interpretStatements(this.this$0, this.$block.getStatements());
            }
        }, 2, null);
    }

    private final ExecutionResult interpretBody(IrBody body2) {
        return Stack.DefaultImpls.newFrame$default(this.stack, true, null, (Function0)new Function0<ExecutionResult>(this, body2){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrBody $body;
            {
                this.this$0 = $receiver;
                this.$body = $body;
                super(0);
            }

            @NotNull
            public final ExecutionResult invoke() {
                return IrInterpreter.access$interpretStatements(this.this$0, IrUtilsKt.getStatements(this.$body));
            }
        }, 2, null);
    }

    private final ExecutionResult interpretReturn(IrReturn expression2) {
        ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)expression2.getValue());
        ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
        boolean $i$f$check = false;
        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        }
        return Return.INSTANCE.addOwnerInfo(expression2.getReturnTargetSymbol().getOwner());
    }

    private final ExecutionResult interpretWhile(IrWhileLoop expression2) {
        block2: {
            ExecutionResult $this$check_u24default$iv;
            while (true) {
                ExecutionResult executionResult2;
                ExecutionResult $this$check_u24default$iv2 = this.interpret((IrElement)expression2.getCondition());
                ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
                boolean $i$f$check = false;
                if ($this$check_u24default$iv2.getReturnLabel() != toCheckLabel$iv) {
                    ExecutionResult it = $this$check_u24default$iv2;
                    boolean bl = false;
                    return it;
                }
                if (!Intrinsics.areEqual((Object)StateKt.asBooleanOrNull(this.stack.popReturnValue()), (Object)true)) break block2;
                IrExpression irExpression = expression2.getBody();
                if (irExpression == null) continue;
                $this$check_u24default$iv = executionResult2 = this.interpret((IrElement)irExpression);
                ReturnLabel toCheckLabel$iv2 = ReturnLabel.REGULAR;
                boolean $i$f$check2 = false;
                if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv2) break;
            }
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        }
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretDoWhile(IrDoWhileLoop expression2) {
        do {
            ExecutionResult $this$check_u24default$iv = Stack.DefaultImpls.newFrame$default(this.stack, true, null, (Function0)new Function0<ExecutionResult>(expression2, this){
                final /* synthetic */ IrDoWhileLoop $expression;
                final /* synthetic */ IrInterpreter this$0;
                {
                    this.$expression = $expression;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final ExecutionResult invoke() {
                    IrExpression irExpression = this.$expression.getBody();
                    if (irExpression != null) {
                        ExecutionResult executionResult2;
                        ExecutionResult $this$check_u24default$iv = executionResult2 = IrInterpreter.access$interpret(this.this$0, irExpression);
                        ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
                        boolean $i$f$check = false;
                        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                            ExecutionResult it = $this$check_u24default$iv;
                            boolean bl = false;
                            return it;
                        }
                    }
                    ExecutionResult $this$check_u24default$iv = IrInterpreter.access$interpret(this.this$0, this.$expression.getCondition());
                    ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
                    boolean $i$f$check = false;
                    if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                        ExecutionResult it = $this$check_u24default$iv;
                        boolean bl = false;
                        return it;
                    }
                    return Next.INSTANCE;
                }
            }, 2, null);
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() == toCheckLabel$iv) continue;
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        } while (Intrinsics.areEqual((Object)StateKt.asBooleanOrNull(this.stack.popReturnValue()), (Object)true));
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretWhen(IrWhen expression2) {
        ExecutionResult executionResult2 = Next.INSTANCE;
        for (IrBranch branch : expression2.getBranches()) {
            ExecutionResult $this$check_u24default$iv = this.interpret(branch);
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult it = $this$check_u24default$iv;
                boolean bl = false;
                return it;
            }
            executionResult2 = $this$check_u24default$iv;
        }
        return executionResult2;
    }

    private final ExecutionResult interpretBranch(IrBranch expression2) {
        ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)expression2.getCondition());
        ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
        boolean $i$f$check = false;
        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        }
        ExecutionResult executionResult2 = $this$check_u24default$iv;
        if (Intrinsics.areEqual((Object)StateKt.asBooleanOrNull(this.stack.popReturnValue()), (Object)true)) {
            $this$check_u24default$iv = this.interpret((IrElement)expression2.getResult());
            toCheckLabel$iv = ReturnLabel.REGULAR;
            $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult it = $this$check_u24default$iv;
                boolean bl = false;
                return it;
            }
            return BreakWhen.INSTANCE;
        }
        return executionResult2;
    }

    private final ExecutionResult interpretBreak(IrBreak breakStatement) {
        return BreakLoop.INSTANCE.addOwnerInfo(breakStatement.getLoop());
    }

    private final ExecutionResult interpretContinue(IrContinue continueStatement) {
        return Continue.INSTANCE.addOwnerInfo(continueStatement.getLoop());
    }

    private final ExecutionResult interpretSetField(IrSetField expression2) {
        ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)expression2.getValue());
        Object toCheckLabel$iv = ReturnLabel.REGULAR;
        boolean $i$f$check = false;
        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        }
        toCheckLabel$iv = expression2.getReceiver();
        if (toCheckLabel$iv == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDeclarationReference");
        }
        IrSymbol receiver = ((IrDeclarationReference)toCheckLabel$iv).getSymbol();
        Object object = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)object);
        IrPropertySymbol propertySymbol = object;
        object = this.stack.getVariable(receiver);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$interpretSetField_u24lambda_u2d46 = object;
        boolean bl3 = false;
        ((Variable)$this$interpretSetField_u24lambda_u2d46).getState().setField(new Variable(propertySymbol, this.stack.popReturnValue()));
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretGetField(IrGetField expression2) {
        Object object;
        Object object2;
        IrElementBase irElementBase;
        Object initializerExpression;
        IrExpression irExpression = expression2.getReceiver();
        IrDeclarationReference irDeclarationReference = irExpression instanceof IrDeclarationReference ? (IrDeclarationReference)irExpression : null;
        IrSymbol receiver = irDeclarationReference == null ? null : irDeclarationReference.getSymbol();
        IrField field = (IrField)expression2.getSymbol().getOwner();
        if (Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && field.isStatic()) {
            Object object3 = field.getInitializer();
            Object object4 = initializerExpression = object3 == null ? null : ((IrExpressionBody)object3).getExpression();
            if (initializerExpression instanceof IrConst) {
                return this.interpretConst((IrConst)initializerExpression);
            }
            object3 = Wrapper.Companion.getStaticGetter(field);
            Intrinsics.checkNotNull((Object)object3);
            this.stack.pushReturnValue(UtilsKt.toState(((MethodHandle)object3).invokeWithArguments(new Object[0]), field.getType()));
            return Next.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE) && Intrinsics.areEqual((initializerExpression = field.getCorrespondingPropertySymbol()) == null ? null : ((irElementBase = (IrProperty)initializerExpression.getOwner()) == null ? null : Boolean.valueOf(((IrProperty)irElementBase).isConst())), (Object)true)) {
            irElementBase = field.getInitializer();
            initializerExpression = irElementBase == null ? null : ((IrExpressionBody)irElementBase).getExpression();
            return initializerExpression == null ? (ExecutionResult)Next.INSTANCE : this.interpret((IrElement)initializerExpression);
        }
        Object object5 = receiver;
        if (object5 == null) {
            object2 = null;
        } else {
            object = object5;
            boolean bl = false;
            boolean bl2 = false;
            IrSymbol it = object;
            boolean bl3 = false;
            State state = this.stack.getVariable(receiver).getState();
            IrPropertySymbol irPropertySymbol = field.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull((Object)irPropertySymbol);
            object2 = state.getState(irPropertySymbol);
        }
        irElementBase = object2;
        if (irElementBase == null) {
            object = ((IrField)expression2.getSymbol().getOwner()).getInitializer();
            object5 = object == null ? null : ((IrExpressionBody)object).getExpression();
            return object5 == null ? (ExecutionResult)Next.INSTANCE : this.interpret((IrElement)object5);
        }
        IrProperty result2 = irElementBase;
        this.stack.pushReturnValue((State)((Object)result2));
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretGetValue(IrGetValue expression2) {
        IrClass owner;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        IrClass irClass2 = owner = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
        if (owner != null && IrUtilsKt.isObject(owner)) {
            return this.getOrCreateObjectValue(owner);
        }
        this.stack.pushReturnValue(this.stack.getVariable(expression2.getSymbol()).getState());
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretVariable(IrVariable expression2) {
        ExecutionResult executionResult2;
        ExecutionResult executionResult3;
        IrExpression irExpression = expression2.getInitializer();
        if (irExpression == null) {
            executionResult3 = null;
        } else {
            ExecutionResult executionResult4;
            ExecutionResult $this$check_u24default$iv = executionResult4 = this.interpret((IrElement)irExpression);
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult it = $this$check_u24default$iv;
                boolean bl = false;
                return it;
            }
            executionResult3 = executionResult2 = $this$check_u24default$iv;
        }
        if (executionResult2 == null) {
            return Next.INSTANCE;
        }
        this.stack.addVar(new Variable(expression2.getSymbol(), this.stack.popReturnValue()));
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretSetVariable(IrSetValue expression2) {
        ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)expression2.getValue());
        ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
        boolean $i$f$check = false;
        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        }
        if (this.stack.contains(expression2.getSymbol())) {
            Variable variable2 = this.stack.getVariable(expression2.getSymbol());
            boolean bl = false;
            boolean bl2 = false;
            Variable $this$interpretSetVariable_u24lambda_u2d50 = variable2;
            boolean bl3 = false;
            $this$interpretSetVariable_u24lambda_u2d50.setState(this.stack.popReturnValue());
        } else {
            this.stack.addVar(new Variable(expression2.getSymbol(), this.stack.popReturnValue()));
        }
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretGetObjectValue(IrGetObjectValue expression2) {
        return this.getOrCreateObjectValue((IrClass)expression2.getSymbol().getOwner());
    }

    private final ExecutionResult getOrCreateObjectValue(IrClass objectClass) {
        boolean bl;
        Object object;
        Complex complex;
        Complex complex2 = this.mapOfObjects.get(objectClass.getSymbol());
        if (complex2 != null) {
            Complex complex3 = complex2;
            boolean bl2 = false;
            boolean bl3 = false;
            Complex it = complex3;
            boolean bl4 = false;
            Next next = Next.INSTANCE;
            boolean bl5 = false;
            boolean bl6 = false;
            Next $this$getOrCreateObjectValue_u24lambda_u2d52_u24lambda_u2d51 = next;
            boolean bl7 = false;
            this.stack.pushReturnValue(it);
            return next;
        }
        if (UtilsKt.hasAnnotation(objectClass, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation())) {
            complex = Wrapper.Companion.getCompanionObject(objectClass);
        } else {
            object = new Common(objectClass);
            boolean bl8 = false;
            bl = false;
            Object $this$getOrCreateObjectValue_u24lambda_u2d53 = object;
            boolean bl9 = false;
            ((Common)$this$getOrCreateObjectValue_u24lambda_u2d53).setSuperClassRecursive();
            complex = (Complex)object;
        }
        Complex objectState = complex;
        object = this.mapOfObjects;
        IrClassSymbol irClassSymbol = objectClass.getSymbol();
        bl = false;
        object.put(irClassSymbol, objectState);
        this.stack.pushReturnValue(objectState);
        return Next.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult interpretGetEnumValue(IrGetEnumValue expression2) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Complex complex = this.mapOfEnums.get(expression2.getSymbol());
        if (complex != null) {
            Complex complex2 = complex;
            boolean bl = false;
            boolean bl2 = false;
            Complex it = complex2;
            boolean bl3 = false;
            Next next = Next.INSTANCE;
            boolean bl4 = false;
            boolean bl5 = false;
            Next $this$interpretGetEnumValue_u24lambda_u2d55_u24lambda_u2d54 = next;
            boolean bl6 = false;
            this.stack.pushReturnValue(it);
            return next;
        }
        IrEnumEntry enumEntry = (IrEnumEntry)expression2.getSymbol().getOwner();
        IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)enumEntry.getSymbol().getOwner());
        Iterable $this$single$iv = enumClass2.getDeclarations();
        boolean $i$f$single = false;
        Iterable single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), (Object)"valueOf")) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        IrFunction valueOfFun = (IrFunction)((Object)single$iv);
        Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        single$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutionResult executionResult2;
            ExecutionResult executionResult3;
            IrEnumEntry it = (IrEnumEntry)element$iv;
            boolean bl = false;
            if (UtilsKt.hasAnnotation(enumClass2, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation())) {
                State enumEntryName = UtilsKt.toState(it.getName().asString(), this.irBuiltIns.getStringType());
                Variable enumNameAsVariable = new Variable(((IrValueParameter)CollectionsKt.first(valueOfFun.getValueParameters())).getSymbol(), enumEntryName);
                executionResult3 = Stack.DefaultImpls.newFrame$default(this.stack, false, CollectionsKt.listOf((Object)enumNameAsVariable), (Function0)new Function0<ExecutionResult>(this, enumClass2, valueOfFun){
                    final /* synthetic */ IrInterpreter this$0;
                    final /* synthetic */ IrClass $enumClass;
                    final /* synthetic */ IrFunction $valueOfFun;
                    {
                        this.this$0 = $receiver;
                        this.$enumClass = $enumClass;
                        this.$valueOfFun = $valueOfFun;
                        super(0);
                    }

                    @NotNull
                    public final ExecutionResult invoke() {
                        MethodHandle methodHandle = Wrapper.Companion.getEnumEntry(this.$enumClass);
                        Intrinsics.checkNotNull((Object)methodHandle);
                        return IrInterpreter.access$invokeMethod(this.this$0, methodHandle, this.$valueOfFun);
                    }
                }, 1, null);
            } else {
                executionResult3 = this.interpretEnumEntry(it);
            }
            ExecutionResult $this$check_u24default$iv = executionResult2 = executionResult3;
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult result2 = $this$check_u24default$iv;
                boolean bl7 = false;
                return result2;
            }
            Map<IrSymbol, Complex> map = this.mapOfEnums;
            IrEnumEntrySymbol irEnumEntrySymbol = it.getSymbol();
            Complex complex3 = (Complex)this.stack.popReturnValue();
            boolean bl8 = false;
            map.put(irEnumEntrySymbol, complex3);
        }
        Complex complex4 = this.mapOfEnums.get(expression2.getSymbol());
        Intrinsics.checkNotNull((Object)complex4);
        this.stack.pushReturnValue(complex4);
        return Next.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult interpretEnumEntry(IrEnumEntry enumEntry) {
        ExecutionResult executionResult2;
        IrElementBase irElementBase;
        IrBody $this$filterIsInstanceTo$iv$iv222;
        IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)enumEntry.getSymbol().getOwner());
        Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
        boolean $i$f$filterIsInstance22 = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator2 = $this$filterIsInstanceTo$iv$iv222.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enumEntries = (List)destination$iv$iv;
        destination$iv$iv = IrUtilsKt.getPrimaryConstructor(enumClass2);
        IrBody irBody = $this$filterIsInstanceTo$iv$iv222 = destination$iv$iv == null ? null : ((IrFunction)destination$iv$iv).getBody();
        Object $i$f$filterIsInstance22 = $this$filterIsInstanceTo$iv$iv222 == null ? null : ((destination$iv$iv = IrUtilsKt.getStatements($this$filterIsInstanceTo$iv$iv222)) == null ? null : (IrStatement)CollectionsKt.firstOrNull(destination$iv$iv));
        IrEnumConstructorCall enumSuperCall = $i$f$filterIsInstance22 instanceof IrEnumConstructorCall ? (IrEnumConstructorCall)$i$f$filterIsInstance22 : null;
        $i$f$filterIsInstance22 = enumEntries;
        boolean $this$filterIsInstanceTo$iv$iv222 = false;
        if (!$i$f$filterIsInstance22.isEmpty() && enumSuperCall != null) {
            Object[] $this$filterIsInstanceTo$iv$iv222 = new IrConst[]{UtilsKt.toIrConst$default(enumEntry.getName().asString(), this.irBuiltIns.getStringType(), 0, 0, 6, null), UtilsKt.toIrConst$default(enumEntries.indexOf(enumEntry), this.irBuiltIns.getIntType(), 0, 0, 6, null)};
            List valueArguments = CollectionsKt.listOf((Object[])$this$filterIsInstanceTo$iv$iv222);
            Iterable $this$forEachIndexed$iv = valueArguments;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void irConst;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrConst irConst2 = (IrConst)item$iv;
                int index2 = n;
                boolean bl2 = false;
                enumSuperCall.putValueArgument(index2, (IrExpression)irConst);
            }
        }
        if ((irElementBase = enumEntry.getInitializerExpression()) == null) {
            executionResult2 = null;
        } else {
            ExecutionResult executionResult3;
            ExecutionResult $this$check_u24default$iv = executionResult3 = this.interpret(irElementBase);
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult it = $this$check_u24default$iv;
                boolean bl = false;
                return it;
            }
            executionResult2 = $this$check_u24default$iv;
        }
        ExecutionResult executionResult4 = executionResult2;
        irElementBase = enumSuperCall;
        if (irElementBase != null) {
            IrElementBase irElementBase2 = irElementBase;
            boolean bl = false;
            boolean bl3 = false;
            IrElementBase $this$interpretEnumEntry_u24lambda_u2d62 = irElementBase2;
            boolean bl4 = false;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)((IrFunctionAccessExpression)$this$interpretEnumEntry_u24lambda_u2d62).getValueArgumentsCount());
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator3).nextInt();
                boolean bl5 = false;
                ((IrFunctionAccessExpression)$this$interpretEnumEntry_u24lambda_u2d62).putValueArgument(it, null);
            }
        }
        irElementBase = executionResult4;
        if (irElementBase == null) {
            throw new InterpreterException("Initializer at enum entry " + IrUtilsKt.getFqNameWhenAvailable(enumEntry) + " is null");
        }
        return irElementBase;
    }

    private final ExecutionResult interpretTypeOperatorCall(IrTypeOperatorCall expression2) {
        ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)expression2.getArgument());
        ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
        boolean $i$f$check22 = false;
        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        }
        ExecutionResult executionResult2 = $this$check_u24default$iv;
        IrClassifierSymbol typeClassifier = IrTypesKt.getClassifierOrFail(expression2.getTypeOperand());
        IrSymbolOwner it = typeClassifier.getOwner();
        IrTypeParameter $i$f$check22 = it instanceof IrTypeParameter ? (IrTypeParameter)it : null;
        boolean isReified = Intrinsics.areEqual((Object)($i$f$check22 == null ? null : Boolean.valueOf($i$f$check22.isReified())), (Object)true);
        boolean isErased = typeClassifier.getOwner() instanceof IrTypeParameter && !isReified;
        IrType typeOperand = isReified ? (IrType)IrUtilsKt.getDefaultType(this.stack.getVariable(typeClassifier).getState().getIrClass()) : expression2.getTypeOperand();
        IrTypeOperator irTypeOperator = expression2.getOperator();
        int n = WhenMappings.$EnumSwitchMapping$1[irTypeOperator.ordinal()];
        switch (n) {
            case 1: {
                this.stack.popReturnValue();
                break;
            }
            case 2: 
            case 3: {
                if (!isErased && !StateKt.isSubtypeOf(this.stack.peekReturnValue(), typeOperand)) {
                    FqName convertibleClassName = IrUtilsKt.getFqNameWhenAvailable(this.stack.popReturnValue().getIrClass());
                    throw new ClassCastException(convertibleClassName + " cannot be cast to " + RenderIrElementKt.render(typeOperand));
                }
                break;
            }
            case 4: {
                if (!isErased && !StateKt.isSubtypeOf(this.stack.peekReturnValue(), typeOperand)) {
                    this.stack.popReturnValue();
                    this.stack.pushReturnValue(UtilsKt.toState(null, this.irBuiltIns.getNothingNType()));
                }
                break;
            }
            case 5: {
                boolean isInstance = isErased || StateKt.isSubtypeOf(this.stack.peekReturnValue(), typeOperand);
                this.stack.pushReturnValue(UtilsKt.toState(isInstance, this.irBuiltIns.getNothingType()));
                break;
            }
            case 6: {
                boolean isInstance = isErased || StateKt.isSubtypeOf(this.stack.peekReturnValue(), typeOperand);
                this.stack.pushReturnValue(UtilsKt.toState(!isInstance, this.irBuiltIns.getNothingType()));
                break;
            }
            case 7: {
                break;
            }
            default: {
                String string2 = (Object)((Object)expression2.getOperator()) + " not implemented";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }
        }
        return executionResult2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ExecutionResult interpretVararg(IrVararg expression) {
        $this$flatMap$iv = expression.getElements();
        $i$f$flatMap = false;
        var5_5 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var8_9 = $this$flatMapTo$iv$iv.iterator();
        while (var8_9.hasNext()) {
            element$iv$iv /* !! */  = var8_9.next();
            it = (IrVarargElement)element$iv$iv /* !! */ ;
            $i$a$-flatMap-IrInterpreter$interpretVararg$args$1 = false;
            $this$check_u24default$iv = this.interpret(it);
            toCheckLabel$iv = ReturnLabel.REGULAR;
            $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                executionResult = $this$check_u24default$iv;
                $i$a$-check$default-IrInterpreter$interpretVararg$args$1$1 = false;
                return executionResult;
            }
            result = this.stack.popReturnValue();
            list$iv$iv = result instanceof Wrapper ? CollectionsKt.listOf((Object)((Wrapper)result).getValue()) : (result instanceof Primitive ? ((value = ((Primitive)result).getValue()) instanceof byte[] ? ArraysKt.toList((byte[])((byte[])value)) : (value instanceof char[] ? ArraysKt.toList((char[])((char[])value)) : (value instanceof short[] ? ArraysKt.toList((short[])((short[])value)) : (value instanceof int[] ? ArraysKt.toList((int[])((int[])value)) : (value instanceof long[] ? ArraysKt.toList((long[])((long[])value)) : (value instanceof float[] ? ArraysKt.toList((float[])((float[])value)) : (value instanceof double[] ? ArraysKt.toList((double[])((double[])value)) : (value instanceof boolean[] ? ArraysKt.toList((boolean[])((boolean[])value)) : (value instanceof Object[] ? ArraysKt.toList((Object[])((Object[])value)) : CollectionsKt.listOf(value)))))))))) : CollectionsKt.listOf((Object)result));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        args = (List)destination$iv$iv;
        destination$iv$iv = IrTypesKt.getClassifierOrFail(expression.getType()).getOwner();
        v0 = $this$flatMapTo$iv$iv = destination$iv$iv instanceof IrDeclaration != false ? (IrDeclaration)destination$iv$iv : null;
        v1 = $this$flatMapTo$iv$iv == null ? null : (var4_4 = (destination$iv$iv = AdditionalIrUtilsKt.getNameForIrSerialization($this$flatMapTo$iv$iv)) == null ? null : destination$iv$iv.asString());
        if (var4_4 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var4_4.hashCode()) {
            case 1114677618: {
                if (var4_4.equals("UShortArray")) {
                    tmp = 1;
                }
                break;
            }
            case 401290588: {
                if (var4_4.equals("UByteArray")) {
                    tmp = 1;
                }
                break;
            }
            case 1587005215: {
                if (var4_4.equals("UIntArray")) {
                    tmp = 1;
                }
                break;
            }
            case -1714415512: {
                if (var4_4.equals("ULongArray")) {
                    tmp = 1;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                destination$iv$iv = IrTypesKt.getClassOrNull(expression.getType());
                Intrinsics.checkNotNull((Object)destination$iv$iv);
                owner = (IrClass)destination$iv$iv.getOwner();
                $this$filterIsInstance$iv = owner.getDeclarations();
                $i$f$filterIsInstance = false;
                element$iv$iv /* !! */  = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                result = $this$filterIsInstanceTo$iv$iv.iterator();
                while (result.hasNext()) {
                    element$iv$iv /* !! */  = result.next();
                    if (!(element$iv$iv /* !! */  instanceof IrProperty)) continue;
                    destination$iv$iv.add(element$iv$iv /* !! */ );
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$first = false;
                for (T element$iv : $this$first$iv) {
                    it = (IrProperty)element$iv /* !! */ ;
                    $i$a$-first-IrInterpreter$interpretVararg$array$storageProperty$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"storage")) continue;
                    ** GOTO lbl78
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
lbl78:
                // 1 sources

                storageProperty = (IrProperty)element$iv /* !! */ ;
                $this$map$iv = args;
                $i$f$map = false;
                element$iv /* !! */  = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                element$iv$iv /* !! */  = $this$mapTo$iv$iv.iterator();
                while (element$iv$iv /* !! */ .hasNext()) {
                    executionResult = item$iv$iv = element$iv$iv /* !! */ .next();
                    var17_29 = destination$iv$iv;
                    $i$a$-map-IrInterpreter$interpretVararg$array$primitiveArray$1 = false;
                    if (it == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Common");
                    }
                    var18_30 = ((Primitive)((Variable)CollectionsKt.single(((Common)it).getFields())).getState()).getValue();
                    var17_29.add(var18_30);
                }
                primitiveArray = (List)destination$iv$iv;
                var9_11 = storageProperty.getBackingField();
                Intrinsics.checkNotNull((Object)var9_11);
                unsignedArray = UtilsKt.toPrimitiveStateArray(primitiveArray, var9_11.getType());
                var9_11 = new Common(owner);
                var10_14 = false;
                var11_15 = false;
                $this$interpretVararg_u24lambda_u2d68 = var9_11;
                $i$a$-apply-IrInterpreter$interpretVararg$array$1 = false;
                $this$interpretVararg_u24lambda_u2d68.setSuperClassRecursive();
                $this$interpretVararg_u24lambda_u2d68.getFields().add(new Variable(storageProperty.getSymbol(), unsignedArray));
                v2 = (State)var9_11;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v2 = UtilsKt.toPrimitiveStateArray(args, expression.getType());
            }
        }
        array = v2;
        this.stack.pushReturnValue(array);
        return Next.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult interpretSpreadElement(IrSpreadElement spreadElement) {
        void var2_2;
        ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)spreadElement.getExpression());
        ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
        boolean $i$f$check = false;
        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ExecutionResult interpretTry(IrTry expression2) {
        try {
            void $this$check$iv;
            ExecutionResult executionResult2 = this.interpret((IrElement)expression2.getTryResult());
            ReturnLabel toCheckLabel$iv = ReturnLabel.EXCEPTION;
            boolean $i$f$check = false;
            if ($this$check$iv.getReturnLabel() != toCheckLabel$iv) {
                void it = $this$check$iv;
                boolean bl = false;
                void var12_14 = it;
                return var12_14;
            }
            ExceptionState exception = (ExceptionState)this.stack.peekReturnValue();
            for (IrCatch catchBlock : expression2.getCatches()) {
                IrClassSymbol it = IrTypesKt.getClassOrNull(catchBlock.getCatchParameter().getType());
                Intrinsics.checkNotNull((Object)it);
                if (!exception.isSubtypeOf((IrClass)it.getOwner())) continue;
                ExecutionResult $this$check_u24default$iv = this.interpret(catchBlock);
                ReturnLabel toCheckLabel$iv2 = ReturnLabel.REGULAR;
                boolean $i$f$check2 = false;
                if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv2) {
                    ExecutionResult it2 = $this$check_u24default$iv;
                    boolean bl = false;
                    ExecutionResult executionResult3 = it2;
                    return executionResult3;
                }
                break;
            }
        }
        finally {
            IrExpression irExpression = expression2.getFinallyExpression();
            if (irExpression != null) {
                ExecutionResult executionResult4;
                ExecutionResult executionResult5 = executionResult4 = this.interpret((IrElement)irExpression);
                ReturnLabel returnLabel = ReturnLabel.REGULAR;
                boolean bl = false;
                if (executionResult5.getReturnLabel() != returnLabel) {
                    ExecutionResult executionResult6 = executionResult5;
                    boolean bl2 = false;
                    return executionResult6;
                }
            }
        }
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretCatch(IrCatch expression2) {
        Variable catchParameter = new Variable(expression2.getCatchParameter().getSymbol(), this.stack.popReturnValue());
        return this.stack.newFrame(true, CollectionsKt.listOf((Object)catchParameter), (Function0<? extends ExecutionResult>)((Function0)new Function0<ExecutionResult>(this, expression2){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrCatch $expression;
            {
                this.this$0 = $receiver;
                this.$expression = $expression;
                super(0);
            }

            @NotNull
            public final ExecutionResult invoke() {
                return IrInterpreter.access$interpret(this.this$0, this.$expression.getResult());
            }
        }));
    }

    private final ExecutionResult interpretThrow(IrThrow expression2) {
        ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)expression2.getValue());
        ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
        boolean $i$f$check = false;
        if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
            ExecutionResult it = $this$check_u24default$iv;
            boolean bl = false;
            return it;
        }
        State exception = this.stack.popReturnValue();
        if (exception instanceof Common) {
            this.stack.pushReturnValue(new ExceptionState((Common)exception, this.stack.getStackTrace()));
        } else if (exception instanceof Wrapper) {
            this.stack.pushReturnValue(new ExceptionState((Wrapper)exception, this.stack.getStackTrace()));
        } else if (exception instanceof ExceptionState) {
            this.stack.pushReturnValue(exception);
        } else {
            throw new InterpreterException(Reflection.getOrCreateKotlinClass(exception.getClass()) + " cannot be used as exception state");
        }
        return Exception.INSTANCE;
    }

    private final ExecutionResult interpretStringConcatenation(IrStringConcatenation expression2) {
        StringBuilder result2 = new StringBuilder();
        Iterable $this$forEach$iv = expression2.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrExpression it = (IrExpression)element$iv;
            boolean bl = false;
            ExecutionResult $this$check_u24default$iv = this.interpret((IrElement)it);
            ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
            boolean $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult executionResult2 = $this$check_u24default$iv;
                boolean bl2 = false;
                return executionResult2;
            }
            $this$check_u24default$iv = this.interpretToString(this.stack.popReturnValue());
            toCheckLabel$iv = ReturnLabel.REGULAR;
            $i$f$check = false;
            if ($this$check_u24default$iv.getReturnLabel() != toCheckLabel$iv) {
                ExecutionResult executionResult3 = $this$check_u24default$iv;
                boolean bl3 = false;
                return executionResult3;
            }
            result2.append(StateKt.asString(this.stack.popReturnValue()));
        }
        this.stack.pushReturnValue(UtilsKt.toState(result2.toString(), expression2.getType()));
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretToString(State state) {
        String string2;
        State state2 = state;
        if (state2 instanceof Primitive) {
            string2 = String.valueOf(((Primitive)state).getValue());
        } else if (state2 instanceof Wrapper) {
            string2 = ((Wrapper)state).getValue().toString();
        } else {
            if (state2 instanceof Common) {
                IrFunction toStringFun = ((Common)state).getToStringFunction();
                Stack stack = this.stack;
                Object[] objectArray = new Variable[1];
                IrSymbol irSymbol = UtilsKt.getReceiver(toStringFun);
                Intrinsics.checkNotNull((Object)irSymbol);
                objectArray[0] = new Variable(irSymbol, state);
                return Stack.DefaultImpls.newFrame$default(stack, false, CollectionsKt.mutableListOf((Object[])objectArray), (Function0)new Function0<ExecutionResult>(toStringFun, this){
                    final /* synthetic */ IrFunction $toStringFun;
                    final /* synthetic */ IrInterpreter this$0;
                    {
                        this.$toStringFun = $toStringFun;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final ExecutionResult invoke() {
                        ExecutionResult executionResult2;
                        IrBody irBody = this.$toStringFun.getBody();
                        if (irBody == null) {
                            executionResult2 = null;
                        } else {
                            IrBody irBody2 = irBody;
                            IrInterpreter irInterpreter = this.this$0;
                            IrFunction irFunction2 = this.$toStringFun;
                            boolean bl = false;
                            boolean bl2 = false;
                            IrBody it = irBody2;
                            boolean bl3 = false;
                            executionResult2 = IrInterpreter.access$interpret(irInterpreter, irFunction2);
                        }
                        ExecutionResult executionResult3 = executionResult2;
                        return executionResult3 == null ? IrInterpreter.access$calculateBuiltIns(this.this$0, this.$toStringFun) : executionResult3;
                    }
                }, 1, null);
            }
            if (state2 instanceof Lambda) {
                string2 = state.toString();
            } else {
                throw new InterpreterException(state.getClass() + " cannot be used in StringConcatenation expression");
            }
        }
        String result2 = string2;
        this.stack.pushReturnValue(UtilsKt.toState(result2, this.irBuiltIns.getStringType()));
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretFunctionExpression(IrFunctionExpression expression2) {
        IrFunction irFunction2 = expression2.getFunction();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        Lambda lambda = new Lambda(irFunction2, (IrClass)irClassSymbol.getOwner());
        if (AdditionalIrUtilsKt.isLocal(expression2.getFunction())) {
            lambda.getFields().addAll((Collection<Variable>)this.stack.getAll());
        }
        this.stack.pushReturnValue(lambda);
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretFunctionReference(IrFunctionReference reference) {
        IrFunction irFunction2 = ((IrFunctionSymbol)reference.getSymbol()).getOwner();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(reference.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this.stack.pushReturnValue(new Lambda(irFunction2, (IrClass)irClassSymbol.getOwner()));
        return Next.INSTANCE;
    }

    private final ExecutionResult interpretComposite(IrComposite expression2) {
        ExecutionResult executionResult2;
        IrStatementOrigin irStatementOrigin = expression2.getOrigin();
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.DESTRUCTURING_DECLARATION.INSTANCE)) {
            executionResult2 = this.interpretStatements(expression2.getStatements());
        } else if (irStatementOrigin == null) {
            executionResult2 = this.interpretStatements(expression2.getStatements());
        } else {
            String string2 = expression2.getOrigin() + " not implemented";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return executionResult2;
    }

    private static final String calculateBuiltIns$getOnlyName(IrType $this$calculateBuiltIns_u24getOnlyName) {
        return IrTypeBaseKt.getOriginalKotlinType($this$calculateBuiltIns_u24getOnlyName) != null ? String.valueOf(IrTypeBaseKt.getOriginalKotlinType($this$calculateBuiltIns_u24getOnlyName)) : ($this$calculateBuiltIns_u24getOnlyName instanceof IrSimpleType ? Intrinsics.stringPlus((String)((IrDeclarationWithName)IrTypesKt.getClassifierOrFail($this$calculateBuiltIns_u24getOnlyName).getOwner()).getName().asString(), (Object)(((IrSimpleType)$this$calculateBuiltIns_u24getOnlyName).getHasQuestionMark() ? "?" : "")) : RenderIrElementKt.render($this$calculateBuiltIns_u24getOnlyName));
    }

    private static final IrType interpretConst$getSignedType(IrInterpreter this$0, IrType unsignedType) {
        IrType irType;
        UnsignedType unsignedType2 = IrTypePredicatesKt.getUnsignedType(unsignedType);
        int n = unsignedType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[unsignedType2.ordinal()];
        switch (n) {
            case 1: {
                irType = this$0.irBuiltIns.getByteType();
                break;
            }
            case 2: {
                irType = this$0.irBuiltIns.getShortType();
                break;
            }
            case 3: {
                irType = this$0.irBuiltIns.getIntType();
                break;
            }
            case 4: {
                irType = this$0.irBuiltIns.getLongType();
                break;
            }
            default: {
                irType = null;
            }
        }
        return irType;
    }

    public static final /* synthetic */ ExecutionResult access$interpret(IrInterpreter $this, IrElement $receiver) {
        return $this.interpret($receiver);
    }

    public static final /* synthetic */ StackImpl access$getStack$p(IrInterpreter $this) {
        return $this.stack;
    }

    public static final /* synthetic */ ExecutionResult access$invokeMethod(IrInterpreter $this, MethodHandle $receiver, IrFunction irFunction2) {
        return $this.invokeMethod($receiver, irFunction2);
    }

    public static final /* synthetic */ ExecutionResult access$calculateBuiltIns(IrInterpreter $this, IrFunction irFunction2) {
        return $this.calculateBuiltIns(irFunction2);
    }

    public static final /* synthetic */ ExecutionResult access$trySubstituteFunctionBody(IrInterpreter $this, IrFunction $receiver) {
        return $this.trySubstituteFunctionBody($receiver);
    }

    public static final /* synthetic */ ExecutionResult access$tryCalculateLazyConst(IrInterpreter $this, IrFunction $receiver) {
        return $this.tryCalculateLazyConst($receiver);
    }

    public static final /* synthetic */ ExecutionResult access$handleIntrinsicMethods(IrInterpreter $this, IrFunction irFunction2) {
        return $this.handleIntrinsicMethods(irFunction2);
    }

    public static final /* synthetic */ ExecutionResult access$interpretStatements(IrInterpreter $this, List statements2) {
        return $this.interpretStatements(statements2);
    }

    @Metadata(mv={1, 5, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnsignedType.values().length];
            nArray[UnsignedType.UBYTE.ordinal()] = 1;
            nArray[UnsignedType.USHORT.ordinal()] = 2;
            nArray[UnsignedType.UINT.ordinal()] = 3;
            nArray[UnsignedType.ULONG.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrTypeOperator.values().length];
            nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            nArray[IrTypeOperator.CAST.ordinal()] = 2;
            nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 3;
            nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

