/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.extensions.FirStatusTransfomerExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirStatusTransformerExtension;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.ReplaceStatus;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirGlobalExtensionStatusProcessor;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirGlobalResolveProcessor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "process", "", "resolve"})
public final class FirGlobalExtensionStatusProcessor
extends FirGlobalResolveProcessor {
    public FirGlobalExtensionStatusProcessor(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session2, scopeSession);
    }

    @Override
    public void process() {
        List<FirStatusTransformerExtension> extensions = FirStatusTransfomerExtensionKt.getStatusTransformerExtensions(FirExtensionServiceKt.getExtensionService(this.getSession()));
        if (extensions.isEmpty()) {
            return;
        }
        FirPredicateBasedProvider provider = FirPredicateBasedProviderKt.getPredicateBasedProvider(this.getSession());
        for (FirStatusTransformerExtension extension : extensions) {
            List<Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>>> declarations2 = provider.getSymbolsWithOwnersByPredicate(extension.getPredicate());
            for (Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>> pair : declarations2) {
                FirAnnotatedDeclaration declaration = (FirAnnotatedDeclaration)pair.component1();
                List owners = (List)pair.component2();
                if (!(declaration instanceof FirMemberDeclaration)) continue;
                FirDeclarationStatus newStatus = extension.transformStatus(declaration, owners, ((FirMemberDeclaration)declaration).getStatus());
                ((FirMemberDeclaration)declaration).transformStatus(ReplaceStatus.INSTANCE, newStatus);
            }
        }
    }
}

