/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantModalityModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class RedundantModalityModifierChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final RedundantModalityModifierChecker INSTANCE = new RedundantModalityModifierChecker();

    private RedundantModalityModifierChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirMemberDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirSourceElement source;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSourceElement firSourceElement = source = declaration.getSource();
        if ((firSourceElement == null ? null : firSourceElement.getKind()) instanceof FirFakeSourceElementKind) {
            return;
        }
        Object $this$modality$iv = declaration;
        boolean $i$f$getModality = false;
        Object object = $this$modality$iv.getStatus().getModality();
        if (object == null) {
            return;
        }
        Modality modality = object;
        if (modality == Modality.FINAL && ((object = ($this$modality$iv = CollectionsKt.last(context2.getContainingDeclarations())) instanceof FirClass ? (FirClass)$this$modality$iv : null) == null ? null : object.getClassKind()) == ClassKind.INTERFACE) {
            return;
        }
        if (source != null && LightTreePositioningStrategiesKt.modalityModifier(source.getTreeStructure(), source.getLighterASTNode()) == null) {
            return;
        }
        Modality implicitModality = FirHelpersKt.implicitModality(declaration, context2);
        if (modality != implicitModality) {
            return;
        }
        $this$modality$iv = reporter;
        FirDiagnosticFactory0<FirSourceElement, KtModifierListOwner> factory$iv = FirErrors.INSTANCE.getREDUNDANT_MODALITY_MODIFIER();
        boolean $i$f$report = false;
        FirSourceElement firSourceElement2 = source;
        if (firSourceElement2 != null) {
            void $this$report$iv;
            FirSourceElement firSourceElement3 = firSourceElement2;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it$iv = firSourceElement3;
            boolean bl3 = false;
            $this$report$iv.report((FirDiagnostic)factory$iv.on(it$iv));
        }
    }
}

