/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\r*\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantExplicitTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "hasSameNameWithoutModifiers", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "name", "Lorg/jetbrains/kotlin/name/Name;", "isSame", "other", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
public final class RedundantExplicitTypeChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final RedundantExplicitTypeChecker INSTANCE = new RedundantExplicitTypeChecker();

    private RedundantExplicitTypeChecker() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirMemberDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$report$iv;
        void source$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration instanceof FirProperty)) {
            return;
        }
        if (!((FirProperty)declaration).isLocal()) {
            return;
        }
        FirExpression firExpression2 = ((FirProperty)declaration).getInitializer();
        if (firExpression2 == null) {
            return;
        }
        FirExpression initializer2 = firExpression2;
        FirTypeRef typeReference = ((FirProperty)declaration).getReturnTypeRef();
        FirSourceElement firSourceElement = typeReference.getSource();
        if ((firSourceElement == null ? null : firSourceElement.getKind()) instanceof FirFakeSourceElementKind) {
            return;
        }
        Object $this$coneType$iv = ((FirProperty)declaration).getReturnTypeRef();
        boolean $i$f$getConeType22 = false;
        Object $this$coneTypeSafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if ((object = coneKotlinType) == null) {
            $this$coneTypeSafe$iv$iv = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default((FirElement)$this$coneType$iv, null, 1, null);
            $i$f$coneTypeSafe = false;
            throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv.toString());
        }
        ConeKotlinType type2 = object;
        if (typeReference instanceof FirTypeAlias) {
            return;
        }
        $this$coneType$iv = typeReference.getAnnotations();
        $i$f$getConeType22 = false;
        if (!$this$coneType$iv.isEmpty()) {
            return;
        }
        boolean bl2 = false;
        if (bl2) {
            return;
        }
        $this$coneType$iv = initializer2;
        if ($this$coneType$iv instanceof FirConstExpression) {
            $this$coneTypeSafe$iv$iv = initializer2.getSource();
            IElementType iElementType = $i$f$getConeType22 = $this$coneTypeSafe$iv$iv == null ? null : ((FirSourceElement)$this$coneTypeSafe$iv$iv).getElementType();
            if (Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getBoolean())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                if (Intrinsics.areEqual(((FirConstExpression)initializer2).getKind(), (Object)ConstantValueKind.Long.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getLong()) : !this.isSame(type2, StandardClassIds.INSTANCE.getInt())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
                if (Intrinsics.areEqual(((FirConstExpression)initializer2).getKind(), (Object)ConstantValueKind.Float.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getFloat()) : !this.isSame(type2, StandardClassIds.INSTANCE.getDouble())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getChar())) {
                    return;
                }
            } else {
                if (!Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.STRING_TEMPLATE)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        } else if ($this$coneType$iv instanceof FirNamedReference) {
            if (!this.hasSameNameWithoutModifiers(type2, ((FirNamedReference)((Object)initializer2)).getName())) {
                return;
            }
        } else if ($this$coneType$iv instanceof FirFunctionCall) {
            if (!this.hasSameNameWithoutModifiers(type2, ((FirFunctionCall)initializer2).getCalleeReference().getName())) {
                return;
            }
        } else {
            if ($this$coneType$iv instanceof FirGetClassCall) {
                return;
            }
            if ($this$coneType$iv instanceof FirResolvedQualifier) {
                if (!this.isSame(type2, ((FirResolvedQualifier)initializer2).getClassId())) {
                    return;
                }
            } else {
                if (!($this$coneType$iv instanceof FirStringConcatenationCall)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        }
        $this$coneType$iv = reporter;
        FirSourceElement $i$f$getConeType22 = ((FirProperty)declaration).getReturnTypeRef().getSource();
        FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_TYPE();
        boolean $i$f$report = false;
        firResolvedTypeRef = source$iv;
        if (firResolvedTypeRef == null) return;
        object = firResolvedTypeRef;
        boolean bl3 = false;
        boolean bl4 = false;
        Object it$iv = object;
        boolean bl5 = false;
        $this$report$iv.report((FirDiagnostic)factory$iv.on((FirSourceElement)it$iv));
    }

    private final boolean isSame(ConeKotlinType $this$isSame, ClassId other) {
        if ($this$isSame.getNullability().isNullable()) {
            return false;
        }
        return Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId($this$isSame.getType()), (Object)other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasSameNameWithoutModifiers(ConeKotlinType $this$hasSameNameWithoutModifiers, Name name) {
        if (!($this$hasSameNameWithoutModifiers instanceof ConeClassLikeType)) return false;
        if (!Intrinsics.areEqual((Object)((ConeClassLikeType)$this$hasSameNameWithoutModifiers).getLookupTag().getName(), (Object)name)) return false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$hasSameNameWithoutModifiers.getTypeArguments();
        boolean bl = false;
        if (coneTypeProjectionArray.length != 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (ConeTypeUtilsKt.isMarkedNullable($this$hasSameNameWithoutModifiers)) return false;
        return true;
    }
}

