/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Iterator;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\rH\u0016J\u0018\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\u000eH\u0016J\u0018\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\u000fH\u0016J\u0018\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\u0010H\u0016J\u0018\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J\u0018\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\u0012H\u0016J\u0018\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\u0013H\u0016J\u0018\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;", "", "represent", "", "it", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "appendRepresentation", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
public interface FirDeclarationPresenter {
    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirElement var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ClassId var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull CallableId var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ConeTypeProjection var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ConeKotlinType var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirTypeRef var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirTypeParameter var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirValueParameter var2);

    @NotNull
    public String represent(@NotNull FirProperty var1);

    @NotNull
    public String represent(@NotNull FirSimpleFunction var1);

    @NotNull
    public String represent(@NotNull FirTypeAlias var1);

    @NotNull
    public String represent(@NotNull FirRegularClass var1);

    @Metadata(mv={1, 5, 0}, k=3, xi=50)
    public static final class DefaultImpls {
        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirElement it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            receiver.append("NO_REPRESENTATION");
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull ClassId it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            receiver.append(it.getPackageFqName().asString());
            receiver.append('/');
            receiver.append(it.getRelativeClassName().asString());
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull CallableId it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (it.getClassName() != null) {
                receiver.append(it.getPackageName().asString());
                receiver.append('/');
                receiver.append(it.getClassName());
                receiver.append('.');
                receiver.append(it.getCallableName());
            } else {
                receiver.append(it.getPackageName().asString());
                receiver.append('/');
                receiver.append(it.getCallableName());
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull ConeTypeProjection it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ConeTypeProjection coneTypeProjection = it;
            if (Intrinsics.areEqual((Object)coneTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
                receiver.append('*');
            } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
                receiver.append("in ");
                this_.appendRepresentation(receiver, ((ConeKotlinTypeProjectionIn)it).getType());
            } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
                receiver.append("out ");
                this_.appendRepresentation(receiver, ((ConeKotlinTypeProjectionOut)it).getType());
            } else if (coneTypeProjection instanceof ConeKotlinType) {
                this_.appendRepresentation(receiver, (ConeKotlinType)it);
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull ConeKotlinType it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ConeKotlinType coneKotlinType = it;
            if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                this_.appendRepresentation(receiver, ((ConeDefinitelyNotNullType)it).getOriginal());
                receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeClassErrorType) {
                receiver.append("ERROR(");
                receiver.append(((ConeClassErrorType)it).getDiagnostic().getReason());
                receiver.append(')');
            } else if (coneKotlinType instanceof ConeCapturedType) {
                receiver.append(((ConeCapturedType)it).getConstructor().getProjection());
                receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeClassLikeType) {
                this_.appendRepresentation(receiver, ((ConeClassLikeType)it).getLookupTag().getClassId());
                ConeTypeProjection[] coneTypeProjectionArray = it.getTypeArguments();
                boolean bl = false;
                ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
                int n = 0;
                if (!(coneTypeProjectionArray2.length == 0)) {
                    receiver.append('<');
                    ConeTypeProjection[] $this$forEach$iv = it.getTypeArguments();
                    boolean $i$f$forEach = false;
                    coneTypeProjectionArray2 = $this$forEach$iv;
                    n = coneTypeProjectionArray2.length;
                    for (int i = 0; i < n; ++i) {
                        ConeTypeProjection element$iv;
                        ConeTypeProjection that = element$iv = coneTypeProjectionArray2[i];
                        boolean bl2 = false;
                        this_.appendRepresentation(receiver, that);
                        receiver.append(',');
                    }
                    receiver.append('>');
                }
                receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
                receiver.append(((ConeLookupTagBasedType)it).getLookupTag().getName());
                receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
                receiver.append(((ConeIntegerLiteralType)it).getValue());
                receiver.append(it.getNullability().getSuffix());
            } else if ((coneKotlinType instanceof ConeFlexibleType ? true : coneKotlinType instanceof ConeIntersectionType) ? true : coneKotlinType instanceof ConeStubType) {
                receiver.append("ERROR");
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirTypeRef it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            FirTypeRef firTypeRef = it;
            if (firTypeRef instanceof FirResolvedTypeRef) {
                this_.appendRepresentation(receiver, ((FirResolvedTypeRef)it).getType());
            } else if (firTypeRef instanceof FirErrorTypeRef) {
                receiver.append("ERROR");
            } else {
                receiver.append("?");
            }
        }

        /*
         * WARNING - void declaration
         */
        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirTypeParameter it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            receiver.append(it.getName().asString());
            receiver.append(':');
            int n = it.getBounds().size();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    this_.appendRepresentation(receiver, it.getBounds().get(0));
                    break;
                }
                default: {
                    Object that;
                    TreeSet set = SetsKt.sortedSetOf((Object[])new String[0]);
                    Iterable $this$forEach$iv = it.getBounds();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void receiver2;
                        that = (FirTypeRef)element$iv;
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        StringBuilder stringBuilder2 = new StringBuilder();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        StringBuilder stringBuilder3 = stringBuilder2;
                        TreeSet treeSet = set;
                        boolean bl6 = false;
                        this_.appendRepresentation((StringBuilder)receiver2, (FirTypeRef)that);
                        Unit unit = Unit.INSTANCE;
                        String string2 = stringBuilder2.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                        treeSet.add(string2);
                    }
                    $this$forEach$iv = set;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        that = (String)element$iv;
                        boolean bl = false;
                        receiver.append((String)that);
                        receiver.append(',');
                    }
                }
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirValueParameter it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (it.isVararg()) {
                receiver.append("vararg ");
            }
            this_.appendRepresentation(receiver, it.getReturnTypeRef());
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirProperty it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder receiver = stringBuilder2;
            boolean bl5 = false;
            receiver.append('[');
            FirTypeRef firTypeRef = it.getReceiverTypeRef();
            if (firTypeRef != null) {
                FirTypeRef firTypeRef2 = firTypeRef;
                boolean bl6 = false;
                boolean bl7 = false;
                FirTypeRef it2 = firTypeRef2;
                boolean bl8 = false;
                this_.appendRepresentation(receiver, it2);
            }
            receiver.append(']');
            this_.appendRepresentation(receiver, it.getSymbol().getCallableId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirSimpleFunction it) {
            Object it2;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder receiver = stringBuilder2;
            boolean bl5 = false;
            receiver.append('<');
            Object $this$forEach$iv = it.getTypeParameters();
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                it2 = (FirTypeParameter)element$iv;
                boolean bl6 = false;
                this_.appendRepresentation(receiver, (FirTypeParameter)it2);
                receiver.append(',');
            }
            receiver.append('>');
            receiver.append('[');
            $this$forEach$iv = it.getReceiverTypeRef();
            if ($this$forEach$iv != null) {
                Object $i$f$forEach2 = $this$forEach$iv;
                boolean bl7 = false;
                boolean element$iv = false;
                it2 = $i$f$forEach2;
                boolean bl8 = false;
                this_.appendRepresentation(receiver, (FirTypeRef)it2);
            }
            receiver.append(']');
            FirMemberDeclaration $this$isOperator$iv = it;
            boolean $i$f$isOperator = false;
            if ($this$isOperator$iv.getStatus().isOperator()) {
                receiver.append("operator ");
            }
            this_.appendRepresentation(receiver, it.getSymbol().getCallableId());
            receiver.append('(');
            $this$forEach$iv = it.getValueParameters();
            $i$f$forEach2 = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                it2 = (FirValueParameter)element$iv;
                boolean bl9 = false;
                this_.appendRepresentation(receiver, (FirValueParameter)it2);
                receiver.append(',');
            }
            receiver.append(')');
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirTypeAlias it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder receiver = stringBuilder2;
            boolean bl5 = false;
            receiver.append('[');
            receiver.append(']');
            this_.appendRepresentation(receiver, it.getSymbol().getClassId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirRegularClass it) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder receiver = stringBuilder2;
            boolean bl5 = false;
            receiver.append('[');
            receiver.append(']');
            this_.appendRepresentation(receiver, it.getSymbol().getClassId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }
    }
}

