/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J.\u0010\f\u001a\u00020\u00042\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J-\u0010\u0011\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0012*\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u0002H\u00122\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018JB\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH$J\f\u0010!\u001a\u00020\u0004*\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\u0004*\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J \u0010%\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010&\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010&\u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010'\u001a\u00020(*\u0006\u0012\u0002\b\u00030\u001dH\u0004\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "()V", "canSeePrivateMemberOf", "", "containingDeclarationOfUseSite", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "ownerId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "canSeeProtectedMemberOf", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "containingUseSiteClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "isVisible", "T", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/FirSymbolOwner;", "declaration", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;)Z", "platformVisibilityCheck", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "isAllowedToBeAccessedFromOutside", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "isSame", "other", "isSubClass", "ownerIfCompanion", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Default", "resolve"})
public abstract class FirVisibilityChecker
implements FirSessionComponent {
    /*
     * Enabled aggressive block sorting
     */
    public final <T extends FirMemberDeclaration & FirSymbolOwner<?>> boolean isVisible(@NotNull T declaration, @NotNull Candidate candidate2) {
        boolean bl;
        ClassId ownerId;
        Visibility visibility2;
        boolean $i$f$getVisibility;
        Object $this$visibility$iv;
        FirSession session2;
        List<FirDeclaration> containingDeclarations;
        FirFile useSiteFile;
        AbstractFirBasedSymbol<?> symbol2;
        block8: {
            block9: {
                block11: {
                    AbstractFirBasedSymbol<?> abstractFirBasedSymbol;
                    FirProvider provider;
                    block10: {
                        Intrinsics.checkNotNullParameter(declaration, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
                        symbol2 = ((FirSymbolOwner<?>)declaration).getSymbol();
                        if (declaration instanceof FirCallableDeclaration && (ClassMembersKt.isIntersectionOverride((FirCallableDeclaration)declaration) || ClassMembersKt.isSubstitutionOverride((FirCallableDeclaration)declaration))) {
                            FirCallableDeclaration firCallableDeclaration;
                            FirCallableDeclaration firCallableDeclaration2;
                            FirCallableDeclaration $this$originalIfFakeOverride$iv = (FirCallableDeclaration)declaration;
                            boolean $i$f$originalIfFakeOverride = false;
                            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = $this$originalIfFakeOverride$iv;
                            boolean $i$f$getOriginalForSubstitutionOverride = false;
                            FirCallableDeclaration firCallableDeclaration3 = firCallableDeclaration2 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
                            if (firCallableDeclaration2 == null) {
                                FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv = $this$originalIfFakeOverride$iv;
                                boolean $i$f$getBaseForIntersectionOverride = false;
                                firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv) : null;
                            } else {
                                firCallableDeclaration = firCallableDeclaration2;
                            }
                            FirCallableDeclaration firCallableDeclaration4 = firCallableDeclaration;
                            if (firCallableDeclaration4 != null) return this.isVisible((FirMemberDeclaration)((Object)firCallableDeclaration4), candidate2);
                            throw new NullPointerException("null cannot be cast to non-null type T of org.jetbrains.kotlin.fir.FirVisibilityChecker.isVisible");
                        }
                        CallInfo callInfo = candidate2.getCallInfo();
                        useSiteFile = callInfo.getContainingFile();
                        containingDeclarations = callInfo.getContainingDeclarations();
                        session2 = callInfo.getSession();
                        provider = MainSessionComponentsKt.getFirProvider(session2);
                        $this$visibility$iv = declaration;
                        $i$f$getVisibility = false;
                        visibility2 = $this$visibility$iv.getStatus().getVisibility();
                        if (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE)) {
                            if (Intrinsics.areEqual((Object)declaration.getSession(), (Object)session2)) return true;
                            $this$visibility$iv = FirVisibilityCheckerKt.getModuleVisibilityChecker(session2);
                            if (Intrinsics.areEqual((Object)($this$visibility$iv == null ? null : Boolean.valueOf($this$visibility$iv.isInFriendModule(declaration))), (Object)true)) return true;
                            return false;
                        }
                        if (!(Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Private.INSTANCE) ? true : Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.PrivateToThis.INSTANCE))) break block8;
                        ownerId = FirVisibilityCheckerKt.getOwnerId(symbol2);
                        if (!Intrinsics.areEqual((Object)declaration.getSession(), (Object)session2)) break block9;
                        if (ownerId == null) break block10;
                        if (!(declaration instanceof FirConstructor)) break block11;
                        T $this$isFromSealedClass$iv = declaration;
                        boolean $i$f$isFromSealedClass = false;
                        if (!$this$isFromSealedClass$iv.getStatus().isFromSealedClass()) break block11;
                    }
                    FirFile candidateFile = (abstractFirBasedSymbol = symbol2) instanceof FirClassLikeSymbol ? provider.getFirClassifierContainerFileIfAny((FirClassLikeSymbol)symbol2) : (abstractFirBasedSymbol instanceof FirCallableSymbol ? provider.getFirCallableContainerFile((FirCallableSymbol)symbol2) : null);
                    bl = Intrinsics.areEqual((Object)candidateFile, (Object)useSiteFile);
                    return bl;
                }
                bl = this.canSeePrivateMemberOf(containingDeclarations, ownerId, session2);
                return bl;
            }
            if (!(declaration instanceof FirSimpleFunction)) return false;
            if (!this.isAllowedToBeAccessedFromOutside((FirSimpleFunction)declaration)) return false;
            return true;
        }
        if (!Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Protected.INSTANCE)) {
            $this$visibility$iv = declaration;
            $i$f$getVisibility = false;
            bl = this.platformVisibilityCheck($this$visibility$iv.getStatus().getVisibility(), symbol2, useSiteFile, containingDeclarations, candidate2, session2);
            return bl;
        }
        ownerId = FirVisibilityCheckerKt.getOwnerId(symbol2);
        if (ownerId == null) return false;
        if (!this.canSeeProtectedMemberOf(containingDeclarations, candidate2.getDispatchReceiverValue(), ownerId, session2)) return false;
        return true;
    }

    protected abstract boolean platformVisibilityCheck(@NotNull Visibility var1, @NotNull AbstractFirBasedSymbol<?> var2, @NotNull FirFile var3, @NotNull List<? extends FirDeclaration> var4, @NotNull Candidate var5, @NotNull FirSession var6);

    private final boolean canSeePrivateMemberOf(List<? extends FirDeclaration> containingDeclarationOfUseSite, ClassId ownerId, FirSession session2) {
        ClassId classId = this.ownerIfCompanion(ownerId, session2);
        if (classId != null) {
            ClassId classId2 = classId;
            boolean bl = false;
            boolean bl2 = false;
            ClassId companionOwnerClassId = classId2;
            boolean bl3 = false;
            return this.canSeePrivateMemberOf(containingDeclarationOfUseSite, companionOwnerClassId, session2);
        }
        for (FirDeclaration firDeclaration : containingDeclarationOfUseSite) {
            FirClassSymbol boundSymbol;
            if (!(firDeclaration instanceof FirClass) || !this.isSame((boundSymbol = ((FirClass)firDeclaration).getSymbol()).getClassId(), ownerId)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSame(ClassId $this$isSame, ClassId other) {
        return Intrinsics.areEqual((Object)$this$isSame.getPackageFqName(), (Object)other.getPackageFqName()) && Intrinsics.areEqual((Object)$this$isSame.getRelativeClassName(), (Object)other.getRelativeClassName());
    }

    private final ClassId ownerIfCompanion(ClassId $this$ownerIfCompanion, FirSession session2) {
        Boolean bl;
        if ($this$ownerIfCompanion.getOuterClassId() == null || $this$ownerIfCompanion.isLocal()) {
            return null;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(session2).getClassLikeSymbolByFqName($this$ownerIfCompanion);
        FirRegularClassSymbol ownerSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        firClassLikeSymbol = $this$ownerIfCompanion.getOuterClassId();
        boolean bl2 = false;
        boolean bl3 = false;
        FirClassLikeSymbol<?> it = firClassLikeSymbol;
        boolean bl4 = false;
        FirRegularClassSymbol firRegularClassSymbol = ownerSymbol;
        if (firRegularClassSymbol == null) {
            bl = null;
        } else {
            FirRegularClass firRegularClass = (FirRegularClass)firRegularClassSymbol.getFir();
            if (firRegularClass == null) {
                bl = null;
            } else {
                FirRegularClass $this$isCompanion$iv = firRegularClass;
                boolean $i$f$isCompanion = false;
                bl = $this$isCompanion$iv.getStatus().isCompanion();
            }
        }
        return Intrinsics.areEqual(bl, (Object)true) ? firClassLikeSymbol : null;
    }

    private final boolean canSeeProtectedMemberOf(FirClass<?> containingUseSiteClass, ReceiverValue dispatchReceiver, ClassId ownerId, FirSession session2) {
        ClassId classId;
        ReceiverValue receiverValue = dispatchReceiver;
        if (receiverValue != null && (classId = this.ownerIfCompanion(receiverValue, session2)) != null) {
            ClassId classId2 = classId;
            boolean bl = false;
            boolean bl2 = false;
            ClassId companionOwnerClassId = classId2;
            boolean bl3 = false;
            if (this.isSubClass(containingUseSiteClass, companionOwnerClassId, session2)) {
                return true;
            }
        }
        return this.isSubClass(containingUseSiteClass, ownerId, session2);
    }

    private final boolean isSubClass(FirClass<?> $this$isSubClass, ClassId ownerId, FirSession session2) {
        boolean bl;
        block4: {
            if (this.isSame(FirDeclarationUtilKt.getClassId($this$isSubClass), ownerId)) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubClass, true, true, session2, null, false, 48, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType coneClassLikeType;
                    ConeClassLikeLookupTag coneClassLikeLookupTag;
                    Object object;
                    ConeClassLikeType superType = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    Object object2 = object = superType instanceof ConeClassLikeType ? superType : null;
                    ConeClassLikeLookupTag coneClassLikeLookupTag2 = object == null ? null : (coneClassLikeLookupTag = (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)object, session2, null, 2, null)) == null ? null : coneClassLikeType.getLookupTag());
                    if (!Intrinsics.areEqual(coneClassLikeLookupTag == null ? null : ((object = coneClassLikeLookupTag.getClassId()) == null ? null : Boolean.valueOf(this.isSame((ClassId)object, ownerId))), (Object)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final ClassId ownerIfCompanion(ReceiverValue $this$ownerIfCompanion, FirSession session2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        ReceiverValue receiverValue = $this$ownerIfCompanion;
        ConeKotlinType coneKotlinType = receiverValue == null ? null : receiverValue.getType();
        Object object = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag = object == null ? null : ((ConeClassLikeType)object).getLookupTag();
        return coneClassLikeLookupTag == null ? null : ((object = coneClassLikeLookupTag.getClassId()) == null ? null : this.ownerIfCompanion((ClassId)object, session2));
    }

    private final boolean isAllowedToBeAccessedFromOutside(FirSimpleFunction $this$isAllowedToBeAccessedFromOutside) {
        FirDeclaration $this$isFromLibrary$iv = $this$isAllowedToBeAccessedFromOutside;
        boolean $i$f$isFromLibrary22 = false;
        if (!Intrinsics.areEqual((Object)$this$isFromLibrary$iv.getOrigin(), (Object)FirDeclarationOrigin.Library.INSTANCE)) {
            return false;
        }
        String $i$f$isFromLibrary22 = $this$isAllowedToBeAccessedFromOutside.getSymbol().getCallableId().getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$isFromLibrary22, (String)"symbol.callableId.packageName.asString()");
        String packageName = $i$f$isFromLibrary22;
        String string2 = $this$isAllowedToBeAccessedFromOutside.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
        String name = string2;
        return Intrinsics.areEqual((Object)packageName, (Object)"kotlin.jvm.internal.unsafe") && (Intrinsics.areEqual((Object)name, (Object)"monitorEnter") || Intrinsics.areEqual((Object)name, (Object)"monitorExit"));
    }

    protected final boolean canSeeProtectedMemberOf(@NotNull List<? extends FirDeclaration> containingDeclarationOfUseSite, @Nullable ReceiverValue dispatchReceiver, @NotNull ClassId ownerId, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(containingDeclarationOfUseSite, (String)"containingDeclarationOfUseSite");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (this.canSeePrivateMemberOf(containingDeclarationOfUseSite, ownerId, session2)) {
            return true;
        }
        for (FirDeclaration firDeclaration : containingDeclarationOfUseSite) {
            FirClassSymbol boundSymbol;
            if (!(firDeclaration instanceof FirClass) || !this.canSeeProtectedMemberOf((FirClass)(boundSymbol = ((FirClass)firDeclaration).getSymbol()).getFir(), dispatchReceiver, ownerId, session2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected final FqName packageFqName(@NotNull AbstractFirBasedSymbol<?> $this$packageFqName) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$packageFqName, (String)"<this>");
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = $this$packageFqName;
        if (abstractFirBasedSymbol instanceof FirClassLikeSymbol) {
            FqName fqName3 = ((FirClassLikeSymbol)$this$packageFqName).getClassId().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"classId.packageFqName");
            fqName2 = fqName3;
        } else if (abstractFirBasedSymbol instanceof FirCallableSymbol) {
            fqName2 = ((FirCallableSymbol)$this$packageFqName).getCallableId().getPackageName();
        } else {
            String string2 = Intrinsics.stringPlus((String)"No package fq name for ", $this$packageFqName);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return fqName2;
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/FirVisibilityChecker$Default;", "Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "()V", "platformVisibilityCheck", "", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "resolve"})
    public static final class Default
    extends FirVisibilityChecker {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        protected boolean platformVisibilityCheck(@NotNull Visibility declarationVisibility, @NotNull AbstractFirBasedSymbol<?> symbol2, @NotNull FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @NotNull Candidate candidate2, @NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)declarationVisibility, (String)"declarationVisibility");
            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)useSiteFile, (String)"useSiteFile");
            Intrinsics.checkNotNullParameter(containingDeclarations, (String)"containingDeclarations");
            Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return true;
        }
    }
}

