/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.components;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectClassUtilKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/components/SignatureSerializer;", "", "()V", "constructorDesc", "", "constructor", "Ljava/lang/reflect/Constructor;", "fieldDesc", "field", "Ljava/lang/reflect/Field;", "methodDesc", "method", "Ljava/lang/reflect/Method;", "descriptors.runtime"})
final class SignatureSerializer {
    @NotNull
    public static final SignatureSerializer INSTANCE = new SignatureSerializer();

    private SignatureSerializer() {
    }

    @NotNull
    public final String methodDesc(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"method.parameterTypes");
        for (Class<?> parameterType : classArray) {
            Intrinsics.checkNotNullExpressionValue(parameterType, (String)"parameterType");
            sb.append(ReflectClassUtilKt.getDesc(parameterType));
        }
        sb.append(")");
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"method.returnType");
        sb.append(ReflectClassUtilKt.getDesc(clazz));
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    @NotNull
    public final String constructorDesc(@NotNull Constructor<?> constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, (String)"constructor");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Class<?>[] classArray = constructor2.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"constructor.parameterTypes");
        for (Class<?> parameterType : classArray) {
            Intrinsics.checkNotNullExpressionValue(parameterType, (String)"parameterType");
            sb.append(ReflectClassUtilKt.getDesc(parameterType));
        }
        sb.append(")V");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    @NotNull
    public final String fieldDesc(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Class<?> clazz = field.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"field.type");
        return ReflectClassUtilKt.getDesc(clazz);
    }
}

