/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.MethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 '2\u00020\u0001:\u0002'(B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0013J\u001a\u0010#\u001a\f\u0018\u00010$R\u00060\fR\u00020\u00002\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\u0013J\b\u0010&\u001a\u00020\u001cH\u0002R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "skipBreakContinueGotoEdges", "", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;Z)V", "analyzer", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "loopEntryPointMarkers", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/utils/SmartList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "maxExtraStackSize", "", "getMaxExtraStackSize", "()I", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyze", "", "getActualStack", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "location", "getActualStackSize", "getExpectedStackSize", "getFrame", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "getStackToSpill", "recordLoopEntryPointMarkers", "Companion", "InternalAnalyzer", "backend"})
public final class FixStackAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MethodNode method;
    @NotNull
    private final FixStackContext context;
    private final boolean skipBreakContinueGotoEdges;
    @NotNull
    private final HashMap<LabelNode, SmartList<AbstractInsnNode>> loopEntryPointMarkers;
    @NotNull
    private final InternalAnalyzer analyzer;
    public static final int DEAD_CODE_STACK_SIZE = -1;

    public FixStackAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull FixStackContext context2, boolean skipBreakContinueGotoEdges) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.method = method;
        this.context = context2;
        this.skipBreakContinueGotoEdges = skipBreakContinueGotoEdges;
        boolean bl = false;
        this.loopEntryPointMarkers = new HashMap();
        this.analyzer = new InternalAnalyzer(owner);
    }

    public /* synthetic */ FixStackAnalyzer(String string2, MethodNode methodNode, FixStackContext fixStackContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string2, methodNode, fixStackContext, bl);
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    public final int getMaxExtraStackSize() {
        return this.analyzer.getMaxExtraStackSize();
    }

    @Nullable
    public final List<BasicValue> getStackToSpill(@NotNull AbstractInsnNode location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return this.analyzer.getSpilledStacks().get(location2);
    }

    @Nullable
    public final List<BasicValue> getActualStack(@NotNull AbstractInsnNode location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        InternalAnalyzer.FixStackFrame fixStackFrame = this.getFrame(location2);
        return fixStackFrame == null ? null : fixStackFrame.getStackContent();
    }

    public final int getActualStackSize(@NotNull AbstractInsnNode location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        InternalAnalyzer.FixStackFrame fixStackFrame = this.getFrame(location2);
        return fixStackFrame == null ? -1 : fixStackFrame.getStackSizeWithExtra();
    }

    public final int getExpectedStackSize(@NotNull AbstractInsnNode location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Map map = this.loopEntryPointMarkers;
        boolean bl = false;
        SmartList smartList = (SmartList)map.get(location2);
        List expectedStackSizeNodes = smartList == null ? CollectionsKt.listOf((Object)location2) : (List)smartList;
        for (AbstractInsnNode node : expectedStackSizeNodes) {
            InternalAnalyzer.FixStackFrame fixStackFrame = this.getFrame(node);
            if (fixStackFrame == null) continue;
            InternalAnalyzer.FixStackFrame frame = fixStackFrame;
            return frame.getStackSizeWithExtra();
        }
        return -1;
    }

    private final InternalAnalyzer.FixStackFrame getFrame(AbstractInsnNode location2) {
        Frame frame = this.analyzer.getFrame(location2);
        return frame instanceof InternalAnalyzer.FixStackFrame ? (InternalAnalyzer.FixStackFrame)frame : null;
    }

    public final void analyze() {
        this.recordLoopEntryPointMarkers();
        this.analyzer.analyze();
    }

    /*
     * WARNING - void declaration
     */
    private final void recordLoopEntryPointMarkers() {
        for (AbstractInsnNode marker : this.context.getFakeAlwaysFalseIfeqMarkers()) {
            Object object;
            void $this$getOrPut$iv;
            AbstractInsnNode next = marker.getNext();
            if (!(next instanceof JumpInsnNode)) continue;
            Map map = this.loopEntryPointMarkers;
            LabelNode labelNode = ((JumpInsnNode)next).label;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"next.label");
            LabelNode key$iv = labelNode;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                SmartList answer$iv = new SmartList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((SmartList)object).add(marker);
        }
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$Companion;", "", "()V", "DEAD_CODE_STACK_SIZE", "", "backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0014J\u001c\u0010\u001c\u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010 \u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010!\u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010\"\u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u001c\u0010#\u001a\u00020\u001d*\n0\u001eR\u00060\u0000R\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rH\u0002R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR9\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\fj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;", "Lorg/jetbrains/kotlin/codegen/optimization/common/MethodAnalyzer;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "owner", "", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;Ljava/lang/String;)V", "<set-?>", "", "maxExtraStackSize", "getMaxExtraStackSize", "()I", "spilledStacks", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "", "Lkotlin/collections/HashMap;", "getSpilledStacks", "()Ljava/util/HashMap;", "indexOf", "node", "newFrame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "nLocals", "nStack", "visitControlFlowEdge", "", "insn", "successor", "executeAfterInlineCallMarker", "", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "executeBeforeInlineCallMarker", "executeRestoreStackInTryCatch", "executeSaveStackBeforeTry", "saveStackAndClear", "FixStackFrame", "backend"})
    private final class InternalAnalyzer
    extends MethodAnalyzer<BasicValue> {
        @NotNull
        private final HashMap<AbstractInsnNode, List<BasicValue>> spilledStacks;
        private int maxExtraStackSize;

        public InternalAnalyzer(String owner) {
            Intrinsics.checkNotNullParameter((Object)FixStackAnalyzer.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner, FixStackAnalyzer.this.getMethod(), new OptimizationBasicInterpreter());
            boolean bl = false;
            this.spilledStacks = new HashMap();
        }

        @NotNull
        public final HashMap<AbstractInsnNode, List<BasicValue>> getSpilledStacks() {
            return this.spilledStacks;
        }

        public final int getMaxExtraStackSize() {
            return this.maxExtraStackSize;
        }

        @Override
        protected boolean visitControlFlowEdge(int insn, int successor) {
            if (!FixStackAnalyzer.this.skipBreakContinueGotoEdges) {
                return true;
            }
            AbstractInsnNode insnNode = this.getInstructions().get(insn);
            return !(insnNode instanceof JumpInsnNode) || !FixStackAnalyzer.this.getContext().getBreakContinueGotoNodes().contains(insnNode);
        }

        @Override
        @NotNull
        protected Frame<BasicValue> newFrame(int nLocals, int nStack) {
            return new FixStackFrame(nLocals, nStack);
        }

        private final int indexOf(AbstractInsnNode node) {
            return this.getMethod().instructions.indexOf(node);
        }

        private final void executeBeforeInlineCallMarker(FixStackFrame $this$executeBeforeInlineCallMarker, AbstractInsnNode insn) {
            this.saveStackAndClear($this$executeBeforeInlineCallMarker, insn);
        }

        private final void saveStackAndClear(FixStackFrame $this$saveStackAndClear, AbstractInsnNode insn) {
            List<BasicValue> savedValues = $this$saveStackAndClear.getStackContent();
            Map map = this.spilledStacks;
            boolean bl = false;
            map.put(insn, savedValues);
            $this$saveStackAndClear.clearStack();
        }

        private final void executeAfterInlineCallMarker(FixStackFrame $this$executeAfterInlineCallMarker, AbstractInsnNode insn) {
            AbstractInsnNode beforeInlineMarker = FixStackAnalyzer.this.getContext().getOpeningInlineMethodMarker().get(insn);
            if ($this$executeAfterInlineCallMarker.getStackSize() > 0) {
                BasicValue returnValue = $this$executeAfterInlineCallMarker.pop();
                $this$executeAfterInlineCallMarker.clearStack();
                Map map = this.spilledStacks;
                boolean bl = false;
                List savedValues = (List)map.get(beforeInlineMarker);
                Intrinsics.checkNotNull((Object)savedValues);
                $this$executeAfterInlineCallMarker.pushAll(savedValues);
                $this$executeAfterInlineCallMarker.push(returnValue);
            } else {
                Map map = this.spilledStacks;
                boolean bl = false;
                List savedValues = (List)map.get(beforeInlineMarker);
                Intrinsics.checkNotNull((Object)savedValues);
                $this$executeAfterInlineCallMarker.pushAll(savedValues);
            }
        }

        private final void executeRestoreStackInTryCatch(FixStackFrame $this$executeRestoreStackInTryCatch, AbstractInsnNode insn) {
            AbstractInsnNode saveNode = FixStackAnalyzer.this.getContext().getSaveStackMarkerForRestoreMarker().get(insn);
            Map map = this.spilledStacks;
            Intrinsics.checkNotNull((Object)saveNode);
            AbstractInsnNode abstractInsnNode = saveNode;
            boolean bl = false;
            Object v = map.get(abstractInsnNode);
            if (v == null) {
                boolean bl2 = false;
                throw new AssertionError((Object)(this.indexOf(insn) + ": Restore stack is unavailable for " + this.indexOf(saveNode)));
            }
            List savedValues = (List)v;
            $this$executeRestoreStackInTryCatch.pushAll(savedValues);
        }

        private final void executeSaveStackBeforeTry(FixStackFrame $this$executeSaveStackBeforeTry, AbstractInsnNode insn) {
            this.saveStackAndClear($this$executeSaveStackBeforeTry, insn);
        }

        @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0014\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "nLocals", "", "nStack", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;II)V", "extraStack", "Lcom/intellij/util/containers/Stack;", "getExtraStack", "()Lcom/intellij/util/containers/Stack;", "stackSizeWithExtra", "getStackSizeWithExtra", "()I", "clearStack", "", "execute", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "getStack", "i", "getStackContent", "", "init", "src", "pop", "push", "value", "pushAll", "values", "", "backend"})
        public final class FixStackFrame
        extends Frame<BasicValue> {
            @NotNull
            private final Stack<BasicValue> extraStack;

            public FixStackFrame(int nLocals, int nStack) {
                Intrinsics.checkNotNullParameter((Object)InternalAnalyzer.this, (String)"this$0");
                super(nLocals, nStack);
                this.extraStack = new Stack();
            }

            @NotNull
            public final Stack<BasicValue> getExtraStack() {
                return this.extraStack;
            }

            @NotNull
            public Frame<BasicValue> init(@NotNull Frame<? extends BasicValue> src) {
                Intrinsics.checkNotNullParameter(src, (String)"src");
                this.extraStack.clear();
                this.extraStack.addAll((Collection)((FixStackFrame)src).extraStack);
                Frame frame = super.init(src);
                Intrinsics.checkNotNullExpressionValue((Object)frame, (String)"super.init(src)");
                return frame;
            }

            public void clearStack() {
                this.extraStack.clear();
                super.clearStack();
            }

            public void execute(@NotNull AbstractInsnNode insn, @NotNull Interpreter<BasicValue> interpreter) {
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Intrinsics.checkNotNullParameter(interpreter, (String)"interpreter");
                if (PseudoInsn.SAVE_STACK_BEFORE_TRY.isa(insn)) {
                    InternalAnalyzer.this.executeSaveStackBeforeTry(this, insn);
                } else if (PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.isa(insn)) {
                    InternalAnalyzer.this.executeRestoreStackInTryCatch(this, insn);
                } else if (InlineCodegenUtilsKt.isBeforeInlineMarker(insn)) {
                    InternalAnalyzer.this.executeBeforeInlineCallMarker(this, insn);
                } else if (InlineCodegenUtilsKt.isAfterInlineMarker(insn)) {
                    InternalAnalyzer.this.executeAfterInlineCallMarker(this, insn);
                } else if (InlineCodegenUtilsKt.isMarkedReturn(insn) && insn.getOpcode() == 177) {
                    return;
                }
                super.execute(insn, interpreter);
            }

            public final int getStackSizeWithExtra() {
                return super.getStackSize() + this.extraStack.size();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<BasicValue> getStackContent() {
                boolean bl = false;
                ArrayList savedStack = new ArrayList();
                Iterable $this$mapTo$iv = (Iterable)new IntRange(0, super.getStackSize() - 1);
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv;
                    int n = item$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = savedStack;
                    boolean bl2 = false;
                    BasicValue basicValue = (BasicValue)super.getStack((int)it);
                    collection.add(basicValue);
                }
                savedStack.addAll((Collection)this.extraStack);
                return savedStack;
            }

            public void push(@NotNull BasicValue value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                if (super.getStackSize() < this.getMaxStackSize()) {
                    super.push((Value)value2);
                } else {
                    this.extraStack.add((Object)value2);
                    int n = InternalAnalyzer.this.getMaxExtraStackSize();
                    int n2 = this.extraStack.size();
                    boolean bl = false;
                    InternalAnalyzer.this.maxExtraStackSize = Math.max(n, n2);
                }
            }

            public final void pushAll(@NotNull Collection<? extends BasicValue> values) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                Iterable $this$forEach$iv = values;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BasicValue it = (BasicValue)element$iv;
                    boolean bl = false;
                    this.push(it);
                }
            }

            @NotNull
            public BasicValue pop() {
                BasicValue basicValue;
                Object object = (Collection)this.extraStack;
                boolean bl = false;
                if (!object.isEmpty()) {
                    object = this.extraStack.pop();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    extraStack.pop()\n                }");
                    basicValue = (BasicValue)object;
                } else {
                    object = super.pop();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    super.pop()\n                }");
                    basicValue = (BasicValue)object;
                }
                return basicValue;
            }

            @NotNull
            public BasicValue getStack(int i) {
                BasicValue basicValue;
                if (i < super.getMaxStackSize()) {
                    Value value2 = super.getStack(i);
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"{\n                    super.getStack(i)\n                }");
                    basicValue = (BasicValue)value2;
                } else {
                    Object object = this.extraStack.get(i - this.getMaxStackSize());
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    extraStack[i - maxStackSize]\n                }");
                    basicValue = (BasicValue)object;
                }
                return basicValue;
            }
        }
    }
}

