/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.DebugInfoDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory0;
import org.jetbrains.kotlin.checkers.utils.DebugInfoUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/checkers/CheckerDebugInfoReporter;", "Lorg/jetbrains/kotlin/checkers/utils/DebugInfoUtil$DebugInfoReporter;", "dynamicCallDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "markDynamicCalls", "", "debugAnnotations", "Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "withNewInference", "platform", "", "(Ljava/util/List;ZLjava/util/List;ZLjava/lang/String;)V", "newDiagnostic", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "factory", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory0;", "reportDynamicCall", "declarationDescriptor", "reportElementWithErrorType", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "reportMissingUnresolved", "reportUnresolvedWithTarget", "target", "frontend"})
public final class CheckerDebugInfoReporter
extends DebugInfoUtil.DebugInfoReporter {
    @NotNull
    private final List<DeclarationDescriptor> dynamicCallDescriptors;
    private final boolean markDynamicCalls;
    @NotNull
    private final List<ActualDiagnostic> debugAnnotations;
    private final boolean withNewInference;
    @Nullable
    private final String platform;

    public CheckerDebugInfoReporter(@NotNull List<DeclarationDescriptor> dynamicCallDescriptors, boolean markDynamicCalls, @NotNull List<ActualDiagnostic> debugAnnotations, boolean withNewInference, @Nullable String platform) {
        Intrinsics.checkNotNullParameter(dynamicCallDescriptors, (String)"dynamicCallDescriptors");
        Intrinsics.checkNotNullParameter(debugAnnotations, (String)"debugAnnotations");
        this.dynamicCallDescriptors = dynamicCallDescriptors;
        this.markDynamicCalls = markDynamicCalls;
        this.debugAnnotations = debugAnnotations;
        this.withNewInference = withNewInference;
        this.platform = platform;
    }

    @Override
    public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.newDiagnostic(expression2, DebugInfoDiagnosticFactory0.Companion.getELEMENT_WITH_ERROR_TYPE());
    }

    @Override
    public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.newDiagnostic(expression2, DebugInfoDiagnosticFactory0.Companion.getMISSING_UNRESOLVED());
    }

    @Override
    public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.newDiagnostic(expression2, DebugInfoDiagnosticFactory0.Companion.getUNRESOLVED_WITH_TARGET());
    }

    @Override
    public void reportDynamicCall(@NotNull KtElement element, @NotNull DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"declarationDescriptor");
        this.dynamicCallDescriptors.add(declarationDescriptor);
        if (this.markDynamicCalls) {
            this.newDiagnostic(element, DebugInfoDiagnosticFactory0.Companion.getDYNAMIC());
        }
    }

    private final void newDiagnostic(KtElement element, DebugInfoDiagnosticFactory0 factory2) {
        this.debugAnnotations.add(new ActualDiagnostic(new DebugInfoDiagnostic(element, (DiagnosticFactory)factory2), this.platform, this.withNewInference));
    }
}

