/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.inline.FunctionInliningKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "SharedVariablesTransformer", "ir.backend.common"})
public final class SharedVariablesLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;

    public SharedVariablesLowering(@NotNull BackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        if (container2 instanceof IrFunction || container2 instanceof IrField || container2 instanceof IrAnonymousInitializer) {
            new SharedVariablesTransformer(irBody, container2).lowerSharedVariables();
        }
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering$SharedVariablesTransformer;", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "irDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;Lorg/jetbrains/kotlin/ir/expressions/IrBody;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getIrBody", "()Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "getIrDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "sharedVariables", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "collectSharedVariables", "", "lowerSharedVariables", "rewriteSharedVariables", "ir.backend.common"})
    private final class SharedVariablesTransformer {
        @NotNull
        private final IrBody irBody;
        @NotNull
        private final IrDeclaration irDeclaration;
        @NotNull
        private final HashSet<IrVariable> sharedVariables;

        public SharedVariablesTransformer(@NotNull IrBody irBody, IrDeclaration irDeclaration2) {
            Intrinsics.checkNotNullParameter((Object)SharedVariablesLowering.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
            Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
            this.irBody = irBody;
            this.irDeclaration = irDeclaration2;
            this.sharedVariables = new HashSet();
        }

        @NotNull
        public final IrBody getIrBody() {
            return this.irBody;
        }

        @NotNull
        public final IrDeclaration getIrDeclaration() {
            return this.irDeclaration;
        }

        public final void lowerSharedVariables() {
            this.collectSharedVariables();
            if (this.sharedVariables.isEmpty()) {
                return;
            }
            this.rewriteSharedVariables();
        }

        private final void collectSharedVariables() {
            boolean bl = false;
            Map skippedFunctionsParents = new LinkedHashMap();
            IrDeclaration irDeclaration2 = this.irDeclaration;
            IrDeclarationParent irDeclarationParent = irDeclaration2 instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)irDeclaration2) : null;
            this.irBody.accept((IrElementVisitor)new IrElementVisitor<Unit, IrDeclarationParent>((Map<IrFunction, IrDeclarationParent>)skippedFunctionsParents, this){
                @NotNull
                private final HashSet<IrVariable> relevantVars;
                @NotNull
                private final HashSet<IrVariable> relevantVals;
                final /* synthetic */ Map<IrFunction, IrDeclarationParent> $skippedFunctionsParents;
                final /* synthetic */ SharedVariablesTransformer this$0;
                {
                    this.$skippedFunctionsParents = $skippedFunctionsParents;
                    this.this$0 = $receiver;
                    this.relevantVars = new HashSet<E>();
                    this.relevantVals = new HashSet<E>();
                }

                @NotNull
                public final HashSet<IrVariable> getRelevantVars() {
                    return this.relevantVars;
                }

                @NotNull
                public final HashSet<IrVariable> getRelevantVals() {
                    return this.relevantVals;
                }

                public void visitElement(@NotNull IrElement element, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    element.acceptChildren(this, data);
                }

                public void visitCall(@NotNull IrCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                    if (!callee.isInline()) {
                        IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
                        return;
                    }
                    Object object = expression2.getDispatchReceiver();
                    if (object != null) {
                        object.accept(this, data);
                    }
                    object = expression2.getExtensionReceiver();
                    if (object != null) {
                        object.accept(this, data);
                    }
                    for (IrValueParameter param : callee.getValueParameters()) {
                        Object object2 = expression2.getValueArgument(param.getIndex());
                        if (object2 == null) continue;
                        IrExpression arg = object2;
                        if (FunctionInliningKt.isInlineParameter$default(param, null, 1, null) && !param.isCrossinline() && arg instanceof IrFunctionExpression) {
                            object2 = this.$skippedFunctionsParents;
                            IrSimpleFunction irSimpleFunction = ((IrFunctionExpression)arg).getFunction();
                            Intrinsics.checkNotNull((Object)data);
                            IrDeclarationParent irDeclarationParent = data;
                            boolean bl = false;
                            object2.put(irSimpleFunction, irDeclarationParent);
                            ((IrFunctionExpression)arg).getFunction().acceptChildren(this, data);
                            this.$skippedFunctionsParents.remove(((IrFunctionExpression)arg).getFunction());
                            continue;
                        }
                        arg.accept(this, data);
                    }
                }

                public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    IrDeclarationParent irDeclarationParent = declaration instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)declaration) : null;
                    IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, irDeclarationParent == null ? data : irDeclarationParent);
                }

                public void visitVariable(@NotNull IrVariable declaration, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    declaration.acceptChildren(this, data);
                    if (declaration.isVar()) {
                        this.relevantVars.add(declaration);
                    } else if (declaration.getInitializer() == null) {
                        this.relevantVals.add(declaration);
                    }
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    expression2.acceptChildren(this, data);
                    IrValueDeclaration value2 = expression2.getSymbol().getOwner();
                    if (CollectionsKt.contains((Iterable)this.relevantVars, (Object)value2) && !Intrinsics.areEqual((Object)this.getRealParent((IrVariable)value2), (Object)data)) {
                        SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(value2);
                    }
                }

                public void visitSetValue(@NotNull IrSetValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data);
                    IrValueDeclaration variable2 = expression2.getSymbol().getOwner();
                    if (variable2 instanceof IrVariable && ((IrVariable)variable2).getInitializer() == null && !Intrinsics.areEqual((Object)this.getRealParent((IrVariable)variable2), (Object)data) && this.relevantVals.contains(variable2)) {
                        SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(variable2);
                    }
                }

                private final IrDeclarationParent getRealParent(IrVariable variable2) {
                    IrDeclarationParent irDeclarationParent = variable2.getParent();
                    Map<IrFunction, IrDeclarationParent> map = this.$skippedFunctionsParents;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrDeclarationParent it = irDeclarationParent;
                    boolean bl3 = false;
                    Map<IrFunction, IrDeclarationParent> map2 = map;
                    boolean bl4 = false;
                    IrDeclarationParent irDeclarationParent2 = map2.get(it);
                    return irDeclarationParent2 == null ? it : irDeclarationParent2;
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
                }

                public void visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBody(@NotNull IrBody body2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBranch(@NotNull IrBranch branch, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBreak(@NotNull IrBreak jump, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitCatch(@NotNull IrCatch aCatch, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitClass(@NotNull IrClass declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitClass(this, declaration, data);
                }

                public void visitClassReference(@NotNull IrClassReference expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitComposite(@NotNull IrComposite expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
                }

                public void visitConstructor(@NotNull IrConstructor declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                public void visitContinue(@NotNull IrContinue jump, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitExpression(@NotNull IrExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
                }

                public void visitField(@NotNull IrField declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitField(this, declaration, data);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitFile(@NotNull IrFile declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFile(this, declaration, data);
                }

                public void visitFunction(@NotNull IrFunction declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFunction(this, declaration, data);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitGetClass(@NotNull IrGetClass expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitGetField(@NotNull IrGetField expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetValue(@NotNull IrGetValue expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitLoop(@NotNull IrLoop loop2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data);
                }

                public void visitProperty(@NotNull IrProperty declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                }

                public void visitReturn(@NotNull IrReturn expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitScript(@NotNull IrScript declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitScript(this, declaration, data);
                }

                public void visitSetField(@NotNull IrSetField expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitThrow(@NotNull IrThrow expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitTry(@NotNull IrTry aTry, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration, data);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data);
                }

                public void visitVararg(@NotNull IrVararg expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitWhen(@NotNull IrWhen expression2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            }, irDeclarationParent == null ? this.irDeclaration.getParent() : irDeclarationParent);
        }

        private final void rewriteSharedVariables() {
            HashMap<IrValueSymbol, IrVariableSymbol> transformedSymbols = new HashMap<IrValueSymbol, IrVariableSymbol>();
            IrElementTransformerVoidKt.transformChildrenVoid(this.irBody, new IrElementTransformerVoid(this, SharedVariablesLowering.this, transformedSymbols){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ SharedVariablesLowering this$1;
                final /* synthetic */ HashMap<IrValueSymbol, IrVariableSymbol> $transformedSymbols;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$transformedSymbols = $transformedSymbols;
                }

                @NotNull
                public IrStatement visitVariable(@NotNull IrVariable declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                    if (!SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).contains(declaration)) {
                        return declaration;
                    }
                    IrVariable newDeclaration = this.this$1.getContext().getSharedVariablesManager().declareSharedVariable(declaration);
                    newDeclaration.setParent(declaration.getParent());
                    Map map = this.$transformedSymbols;
                    IrVariableSymbol irVariableSymbol = declaration.getSymbol();
                    IrVariableSymbol irVariableSymbol2 = newDeclaration.getSymbol();
                    boolean bl = false;
                    map.put(irVariableSymbol, irVariableSymbol2);
                    return this.this$1.getContext().getSharedVariablesManager().defineSharedValue(declaration, newDeclaration);
                }
            });
            IrElementTransformerVoidKt.transformChildrenVoid(this.irBody, new IrElementTransformerVoid(SharedVariablesLowering.this, transformedSymbols, this){
                final /* synthetic */ SharedVariablesLowering this$0;
                final /* synthetic */ HashMap<IrValueSymbol, IrVariableSymbol> $transformedSymbols;
                final /* synthetic */ SharedVariablesTransformer this$1;
                {
                    this.this$0 = $receiver;
                    this.$transformedSymbols = $transformedSymbols;
                    this.this$1 = $receiver2;
                }

                @NotNull
                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.getContext().getSharedVariablesManager().getSharedValue(newDeclaration, expression2);
                }

                @NotNull
                public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.getContext().getSharedVariablesManager().setSharedValue(newDeclaration, expression2);
                }

                private final IrVariableSymbol getTransformedSymbol(IrValueSymbol oldSymbol) {
                    Map map = this.$transformedSymbols;
                    SharedVariablesTransformer sharedVariablesTransformer = this.this$1;
                    boolean bl = false;
                    V v = map.get(oldSymbol);
                    if (v == null) {
                        boolean bl2 = false;
                        boolean bl3 = !CollectionsKt.contains((Iterable)SharedVariablesTransformer.access$getSharedVariables$p(sharedVariablesTransformer), (Object)oldSymbol.getOwner());
                        boolean bl4 = false;
                        if (_Assertions.ENABLED && !bl3) {
                            boolean bl5 = false;
                            String string2 = Intrinsics.stringPlus((String)"Shared variable is not transformed: ", (Object)DumpIrTreeKt.dump$default(oldSymbol.getOwner(), false, 1, null));
                            throw (Throwable)((Object)new AssertionError((Object)string2));
                        }
                        v = null;
                    }
                    return (IrVariableSymbol)v;
                }
            });
        }

        public static final /* synthetic */ HashSet access$getSharedVariables$p(SharedVariablesTransformer $this) {
            return $this.sharedVariables;
        }
    }
}

