/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "assignedNames", "Lcom/google/common/collect/SetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "currentDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "hasWriters", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "visitBinaryExpression", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitDeclaration", "declaration", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "writers", "", "Writer", "frontend"})
public abstract class AssignedVariablesSearcher
extends KtTreeVisitorVoid {
    @NotNull
    private final SetMultimap<Name, Writer> assignedNames;
    @Nullable
    private KtDeclaration currentDeclaration;

    public AssignedVariablesSearcher() {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap, (String)"create()");
        this.assignedNames = (SetMultimap)linkedHashMultimap;
    }

    @NotNull
    public Set<Writer> writers(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Set set = this.assignedNames.get((Object)variableDescriptor.getName());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"assignedNames[variableDescriptor.name]");
        return set;
    }

    public final boolean hasWriters(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Collection collection = this.writers(variableDescriptor);
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Override
    public void visitDeclaration(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtDeclaration previous = this.currentDeclaration;
        if (declaration instanceof KtDeclarationWithBody || declaration instanceof KtClassOrObject || declaration instanceof KtAnonymousInitializer) {
            this.currentDeclaration = declaration;
        }
        super.visitDeclaration(declaration);
        this.currentDeclaration = previous;
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        KtDeclaration previous = this.currentDeclaration;
        this.currentDeclaration = lambdaExpression.getFunctionLiteral();
        super.visitLambdaExpression(lambdaExpression);
        this.currentDeclaration = previous;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression) {
        KtExpression left;
        Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
        if (binaryExpression.getOperationToken() == KtTokens.EQ && (left = KtPsiUtil.deparenthesize(binaryExpression.getLeft())) instanceof KtNameReferenceExpression) {
            this.assignedNames.put((Object)((KtNameReferenceExpression)left).getReferencedNameAsName(), (Object)new Writer(binaryExpression, this.currentDeclaration));
        }
        super.visitBinaryExpression(binaryExpression);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "", "assignment", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "getAssignment", "()Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtDeclaration;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class Writer {
        @NotNull
        private final KtBinaryExpression assignment;
        @Nullable
        private final KtDeclaration declaration;

        public Writer(@NotNull KtBinaryExpression assignment, @Nullable KtDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
            this.assignment = assignment;
            this.declaration = declaration;
        }

        @NotNull
        public final KtBinaryExpression getAssignment() {
            return this.assignment;
        }

        @Nullable
        public final KtDeclaration getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final KtBinaryExpression component1() {
            return this.assignment;
        }

        @Nullable
        public final KtDeclaration component2() {
            return this.declaration;
        }

        @NotNull
        public final Writer copy(@NotNull KtBinaryExpression assignment, @Nullable KtDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
            return new Writer(assignment, declaration);
        }

        public static /* synthetic */ Writer copy$default(Writer writer, KtBinaryExpression ktBinaryExpression, KtDeclaration ktDeclaration, int n, Object object) {
            if ((n & 1) != 0) {
                ktBinaryExpression = writer.assignment;
            }
            if ((n & 2) != 0) {
                ktDeclaration = writer.declaration;
            }
            return writer.copy(ktBinaryExpression, ktDeclaration);
        }

        @NotNull
        public String toString() {
            return "Writer(assignment=" + this.assignment + ", declaration=" + this.declaration + ')';
        }

        public int hashCode() {
            int result2 = this.assignment.hashCode();
            result2 = result2 * 31 + (this.declaration == null ? 0 : this.declaration.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Writer)) {
                return false;
            }
            Writer writer = (Writer)other;
            if (!Intrinsics.areEqual((Object)this.assignment, (Object)writer.assignment)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.declaration, (Object)writer.declaration);
        }
    }
}

