/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/VolatileAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class VolatileAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Object object;
        AnnotationDescriptor delegateAnnotation;
        Object object2;
        AnnotationDescriptor fieldAnnotation;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        FieldDescriptor fieldDescriptor = ((PropertyDescriptor)descriptor2).getBackingField();
        AnnotationDescriptor annotationDescriptor = fieldDescriptor == null ? null : (fieldAnnotation = (object2 = fieldDescriptor.getAnnotations()) == null ? null : object2.findAnnotation(JvmAnnotationUtilKt.VOLATILE_ANNOTATION_FQ_NAME));
        if (fieldAnnotation != null && !((PropertyDescriptor)descriptor2).isVar()) {
            object2 = DescriptorToSourceUtils.getSourceFromAnnotation(fieldAnnotation);
            if (object2 == null) {
                return;
            }
            Object annotationEntry = object2;
            context2.getTrace().report(ErrorsJvm.VOLATILE_ON_VALUE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
        AnnotationDescriptor annotationDescriptor2 = (object2 = ((PropertyDescriptor)descriptor2).getDelegateField()) == null ? null : (delegateAnnotation = (object = object2.getAnnotations()) == null ? null : object.findAnnotation(JvmAnnotationUtilKt.VOLATILE_ANNOTATION_FQ_NAME));
        if (delegateAnnotation != null) {
            object = DescriptorToSourceUtils.getSourceFromAnnotation(delegateAnnotation);
            if (object == null) {
                return;
            }
            Object annotationEntry = object;
            context2.getTrace().report(ErrorsJvm.VOLATILE_ON_DELEGATE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
    }
}

