/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.CoroutineCompatibilitySupport;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00102\u00020\u0001:\u0007\u000f\u0010\u0011\u0012\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "ClassifierUsage", "Companion", "Experimentality", "ExperimentalityDiagnostic", "ExperimentalityDiagnostic2", "ExperimentalityDiagnostics", "Overrides", "frontend"})
public final class ExperimentalUsageChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private static final FqName OLD_EXPERIMENTAL_FQ_NAME = new FqName("kotlin.Experimental");
    @NotNull
    private static final FqName OLD_USE_EXPERIMENTAL_FQ_NAME = new FqName("kotlin.UseExperimental");
    @NotNull
    private static final FqName REQUIRES_OPT_IN_FQ_NAME = new FqName("kotlin.RequiresOptIn");
    @NotNull
    private static final FqName OPT_IN_FQ_NAME = new FqName("kotlin.OptIn");
    @NotNull
    private static final Set<FqName> EXPERIMENTAL_FQ_NAMES;
    @NotNull
    private static final Set<FqName> USE_EXPERIMENTAL_FQ_NAMES;
    @NotNull
    private static final FqName WAS_EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final Name USE_EXPERIMENTAL_ANNOTATION_CLASS;
    @NotNull
    private static final Name WAS_EXPERIMENTAL_ANNOTATION_CLASS;
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;
    @NotNull
    private static final Name WARNING_LEVEL;
    @NotNull
    private static final Name ERROR_LEVEL;
    @NotNull
    private static final ExperimentalityDiagnostics USAGE_DIAGNOSTICS;

    public ExperimentalUsageChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"resolvedCall.resultingDescriptor");
        Set<Experimentality> experimentalities = Companion.loadExperimentalities((DeclarationDescriptor)obj, this.moduleAnnotationsResolver, context2.getLanguageVersionSettings());
        Companion.reportNotAcceptedExperimentalities((Collection<Experimentality>)experimentalities, reportOn, context2);
    }

    static {
        Object object = new FqName[]{Companion.getOLD_EXPERIMENTAL_FQ_NAME(), Companion.getREQUIRES_OPT_IN_FQ_NAME()};
        EXPERIMENTAL_FQ_NAMES = SetsKt.setOf((Object[])object);
        object = new FqName[]{Companion.getOLD_USE_EXPERIMENTAL_FQ_NAME(), Companion.getOPT_IN_FQ_NAME()};
        USE_EXPERIMENTAL_FQ_NAMES = SetsKt.setOf((Object[])object);
        WAS_EXPERIMENTAL_FQ_NAME = new FqName("kotlin.WasExperimental");
        object = Name.identifier("markerClass");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"markerClass\")");
        USE_EXPERIMENTAL_ANNOTATION_CLASS = object;
        object = Name.identifier("markerClass");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"markerClass\")");
        WAS_EXPERIMENTAL_ANNOTATION_CLASS = object;
        object = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"level\")");
        LEVEL = object;
        object = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"message\")");
        MESSAGE = object;
        object = Name.identifier("WARNING");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"WARNING\")");
        WARNING_LEVEL = object;
        object = Name.identifier("ERROR");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"ERROR\")");
        ERROR_LEVEL = object;
        object = Errors.EXPERIMENTAL_API_USAGE;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EXPERIMENTAL_API_USAGE");
        ExperimentalityDiagnostic experimentalityDiagnostic = new ExperimentalityDiagnostic2((DiagnosticFactory2<PsiElement, FqName, String>)object, Companion.getDefaultDiagnosticMessage$frontend("This declaration is experimental and its usage should be marked"));
        object = Errors.EXPERIMENTAL_API_USAGE_ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EXPERIMENTAL_API_USAGE_ERROR");
        USAGE_DIAGNOSTICS = new ExperimentalityDiagnostics(experimentalityDiagnostic, new ExperimentalityDiagnostic2((DiagnosticFactory2<PsiElement, FqName, String>)object, Companion.getDefaultDiagnosticMessage$frontend("This declaration is experimental and its usage must be marked")));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality;", "", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "severity", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "message", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;Ljava/lang/String;)V", "getAnnotationFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getMessage", "()Ljava/lang/String;", "getSeverity", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "Severity", "frontend"})
    public static final class Experimentality {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FqName annotationFqName;
        @NotNull
        private final Severity severity;
        @Nullable
        private final String message;
        @NotNull
        private static final Severity DEFAULT_SEVERITY = Severity.ERROR;

        public Experimentality(@NotNull FqName annotationFqName, @NotNull Severity severity, @Nullable String message2) {
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            this.annotationFqName = annotationFqName;
            this.severity = severity;
            this.message = message2;
        }

        @NotNull
        public final FqName getAnnotationFqName() {
            return this.annotationFqName;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final FqName component1() {
            return this.annotationFqName;
        }

        @NotNull
        public final Severity component2() {
            return this.severity;
        }

        @Nullable
        public final String component3() {
            return this.message;
        }

        @NotNull
        public final Experimentality copy(@NotNull FqName annotationFqName, @NotNull Severity severity, @Nullable String message2) {
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return new Experimentality(annotationFqName, severity, message2);
        }

        public static /* synthetic */ Experimentality copy$default(Experimentality experimentality, FqName fqName2, Severity severity, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = experimentality.annotationFqName;
            }
            if ((n & 2) != 0) {
                severity = experimentality.severity;
            }
            if ((n & 4) != 0) {
                string2 = experimentality.message;
            }
            return experimentality.copy(fqName2, severity, string2);
        }

        @NotNull
        public String toString() {
            return "Experimentality(annotationFqName=" + this.annotationFqName + ", severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ')';
        }

        public int hashCode() {
            int result2 = this.annotationFqName.hashCode();
            result2 = result2 * 31 + this.severity.hashCode();
            result2 = result2 * 31 + (this.message == null ? 0 : this.message.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Experimentality)) {
                return false;
            }
            Experimentality experimentality = (Experimentality)other;
            if (!Intrinsics.areEqual((Object)this.annotationFqName, (Object)experimentality.annotationFqName)) {
                return false;
            }
            if (this.severity != experimentality.severity) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)experimentality.message);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "frontend"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING = new Severity();
            public static final /* enum */ Severity ERROR = new Severity();
            private static final /* synthetic */ Severity[] $VALUES;

            public static Severity[] values() {
                Severity[] severityArray = $VALUES;
                Severity[] severityArray2 = new Severity[severityArray.length];
                System.arraycopy(severityArray, 0, severityArray2, 0, severityArray.length);
                return severityArray2;
            }

            public static Severity valueOf(String value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return Enum.valueOf(Severity.class, value2);
            }

            static {
                Severity[] severityArray = new Severity[]{WARNING, ERROR};
                $VALUES = severityArray;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Companion;", "", "()V", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "", "frontend"})
    public static interface ExperimentalityDiagnostic {
        public void report(@NotNull BindingTrace var1, @NotNull PsiElement var2, @NotNull FqName var3, @Nullable String var4);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic2;", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/name/FqName;", "", "defaultMessage", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;Lkotlin/jvm/functions/Function1;)V", "getDefaultMessage", "()Lkotlin/jvm/functions/Function1;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "message", "frontend"})
    public static final class ExperimentalityDiagnostic2
    implements ExperimentalityDiagnostic {
        @NotNull
        private final DiagnosticFactory2<PsiElement, FqName, String> factory;
        @NotNull
        private final Function1<FqName, String> defaultMessage;

        public ExperimentalityDiagnostic2(@NotNull DiagnosticFactory2<PsiElement, FqName, String> factory2, @NotNull Function1<? super FqName, String> defaultMessage) {
            Intrinsics.checkNotNullParameter(factory2, (String)"factory");
            Intrinsics.checkNotNullParameter(defaultMessage, (String)"defaultMessage");
            this.factory = factory2;
            this.defaultMessage = defaultMessage;
        }

        @NotNull
        public final DiagnosticFactory2<PsiElement, FqName, String> getFactory() {
            return this.factory;
        }

        @NotNull
        public final Function1<FqName, String> getDefaultMessage() {
            return this.defaultMessage;
        }

        @Override
        public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName2, @Nullable String message2) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            String string2 = message2;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = this.factory.on(element, fqName2, string2 == null ? (String)this.defaultMessage.invoke((Object)fqName2) : string2);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"factory.on(element, fqName, message ?: defaultMessage(fqName))");
            DiagnosticUtilsKt.reportDiagnosticOnce(trace, parametrizedDiagnostic);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "", "warning", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "error", "(Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;)V", "getError", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "getWarning", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class ExperimentalityDiagnostics {
        @NotNull
        private final ExperimentalityDiagnostic warning;
        @NotNull
        private final ExperimentalityDiagnostic error;

        public ExperimentalityDiagnostics(@NotNull ExperimentalityDiagnostic warning, @NotNull ExperimentalityDiagnostic error) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.warning = warning;
            this.error = error;
        }

        @NotNull
        public final ExperimentalityDiagnostic getWarning() {
            return this.warning;
        }

        @NotNull
        public final ExperimentalityDiagnostic getError() {
            return this.error;
        }

        @NotNull
        public final ExperimentalityDiagnostic component1() {
            return this.warning;
        }

        @NotNull
        public final ExperimentalityDiagnostic component2() {
            return this.error;
        }

        @NotNull
        public final ExperimentalityDiagnostics copy(@NotNull ExperimentalityDiagnostic warning, @NotNull ExperimentalityDiagnostic error) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new ExperimentalityDiagnostics(warning, error);
        }

        public static /* synthetic */ ExperimentalityDiagnostics copy$default(ExperimentalityDiagnostics experimentalityDiagnostics, ExperimentalityDiagnostic experimentalityDiagnostic, ExperimentalityDiagnostic experimentalityDiagnostic2, int n, Object object) {
            if ((n & 1) != 0) {
                experimentalityDiagnostic = experimentalityDiagnostics.warning;
            }
            if ((n & 2) != 0) {
                experimentalityDiagnostic2 = experimentalityDiagnostics.error;
            }
            return experimentalityDiagnostics.copy(experimentalityDiagnostic, experimentalityDiagnostic2);
        }

        @NotNull
        public String toString() {
            return "ExperimentalityDiagnostics(warning=" + this.warning + ", error=" + this.error + ')';
        }

        public int hashCode() {
            int result2 = this.warning.hashCode();
            result2 = result2 * 31 + this.error.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExperimentalityDiagnostics)) {
                return false;
            }
            ExperimentalityDiagnostics experimentalityDiagnostics = (ExperimentalityDiagnostics)other;
            if (!Intrinsics.areEqual((Object)this.warning, (Object)experimentalityDiagnostics.warning)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)experimentalityDiagnostics.error);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\"0(2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\"0(J!\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)0(2\u0006\u0010,\u001a\u00020)H\u0000\u00a2\u0006\u0002\b-J4\u0010.\u001a\u00020\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u0002032\u0006\u0010%\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0016J$\u0010.\u001a\u00020\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u000208J0\u00109\u001a\u00020:*\u0002032!\u0010;\u001a\u001d\u0012\u0013\u0012\u001103\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020:0(H\u0082\bJ\u001c\u0010>\u001a\u00020:*\u0002032\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020AH\u0002J\u001c\u0010B\u001a\u00020:*\u0002032\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020AH\u0002J\"\u0010C\u001a\u00020:*\u0002032\u0006\u0010?\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010@\u001a\u00020AJ\u001c\u0010C\u001a\u00020:*\u0002032\u0006\u0010?\u001a\u00020\u00072\u0006\u00107\u001a\u000208H\u0002J \u0010D\u001a\b\u0012\u0004\u0012\u0002010\u0006*\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010%\u001a\u00020&J\u0013\u0010H\u001a\u0004\u0018\u000101*\u00020IH\u0000\u00a2\u0006\u0002\bJR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0014\u0010\u001f\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000e\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Companion;", "", "()V", "ERROR_LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "EXPERIMENTAL_FQ_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "getEXPERIMENTAL_FQ_NAMES", "()Ljava/util/Set;", "LEVEL", "MESSAGE", "OLD_EXPERIMENTAL_FQ_NAME", "getOLD_EXPERIMENTAL_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "OLD_USE_EXPERIMENTAL_FQ_NAME", "getOLD_USE_EXPERIMENTAL_FQ_NAME", "OPT_IN_FQ_NAME", "getOPT_IN_FQ_NAME", "REQUIRES_OPT_IN_FQ_NAME", "getREQUIRES_OPT_IN_FQ_NAME", "USAGE_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "USE_EXPERIMENTAL_ANNOTATION_CLASS", "getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend", "()Lorg/jetbrains/kotlin/name/Name;", "USE_EXPERIMENTAL_FQ_NAMES", "getUSE_EXPERIMENTAL_FQ_NAMES", "WARNING_LEVEL", "WAS_EXPERIMENTAL_ANNOTATION_CLASS", "getWAS_EXPERIMENTAL_ANNOTATION_CLASS$frontend", "WAS_EXPERIMENTAL_FQ_NAME", "getWAS_EXPERIMENTAL_FQ_NAME$frontend", "checkCompilerArguments", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "reportError", "Lkotlin/Function1;", "", "reportWarning", "getDefaultDiagnosticMessage", "prefix", "getDefaultDiagnosticMessage$frontend", "reportNotAcceptedExperimentalities", "experimentalities", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality;", "element", "Lcom/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "diagnostics", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "anyParentMatches", "", "predicate", "Lkotlin/ParameterName;", "name", "isDeclarationAnnotatedWith", "annotationFqName", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isElementAnnotatedWithUseExperimentalOf", "isExperimentalityAccepted", "loadExperimentalities", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "loadExperimentalityForMarkerAnnotation$frontend", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getOLD_EXPERIMENTAL_FQ_NAME() {
            return OLD_EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final FqName getOLD_USE_EXPERIMENTAL_FQ_NAME() {
            return OLD_USE_EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final FqName getREQUIRES_OPT_IN_FQ_NAME() {
            return REQUIRES_OPT_IN_FQ_NAME;
        }

        @NotNull
        public final FqName getOPT_IN_FQ_NAME() {
            return OPT_IN_FQ_NAME;
        }

        @NotNull
        public final Set<FqName> getEXPERIMENTAL_FQ_NAMES() {
            return EXPERIMENTAL_FQ_NAMES;
        }

        @NotNull
        public final Set<FqName> getUSE_EXPERIMENTAL_FQ_NAMES() {
            return USE_EXPERIMENTAL_FQ_NAMES;
        }

        @NotNull
        public final FqName getWAS_EXPERIMENTAL_FQ_NAME$frontend() {
            return WAS_EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final Name getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend() {
            return USE_EXPERIMENTAL_ANNOTATION_CLASS;
        }

        @NotNull
        public final Name getWAS_EXPERIMENTAL_ANNOTATION_CLASS$frontend() {
            return WAS_EXPERIMENTAL_ANNOTATION_CLASS;
        }

        @NotNull
        public final Function1<FqName, String> getDefaultDiagnosticMessage$frontend(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return (Function1)new Function1<FqName, String>(prefix){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull FqName fqName2) {
                    Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                    return this.$prefix + " with '@" + fqName2.asString() + "' or '@OptIn(" + fqName2.asString() + "::class)'";
                }
            };
        }

        public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull PsiElement element, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter(experimentalities, (String)"experimentalities");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.reportNotAcceptedExperimentalities(experimentalities, element, context2.getLanguageVersionSettings(), context2.getTrace(), USAGE_DIAGNOSTICS);
        }

        public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull PsiElement element, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace, @NotNull ExperimentalityDiagnostics diagnostics2) {
            Intrinsics.checkNotNullParameter(experimentalities, (String)"experimentalities");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)diagnostics2, (String)"diagnostics");
            for (Experimentality experimentality : experimentalities) {
                ExperimentalityDiagnostic experimentalityDiagnostic;
                FqName annotationFqName = experimentality.component1();
                Experimentality.Severity severity = experimentality.component2();
                String message2 = experimentality.component3();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                if (this.isExperimentalityAccepted(element, annotationFqName, languageVersionSettings, bindingContext)) continue;
                Experimentality.Severity severity2 = severity;
                int n = WhenMappings.$EnumSwitchMapping$0[severity2.ordinal()];
                switch (n) {
                    case 1: {
                        experimentalityDiagnostic = diagnostics2.getWarning();
                        break;
                    }
                    case 2: {
                        experimentalityDiagnostic = diagnostics2.getError();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ExperimentalityDiagnostic diagnostic = experimentalityDiagnostic;
                diagnostic.report(trace, element, annotationFqName, message2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Experimentality> loadExperimentalities(@NotNull DeclarationDescriptor $this$loadExperimentalities, @NotNull ModuleAnnotationsResolver moduleAnnotationsResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
            DeclarationDescriptor container2;
            SinceKotlinAccessibility accessibility;
            boolean bl;
            SmartSet result2;
            block8: {
                Intrinsics.checkNotNullParameter((Object)$this$loadExperimentalities, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)moduleAnnotationsResolver, (String)"moduleAnnotationsResolver");
                Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
                result2 = SmartSet.Companion.create();
                for (AnnotationDescriptor annotation2 : $this$loadExperimentalities.getAnnotations()) {
                    ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getAnnotationClass(annotation2);
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor2 == null ? null : this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor2));
                }
                Iterable $this$any$iv = $this$loadExperimentalities.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)this.getWAS_EXPERIMENTAL_FQ_NAME$frontend())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl && (accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility($this$loadExperimentalities, languageVersionSettings)) instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object element$iv;
                Iterable $i$f$any = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
                SmartSet smartSet = result2;
                boolean $i$f$mapNotNull = false;
                element$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Experimentality experimentality;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    ClassDescriptor it = (ClassDescriptor)element$iv$iv;
                    boolean bl4 = false;
                    if (this.loadExperimentalityForMarkerAnnotation$frontend(it) == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Experimentality it$iv$iv = experimentality;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                smartSet.addAll(list2);
            }
            if ((container2 = $this$loadExperimentalities.getContainingDeclaration()) instanceof ClassDescriptor && !($this$loadExperimentalities instanceof ConstructorDescriptor)) {
                result2.addAll(this.loadExperimentalities(container2, moduleAnnotationsResolver, languageVersionSettings));
            }
            for (ClassId moduleAnnotationClassId : moduleAnnotationsResolver.getAnnotationsOnContainingModule($this$loadExperimentalities)) {
                ClassDescriptor annotationClass = FindClassInModuleKt.findClassAcrossModuleDependencies(DescriptorUtilsKt.getModule($this$loadExperimentalities), moduleAnnotationClassId);
                ClassDescriptor classDescriptor3 = annotationClass;
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor3 == null ? null : this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor3));
            }
            return result2;
        }

        @Nullable
        public final Experimentality loadExperimentalityForMarkerAnnotation$frontend(@NotNull ClassDescriptor $this$loadExperimentalityForMarkerAnnotation) {
            Name name;
            AnnotationDescriptor annotationDescriptor;
            Intrinsics.checkNotNullParameter((Object)$this$loadExperimentalityForMarkerAnnotation, (String)"<this>");
            AnnotationDescriptor annotationDescriptor2 = $this$loadExperimentalityForMarkerAnnotation.getAnnotations().findAnnotation(this.getREQUIRES_OPT_IN_FQ_NAME());
            if (annotationDescriptor2 == null) {
                AnnotationDescriptor annotationDescriptor3 = $this$loadExperimentalityForMarkerAnnotation.getAnnotations().findAnnotation(this.getOLD_EXPERIMENTAL_FQ_NAME());
                if (annotationDescriptor3 == null) {
                    return null;
                }
                annotationDescriptor = annotationDescriptor3;
            } else {
                annotationDescriptor = annotationDescriptor2;
            }
            AnnotationDescriptor experimental = annotationDescriptor;
            Map<Name, ConstantValue<?>> arguments2 = experimental.getAllValueArguments();
            ConstantValue<?> constantValue = arguments2.get(LEVEL);
            ConstantValue constantValue2 = constantValue instanceof EnumValue ? (EnumValue)constantValue : null;
            Name name2 = name = constantValue2 == null ? null : ((EnumValue)constantValue2).getEnumEntryName();
            Experimentality.Severity severity = Intrinsics.areEqual((Object)name, (Object)WARNING_LEVEL) ? Experimentality.Severity.WARNING : (Intrinsics.areEqual((Object)name, (Object)ERROR_LEVEL) ? Experimentality.Severity.ERROR : Experimentality.Companion.getDEFAULT_SEVERITY());
            constantValue = arguments2.get(MESSAGE);
            constantValue2 = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            String message2 = constantValue2 == null ? null : (String)constantValue2.getValue();
            return new Experimentality(DescriptorUtilsKt.getFqNameSafe($this$loadExperimentalityForMarkerAnnotation), severity, message2);
        }

        private final boolean isExperimentalityAccepted(PsiElement $this$isExperimentalityAccepted, FqName annotationFqName, CheckerContext context2) {
            LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            return this.isExperimentalityAccepted($this$isExperimentalityAccepted, annotationFqName, languageVersionSettings, bindingContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isExperimentalityAccepted(@NotNull PsiElement $this$isExperimentalityAccepted, @NotNull FqName annotationFqName, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)$this$isExperimentalityAccepted, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            if (languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getExperimental()).contains(annotationFqName.asString())) return true;
            if (languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getUseExperimental()).contains(annotationFqName.asString())) return true;
            Companion companion = this;
            PsiElement $this$anyParentMatches$iv = $this$isExperimentalityAccepted;
            boolean $i$f$anyParentMatches = false;
            PsiElement element$iv = $this$anyParentMatches$iv;
            while (true) {
                PsiElement element = element$iv;
                boolean bl = false;
                if (this.isDeclarationAnnotatedWith(element, annotationFqName, bindingContext)) return true;
                if (this.isElementAnnotatedWithUseExperimentalOf(element, annotationFqName, bindingContext)) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) {
                    return true;
                }
                PsiElement psiElement = element$iv.getParent();
                if (psiElement == null) {
                    return false;
                }
                element$iv = psiElement;
            }
        }

        private final boolean isDeclarationAnnotatedWith(PsiElement $this$isDeclarationAnnotatedWith, FqName annotationFqName, BindingContext bindingContext) {
            if (!($this$isDeclarationAnnotatedWith instanceof KtDeclaration)) {
                return false;
            }
            DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $this$isDeclarationAnnotatedWith);
            return descriptor2 != null && !DescriptorUtils.isLocal(descriptor2) && descriptor2.getAnnotations().hasAnnotation(annotationFqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithUseExperimentalOf(PsiElement $this$isElementAnnotatedWithUseExperimentalOf, FqName annotationFqName, BindingContext bindingContext) {
            boolean bl;
            if (!($this$isElementAnnotatedWithUseExperimentalOf instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list2 = ((KtAnnotated)$this$isElementAnnotatedWithUseExperimentalOf).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"annotationEntries");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor2 = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                if (descriptor2 != null && CollectionsKt.contains((Iterable)this.getUSE_EXPERIMENTAL_FQ_NAMES(), (Object)descriptor2.getFqName())) {
                    ConstantValue<?> annotationClasses = descriptor2.getAllValueArguments().get(this.getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend());
                    if (annotationClasses instanceof ArrayValue) {
                        boolean bl3;
                        Iterable $this$any$iv2 = (Iterable)((ArrayValue)annotationClasses).getValue();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ConstantValue annotationClass = (ConstantValue)element$iv2;
                                boolean bl4 = false;
                                if (annotationClass instanceof KClassValue) {
                                    Object t = ((KClassValue)annotationClass).getValue();
                                    boolean bl5 = false;
                                    boolean bl6 = false;
                                    KClassValue.Value value2 = (KClassValue.Value)t;
                                    boolean bl7 = false;
                                    if (value2 instanceof KClassValue.Value.NormalClass && Intrinsics.areEqual((Object)((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName(), (Object)annotationFqName) && ((KClassValue.Value.NormalClass)value2).getArrayDimensions() == 0) {
                                        return true;
                                    }
                                    boolean bl8 = false;
                                    if (bl8) {
                                        return true;
                                    }
                                }
                                boolean bl9 = false;
                                if (!bl9) continue;
                                return true;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final boolean anyParentMatches(PsiElement $this$anyParentMatches, Function1<? super PsiElement, Boolean> predicate) {
            boolean $i$f$anyParentMatches = false;
            PsiElement element = $this$anyParentMatches;
            while (!((Boolean)predicate.invoke((Object)element)).booleanValue()) {
                PsiElement psiElement = element.getParent();
                if (psiElement == null) {
                    return false;
                }
                element = psiElement;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void checkCompilerArguments(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super String, Unit> reportError2, @NotNull Function1<? super String, Unit> reportWarning) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter(reportError2, (String)"reportError");
            Intrinsics.checkNotNullParameter(reportWarning, (String)"reportWarning");
            DeprecationResolver deprecationResolver = new DeprecationResolver(new LockBasedStorageManager("ExperimentalUsageChecker"), languageVersionSettings, CoroutineCompatibilitySupport.Companion.getENABLED(), DeprecationSettings.Default.INSTANCE);
            Iterable $this$filter$iv = languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getExperimental());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String p0 = (String)element$iv$iv;
                boolean bl = false;
                if (!org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.checkCompilerArguments$checkAnnotation(module2, reportWarning, this, deprecationResolver, reportError2, p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validExperimental = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getUseExperimental());
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String fqName2 = (String)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)fqName2, (Object)this.getREQUIRES_OPT_IN_FQ_NAME().asString()) || Intrinsics.areEqual((Object)fqName2, (Object)this.getOLD_EXPERIMENTAL_FQ_NAME().asString()) || org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.checkCompilerArguments$checkAnnotation(module2, reportWarning, this, deprecationResolver, reportError2, fqName2))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List validUseExperimental = (List)destination$iv$iv2;
            for (String fqName3 : CollectionsKt.intersect((Iterable)validExperimental, (Iterable)validUseExperimental)) {
                reportError2.invoke((Object)("'-Xopt-in=" + fqName3 + "' has no effect because '-Xexperimental=" + fqName3 + "' is used"));
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean checkCompilerArguments$checkAnnotation(ModuleDescriptor $module, Function1<? super String, Unit> $reportWarning, Companion this$0, DeprecationResolver $deprecationResolver, Function1<? super String, Unit> $reportError, String fqName2) {
            ClassDescriptor descriptor2 = DescriptorUtilKt.resolveClassByFqName($module, new FqName(fqName2), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
            if (descriptor2 == null) {
                $reportWarning.invoke((Object)("Opt-in requirement marker " + fqName2 + " is unresolved. Please make sure it's present in the module dependencies"));
                return false;
            }
            if (this$0.loadExperimentalityForMarkerAnnotation$frontend(descriptor2) == null) {
                $reportWarning.invoke((Object)("Class " + fqName2 + " is not an opt-in requirement marker"));
                return false;
            }
            for (Deprecation deprecation : $deprecationResolver.getDeprecations(descriptor2)) {
                String string2;
                Function1<? super String, Unit> report2;
                Function1<? super String, Unit> function1;
                Object object = deprecation.getDeprecationLevel();
                int n = WhenMappings.$EnumSwitchMapping$1[object.ordinal()];
                switch (n) {
                    case 1: {
                        function1 = $reportWarning;
                        break;
                    }
                    case 2: 
                    case 3: {
                        function1 = $reportError;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Function1<? super String, Unit> function12 = report2 = function1;
                StringBuilder stringBuilder2 = new StringBuilder().append("Opt-in requirement marker ").append(fqName2).append(" is deprecated");
                object = deprecation.getMessage();
                if (object == null) {
                    string2 = null;
                } else {
                    void it;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object object3 = object2;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    Function1<? super String, Unit> function13 = function12;
                    boolean bl3 = false;
                    String string3 = Intrinsics.stringPlus((String)". ", (Object)it);
                    function12 = function13;
                    stringBuilder2 = stringBuilder3;
                    string2 = string3;
                }
                object = string2;
                n = 0;
                Object object4 = object;
                if (object4 == null) {
                    object4 = "";
                }
                function12.invoke((Object)stringBuilder2.append((String)object4).toString());
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Experimentality.Severity.values().length];
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[DeprecationLevelValue.values().length];
                nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
                nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
                nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\fH\u0002J\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "checkUsageOfKotlinExperimentalOrUseExperimental", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "isUsageAsQualifier", "", "isUsageAsUseExperimentalArgument", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        public ClassifierUsage(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            void $this$getParentOfType$iv;
            ClassDescriptor targetClass;
            Object object;
            Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Name name = targetDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"targetDescriptor.name");
            Name name2 = name;
            if (Intrinsics.areEqual((Object)name2, (Object)Companion.getOLD_EXPERIMENTAL_FQ_NAME().shortName()) || Intrinsics.areEqual((Object)name2, (Object)Companion.getREQUIRES_OPT_IN_FQ_NAME().shortName()) || Intrinsics.areEqual((Object)name2, (Object)Companion.getOLD_USE_EXPERIMENTAL_FQ_NAME().shortName()) || Intrinsics.areEqual((Object)name2, (Object)Companion.getOPT_IN_FQ_NAME().shortName())) {
                FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(targetDescriptor);
                if (Companion.getEXPERIMENTAL_FQ_NAMES().contains(fqName2) || Companion.getUSE_EXPERIMENTAL_FQ_NAMES().contains(fqName2)) {
                    this.checkUsageOfKotlinExperimentalOrUseExperimental(element, context2);
                    return;
                }
            }
            ClassDescriptor classDescriptor2 = (object = targetDescriptor) instanceof ClassDescriptor ? (ClassDescriptor)targetDescriptor : (targetClass = object instanceof TypeAliasDescriptor ? ((TypeAliasDescriptor)targetDescriptor).getClassDescriptor() : null);
            if (targetClass != null && Companion.loadExperimentalityForMarkerAnnotation$frontend(targetClass) != null && !UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element)) {
                object = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace.bindingContext");
                if (!this.isUsageAsUseExperimentalArgument(element, (BindingContext)object)) {
                    context2.getTrace().report(Errors.EXPERIMENTAL_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_USE_EXPERIMENTAL.on(element));
                }
            }
            object = element;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, (boolean)strict$iv) == null) {
                Set<Experimentality> experimentalities = Companion.loadExperimentalities(targetDescriptor, this.moduleAnnotationsResolver, context2.getLanguageVersionSettings());
                Companion.reportNotAcceptedExperimentalities((Collection<Experimentality>)experimentalities, element, context2);
            }
        }

        private final void checkUsageOfKotlinExperimentalOrUseExperimental(PsiElement element, CheckerContext context2) {
            List<String> useExperimentalFqNames = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.INSTANCE.getUseExperimental());
            if (!useExperimentalFqNames.contains(Companion.getREQUIRES_OPT_IN_FQ_NAME().asString()) && !useExperimentalFqNames.contains(Companion.getOLD_EXPERIMENTAL_FQ_NAME().asString())) {
                context2.getTrace().report(Errors.EXPERIMENTAL_IS_NOT_ENABLED.on(element));
            }
            if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsQualifier(element)) {
                context2.getTrace().report(Errors.EXPERIMENTAL_CAN_ONLY_BE_USED_AS_ANNOTATION.on(element));
            }
        }

        private final boolean isUsageAsQualifier(PsiElement $this$isUsageAsQualifier) {
            KtExpression qualifier;
            PsiElement psiElement;
            KtQualifiedExpression ktQualifiedExpression;
            return $this$isUsageAsQualifier instanceof KtSimpleNameExpression && Intrinsics.areEqual((Object)((ktQualifiedExpression = (psiElement = (qualifier = (ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)$this$isUsageAsQualifier)) == null ? (KtExpression)$this$isUsageAsQualifier : (KtExpression)ktQualifiedExpression).getParent()) instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null) == null ? null : ((KtDotQualifiedExpression)ktQualifiedExpression).getReceiverExpression()), (Object)qualifier);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsageAsUseExperimentalArgument(PsiElement $this$isUsageAsUseExperimentalArgument, BindingContext bindingContext) {
            Boolean bl;
            KtQualifiedExpression ktQualifiedExpression;
            KtSimpleNameExpression ktSimpleNameExpression;
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression = $this$isUsageAsUseExperimentalArgument instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)$this$isUsageAsUseExperimentalArgument : null;
            PsiElement qualifier = ktSimpleNameExpression == null ? $this$isUsageAsUseExperimentalArgument : ((ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(ktSimpleNameExpression)) == null ? $this$isUsageAsUseExperimentalArgument : (PsiElement)ktQualifiedExpression);
            PsiElement parent2 = qualifier.getParent();
            if (!(parent2 instanceof KtClassLiteralExpression)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent() instanceof KtValueArgument)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent().getParent() instanceof KtValueArgumentList)) return false;
            ktQualifiedExpression = ((KtClassLiteralExpression)parent2).getParent().getParent().getParent();
            boolean bl2 = false;
            boolean bl3 = false;
            KtQualifiedExpression entry = ktQualifiedExpression;
            boolean bl4 = false;
            if (!(entry instanceof KtAnnotationEntry)) return false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor == null) {
                bl = null;
            } else {
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                boolean bl5 = false;
                boolean bl6 = false;
                AnnotationDescriptor annotation2 = annotationDescriptor2;
                boolean bl7 = false;
                bl = CollectionsKt.contains((Iterable)Companion.getUSE_EXPERIMENTAL_FQ_NAMES(), (Object)annotation2.getFqName()) || Intrinsics.areEqual((Object)annotation2.getFqName(), (Object)Companion.getWAS_EXPERIMENTAL_FQ_NAME$frontend());
            }
            if (!Intrinsics.areEqual(bl, (Object)true)) return false;
            return true;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    public static final class Overrides
    implements DeclarationChecker {
        @NotNull
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        public Overrides(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
            Iterable list$iv$iv22;
            Object object;
            void $this$flatMapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return;
            }
            Object object2 = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(object2, (String)"descriptor.overriddenDescriptors");
            Iterable $this$flatMap$iv = (Iterable)object2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CallableMemberDescriptor member2 = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)member2, (String)"member");
                object = Companion.loadExperimentalities(member2, this.moduleAnnotationsResolver, context2.getLanguageVersionSettings());
                boolean $i$f$map = false;
                void var16_23 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void experimentality;
                    Experimentality experimentality2 = (Experimentality)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)experimentality, (Object)member2);
                    collection.add(pair);
                }
                list$iv$iv22 = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv22);
            }
            Map experimentalOverridden = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            Object object3 = experimentalOverridden;
            boolean $this$flatMapTo$iv$iv2 = false;
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                Pair pair;
                PsiElement psiElement;
                Object element$iv$iv;
                destination$iv$iv = object3 = (Map.Entry)object2.next();
                $i$f$flatMapTo2 = false;
                Experimentality experimentality = (Experimentality)destination$iv$iv.getKey();
                Object $i$f$flatMapTo2 = object3;
                boolean bl = false;
                CallableMemberDescriptor member3 = (CallableMemberDescriptor)$i$f$flatMapTo2.getValue();
                if (Companion.isExperimentalityAccepted(declaration, experimentality.getAnnotationFqName(), context2)) continue;
                Object object4 = element$iv$iv = declaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration : null;
                PsiElement reportOn = psiElement = element$iv$iv == null ? (PsiElement)declaration : ((list$iv$iv22 = element$iv$iv.getNameIdentifier()) == null ? (PsiElement)declaration : list$iv$iv22);
                element$iv$iv = experimentality.getSeverity();
                int list$iv$iv22 = WhenMappings.$EnumSwitchMapping$0[((Enum)element$iv$iv).ordinal()];
                switch (list$iv$iv22) {
                    case 1: {
                        pair = TuplesKt.to(Errors.EXPERIMENTAL_OVERRIDE, (Object)"should");
                        break;
                    }
                    case 2: {
                        pair = TuplesKt.to(Errors.EXPERIMENTAL_OVERRIDE_ERROR, (Object)"must");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                psiElement = pair;
                DiagnosticFactory2 diagnostic = (DiagnosticFactory2)psiElement.component1();
                String defaultMessageVerb = (String)psiElement.component2();
                object = experimentality.getMessage();
                Object message2 = object == null ? "This declaration overrides experimental member of supertype '" + member3.getContainingDeclaration().getName().asString() + "' and " + defaultMessageVerb + " be annotated with '@" + experimentality.getAnnotationFqName().asString() + '\'' : object;
                context2.getTrace().report(diagnostic.on(reportOn, experimentality.getAnnotationFqName(), message2));
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Experimentality.Severity.values().length];
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

