/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils.mutator;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.Mutator;

public final class LastExpressionMutator {
    @NotNull
    private final Mutator mutator;

    public static JsStatement mutateLastExpression(@NotNull JsNode node, @NotNull Mutator mutator) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$1(0);
        }
        if (mutator == null) {
            LastExpressionMutator.$$$reportNull$$$1(1);
        }
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(0);
        }
        if (mutator == null) {
            LastExpressionMutator.$$$reportNull$$$0(1);
        }
        return JsAstUtils.convertToStatement(new LastExpressionMutator(mutator).apply(node));
    }

    private LastExpressionMutator(@NotNull Mutator mutator) {
        if (mutator == null) {
            LastExpressionMutator.$$$reportNull$$$1(2);
        }
        if (mutator == null) {
            LastExpressionMutator.$$$reportNull$$$0(2);
        }
        this.mutator = mutator;
    }

    @NotNull
    private JsNode apply(@NotNull JsNode node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$1(3);
        }
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(3);
        }
        if (node instanceof JsBlock) {
            return this.applyToBlock((JsBlock)node);
        }
        if (node instanceof JsIf) {
            return this.applyToIf((JsIf)node);
        }
        if (node instanceof JsTry) {
            return this.applyToTry((JsTry)node);
        }
        if (node instanceof JsExpressionStatement) {
            return this.applyToStatement((JsExpressionStatement)node);
        }
        if (node instanceof JsSwitch) {
            return this.applyToSwitch((JsSwitch)node);
        }
        JsNode jsNode = this.mutator.mutate(node);
        if (jsNode == null) {
            LastExpressionMutator.$$$reportNull$$$0(4);
        }
        if (jsNode == null) {
            LastExpressionMutator.$$$reportNull$$$1(4);
        }
        return jsNode;
    }

    @NotNull
    private JsNode applyToStatement(@NotNull JsExpressionStatement node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$1(5);
        }
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(5);
        }
        JsStatement jsStatement = JsAstUtils.convertToStatement(this.apply(node.getExpression()));
        if (jsStatement == null) {
            LastExpressionMutator.$$$reportNull$$$0(6);
        }
        if (jsStatement == null) {
            LastExpressionMutator.$$$reportNull$$$1(6);
        }
        return jsStatement;
    }

    @NotNull
    private JsNode applyToIf(@NotNull JsIf node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$1(7);
        }
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(7);
        }
        node.setThenStatement(JsAstUtils.convertToStatement(this.apply(node.getThenStatement())));
        JsStatement elseStmt = node.getElseStatement();
        if (elseStmt != null) {
            node.setElseStatement(JsAstUtils.convertToStatement(this.apply(elseStmt)));
        }
        JsIf jsIf = node;
        if (jsIf == null) {
            LastExpressionMutator.$$$reportNull$$$0(8);
        }
        if (jsIf == null) {
            LastExpressionMutator.$$$reportNull$$$1(8);
        }
        return jsIf;
    }

    @NotNull
    private JsNode applyToTry(@NotNull JsTry node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$1(9);
        }
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(9);
        }
        this.applyToBlock(node.getTryBlock());
        for (JsCatch jsCatch : node.getCatches()) {
            this.applyToBlock(jsCatch.getBody());
        }
        JsTry jsTry = node;
        if (jsTry == null) {
            LastExpressionMutator.$$$reportNull$$$0(10);
        }
        if (jsTry == null) {
            LastExpressionMutator.$$$reportNull$$$1(10);
        }
        return jsTry;
    }

    @NotNull
    private JsNode applyToBlock(@NotNull JsBlock node) {
        List<JsStatement> statements2;
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$1(11);
        }
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(11);
        }
        if ((statements2 = node.getStatements()).isEmpty()) {
            JsBlock jsBlock = node;
            if (jsBlock == null) {
                LastExpressionMutator.$$$reportNull$$$0(12);
            }
            if (jsBlock == null) {
                LastExpressionMutator.$$$reportNull$$$1(12);
            }
            return jsBlock;
        }
        int size2 = statements2.size();
        statements2.set(size2 - 1, JsAstUtils.convertToStatement(this.apply(statements2.get(size2 - 1))));
        JsBlock jsBlock = node;
        if (jsBlock == null) {
            LastExpressionMutator.$$$reportNull$$$0(13);
        }
        if (jsBlock == null) {
            LastExpressionMutator.$$$reportNull$$$1(13);
        }
        return jsBlock;
    }

    @NotNull
    private JsNode applyToSwitch(@NotNull JsSwitch node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$1(14);
        }
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(14);
        }
        for (JsSwitchMember member2 : node.getCases()) {
            JsNode lastStatement;
            int size2 = member2.getStatements().size();
            if (size2 < 2 || !((lastStatement = this.apply(member2.getStatements().get(size2 - 1))) instanceof JsBreak)) continue;
            member2.getStatements().set(size2 - 2, JsAstUtils.convertToStatement(this.apply(member2.getStatements().get(size2 - 2))));
        }
        JsSwitch jsSwitch = node;
        if (jsSwitch == null) {
            LastExpressionMutator.$$$reportNull$$$0(15);
        }
        if (jsSwitch == null) {
            LastExpressionMutator.$$$reportNull$$$1(15);
        }
        return jsSwitch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToIf";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToTry";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToBlock";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToSwitch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mutateLastExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyToStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyToIf";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyToTry";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyToBlock";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyToSwitch";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToIf";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToTry";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToBlock";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToSwitch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mutateLastExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyToStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyToIf";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyToTry";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyToBlock";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyToSwitch";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

