/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeType;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J(\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J \u0010\r\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/RangeCheckTranslator;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translateAsIntRangeCheck", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "lower", "upper", "kind", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/RangeKind;", "subject", "translateAsLongRangeCheck", "translateAsRangeCheck", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "receivers", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "js.translator"})
public final class RangeCheckTranslator {
    @NotNull
    private final TranslationContext context;

    public RangeCheckTranslator(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Nullable
    public final JsExpression translateAsRangeCheck(@NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers receivers) {
        JsExpression jsExpression;
        KtExpression ktExpression;
        Object object;
        Object receiver;
        List list2;
        Pair<RangeType, RangeKind> pair;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)receivers, (String)"receivers");
        FunctionDescriptor calledFunction = resolvedCall2.getResultingDescriptor();
        if (!Intrinsics.areEqual((Object)calledFunction.getName().asString(), (Object)"contains") || !(calledFunction.getContainingDeclaration() instanceof ClassDescriptor)) {
            return null;
        }
        Pair<RangeType, RangeKind> pair2 = receivers.getExtensionOrDispatchReceiver();
        Pair<RangeType, RangeKind> pair3 = pair = pair2 instanceof JsExpression.JsExpressionHasArguments ? (Pair<RangeType, RangeKind>)pair2 : null;
        if (pair == null) {
            return null;
        }
        Pair<RangeType, RangeKind> invocation = pair;
        pair2 = MetadataProperties.getRange((JsExpression)invocation);
        if (pair2 == null) {
            return null;
        }
        pair = pair2;
        RangeType rangeType = (RangeType)((Object)pair.component1());
        RangeKind rangeKind = (RangeKind)((Object)pair.component2());
        if (rangeKind == RangeKind.UNTIL || rangeType == RangeType.INT) {
            if (invocation.getArguments().size() != 2) {
                return null;
            }
            list2 = invocation.getArguments();
        } else {
            JsNameRef jsNameRef;
            if (!(invocation instanceof JsInvocation)) {
                return null;
            }
            Object[] objectArray = ((JsInvocation)invocation).getQualifier();
            JsNameRef jsNameRef2 = jsNameRef = objectArray instanceof JsNameRef ? (JsNameRef)objectArray : null;
            if (jsNameRef == null) {
                return null;
            }
            JsNameRef qualifier = jsNameRef;
            Object object2 = qualifier.getQualifier();
            if (object2 == null) {
                return null;
            }
            objectArray = object2;
            receiver = objectArray;
            if (((JsInvocation)invocation).getArguments().size() != 1) {
                return null;
            }
            objectArray = new JsExpression[2];
            objectArray[0] = receiver;
            object2 = ((JsInvocation)invocation).getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"invocation.arguments");
            objectArray[1] = (JsExpression)CollectionsKt.single((List)object2);
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        List list3 = list2;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"when {\n            rangeKind == RangeKind.UNTIL || rangeType == RangeType.INT -> {\n                if (invocation.arguments.size != 2) return null\n                invocation.arguments\n            }\n            else -> {\n                if (invocation !is JsInvocation) return null\n                val qualifier = invocation.qualifier as? JsNameRef ?: return null\n                val receiver = qualifier.qualifier ?: return null\n                if (invocation.arguments.size != 1) return null\n                listOf(receiver, invocation.arguments.single())\n            }\n        }");
        receiver = list3;
        boolean bl = false;
        JsExpression lower2 = receiver.get(0);
        List list4 = list3;
        boolean bl2 = false;
        JsExpression upper = list4.get(1);
        lower2 = this.context.cacheExpressionIfNeeded(lower2);
        upper = this.context.cacheExpressionIfNeeded(upper);
        Object object3 = (ResolvedValueArgument)CollectionsKt.singleOrNull((Iterable)resolvedCall2.getValueArguments().values());
        Object object4 = object = object3 == null ? null : object3.getArguments();
        KtExpression ktExpression2 = object == null ? null : (ktExpression = (object3 = (ValueArgument)CollectionsKt.singleOrNull(object)) == null ? null : object3.getArgumentExpression());
        if (ktExpression == null) {
            return null;
        }
        KtExpression subjectPsi = ktExpression;
        object = this.context.cacheExpressionIfNeeded(Translation.translateAsExpression(subjectPsi, this.context));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.cacheExpressionIfNeeded(Translation.translateAsExpression(subjectPsi, context))");
        Object subject = object;
        object = rangeType;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                JsExpression jsExpression2 = lower2;
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"lower");
                JsExpression jsExpression3 = jsExpression2;
                jsExpression2 = upper;
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"upper");
                jsExpression = this.translateAsIntRangeCheck(jsExpression3, jsExpression2, rangeKind, (JsExpression)subject);
                break;
            }
            case 2: {
                JsExpression jsExpression4 = lower2;
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression4, (String)"lower");
                JsExpression jsExpression5 = jsExpression4;
                jsExpression4 = upper;
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression4, (String)"upper");
                jsExpression = this.translateAsLongRangeCheck(jsExpression5, jsExpression4, rangeKind, (JsExpression)subject);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsExpression;
    }

    private final JsExpression translateAsIntRangeCheck(JsExpression lower2, JsExpression upper, RangeKind kind, JsExpression subject) {
        JsBinaryOperation jsBinaryOperation;
        JsBinaryOperation jsBinaryOperation2 = JsAstUtils.lessThanEq(lower2, subject);
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation2, (String)"lessThanEq(lower, subject)");
        JsBinaryOperation lowerCheck = jsBinaryOperation2;
        Object object = kind;
        int n = WhenMappings.$EnumSwitchMapping$1[object.ordinal()];
        switch (n) {
            case 1: {
                jsBinaryOperation = JsAstUtils.lessThanEq(subject, upper);
                break;
            }
            case 2: {
                jsBinaryOperation = JsAstUtils.lessThan(subject, upper);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object object2 = jsBinaryOperation;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"when (kind) {\n            RangeKind.RANGE_TO -> JsAstUtils.lessThanEq(subject, upper)\n            RangeKind.UNTIL -> JsAstUtils.lessThan(subject, upper)\n        }");
        JsBinaryOperation upperCheck = object2;
        MetadataProperties.setSynthetic(lowerCheck, true);
        MetadataProperties.setSynthetic(upperCheck, true);
        object = JsAstUtils.and(lowerCheck, upperCheck);
        n = 0;
        boolean bl = false;
        Object $this$translateAsIntRangeCheck_u24lambda_u2d0 = object;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$translateAsIntRangeCheck_u24lambda_u2d0, (String)"");
        MetadataProperties.setSynthetic((HasMetadata)$this$translateAsIntRangeCheck_u24lambda_u2d0, true);
        object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"and(lowerCheck, upperCheck).apply { synthetic = true }");
        return object2;
    }

    private final JsExpression translateAsLongRangeCheck(JsExpression lower2, JsExpression upper, RangeKind kind, JsExpression subject) {
        JsInvocation jsInvocation;
        Object object = new JsExpression[]{subject};
        object = JsAstUtils.invokeMethod(lower2, "lessThanOrEqual", object);
        boolean bl = false;
        int n = 0;
        Object $this$translateAsLongRangeCheck_u24lambda_u2d1 = object;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$translateAsLongRangeCheck_u24lambda_u2d1, (String)"");
        MetadataProperties.setSideEffects((HasMetadata)$this$translateAsLongRangeCheck_u24lambda_u2d1, SideEffectKind.PURE);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"invokeMethod(lower, \"lessThanOrEqual\", subject).apply { sideEffects = SideEffectKind.PURE }");
        Object lowerCheck = object2;
        RangeKind rangeKind = kind;
        n = WhenMappings.$EnumSwitchMapping$1[rangeKind.ordinal()];
        switch (n) {
            case 1: {
                JsExpression[] jsExpressionArray = new JsExpression[]{upper};
                jsInvocation = JsAstUtils.invokeMethod(subject, "lessThanOrEqual", jsExpressionArray);
                break;
            }
            case 2: {
                JsExpression[] jsExpressionArray = new JsExpression[]{upper};
                jsInvocation = JsAstUtils.invokeMethod(subject, "lessThan", jsExpressionArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        object = jsInvocation;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (kind) {\n            RangeKind.RANGE_TO -> JsAstUtils.invokeMethod(subject, \"lessThanOrEqual\", upper)\n            RangeKind.UNTIL -> JsAstUtils.invokeMethod(subject, \"lessThan\", upper)\n        }");
        Object upperCheck = object;
        MetadataProperties.setSideEffects((HasMetadata)upperCheck, SideEffectKind.PURE);
        object = JsAstUtils.and((JsExpression)lowerCheck, (JsExpression)upperCheck);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"and(lowerCheck, upperCheck)");
        return (JsExpression)object;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RangeType.values().length];
            nArray[RangeType.INT.ordinal()] = 1;
            nArray[RangeType.LONG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RangeKind.values().length];
            nArray[RangeKind.RANGE_TO.ordinal()] = 1;
            nArray[RangeKind.UNTIL.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

