/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirLegacyRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBinaryLogicExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckedSafeCallSubjectBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirElvisExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionStubBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSafeCallExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirStubStatement;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.SymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty2TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty2TypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u001c\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013\u001a,\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019\u001a8\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0016\u0010\u001f\u001a\u00020 *\u00020\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0002\u001a0\u0010!\u001a\u00020\"*\u00020\u00192\b\u0010#\u001a\u0004\u0018\u00010\r2\b\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0001H\u0002\u001a\u001c\u0010'\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0006\u0012\u0004\u0018\u00010*0(*\u0004\u0018\u00010)\u001a@\u0010+\u001a\u00020,*\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020 2\b\u00104\u001a\u0004\u0018\u00010\u0019\u001a.\u00105\u001a\u000206*\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\b\u0010$\u001a\u0004\u0018\u00010\r2\b\u0010#\u001a\u0004\u0018\u00010\r\u001a.\u00109\u001a\u00020\"*\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010:\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010\r2\b\u0010#\u001a\u0004\u0018\u00010\r\u001a$\u0010;\u001a\u00020<*\u00020\u00192\u0006\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010\r\u001a\u001c\u0010?\u001a\u00020@*\u00020\u00192\u0006\u0010=\u001a\u00020\u00192\b\u0010$\u001a\u0004\u0018\u00010\r\u001a\n\u0010A\u001a\u00020 *\u00020)\u001a\u0011\u0010B\u001a\u0004\u0018\u00010\u0006*\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\f\u0010C\u001a\u0004\u0018\u00010\u0001*\u000208\u001a\n\u0010D\u001a\u00020E*\u000208\u001a\f\u0010F\u001a\u0004\u0018\u00010\u0001*\u000208\u001a\u0012\u0010G\u001a\u00020H*\u00020I2\u0006\u00104\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"DELEGATED_SETTER_PARAM", "Lorg/jetbrains/kotlin/name/Name;", "GET_VALUE", "PROVIDE_DELEGATE", "SET_VALUE", "escapedStringToCharacter", "", "text", "", "(Ljava/lang/String;)Ljava/lang/Character;", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "calleeReferenceSource", "name", "generateResolvedAccessExpression", "source", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "generateTemporaryVariable", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "specialName", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "translateEscape", "c", "(C)Ljava/lang/Character;", "checkReceiver", "", "createConventionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "operationReferenceSource", "baseSource", "argument", "conventionName", "extractContractDescriptionIfPossible", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "generateAccessorsByDelegate", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "ownerClassBuilder", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "isExtension", "stubMode", "receiver", "generateComparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "Lcom/intellij/psi/tree/IElementType;", "generateContainsOperation", "inverted", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "isContractPresentFirCheck", "parseCharacter", "toBinaryName", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toUnaryName", "wrapWithSafeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "raw-fir.common"})
public final class ConversionUtilsKt {
    @NotNull
    private static final Name GET_VALUE;
    @NotNull
    private static final Name SET_VALUE;
    @NotNull
    private static final Name PROVIDE_DELEGATE;
    @NotNull
    private static final Name DELEGATED_SETTER_PARAM;

    @Nullable
    public static final Character parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCharacter, (String)"<this>");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return null;
        }
        CharSequence charSequence = $this$parseCharacter;
        int n = 1;
        int n2 = $this$parseCharacter.length() - 1;
        boolean bl = false;
        String string2 = ((String)charSequence).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String text = string2;
        charSequence = text;
        n = 0;
        if (charSequence.length() == 0) {
            return null;
        }
        return text.charAt(0) != '\\' ? (text.length() == 1 ? Character.valueOf(text.charAt(0)) : (Character)null) : ConversionUtilsKt.escapedStringToCharacter(text);
    }

    @Nullable
    public static final Character escapedStringToCharacter(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0 && text.charAt(0) == '\\';
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$222 = false;
            String $i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$222 = Intrinsics.stringPlus((String)"Only escaped sequences must be passed to this routine: ", (Object)text);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$222));
        }
        String string2 = text;
        int $i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$222 = 1;
        boolean bl3 = false;
        String string3 = string2.substring($i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$222);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String escape = string3;
        int n = escape.length();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                Character $i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$222 = ConversionUtilsKt.translateEscape(escape.charAt(0));
                if ($i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$222 == null) {
                    return null;
                }
                return $i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$222;
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    String string4 = escape;
                    int n2 = 1;
                    boolean bl4 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                    Integer intValue = Integer.valueOf(string6, 16);
                    return Character.valueOf((char)intValue.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    public static final Character translateEscape(char c) {
        char c2 = c;
        return c2 == 't' ? Character.valueOf('\t') : (c2 == 'b' ? Character.valueOf('\b') : (c2 == 'n' ? Character.valueOf('\n') : (c2 == 'r' ? Character.valueOf('\r') : (c2 == '\'' ? Character.valueOf('\'') : (c2 == '\"' ? Character.valueOf('\"') : (c2 == '\\' ? Character.valueOf('\\') : (c2 == '$' ? Character.valueOf('$') : null)))))));
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryName, (String)"<this>");
        Object object = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(object, (String)"BINARY_OPERATION_NAMES");
        object = (Map)object;
        boolean bl = false;
        return (Name)object.get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnaryName, (String)"<this>");
        Object object = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(object, (String)"UNARY_OPERATION_NAMES");
        object = (Map)object;
        boolean bl = false;
        return (Name)object.get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperation, (String)"<this>");
        IElementType iElementType = $this$toFirOperation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
            firOperation = FirOperation.GT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
            firOperation = FirOperation.EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
            firOperation = FirOperation.NOT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ))) {
            firOperation = FirOperation.IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ))) {
            firOperation = FirOperation.NOT_IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQ))) {
            firOperation = FirOperation.ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSEQ))) {
            firOperation = FirOperation.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSEQ))) {
            firOperation = FirOperation.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MULTEQ))) {
            firOperation = FirOperation.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.DIVEQ))) {
            firOperation = FirOperation.DIV_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PERCEQ))) {
            firOperation = FirOperation.REM_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.AS_KEYWORD))) {
            firOperation = FirOperation.AS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.AS_SAFE))) {
            firOperation = FirOperation.SAFE_AS;
        } else {
            throw new AssertionError((Object)$this$toFirOperation.toString());
        }
        return firOperation;
    }

    @NotNull
    public static final FirElvisExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirExpression other, @Nullable FirSourceElement baseSource) {
        Intrinsics.checkNotNullParameter((Object)$this$generateNotNullOrOther, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildElvisExpression = false;
        boolean bl = false;
        FirElvisExpressionBuilder firElvisExpressionBuilder = new FirElvisExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirElvisExpressionBuilder $this$generateNotNullOrOther_u24lambda_u2d1 = firElvisExpressionBuilder;
        boolean bl4 = false;
        $this$generateNotNullOrOther_u24lambda_u2d1.setSource(baseSource);
        $this$generateNotNullOrOther_u24lambda_u2d1.setLhs($this$generateNotNullOrOther);
        $this$generateNotNullOrOther_u24lambda_u2d1.setRhs(other);
        return firElvisExpressionBuilder.build();
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable FirSourceElement baseSource) {
        Intrinsics.checkNotNullParameter((Object)$this$generateLazyLogicalOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildBinaryLogicExpression = false;
        boolean bl = false;
        FirBinaryLogicExpressionBuilder firBinaryLogicExpressionBuilder = new FirBinaryLogicExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirBinaryLogicExpressionBuilder $this$generateLazyLogicalOperation_u24lambda_u2d2 = firBinaryLogicExpressionBuilder;
        boolean bl4 = false;
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setSource(baseSource);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setLeftOperand($this$generateLazyLogicalOperation);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setRightOperand(other);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBinaryLogicExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument, boolean inverted, @Nullable FirSourceElement baseSource, @Nullable FirSourceElement operationReferenceSource) {
        void $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3;
        Intrinsics.checkNotNullParameter((Object)$this$generateContainsOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, operationReferenceSource, baseSource, argument, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        boolean bl = false;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirFunctionCallBuilder $this$generateContainsOperation_u24lambda_u2d4 = firFunctionCallBuilder;
        boolean bl4 = false;
        FirSourceElement firSourceElement = baseSource;
        $this$generateContainsOperation_u24lambda_u2d4.setSource(firSourceElement == null ? null : FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.DesugaredInvertedContains.INSTANCE));
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$generateContainsOperation_u24lambda_u2d4;
        boolean bl8 = false;
        FirSourceElement firSourceElement2 = operationReferenceSource;
        $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3.setSource(firSourceElement2 == null ? null : FirSourceElementKt.fakeElement(firSourceElement2, FirFakeSourceElementKind.DesugaredInvertedContains.INSTANCE));
        $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3.setName(OperatorNameConventions.NOT);
        Unit unit = Unit.INSTANCE;
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$generateContainsOperation_u24lambda_u2d4.setExplicitReceiver(containsCall);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument, @NotNull IElementType operatorToken, @Nullable FirSourceElement baseSource, @Nullable FirSourceElement operationReferenceSource) {
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$generateComparisonExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"COMPARISON_OPERATIONS");
        boolean bl = CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)operatorToken);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FirSourceElement firSourceElement = baseSource;
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, firSourceElement == null ? null : FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.GeneratedComparisonExpression.INSTANCE), argument, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
            firOperation = FirOperation.GT_EQ;
        } else {
            String string3 = Intrinsics.stringPlus((String)"Unknown ", (Object)operatorToken);
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        boolean bl6 = false;
        FirComparisonExpressionBuilder firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl7 = false;
        boolean bl8 = false;
        FirComparisonExpressionBuilder $this$generateComparisonExpression_u24lambda_u2d6 = firComparisonExpressionBuilder;
        boolean bl9 = false;
        $this$generateComparisonExpression_u24lambda_u2d6.setSource(baseSource);
        $this$generateComparisonExpression_u24lambda_u2d6.setOperation(firOperation2);
        $this$generateComparisonExpression_u24lambda_u2d6.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, FirSourceElement operationReferenceSource, FirSourceElement baseSource, FirExpression argument, Name conventionName) {
        void $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7;
        boolean $i$f$buildFunctionCall = false;
        boolean bl = false;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirFunctionCallBuilder $this$createConventionCall_u24lambda_u2d8 = firFunctionCallBuilder;
        boolean bl4 = false;
        $this$createConventionCall_u24lambda_u2d8.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$createConventionCall_u24lambda_u2d8;
        boolean bl8 = false;
        $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7.setSource(operationReferenceSource);
        $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7.setName(conventionName);
        Unit unit = Unit.INSTANCE;
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$createConventionCall_u24lambda_u2d8.setExplicitReceiver($this$createConventionCall);
        $this$createConventionCall_u24lambda_u2d8.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument));
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable FirSourceElement qualifiedSource, @Nullable FirSourceElement calleeReferenceSource, @NotNull Name name) {
        void $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$generateAccessExpression_u24lambda_u2d10 = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$generateAccessExpression_u24lambda_u2d10.setSource(qualifiedSource);
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$generateAccessExpression_u24lambda_u2d10;
        boolean bl8 = false;
        $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9.setSource(calleeReferenceSource);
        $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9.setName(name);
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable FirSourceElement source, @NotNull FirVariable<?> variable2) {
        void $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11;
        Intrinsics.checkNotNullParameter(variable2, (String)"variable");
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$generateResolvedAccessExpression_u24lambda_u2d12 = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2d12.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        boolean bl5 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$generateResolvedAccessExpression_u24lambda_u2d12;
        boolean bl8 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setSource(source);
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setName(variable2.getName());
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setResolvedSymbol((AbstractFirBasedSymbol)variable2.getSymbol());
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirSession session2, @Nullable FirSourceElement source, @NotNull Name name, @NotNull FirExpression initializer2, @Nullable FirTypeRef typeRef) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        boolean $i$f$buildProperty = false;
        boolean bl = false;
        FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirPropertyBuilder $this$generateTemporaryVariable_u24lambda_u2d14 = firPropertyBuilder;
        boolean bl4 = false;
        $this$generateTemporaryVariable_u24lambda_u2d14.setSource(source);
        $this$generateTemporaryVariable_u24lambda_u2d14.setSession(session2);
        $this$generateTemporaryVariable_u24lambda_u2d14.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        FirPropertyBuilder firPropertyBuilder2 = $this$generateTemporaryVariable_u24lambda_u2d14;
        FirTypeRef firTypeRef2 = typeRef;
        if (firTypeRef2 == null) {
            void $this$generateTemporaryVariable_u24lambda_u2d14_u24lambda_u2d13;
            boolean $i$f$buildImplicitTypeRef = false;
            boolean bl5 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder2 = firImplicitTypeRefBuilder;
            FirPropertyBuilder firPropertyBuilder3 = firPropertyBuilder2;
            boolean bl8 = false;
            $this$generateTemporaryVariable_u24lambda_u2d14_u24lambda_u2d13.setSource(source);
            Unit unit = Unit.INSTANCE;
            firPropertyBuilder2 = firPropertyBuilder3;
            firTypeRef = firImplicitTypeRefBuilder.build();
        } else {
            firTypeRef = firTypeRef2;
        }
        firPropertyBuilder2.setReturnTypeRef(firTypeRef);
        $this$generateTemporaryVariable_u24lambda_u2d14.setName(name);
        $this$generateTemporaryVariable_u24lambda_u2d14.setInitializer(initializer2);
        $this$generateTemporaryVariable_u24lambda_u2d14.setSymbol(new FirPropertySymbol(name));
        $this$generateTemporaryVariable_u24lambda_u2d14.setVar(false);
        $this$generateTemporaryVariable_u24lambda_u2d14.setLocal(true);
        $this$generateTemporaryVariable_u24lambda_u2d14.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
        return firPropertyBuilder.build();
    }

    public static /* synthetic */ FirVariable generateTemporaryVariable$default(FirSession firSession, FirSourceElement firSourceElement, Name name, FirExpression firExpression2, FirTypeRef firTypeRef, int n, Object object) {
        if ((n & 0x10) != 0) {
            firTypeRef = null;
        }
        return ConversionUtilsKt.generateTemporaryVariable(firSession, firSourceElement, name, firExpression2, firTypeRef);
    }

    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirSession session2, @Nullable FirSourceElement source, @NotNull String specialName, @NotNull FirExpression initializer2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)specialName, (String)"specialName");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        Name name = Name.special('<' + specialName + '>');
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<$specialName>\")");
        return ConversionUtilsKt.generateTemporaryVariable$default(session2, source, name, initializer2, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @Nullable FirClassBuilder ownerClassBuilder, @NotNull FirSession session2, boolean isExtension, boolean stubMode, @Nullable FirExpression receiver) {
        FirPropertyAccessorBuilder it;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        Unit unit;
        FirReturnExpressionBuilder firReturnExpressionBuilder;
        boolean bl;
        boolean bl2;
        FirExpression firExpression2;
        FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder;
        Unit unit2;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2;
        boolean bl3;
        boolean bl4;
        Intrinsics.checkNotNullParameter((Object)$this$generateAccessorsByDelegate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (delegateBuilder == null) {
            return;
        }
        FirDelegateFieldSymbol<FirProperty> firDelegateFieldSymbol = new FirDelegateFieldSymbol<FirProperty>($this$generateAccessorsByDelegate.getSymbol().getCallableId());
        boolean bl5 = false;
        boolean bl6 = false;
        Object it2 = firDelegateFieldSymbol;
        boolean bl7 = false;
        $this$generateAccessorsByDelegate.setDelegateFieldSymbol((FirDelegateFieldSymbol<FirProperty>)it2);
        FirDelegateFieldSymbol<FirProperty> delegateFieldSymbol = firDelegateFieldSymbol;
        FirClassBuilder firClassBuilder = ownerClassBuilder;
        FirClassSymbol ownerSymbol = firClassBuilder instanceof FirAnonymousObjectBuilder ? (FirClassSymbol)((FirAnonymousObjectBuilder)ownerClassBuilder).getSymbol() : (firClassBuilder instanceof FirRegularClassBuilder ? (FirClassSymbol)((FirRegularClassBuilder)ownerClassBuilder).getSymbol() : null);
        boolean isMember = ownerSymbol != null;
        it2 = delegateBuilder.getSource();
        FirSourceElement fakeSource = it2 == null ? null : FirSourceElementKt.fakeElement((FirSourceElement)it2, FirFakeSourceElementKind.DefaultAccessor.INSTANCE);
        boolean isVar = $this$generateAccessorsByDelegate.isVar();
        FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder2 = delegateBuilder;
        if (stubMode) {
            boolean $i$f$buildExpressionStub22 = false;
            boolean bl8 = false;
            FirExpressionStubBuilder firExpressionStubBuilder = new FirExpressionStubBuilder();
            bl4 = false;
            bl3 = false;
            FirExpressionStubBuilder firExpressionStubBuilder2 = firExpressionStubBuilder;
            firAnnotationContainerBuilder2 = firWrappedDelegateExpressionBuilder2;
            unit2 = Unit.INSTANCE;
            firWrappedDelegateExpressionBuilder = firAnnotationContainerBuilder2;
            firExpression2 = firExpressionStubBuilder.build();
        } else {
            void $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25;
            void $this$generateAccessorsByDelegate_u24lambda_u2d26;
            boolean $i$f$buildFunctionCall = false;
            boolean $i$f$buildExpressionStub22 = false;
            FirFunctionCallBuilder $i$f$buildExpressionStub22 = new FirFunctionCallBuilder();
            boolean bl9 = false;
            bl4 = false;
            FirFunctionCallBuilder firFunctionCallBuilder = $i$f$buildExpressionStub22;
            firAnnotationContainerBuilder2 = firWrappedDelegateExpressionBuilder2;
            boolean $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$22 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d26.setExplicitReceiver(receiver);
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl10 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = new FirSimpleNamedReferenceBuilder();
            bl2 = false;
            bl = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder3 = firSimpleNamedReferenceBuilder2;
            firReturnExpressionBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d26;
            boolean bl11 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25.setName(PROVIDE_DELEGATE);
            unit = Unit.INSTANCE;
            ((FirFunctionCallBuilder)((Object)firReturnExpressionBuilder)).setCalleeReference(firSimpleNamedReferenceBuilder2.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d26.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef(ownerSymbol, isExtension, fakeSource, ownerClassBuilder, $this$generateAccessorsByDelegate, true), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            unit2 = Unit.INSTANCE;
            firWrappedDelegateExpressionBuilder = firAnnotationContainerBuilder2;
            firExpression2 = $i$f$buildExpressionStub22.build();
        }
        firWrappedDelegateExpressionBuilder.setDelegateProvider(firExpression2);
        $this$generateAccessorsByDelegate.setDelegate(delegateBuilder.build());
        if (stubMode) {
            return;
        }
        if ($this$generateAccessorsByDelegate.getGetter() == null || $this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor) {
            void $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28_u24lambda_u2d27;
            void $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28;
            void $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29;
            void $this$generateAccessorsByDelegate_u24lambda_u2d30;
            FirPropertyAccessor $i$f$buildExpressionStub22 = $this$generateAccessorsByDelegate.getGetter();
            List<FirAnnotationCall> annotations2 = $i$f$buildExpressionStub22 == null ? null : $i$f$buildExpressionStub22.getAnnotations();
            FirFunctionTarget returnTarget = new FirFunctionTarget(null, false);
            boolean $i$f$buildPropertyAccessor = false;
            bl4 = false;
            FirPropertyAccessorBuilder firPropertyAccessorBuilder = new FirPropertyAccessorBuilder();
            bl3 = false;
            boolean $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$22 = false;
            FirPropertyAccessorBuilder $i$f$buildSimpleNamedReference = firPropertyAccessorBuilder;
            firAnnotationContainerBuilder2 = $this$generateAccessorsByDelegate;
            boolean bl12 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setSession(session2);
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef = false;
            bl = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            boolean bl13 = false;
            boolean bl14 = false;
            FirImplicitTypeRefBuilder bl11 = firImplicitTypeRefBuilder;
            unit = $this$generateAccessorsByDelegate_u24lambda_u2d30;
            Unit unit3 = Unit.INSTANCE;
            unit.setReturnTypeRef(firImplicitTypeRefBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setGetter(true);
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setStatus(new FirDeclarationStatusImpl(Visibilities.Unknown.INSTANCE, Modality.FINAL));
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildReturnExpression = false;
            bl2 = false;
            FirReturnExpressionBuilder firReturnExpressionBuilder2 = new FirReturnExpressionBuilder();
            bl = false;
            bl13 = false;
            firReturnExpressionBuilder = firReturnExpressionBuilder2;
            unit = $this$generateAccessorsByDelegate_u24lambda_u2d30;
            boolean bl15 = false;
            boolean $i$f$buildFunctionCall = false;
            boolean bl16 = false;
            firAnnotationContainerBuilder = new FirFunctionCallBuilder();
            boolean bl17 = false;
            boolean bl18 = false;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder3 = firAnnotationContainerBuilder;
            void var34_83 = $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29;
            boolean bl19 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerSymbol, delegateFieldSymbol, isExtension, ownerClassBuilder, $this$generateAccessorsByDelegate));
            boolean $i$f$buildSimpleNamedReference2 = false;
            boolean bl20 = false;
            firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            boolean bl21 = false;
            boolean bl22 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder4 = firSimpleNamedReferenceBuilder;
            void var41_100 = $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28;
            boolean bl23 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28_u24lambda_u2d27.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28_u24lambda_u2d27.setName(GET_VALUE);
            Unit unit4 = Unit.INSTANCE;
            var41_100.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(ownerSymbol, isExtension, fakeSource, ownerClassBuilder, $this$generateAccessorsByDelegate, false, 32, null), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            Unit unit5 = Unit.INSTANCE;
            var34_83.setResult(((FirFunctionCallBuilder)firAnnotationContainerBuilder).build());
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29.setTarget(returnTarget);
            Unit unit6 = Unit.INSTANCE;
            FirStatement firStatement = firReturnExpressionBuilder2.build();
            unit.setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2d30.getAnnotations().addAll((Collection<FirAnnotationCall>)annotations2);
            }
            unit2 = Unit.INSTANCE;
            FirPropertyAccessor firPropertyAccessor = firPropertyAccessorBuilder.build();
            bl4 = false;
            bl3 = false;
            FirPropertyAccessor $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$22 = firPropertyAccessor;
            boolean bl24 = false;
            returnTarget.bind((FirTargetElement)((Object)it));
            unit2 = Unit.INSTANCE;
            ((FirPropertyBuilder)firAnnotationContainerBuilder2).setGetter(firPropertyAccessor);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            void $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34;
            void $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            FirArgumentListBuilder $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d33;
            void $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37;
            void $this$generateAccessorsByDelegate_u24lambda_u2d38;
            FirPropertyAccessor returnTarget = $this$generateAccessorsByDelegate.getSetter();
            List<FirAnnotationCall> annotations3 = returnTarget == null ? null : returnTarget.getAnnotations();
            boolean $i$f$buildPropertyAccessor = false;
            boolean bl25 = false;
            FirPropertyAccessorBuilder firPropertyAccessorBuilder = new FirPropertyAccessorBuilder();
            bl4 = false;
            bl3 = false;
            it = firPropertyAccessorBuilder;
            firAnnotationContainerBuilder2 = $this$generateAccessorsByDelegate;
            boolean bl26 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setSession(session2);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setReturnTypeRef(session2.getBuiltinTypes().getUnitType());
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setGetter(false);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setStatus(new FirDeclarationStatusImpl(Visibilities.Unknown.INSTANCE, Modality.FINAL));
            boolean $i$f$buildValueParameter22 = false;
            bl2 = false;
            Object object = new FirValueParameterBuilder();
            bl = false;
            boolean bl27 = false;
            FirAnnotationContainerBuilder $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32 = object;
            boolean bl28 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setSession(session2);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef = false;
            boolean bl29 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            boolean bl30 = false;
            boolean bl31 = false;
            FirImplicitTypeRefBuilder $i$f$buildFunctionCall = firImplicitTypeRefBuilder;
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32;
            Unit unit7 = Unit.INSTANCE;
            ((FirValueParameterBuilder)firAnnotationContainerBuilder).setReturnTypeRef(firImplicitTypeRefBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setName(DELEGATED_SETTER_PARAM);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setSymbol(new FirVariableSymbol<FirValueParameter>($this$generateAccessorsByDelegate.getName()));
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setCrossinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setNoinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setVararg(false);
            FirValueParameter parameter = ((FirValueParameterBuilder)object).build();
            void $i$f$buildValueParameter22 = $this$generateAccessorsByDelegate_u24lambda_u2d38;
            object = $i$f$buildValueParameter22.getValueParameters();
            bl = false;
            object.add(parameter);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildFunctionCall2 = false;
            boolean bl32 = false;
            FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
            bl = false;
            bl27 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32 = firFunctionCallBuilder;
            void var35_85 = $this$generateAccessorsByDelegate_u24lambda_u2d38;
            boolean bl33 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerSymbol, delegateFieldSymbol, isExtension, ownerClassBuilder, $this$generateAccessorsByDelegate));
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl34 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder5 = new FirSimpleNamedReferenceBuilder();
            bl30 = false;
            bl31 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder6 = firSimpleNamedReferenceBuilder5;
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37;
            boolean bl35 = false;
            ((FirSimpleNamedReferenceBuilder)((Object)$this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d33)).setName(SET_VALUE);
            Unit unit8 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)firAnnotationContainerBuilder).setCalleeReference(firSimpleNamedReferenceBuilder5.build());
            boolean $i$f$buildArgumentList = false;
            boolean bl36 = false;
            FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
            bl30 = false;
            bl31 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d33 = firArgumentListBuilder;
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37;
            boolean bl37 = false;
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            Collection collection = ((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments();
            FirExpression firExpression3 = ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(ownerSymbol, isExtension, fakeSource, ownerClassBuilder, $this$generateAccessorsByDelegate, false, 32, null);
            boolean bl38 = false;
            collection.add(firExpression3);
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            collection = ((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments();
            firExpression3 = ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate);
            bl38 = false;
            collection.add(firExpression3);
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            collection = ((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments();
            boolean $i$f$buildQualifiedAccessExpression = false;
            bl38 = false;
            FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
            boolean bl39 = false;
            boolean bl40 = false;
            FirQualifiedAccessExpressionBuilder $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35 = firQualifiedAccessExpressionBuilder;
            boolean bl41 = false;
            boolean $i$f$buildResolvedNamedReference = false;
            boolean bl42 = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
            boolean bl43 = false;
            boolean bl44 = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
            FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35;
            boolean bl45 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34.setName(DELEGATED_SETTER_PARAM);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34.setResolvedSymbol((AbstractFirBasedSymbol)parameter.getSymbol());
            Unit unit9 = Unit.INSTANCE;
            firQualifiedAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
            FirQualifiedAccessExpression firQualifiedAccessExpression = firQualifiedAccessExpressionBuilder.build();
            boolean bl46 = false;
            collection.add(firQualifiedAccessExpression);
            unit8 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)firAnnotationContainerBuilder).setArgumentList(firArgumentListBuilder.build());
            Unit unit10 = Unit.INSTANCE;
            FirStatement firStatement = firFunctionCallBuilder.build();
            var35_85.setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations3 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2d38.getAnnotations().addAll((Collection<FirAnnotationCall>)annotations3);
            }
            unit2 = Unit.INSTANCE;
            ((FirPropertyBuilder)firAnnotationContainerBuilder2).setSetter(firPropertyAccessorBuilder.build());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<FirBlock, FirContractDescription> extractContractDescriptionIfPossible(@Nullable FirBlock $this$extractContractDescriptionIfPossible) {
        void $this$extractContractDescriptionIfPossible_u24lambda_u2d39;
        if ($this$extractContractDescriptionIfPossible == null) {
            return TuplesKt.to(null, null);
        }
        if (!ConversionUtilsKt.isContractPresentFirCheck($this$extractContractDescriptionIfPossible)) {
            return TuplesKt.to((Object)$this$extractContractDescriptionIfPossible, null);
        }
        FirFunctionCall contractCall = (FirFunctionCall)FirExpressionUtilKt.replaceFirstStatement($this$extractContractDescriptionIfPossible, FirStubStatement.INSTANCE);
        boolean $i$f$buildLegacyRawContractDescription = false;
        boolean bl = false;
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder = new FirLegacyRawContractDescriptionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder2 = firLegacyRawContractDescriptionBuilder;
        FirBlock firBlock = $this$extractContractDescriptionIfPossible;
        boolean bl4 = false;
        $this$extractContractDescriptionIfPossible_u24lambda_u2d39.setSource(contractCall.getSource());
        $this$extractContractDescriptionIfPossible_u24lambda_u2d39.setContractCall(contractCall);
        Unit unit = Unit.INSTANCE;
        return TuplesKt.to((Object)firBlock, (Object)firLegacyRawContractDescriptionBuilder.build());
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        FirQualifiedAccessExpression firQualifiedAccessExpression;
        FirFunctionCall firFunctionCall;
        Intrinsics.checkNotNullParameter((Object)$this$isContractPresentFirCheck, (String)"<this>");
        FirStatement firStatement = (FirStatement)CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        FirFunctionCall firFunctionCall2 = firFunctionCall = firstStatement instanceof FirFunctionCall ? (FirFunctionCall)firstStatement : null;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall = firFunctionCall;
        if (!Intrinsics.areEqual((Object)contractCall.getCalleeReference().getName().asString(), (Object)"contract")) {
            return false;
        }
        FirExpression firExpression2 = contractCall.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver, "kotlin")) {
            return false;
        }
        FirExpression firExpression3 = receiver.getExplicitReceiver();
        FirExpression firExpression4 = firExpression2 = firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
        if (firExpression2 == null) {
            return false;
        }
        FirExpression receiverOfReceiver = firExpression2;
        return ((FirQualifiedAccessExpression)receiverOfReceiver).getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name) {
        String string2;
        FirNamedReference firNamedReference;
        FirQualifiedAccessExpression firQualifiedAccessExpression;
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        Object object = receiver.getCalleeReference();
        FirNamedReference firNamedReference2 = firNamedReference = object instanceof FirNamedReference ? (FirNamedReference)object : null;
        String string3 = firNamedReference == null ? null : (string2 = (object = firNamedReference.getName()) == null ? null : ((Name)object).asString());
        if (string2 == null) {
            return false;
        }
        FirExpression receiverName = firExpression2 = string2;
        return Intrinsics.areEqual((Object)receiverName, (Object)name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSafeCallExpression wrapWithSafeCall(@NotNull FirQualifiedAccess $this$wrapWithSafeCall, @NotNull FirExpression receiver) {
        void $this$wrapWithSafeCall_u24lambda_u2d43_u24lambda_u2d42;
        FirExpressionRef<FirCheckedSafeCallSubject> $this$wrapWithSafeCall_u24lambda_u2d41_u24lambda_u2d40;
        Intrinsics.checkNotNullParameter((Object)$this$wrapWithSafeCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        boolean $i$f$buildCheckedSafeCallSubject = false;
        boolean bl = false;
        FirCheckedSafeCallSubjectBuilder firCheckedSafeCallSubjectBuilder = new FirCheckedSafeCallSubjectBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirCheckedSafeCallSubjectBuilder $this$wrapWithSafeCall_u24lambda_u2d41 = firCheckedSafeCallSubjectBuilder;
        boolean bl4 = false;
        Object object = new FirExpressionRef<FirExpression>();
        boolean bl5 = false;
        boolean bl6 = false;
        FirExpressionRef<FirExpression> firExpressionRef = object;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder = $this$wrapWithSafeCall_u24lambda_u2d41;
        boolean bl7 = false;
        $this$wrapWithSafeCall_u24lambda_u2d41_u24lambda_u2d40.bind((FirCheckedSafeCallSubject)receiver);
        Unit unit = Unit.INSTANCE;
        ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder).setOriginalReceiverRef((FirExpressionRef<FirExpression>)object);
        object = receiver.getSource();
        $this$wrapWithSafeCall_u24lambda_u2d41.setSource(object == null ? null : FirSourceElementKt.fakeElement((FirSourceElement)object, FirFakeSourceElementKind.CheckedSafeCallSubject.INSTANCE));
        FirCheckedSafeCallSubject checkedSafeCallSubject = firCheckedSafeCallSubjectBuilder.build();
        $this$wrapWithSafeCall.replaceExplicitReceiver(checkedSafeCallSubject);
        boolean $i$f$buildSafeCallExpression = false;
        boolean bl8 = false;
        FirSafeCallExpressionBuilder firSafeCallExpressionBuilder = new FirSafeCallExpressionBuilder();
        bl2 = false;
        bl3 = false;
        FirSafeCallExpressionBuilder $this$wrapWithSafeCall_u24lambda_u2d43 = firSafeCallExpressionBuilder;
        boolean bl9 = false;
        $this$wrapWithSafeCall_u24lambda_u2d43.setReceiver(receiver);
        object = new FirExpressionRef<FirCheckedSafeCallSubject>();
        bl5 = false;
        bl6 = false;
        $this$wrapWithSafeCall_u24lambda_u2d41_u24lambda_u2d40 = object;
        firAnnotationContainerBuilder = $this$wrapWithSafeCall_u24lambda_u2d43;
        boolean bl10 = false;
        $this$wrapWithSafeCall_u24lambda_u2d43_u24lambda_u2d42.bind((FirExpression)checkedSafeCallSubject);
        unit = Unit.INSTANCE;
        ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder).setCheckedSubjectRef((FirExpressionRef<FirCheckedSafeCallSubject>)object);
        $this$wrapWithSafeCall_u24lambda_u2d43.setRegularQualifiedAccess($this$wrapWithSafeCall);
        object = $this$wrapWithSafeCall.getSource();
        $this$wrapWithSafeCall_u24lambda_u2d43.setSource(object == null ? null : FirSourceElementKt.fakeElement((FirSourceElement)object, FirFakeSourceElementKind.DesugaredSafeCallExpression.INSTANCE));
        return firSafeCallExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirExpression generateAccessorsByDelegate$thisRef(FirClassSymbol<?> $ownerSymbol, boolean $isExtension, FirSourceElement $fakeSource, FirClassBuilder $ownerClassBuilder, FirPropertyBuilder $this_generateAccessorsByDelegate, boolean isForDelegateProviderCall) {
        FirExpression firExpression2;
        if ($ownerSymbol != null) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18_u24lambda_u2d17;
            int n;
            FirResolvedTypeRefBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18_u24lambda_u2d16;
            boolean $i$f$buildThisReceiverExpression = false;
            boolean bl = false;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18 = firThisReceiverExpressionBuilder;
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18.setSource($fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            boolean bl5 = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18;
            boolean bl8 = false;
            ((FirImplicitThisReferenceBuilder)((Object)$this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18_u24lambda_u2d16)).setBoundSymbol((AbstractFirBasedSymbol)$ownerSymbol);
            Unit unit = Unit.INSTANCE;
            firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
            boolean $i$f$buildResolvedTypeRef = false;
            boolean bl9 = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            bl6 = false;
            bl7 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18_u24lambda_u2d16 = firResolvedTypeRefBuilder;
            firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18;
            boolean bl10 = false;
            FirRegularClassBuilder firRegularClassBuilder = $ownerClassBuilder instanceof FirRegularClassBuilder ? (FirRegularClassBuilder)$ownerClassBuilder : null;
            List<FirTypeParameterRef> list2 = firRegularClassBuilder == null ? null : firRegularClassBuilder.getTypeParameters();
            int typeParameterNumber = list2 == null ? 0 : (n = list2.size());
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18_u24lambda_u2d17.setType(SymbolUtilsKt.constructStarProjectedType($ownerSymbol, typeParameterNumber));
            unit = Unit.INSTANCE;
            firThisReceiverExpressionBuilder2.setTypeRef(firResolvedTypeRefBuilder.build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else if ($isExtension && !isForDelegateProviderCall) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d19;
            boolean $i$f$buildThisReceiverExpression = false;
            boolean bl = false;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl11 = false;
            boolean bl12 = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20 = firThisReceiverExpressionBuilder;
            boolean bl13 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20.setSource($fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            boolean bl14 = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            boolean bl15 = false;
            boolean bl16 = false;
            FirImplicitThisReferenceBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d18_u24lambda_u2d17 = firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20;
            boolean bl17 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d19.setBoundSymbol($this_generateAccessorsByDelegate.getSymbol());
            Unit unit = Unit.INSTANCE;
            firThisReceiverExpressionBuilder3.setCalleeReference(firImplicitThisReferenceBuilder.build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else {
            firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, FirConstKind.Null.INSTANCE, null, null, 8, null);
        }
        return firExpression2;
    }

    static /* synthetic */ FirExpression generateAccessorsByDelegate$thisRef$default(FirClassSymbol firClassSymbol, boolean bl, FirSourceElement firSourceElement, FirClassBuilder firClassBuilder, FirPropertyBuilder firPropertyBuilder, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        return ConversionUtilsKt.generateAccessorsByDelegate$thisRef(firClassSymbol, bl, firSourceElement, firClassBuilder, firPropertyBuilder, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final FirQualifiedAccessExpression generateAccessorsByDelegate$delegateAccess(FirSourceElement $fakeSource, FirClassSymbol<?> $ownerSymbol, FirDelegateFieldSymbol<FirProperty> $delegateFieldSymbol, boolean $isExtension, FirClassBuilder $ownerClassBuilder, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22_u24lambda_u2d21;
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22 = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22.setSource($fakeSource);
        boolean $i$f$buildDelegateFieldReference = false;
        boolean bl5 = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22;
        boolean bl8 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22_u24lambda_u2d21.setResolvedSymbol($delegateFieldSymbol);
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
        if ($ownerSymbol != null) {
            $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22.setDispatchReceiver(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default($ownerSymbol, $isExtension, $fakeSource, $ownerClassBuilder, $this_generateAccessorsByDelegate, false, 32, null));
        }
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirCallableReferenceAccess generateAccessorsByDelegate$propertyRef(FirSourceElement $fakeSource, boolean $isMember, boolean $isExtension, boolean $isVar, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23;
        boolean $i$f$buildCallableReferenceAccess = false;
        boolean bl = false;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirCallableReferenceAccessBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24 = firCallableReferenceAccessBuilder;
        boolean bl4 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24.setSource($fakeSource);
        boolean $i$f$buildResolvedNamedReference = false;
        boolean bl5 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder2 = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24;
        boolean bl8 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setSource($fakeSource);
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setName($this_generateAccessorsByDelegate.getName());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setResolvedSymbol($this_generateAccessorsByDelegate.getSymbol());
        Unit unit = Unit.INSTANCE;
        firCallableReferenceAccessBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24.setTypeRef(!$isMember && !$isExtension ? (FirTypeRef)($isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty0TypeRef(null, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty0TypeRef(null, ConeStarProjection.INSTANCE)) : ($isMember && $isExtension ? (FirTypeRef)($isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE)) : (FirTypeRef)($isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE))));
        return firCallableReferenceAccessBuilder.build();
    }

    static {
        Name name = Name.identifier("getValue");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"getValue\")");
        GET_VALUE = name;
        name = Name.identifier("setValue");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"setValue\")");
        SET_VALUE = name;
        name = Name.identifier("provideDelegate");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"provideDelegate\")");
        PROVIDE_DELEGATE = name;
        name = Name.special("<set-?>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<set-?>\")");
        DELEGATED_SETTER_PARAM = name;
    }
}

