/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantExplicitTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "text", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getText", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Ljava/lang/String;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isSame", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "other", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
public final class RedundantExplicitTypeChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final RedundantExplicitTypeChecker INSTANCE = new RedundantExplicitTypeChecker();

    private RedundantExplicitTypeChecker() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirMemberDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$report$iv;
        void source$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration instanceof FirProperty)) {
            return;
        }
        if (!((FirProperty)declaration).isLocal()) {
            return;
        }
        FirExpression firExpression2 = ((FirProperty)declaration).getInitializer();
        if (firExpression2 == null) {
            return;
        }
        FirExpression initializer2 = firExpression2;
        FirTypeRef typeReference = ((FirProperty)declaration).getReturnTypeRef();
        FirSourceElement firSourceElement = typeReference.getSource();
        if ((firSourceElement == null ? null : firSourceElement.getKind()) instanceof FirFakeSourceElementKind) {
            return;
        }
        Object $this$coneType$iv = ((FirProperty)declaration).getReturnTypeRef();
        boolean $i$f$getConeType22 = false;
        Object $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeKotlinType type2 = coneKotlinType;
        if (typeReference instanceof FirTypeAlias) {
            return;
        }
        $this$coneType$iv = typeReference.getAnnotations();
        $i$f$getConeType22 = false;
        if (!$this$coneType$iv.isEmpty()) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        $this$coneType$iv = initializer2;
        if ($this$coneType$iv instanceof FirConstExpression) {
            $this$coneTypeUnsafe$iv$iv = initializer2.getSource();
            IElementType iElementType = $i$f$getConeType22 = $this$coneTypeUnsafe$iv$iv == null ? null : ((FirSourceElement)$this$coneTypeUnsafe$iv$iv).getElementType();
            if (Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getBoolean())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                if (Intrinsics.areEqual(((FirConstExpression)initializer2).getKind(), (Object)FirConstKind.Long.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getLong()) : !this.isSame(type2, StandardClassIds.INSTANCE.getInt())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
                if (Intrinsics.areEqual(((FirConstExpression)initializer2).getKind(), (Object)FirConstKind.Float.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getFloat()) : !this.isSame(type2, StandardClassIds.INSTANCE.getDouble())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getChar())) {
                    return;
                }
            } else {
                if (!Intrinsics.areEqual((Object)$i$f$getConeType22, (Object)KtNodeTypes.STRING_TEMPLATE)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        } else if ($this$coneType$iv instanceof FirNamedReference) {
            if (!Intrinsics.areEqual((Object)this.getText(typeReference), (Object)((FirNamedReference)((Object)initializer2)).getName().getIdentifier())) {
                return;
            }
        } else if ($this$coneType$iv instanceof FirFunctionCall) {
            if (!Intrinsics.areEqual((Object)this.getText(typeReference), (Object)((FirFunctionCall)initializer2).getCalleeReference().getName().asString())) {
                return;
            }
        } else {
            if ($this$coneType$iv instanceof FirGetClassCall) {
                return;
            }
            if ($this$coneType$iv instanceof FirResolvedQualifier) {
                if (!this.isSame(type2, ((FirResolvedQualifier)initializer2).getClassId())) {
                    return;
                }
            } else {
                if (!($this$coneType$iv instanceof FirStringConcatenationCall)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        }
        $this$coneType$iv = reporter;
        FirSourceElement $i$f$getConeType22 = ((FirProperty)declaration).getReturnTypeRef().getSource();
        FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_TYPE();
        boolean $i$f$report = false;
        void var11_13 = source$iv;
        if (var11_13 == null) return;
        void var12_14 = var11_13;
        boolean bl2 = false;
        boolean bl3 = false;
        void it$iv = var12_14;
        boolean bl4 = false;
        $this$report$iv.report((FirDiagnostic)factory$iv.on((FirSourceElement)it$iv));
    }

    private final String getText(FirTypeRef $this$text) {
        LighterASTNode lighterASTNode2;
        FirSourceElement firSourceElement;
        PsiElement psiElement;
        FirSourceElement firSourceElement2 = $this$text.getSource();
        Object object = firSourceElement2 instanceof FirPsiSourceElement ? ((psiElement = FirSourceElementKt.getPsi($this$text.getSource())) == null ? null : psiElement.getText()) : (firSourceElement2 instanceof FirLightSourceElement ? ((firSourceElement = $this$text.getSource()) == null ? null : ((lighterASTNode2 = firSourceElement.getLighterASTNode()) == null ? null : lighterASTNode2.toString())) : null);
        return object;
    }

    private final boolean isSame(ConeKotlinType $this$isSame, ClassId other) {
        if ($this$isSame.getNullability().isNullable()) {
            return false;
        }
        return Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId($this$isSame.getType()), (Object)other);
    }
}

