/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictingProjectionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "reportConflictingProjections", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "desiredProjection", "", "reportVarianceNotAllowed", "checkers"})
public final class FirConflictingProjectionChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictingProjectionChecker INSTANCE = new FirConflictingProjectionChecker();

    private FirConflictingProjectionChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration instanceof FirPropertyAccessor) {
            return;
        }
        if (declaration instanceof FirTypedDeclaration) {
            this.checkTypeRef(((FirTypedDeclaration)declaration).getReturnTypeRef(), context2, reporter);
        }
        if ((firDeclaration = declaration) instanceof FirClass) {
            for (FirTypeRef it : ((FirClass)declaration).getSuperTypeRefs()) {
                this.checkTypeRef(it, context2, reporter);
            }
        } else if (firDeclaration instanceof FirTypeAlias) {
            for (FirTypeParameter it : ((FirTypeAlias)declaration).getTypeParameters()) {
                if (it.getVariance() == Variance.INVARIANT) continue;
                this.reportVarianceNotAllowed(reporter, it.getSource());
            }
            this.checkTypeRef(((FirTypeAlias)declaration).getExpandedTypeRef(), context2, reporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeRef(FirTypeRef typeRef, CheckerContext context2, DiagnosticReporter reporter) {
        FirRegularClass firRegularClass;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        ConeClassLikeLookupTag coneClassLikeLookupTag2;
        Object object;
        Object $this$safeAs$iv = typeRef;
        boolean $i$f$safeAs2 = false;
        Object object2 = $this$safeAs$iv;
        if (!(object2 instanceof FirResolvedTypeRef)) {
            object2 = null;
        }
        if ((object = (FirResolvedTypeRef)object2) == null) {
            coneClassLikeLookupTag2 = null;
        } else {
            void $this$coneTypeSafe$iv;
            FirTypeRef $i$f$safeAs2 = (FirTypeRef)object;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            coneClassLikeLookupTag2 = coneClassLikeLookupTag = ($this$safeAs$iv = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : ((ConeClassLikeType)$this$safeAs$iv).getLookupTag();
        }
        FirClassLikeDeclaration $this$safeAs$iv2 = coneClassLikeLookupTag == null ? null : ((object = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession())) == null ? null : (FirClassLikeDeclaration)((AbstractFirBasedSymbol)object).getFir());
        boolean $i$f$safeAs3 = false;
        FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv2;
        if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
            firClassLikeDeclaration = null;
        }
        if ((firRegularClass = (FirRegularClass)firClassLikeDeclaration) == null) {
            return;
        }
        FirRegularClass declaration = firRegularClass;
        FirTypeRef $this$coneType$iv = typeRef;
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        int n = 0;
        int size2 = ((Number)((Object)AddToStdlibKt.min(declaration.getTypeParameters().size(), coneKotlinType.getTypeArguments().length))).intValue();
        if (n < size2) {
            do {
                Variance protoVariance;
                int it = n++;
                FirTypeParameterRef proto = declaration.getTypeParameters().get(it);
                FirTypeRef $this$coneType$iv2 = typeRef;
                boolean $i$f$getConeType2 = false;
                Object $this$coneTypeUnsafe$iv$iv2 = $this$coneType$iv2;
                boolean $i$f$coneTypeUnsafe2 = false;
                ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv2).getType();
                if (coneKotlinType2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                ConeTypeProjection actual = coneKotlinType2.getTypeArguments()[it];
                FirTypeParameterRef $this$safeAs$iv3 = proto;
                boolean $i$f$safeAs4 = false;
                FirTypeParameterRef firTypeParameterRef = $this$safeAs$iv3;
                if (!(firTypeParameterRef instanceof FirTypeParameterRef)) {
                    firTypeParameterRef = null;
                }
                Object object3 = $this$coneTypeUnsafe$iv$iv2 = ($i$f$coneTypeUnsafe2 = firTypeParameterRef) == null ? null : $i$f$coneTypeUnsafe2.getSymbol();
                Variance variance = $this$coneTypeUnsafe$iv$iv2 == null ? null : ($i$f$getConeType2 = ($i$f$coneTypeUnsafe2 = (FirTypeParameter)((AbstractFirBasedSymbol)$this$coneTypeUnsafe$iv$iv2).getFir()) == null ? null : ((FirTypeParameter)$i$f$coneTypeUnsafe2).getVariance());
                if ($i$f$getConeType2 == null || (protoVariance = $i$f$getConeType2) == Variance.INVARIANT || (!(actual instanceof ConeKotlinTypeProjectionIn) || protoVariance != Variance.OUT_VARIANCE) && (!(actual instanceof ConeKotlinTypeProjectionOut) || protoVariance != Variance.IN_VARIANCE)) continue;
                FirTypeRef $this$coneType$iv3 = typeRef;
                boolean $i$f$getConeType3 = false;
                FirTypeRef $this$coneTypeUnsafe$iv$iv3 = $this$coneType$iv3;
                boolean $i$f$coneTypeUnsafe3 = false;
                ConeKotlinType coneKotlinType3 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv3).getType();
                if (coneKotlinType3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                this.reportConflictingProjections(reporter, typeRef.getSource(), coneKotlinType3.toString());
                return;
            } while (n < size2);
        }
    }

    private final void reportConflictingProjections(DiagnosticReporter $this$reportConflictingProjections, FirSourceElement source, String desiredProjection) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportConflictingProjections.report((FirDiagnostic)FirErrors.INSTANCE.getCONFLICTING_PROJECTION().on(it, desiredProjection));
        }
    }

    private final void reportVarianceNotAllowed(DiagnosticReporter $this$reportVarianceNotAllowed, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportVarianceNotAllowed.report((FirDiagnostic)FirErrors.INSTANCE.getVARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED().on(it));
        }
    }
}

